!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Basis  ! Ūʷ׻ؿ¹Ԥ⥸塼

  type dtime  ! 
     integer :: year_d  ! 
     integer :: month_d  ! 
     integer :: day_d  ! 
  end type dtime

contains

subroutine rand_make(L,output)
  ! Ǥդηǵ륵֥롼
  ! ƱˡȤ르ꥺѤƵ
  ! $x_{n+1}=a\times x_{n}+b (mod \; L)$
  implicit none
  integer, intent(in) :: L  ! Ϥ + 1 ο
  integer, intent(inout) :: output  ! Ϥ
  integer :: a, b, x0, i, input
  integer, external :: time

  input=time()
  input=mod(input,L)
  write(*,*) input
  a=11
  b=12
  x0=input

  do i=1,10
     x0=a*x0+b
     x0=mod(x0,L)
  end do

  output=x0

end subroutine

!-----------------------------------
!-----------------------------------

character(100) function r2c_convert( rval, forma )
! ¿ʸѴ
  implicit none
  real, intent(in) :: rval  ! Ѵ¿
  character(*), intent(in), optional :: forma  ! ꤹեޥå
  character(100) :: tmp

  if(present(forma))then
     write(tmp,trim(forma)) rval
  else
     write(tmp,*) rval
  end if

  r2c_convert=tmp

  return
end function

!-----------------------------------
!-----------------------------------

real function c2r_convert( cval )
! ʸ¿Ѵ
  implicit none
  character(*), intent(in) :: cval  ! Ѵʸ

  read(cval,*) c2r_convert

  return
end function

!-----------------------------------
!-----------------------------------

character(100) function i2c_convert( ival, forma )
! ¿ʸѴ
  implicit none
  integer, intent(in) :: ival  ! Ѵ
  character(*), intent(in), optional :: forma  ! ꤹեޥå
  character(100) :: tmp

  if(present(forma))then
     write(tmp,trim(forma)) ival
  else
     write(tmp,*) ival
  end if

  i2c_convert=tmp

  return
end function

!-----------------------------------
!-----------------------------------

integer function c2i_convert( cval )
! ʸ¿Ѵ
  implicit none
  character(*), intent(in) :: cval  ! Ѵʸ

  read(cval,*) c2i_convert

  return
end function

!-----------------------------------
!-----------------------------------

integer function split_num( cval, split_str )
! split_str ǻꤵ줿ʸʬȤ, ʸ cval ʬ䤷Ȥ
! ʬĿ֤. split_str ꤵʤ, ʸʬ䵭Ȥƽ.
! , ʬ䵭 1 ʸΤб.
  implicit none
  character(*), intent(in) :: cval  ! ʬ䤷ʸ
  character(1), intent(in), optional :: split_str  ! ʬ䵭
  character(1) :: split
  integer :: nc, counter, i
  logical :: double_flag

  if(present(split_str))then
     split=trim(adjustl(split_str))
  else
     split=' '
  end if

  nc=len_trim(adjustl(cval))
  counter=0
  double_flag=.false.

  do i=2,nc-1  ! ʸκǽȺǸʬʸäƤƤ⤽̵Ǥ뤿.
     if(cval(i:i)==split)then
        if(double_flag.eqv..false.)then
           counter=counter+1
           double_flag=.true.
        end if
     else
        double_flag=.false.
     end if
  end do

  split_num=counter+1

  return
end function

!-----------------------------------
!-----------------------------------

subroutine splitting( cval, num, cval_ar, split_str )
! cval  split_str ʬʸȤ cval_ar Ȥʬ䤹.
! , split_str  1 ʸˤΤбƤ. ǥեȤǤȾѥڡ
! бƤ.
  implicit none
  character(*), intent(in) :: cval  ! ʬ䤷ʸ
  integer, intent(in) :: num        ! num Ĥʬ.
                                    ! ͤ split_num ؿĴ٤Ƥ.
  character(*), dimension(num), intent(inout) :: cval_ar
                                    ! ʬ䤵줿ʸ󤬳Ǽ.
  character(1), intent(in), optional :: split_str
  character(1) :: split
  integer :: nc, counter, counter_counter, i
  integer, dimension(num) :: isnum, ienum
  logical :: double_flag

  if(present(split_str))then
     split=split_str
  else
     split=' '
  end if

  nc=len_trim(adjustl(cval))
  counter=0
  counter_counter=0
  double_flag=.false.

  isnum(1)=1
  do i=2,nc-1  ! ʸκǽȺǸʬʸäƤƤ⤽̵Ǥ뤿.
     if(cval(i:i)==split)then
        if(double_flag.eqv..false.)then
           counter_counter=counter_counter+1
           counter=0
           ienum(counter_counter)=i-1
           double_flag=.true.
        else
           counter=counter+1
        end if
     else
        if(double_flag.eqv..true.)then
           isnum(counter_counter)=i
        end if
        double_flag=.false.
     end if
  end do

  do i=1,num
     cval_ar(i)=cval(isnum(i):ienum(i))
  end do

end subroutine splitting

!-----------------------------------
!-----------------------------------

integer function counter_day( stime, etime )
! 齪λޤǤ򥫥Ȥ.
  implicit none
  type(dtime), intent(in) :: stime  ! 
  type(dtime), intent(in) :: etime  ! λ
  integer, parameter, dimension(13) :: month=(/31,28,31,30,31,30,  &
  &                                            31,31,30,31,30,31,29/)
  integer :: nt, nm, days, i, year_tmp, year_fact
  integer :: nsy, nsm, nsd, ney, nem, ned

  nt=etime%year_d-stime%year_d+1
  nm=etime%month_d-stime%month_d+1
  days=0
  nsy=stime%year_d
  nsm=stime%month_d
  nsd=stime%day_d
  ney=etime%year_d
  nem=etime%month_d
  ned=etime%day_d

!-- ǯʬ, ǯǾʬ.
  if(nt>2)then
     do i=2,nt-1
        year_tmp=nsy+i-1
        if(mod(year_tmp,4)==0)then
           year_fact=366
        else
           year_fact=365
        end if
        days=days+year_fact
     end do
  end if

!-- νԤäƤΤ, ­碌ΤϳǯȽλǯΤ.
!-- ޤ, 1 ޤޤ¸ߤ­碌.
!-- ,  12 , λ 1 ξ, ­­Τ,
!-- ǤϥȤʤ.
  if(nt>1)then  ! ǯޤ
     if(nsm<12)then  !  12 ǤϤʤ.
        do i=nsm+1,12
           if(i==2.and.mod(nsy,4)==0)then
              days=days+month(13)
           else
              days=days+month(i)
           end if
        end do
     end if

     if(nem>1)then  ! λ 1 ǤϤʤ.
        do i=1,nem-1
           if(i==2.and.mod(ney,4)==0)then
              days=days+month(13)
           else
              days=days+month(i)
           end if
        end do
     end if
  else
     if(nm>2)then  ! ǯޤ餺, ޤ, Ĵ֤ 1 ʬ
                   ! ޤޤäƤ.
        do i=nsm+1,nem-1
           if(i==2.and.mod(ney,4)==0)then
              days=days+month(13)
           else
              days=days+month(i)
           end if
        end do
     end if
  end if

!-- , ϷȽλ­碌.
  if(nt/=1.or.nm/=1)then  ! ǯ⤫֤äƤʤ
     if(mod(nsy,4)==0.and.nsm==2)then
        days=days+month(13)-nsd
     else
        days=days+month(nsm)-nsd
     end if

     if(mod(ney,4)==0.and.nem==2)then
        days=days+ned
     else
        days=days+ned
     end if
  else
     days=days+ned-nsd
  end if

  days=days+1
  counter_day=days

  return
end function

end module
