program cov
  use Statistics
  use file_operate
  use max_min
  use Basis
  implicit none
  real, allocatable, dimension(:) :: x, y, xa, ya
  integer :: nx, i
  real :: a, cc, slope, intercept
  real :: xmax, xmin, ymax, ymin, xmean, ymean
  integer :: xmim, ymim, xmam, ymam
  character(10), allocatable, dimension(:,:) :: cval

  nx=line_number_counter( 'data.org' )

  allocate(cval(2,nx))
  allocate(x(nx))
  allocate(y(nx))
  allocate(xa(nx))
  allocate(ya(nx))

  call read_file_text( 'data.org', 2, nx, cval )

  do i=1,nx
     x(i)=c2r_convert( cval(1,i) )
     y(i)=c2r_convert( cval(2,i) )
  end do

  call Cor_Coe( x, y, cc )
  call Reg_Line( x, y, slope, intercept )
  call Mean_1d( x, xmean )
  call Mean_1d( y, ymean )
!  call Anomaly_1d( nx, x, xa )
!  call Anomaly_1d( nx, y, ya )

  do i=1,nx
     xa(i)=x(i)/xmean
     ya(i)=y(i)/ymean
  end do

  call max_val_1d(xa, xmam, xmax )
  call max_val_1d(ya, ymam, ymax )
  call min_val_1d(xa, xmim, xmin )
  call min_val_1d(ya, ymim, ymin )

  write(*,*) '************************************'
  write(*,*) 'slope =', slope
  write(*,*) 'intercept =', intercept
  write(*,*) 'Cor_Coe =', cc
  write(*,*) 'data number =', nx
  write(*,*) '************************************'

  deallocate(x)
  deallocate(y)
  deallocate(xa)
  deallocate(ya)

end program
