module fft_read_namelist

  use fft_saveval_define

  implicit none

contains

subroutine fft_read_name()

  use fft_saveval_define

  namelist /input /nxi, nyi, hxnt, hynt, nt, Lx, Ly, dt,  &
  &                dmpstp, ininame, inix, iniy, iniz, inixd, iniyd,  &
  &                foname, time_flag, nu, flag_fric, mu,  &
  &                flag_stretch, force_type, force_wn, force_kr, sth_fname, sth_vname,  &
  &                zetam, sth_thres_zeta, cent_lat, tcx, tcy
  namelist /restart /resopt, resfname, restp
  read(5,nml=input)
  read(5,nml=restart)

  nx=hxnt*2+1
  ny=hynt*2+1
  jxnt=hxnt*3+1
  jynt=hynt*3+1
  dx=Lx/dble(nx-1)
  dy=Ly/dble(ny-1)
  xmin=0.0d0
  ymin=0.0d0

end subroutine fft_read_name

subroutine fft_read_name_isp()

  use fft_saveval_define

  namelist /input /nxi, nyi, hxnt, hynt, nx, ny, jxnt, jynt,  &
  &                nt, Lx, Ly, dt,  &
  &                dmpstp, ininame, inix, iniy, iniz, inixd, iniyd,  &
  &                foname, time_flag, nu, flag_fric, mu,  &
  &                flag_stretch, force_type, force_wn, force_kr, sth_fname, sth_vname,  &
  &                zetam, sth_thres_zeta, cent_lat, tcx, tcy
  namelist /restart /resopt, resfname, restp
  read(5,nml=input)
  read(5,nml=restart)

  kxnt=2*hxnt+1
  kynt=2*hynt+1
  dx=Lx/dble(nx-1)
  dy=Ly/dble(ny-1)
  xmin=0.0d0
  ymin=0.0d0

end subroutine fft_read_name_isp

end module fft_read_namelist
