module saveval_define

!-- setting variables

!-- namelist variables

  integer, save :: nxi     ! grid number of x direction
  integer, save :: nyi     ! grid number of y direction
  integer, save :: nx      ! grid number of x direction
  integer, save :: ny      ! grid number of y direction
  integer, save :: nt      ! grid number of time
  integer, save :: dmpstp  ! output interval

  double precision, save :: xmin    ! minimum x-coordinate
  double precision, save :: ymin    ! minimum x-coordinate
  double precision, save :: dx      ! grid interval of x direction
  double precision, save :: dy      ! grid interval of y direction
  double precision, save :: dt      ! grid interval of time
  double precision, save :: nu      ! diffusion coefficient
  double precision, save :: eps     ! Poisson condition
  double precision, save :: betaf   ! beta coefficient

  character(1), save :: adv_flag     ! advection scheme
  character(3), save :: time_flag    ! time integration type
  character(4), save :: boundary     ! boundary condition flag
  character(1000), save :: ininame   ! input file name
  character(1000), save :: foname    ! output file name
  character(100), save :: inix       ! X-coordinate name
  character(100), save :: iniy       ! y-coordinate name
  character(100), save :: iniz       ! initial zeta name

!-- others variables

  real, allocatable, dimension(:), save :: xi      ! array of x direction
  real, allocatable, dimension(:), save :: yi      ! array of y direction
  real, allocatable, dimension(:), save :: xd      ! array of x direction
  real, allocatable, dimension(:), save :: yd      ! array of y direction
  double precision, allocatable, dimension(:), save :: x  ! array of x direction
  double precision, allocatable, dimension(:), save :: y  ! array of y direction
  double precision, allocatable, dimension(:), save :: t  ! array of time
  double precision, allocatable, dimension(:,:), save :: bnd   ! boundary values

end module saveval_define
