module m_phase1

  implicit none

contains

  subroutine phase1( nx, ny, ival1, oval1, fval1, wnx, wny, fff )

  use Math_Const
  use ffts

  implicit none

  integer, intent(in) :: nx, ny
  double precision, dimension(nx,ny), intent(in) :: ival1
  double precision, dimension(nx,ny), intent(out) :: oval1
  double precision, dimension(nx,ny), intent(out) :: fval1
  integer, intent(in) :: wnx, wny
  character(1), intent(in) :: fff

  integer, parameter :: ifft=5
  integer :: i, j, imax, jmax
  double precision :: t1, t2, t3
  integer, dimension(ifft) :: pxfact, pyfact, pxsfact, pysfact
  double precision, dimension(2*nx-1,2*ny-1) :: tmp1, tmp2
! For FFTJ
  integer :: ITJ(4), ITI(4)
  double precision :: TJ(ny*6), TI(nx*6)
  double precision :: WG(ny,nx)
  double precision :: ifval1(ny,nx), ifval2(-(ny/2-1):ny/2-1,-(nx/2-1):nx/2-1)
  double precision :: icval1(ny,nx), icval2(-(ny/2-1):ny/2-1,-(nx/2-1):nx/2-1)
! For ISPACK
  integer :: SITJ(5), SITI(5)
  double precision :: STJ(ny*2), STI(nx*2)
!  !!!! REAL for JSM
  real, dimension(nx,ny) :: dcpval1, dcpval2, dfpval1, dfpval2
  complex(kind(0d0)), dimension(nx,ny) :: cpval1, cpval2, fpval1, fpval2
  complex(kind(0d0)), allocatable, dimension(:,:) :: omegaxbr, omegaybr, omegaxbi, omegaybi
  complex(kind(0d0)), allocatable, dimension(:,:) :: omegaxnr, omegaynr, omegaxni, omegayni
  complex(kind(0d0)), allocatable, dimension(:,:) :: omegaxbrs, omegaybrs, omegaxbis, omegaybis
  complex(kind(0d0)), allocatable, dimension(:,:) :: omegaxnrs, omegaynrs, omegaxnis, omegaynis

  imax=2*nx-1
  jmax=2*ny-1

  if(fff(1:1)=='s')then

     call rotate_array_d()
     call prim_calc( nx, pxfact(1:4), pxfact(5) )
     call prim_calc( ny, pyfact(1:4), pyfact(5) )
     call prim_calc( nx, pxsfact(1:4), pxsfact(5) )
     call prim_calc( ny, pysfact(1:4), pysfact(5) )

     allocate(omegaxnr(0:nx-1,0:nx-1))
     allocate(omegaynr(0:ny-1,0:ny-1))
     allocate(omegaxni(0:nx-1,0:nx-1))
     allocate(omegayni(0:ny-1,0:ny-1))
     allocate(omegaxbr(0:pxfact(5)-1,0:pxfact(5)-1))
     allocate(omegaybr(0:pyfact(5)-1,0:pyfact(5)-1))
     allocate(omegaxbi(0:pxfact(5)-1,0:pxfact(5)-1))
     allocate(omegaybi(0:pyfact(5)-1,0:pyfact(5)-1))
     allocate(omegaxnrs(0:nx-1,0:nx-1))
     allocate(omegaynrs(0:ny-1,0:ny-1))
     allocate(omegaxnis(0:nx-1,0:nx-1))
     allocate(omegaynis(0:ny-1,0:ny-1))
     allocate(omegaxbrs(0:pxsfact(5)-1,0:pxsfact(5)-1))
     allocate(omegaybrs(0:pysfact(5)-1,0:pysfact(5)-1))
     allocate(omegaxbis(0:pxsfact(5)-1,0:pxsfact(5)-1))
     allocate(omegaybis(0:pysfact(5)-1,0:pysfact(5)-1))

     call rotate_calc( nx, 'r', pxfact,  &
     &               omegaxbr(0:pxfact(5)-1,0:pxfact(5)-1),  &
     &               omegaxnr(0:nx-1,0:nx-1) )
     call rotate_calc( nx, 'i', pxfact,  &
     &               omegaxbi(0:pxfact(5)-1,0:pxfact(5)-1),  &
     &               omegaxni(0:nx-1,0:nx-1) )
     call rotate_calc( ny, 'r', pyfact,  &
     &               omegaybr(0:pyfact(5)-1,0:pyfact(5)-1),  &
     &               omegaynr(0:ny-1,0:ny-1) )
     call rotate_calc( ny, 'i', pyfact,  &
     &               omegaybi(0:pyfact(5)-1,0:pyfact(5)-1),  &
     &               omegayni(0:ny-1,0:ny-1) )

     call rotate_calc( nx, 'r', pxsfact,  &
     &               omegaxbrs(0:pxsfact(5)-1,0:pxsfact(5)-1),  &
     &               omegaxnrs(0:nx-1,0:nx-1) )
     call rotate_calc( nx, 'i', pxsfact,  &
     &               omegaxbis(0:pxsfact(5)-1,0:pxsfact(5)-1),  &
     &               omegaxnis(0:nx-1,0:nx-1) )
     call rotate_calc( ny, 'r', pysfact,  &
     &               omegaybrs(0:pysfact(5)-1,0:pysfact(5)-1),  &
     &               omegaynrs(0:ny-1,0:ny-1) )
     call rotate_calc( ny, 'i', pysfact,  &
     &               omegaybis(0:pysfact(5)-1,0:pysfact(5)-1),  &
     &               omegaynis(0:ny-1,0:ny-1) )

  else if(fff(1:1)=='i')then

     call PZINIT(ny,nx,ITJ,TJ,ITI,TI)

  else if(fff(1:1)=='k')then

     call P2INIT(ny,nx,SITJ,STJ,SITI,STI)

  end if

  do j=1,ny
     do i=1,nx
        cpval1(i,j)=ival1(i,j)
        fpval1(i,j)=cpval1(i,j)
        dcpval1(i,j)=real(ival1(i,j))
        dfpval1(i,j)=real(ival1(i,j))
        ifval1(j,i)=ival1(i,j)
        icval1(j,i)=ival1(i,j)
     end do
  end do

  call cpu_time(t1)

  if(fff(1:1)=='s')then
     call ffttp_2d( nx, ny,  &
  &                 cpval1(1:nx,1:ny),  &
  &                 cpval2(1:nx,1:ny),  &
  &                 'r', 'o', prim_factx=pxsfact, prim_facty=pysfact,  &
  &                 omegax_fix=omegaxbrs, omegaxn_fix=omegaxnrs,  &
  &                 omegay_fix=omegaybrs, omegayn_fix=omegaynrs )

     call ffttp_2d( nx, ny,  &
  &                 fpval1(1:nx,1:ny),  &
  &                 fpval2(1:nx,1:ny),  &
  &                 'r', 'o', prim_factx=pxsfact, prim_facty=pysfact,  &
  &                 omegax_fix=omegaxbrs, omegaxn_fix=omegaxnrs,  &
  &                 omegay_fix=omegaybrs, omegayn_fix=omegaynrs )

  else if(fff(1:1)=='j')then
     call DFFT1( dcpval1(1:nx,1:ny), nx, ny,  &
  &              dcpval2(1:nx,1:ny), nx, ny,  &
  &              'GTOW', 'CC', tmp1, tmp2, imax, jmax )
     call DFFT1( dfpval1(1:nx,1:ny), nx, ny,  &
  &              dfpval2(1:nx,1:ny), nx, ny,  &
  &              'GTOW', 'CC', tmp1, tmp2, imax, jmax )

  else if(fff(1:1)=='i')then
     ifval2=0.0d0
     call PZG2SA( ny/2-1, nx/2-1, ny, nx, ifval1, ifval2, WG, ITJ, TJ, ITI, TI )
     icval2=0.0d0
     call PZG2SA( ny/2-1, nx/2-1, ny, nx, icval1, icval2, WG, ITJ, TJ, ITI, TI )

  else if(fff(1:1)=='k')then
     ifval2=0.0d0
     call P2G2SA( ny/2-1, nx/2-1, ny, nx, ifval1, ifval2, WG,  &
  &               SITJ, STJ, SITI, STI )
     icval2=0.0d0
     call P2G2SA( ny/2-1, nx/2-1, ny, nx, icval1, icval2, WG,  &
  &               SITJ, STJ, SITI, STI )
  end if

  call cpu_time(t2)

  write(*,*) "cpu_time [RFFT] is ", t2-t1, "[sec]."

  call cpu_time(t1)

  if(fff(1:1)=='s')then
     call ffttp_2d( nx, ny, cpval2(1:nx,1:ny), cpval1(1:nx,1:ny),  &
  &                 'i', 'o', prim_factx=pxfact, prim_facty=pyfact,  &
  &                 omegax_fix=omegaxbi, omegaxn_fix=omegaxni,  &
  &                 omegay_fix=omegaybi, omegayn_fix=omegayni )

     call ffttp_2d( nx, ny, fpval2(1:nx,1:ny), fpval1(1:nx,1:ny),  &
  &                 'i', 'o', prim_factx=pxfact, prim_facty=pyfact,  &
  &                 omegax_fix=omegaxbi, omegaxn_fix=omegaxni,  &
  &                 omegay_fix=omegaybi, omegayn_fix=omegayni )
  else if(fff(1:1)=='j')then
     call DFFT1( dcpval2(1:nx,1:ny), nx, ny,  &
  &              dcpval1(1:nx,1:ny), nx, ny,  &
  &              'WTOG', 'CC', tmp1, tmp2, imax, jmax )
     call DFFT1( dfpval2(1:nx,1:ny), nx, ny,  &
  &              dfpval1(1:nx,1:ny), nx, ny,  &
  &              'WTOG', 'CC', tmp1, tmp2, imax, jmax )

  else if(fff(1:1)=='i')then
     ifval1=0.0d0
     call PZS2GA( ny/2-1, nx/2-1, ny, nx, ifval2, ifval1, WG, ITJ, TJ, ITI, TI )
     icval1=0.0d0
     call PZS2GA( ny/2-1, nx/2-1, ny, nx, icval2, icval1, WG, ITJ, TJ, ITI, TI )

  else if(fff(1:1)=='k')then
     ifval1=0.0d0
     call P2S2GA( ny/2-1, nx/2-1, ny, nx, ifval2, ifval1, WG,  &
  &               SITJ, STJ, SITI, STI )
     icval1=0.0d0
     call P2S2GA( ny/2-1, nx/2-1, ny, nx, icval2, icval1, WG,  &
  &               SITJ, STJ, SITI, STI )
  end if

  call cpu_time(t2)

  write(*,*) "cpu_time [IFFT] is ", t2-t1, "[sec]."

  if(fff(1:1)=='s')then
     do j=1,ny
        do i=1,nx
           oval1(i,j)=dble(cpval1(i,j))
           fval1(i,j)=dble(fpval1(i,j))
        end do
     end do
  else if(fff(1:1)=='j')then
     do j=1,ny
        do i=1,nx
           oval1(i,j)=dble(dcpval1(i,j))
           fval1(i,j)=dble(dfpval1(i,j))
        end do
     end do
  else if(fff(1:1)=='i'.or.fff(1:1)=='k')then
     do j=1,ny
        do i=1,nx
           oval1(i,j)=icval1(j,i)
           fval1(i,j)=ifval1(j,i)
        end do
     end do
  end if

  end subroutine phase1

end module m_phase1

program fft_check1

!-- FFT 正変換のデータを任意数で間引く.
!-- シングルプロセスでのみ動作.
!-- FFT ルーチンのチェックのために行うので,
!-- 計算結果はスペクトル空間の情報をそのまま数値的に表示する.

  use m_phase1
  use math_const
  use max_min

  implicit none

  integer, parameter :: nx=1024, ny=1024
  integer, parameter :: wnx=10, wny=5

  integer :: i, j, k, l, icounter, ip, jp
  integer :: ixmax, iymax
  double precision :: emax
  double precision :: x(nx), y(ny)
  double precision, allocatable, dimension(:,:) :: valp1
  double precision, allocatable, dimension(:) :: totsp1, totsp2
  double precision, dimension(nx,ny) :: ival1, oval0, oval1, oval2, fval1, error
  character(1) :: fff

  write(*,*) "Set FFT mode [s/j/i/k]."
  write(*,*) "s = stpk FFT, j = JSM FFT, i = FFTJ, k = ISPACK."
  read(*,*) fff

  if(fff(1:1)=='s')then
     write(*,*) "Mode stpk FFT."
  else if(fff(1:1)=='j')then
     write(*,*) "Mode JSM FFT."
  else if(fff(1:1)=='i')then
     write(*,*) "Mode FFTJ."
  else if(fff(1:1)=='k')then
     write(*,*) "Mode ISPACK FFT."
  end if

     x=(/((dble(i)/dble(nx)),i=1,nx)/)
     y=(/((dble(j)/dble(ny)),j=1,ny)/)

     ival1=0.0

     do j=1,ny
        do i=1,nx
           do l=0,wny
              do k=0,wnx
                 ival1(i,j)=ival1(i,j)  &
  &                         +dsin(2.0d0*pi_dp*(dble(k)*dble(i-1)/dble(nx)  &
  &                                           +dble(l)*dble(j-1)/dble(ny)))
              end do
           end do
        end do
     end do

!-- Normalize ival1

     call max_val_2d( ival1, ixmax, iymax, emax )

     do j=1,ny
        do i=1,nx
           ival1(i,j)=ival1(i,j)/emax
        end do
     end do

     call phase1( nx, ny, ival1, oval1, fval1, wnx, wny, fff )

     do j=1,ny
        do i=1,nx
           error(i,j)=dabs(oval1(i,j)-ival1(i,j))
        end do
     end do

     call max_val_2d( error, ixmax, iymax, emax )

     write(*,'(a28)') "*********** Result **********"
     write(*,'(a12,1PE16.8)') "ERROR max : ", emax
     write(*,'(a12,1PE16.8)') "Input val : ", ival1(ixmax,iymax)
     write(*,'(a12,1PE16.8)') "Output val: ", oval1(ixmax,iymax)

     do j=1,ny
        do i=1,nx
           error(i,j)=dabs(fval1(i,j)-ival1(i,j))
        end do
     end do

     call max_val_2d( error, ixmax, iymax, emax )

     write(*,'(a28)') "******* Result (full) ******"
     write(*,'(a12,1PE16.8)') "ERROR max : ", emax
     write(*,'(a12,1PE16.8)') "Input val : ", ival1(ixmax,iymax)
     write(*,'(a12,1PE16.8)') "Output val: ", fval1(ixmax,iymax)

end program fft_check1
