module file_output
!-- module to control file input and output.
  use sub_mod
  use fftsub_mod

contains

subroutine dmp_file( psik, uk_sbl, vk_sbl, pk, itime, history )
!-- control file output
  use gtool_history
  use savegloval_define
  implicit none
  complex(kind(0d0)), intent(in) :: psik(:,:)
  complex(kind(0d0)), intent(in) :: uk_sbl(size(psik,1),size(psik,2))
  complex(kind(0d0)), intent(in) :: vk_sbl(size(psik,1),size(psik,2))
  complex(kind(0d0)), intent(in) :: pk(size(psik,1),size(psik,2))
  integer, intent(in) :: itime
  type(GT_HISTORY), intent(inout) :: history
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)) ::  &
  &                   uk_nbm, vk_nbm, zk_nbm, wk_sbl
  double precision, dimension(nx,ny) :: tmpd
  real, dimension(nx,ny) :: psi_nbm, u_nbm, v_nbm, z_nbm, u_sbl, v_sbl, w_sbl, p

  if(size(psik,1)/=kxnt)then
     write(*,*) "*** ERROR (dmp_file) *** : 1st array in psik is mismatch."
     stop
  end if
  
  if(size(psik,2)/=kynt)then
     write(*,*) "*** ERROR (dmp_file) *** : 2nd array in psik is mismatch."
     stop
  end if

  call psik2ukvk( psik(1:kxnt,1:kynt), uk_nbm(1:kxnt,1:kynt), vk_nbm(1:kxnt,1:kynt) )
  call psik2zetak( psik(1:kxnt,1:kynt), zk_nbm(1:kxnt,1:kynt), zkopt=basezeta )
  call W_divergence( uk_sbl(1:kxnt,1:kynt), vk_sbl(1:kxnt,1:kynt), wk_sbl(1:kxnt,1:kynt) )

  call spec2phys( psik, tmpd )
  call type_convert_d2r( tmpd, psi_nbm )
  call spec2phys( uk_nbm, tmpd )
  call type_convert_d2r( tmpd, u_nbm )
  call spec2phys( vk_nbm, tmpd )
  call type_convert_d2r( tmpd, v_nbm )
  call spec2phys( zk_nbm, tmpd )
  call type_convert_d2r( tmpd, z_nbm )
  call spec2phys( uk_sbl, tmpd )
  call type_convert_d2r( tmpd, u_sbl )
  call spec2phys( vk_sbl, tmpd )
  call type_convert_d2r( tmpd, v_sbl )
  call spec2phys( wk_sbl, tmpd )
  call type_convert_d2r( tmpd, w_sbl )
  call spec2phys( pk, tmpd )
  call type_convert_d2r( tmpd, p )

  call output_2d( psi_nbm, u_nbm, v_nbm, z_nbm, p,  &
  &               u_sbl, v_sbl, w_sbl, history )

  write(*,*) "*******************************************"
  write(*,*) "File damp (time =", dble(itime)*dt, "[s])."
  write(*,*) "*******************************************"

end subroutine dmp_file


subroutine output_2d( psi, u_nbm, v_nbm, z_nbm, p,  &
  &                   u_sbl, v_sbl, w_sbl, history )
!-- output 2d variables in NetCDF file
  use gtool_history
  use savegloval_define
  implicit none
  real, intent(in) :: psi(:,:)
  real, intent(in) :: u_nbm(size(psi,1),size(psi,2))
  real, intent(in) :: v_nbm(size(psi,1),size(psi,2))
  real, intent(in) :: z_nbm(size(psi,1),size(psi,2))
  real, intent(in) :: p(size(psi,1),size(psi,2))
  real, intent(in) :: u_sbl(size(psi,1),size(psi,2))
  real, intent(in) :: v_sbl(size(psi,1),size(psi,2))
  real, intent(in) :: w_sbl(size(psi,1),size(psi,2))
  type(GT_HISTORY), intent(inout) :: history

  call HistoryPut( 'psi', psi, history=history )
  call HistoryPut( 'unbm', u_nbm, history=history )
  call HistoryPut( 'vnbm', v_nbm, history=history )
  call HistoryPut( 'zeta', z_nbm, history=history )
  call HistoryPut( 'p', p, history=history )
  call HistoryPut( 'usbl', u_sbl, history=history )
  call HistoryPut( 'vsbl', v_sbl, history=history )
  call HistoryPut( 'wsbl', w_sbl, history=history )

end subroutine output_2d


subroutine make_restart( itn, rtn, psik, uk_sbl, vk_sbl,  &
  &                      zk_nbm, nbm_opt, sbl_optu, sbl_optv )
!-- output restart file
  use savegloval_define
  use gtool_history
  implicit none
  integer, intent(in) :: itn
  real, intent(in) :: rtn
  complex(kind(0d0)), dimension(:,:), intent(in) :: psik
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), intent(in) :: uk_sbl
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), intent(in) :: vk_sbl
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), intent(in) :: zk_nbm
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), optional, intent(in) :: nbm_opt
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), optional, intent(in) :: sbl_optu
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), optional, intent(in) :: sbl_optv
  double precision, dimension(size(psik,1),size(psik,2)) :: tmpd
  type(GT_HISTORY) :: res_hst
  integer :: ix, jy, ii, jj

  ix=size(psik,1)
  jy=size(psik,2)

  call HistoryCreate( file=trim(adjustl(resfname)),  &
  &    title='SBL_NBM result data', &
  &    source='test', institution='test', dims=(/'x', 'y'/),  &
  &    dimsizes=(/ ix, jy /),  & 
  &    longnames=(/'X-coordinate','Y-coordinate'/),  &
  &    units=(/'m', 'm'/), history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(respsir)), dims=(/'x','y'/), &
  &                        longname='stream line function',  &
  &                        units='m2 s-1', xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(respsii)), dims=(/'x','y'/), &
  &                        longname='stream line function',  &
  &                        units='m2 s-1', xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(reszetar)), dims=(/'x','y'/), &
  &                        longname='vorticity', units='s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(reszetai)), dims=(/'x','y'/), &
  &                        longname='vorticity', units='s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(resusblr)), dims=(/'x','y'/), &
  &                        longname='X-velocity in SBL', units='m s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(resusbli)), dims=(/'x','y'/), &
  &                        longname='X-velocity in SBL', units='m s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(resvsblr)), dims=(/'x','y'/), &
  &                        longname='Y-velocity in SBL', units='m s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname=trim(adjustl(resvsbli)), dims=(/'x','y'/), &
  &                        longname='Y-velocity in SBL', units='m s-1',  &
  &                        xtype='double', history=res_hst )

  call HistoryAddVariable( varname='xd', dims=(/'x'/), &
  &                        longname='X-coord double',  &
  &                        units='m', xtype='double', history=res_hst )

  call HistoryAddVariable( varname='yd', dims=(/'y'/), &
  &                        longname='Y-coord double',  &
  &                        units='m', xtype='double', history=res_hst )

  if(present(nbm_opt))then
     call HistoryAddVariable( varname=trim(adjustl(res_nbm_optr)),  &
  &                           dims=(/'x','y'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )

     call HistoryAddVariable( varname=trim(adjustl(res_nbm_opti)),  &
  &                           dims=(/'x','y'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )
  end if

  if(present(sbl_optu))then
     call HistoryAddVariable( varname=trim(adjustl(res_sbl_optur)),  &
  &                           dims=(/'x','y'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )

     call HistoryAddVariable( varname=trim(adjustl(res_sbl_optui)),  &
  &                           dims=(/'x','y'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )
  end if

  if(present(sbl_optv))then
     call HistoryAddVariable( varname=trim(adjustl(res_sbl_optvr)),  &
  &                           dims=(/'x','y'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )

     call HistoryAddVariable( varname=trim(adjustl(res_sbl_optvi)),  &
  &                           dims=(/'x','y'/), longname='vorticity',  &
  &                           units='s-1', xtype='double', history=res_hst )
  end if

  !-- Trivial (not reuse)
  call HistoryPut( 'x', xd(1:ix), history=res_hst )
  call HistoryPut( 'y', yd(1:jy), history=res_hst )

  call HistoryAddAttr( trim(adjustl(respsir)), trim(adjustl(rest)),  &
  &                    rtn, history=res_hst )
  call HistoryAddAttr( trim(adjustl(respsir)), trim(adjustl(restn)),  &
  &                    itn, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dble(psik(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(respsir)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dimag(psik(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(respsii)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dble(zk_nbm(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(reszetar)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dimag(zk_nbm(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(reszetai)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dble(uk_sbl(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(resusblr)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dimag(uk_sbl(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(resusbli)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dble(vk_sbl(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(resvsblr)), tmpd, history=res_hst )

  do jj=1,jy
     do ii=1,ix
        tmpd(ii,jj)=dimag(vk_sbl(ii,jj))
     end do
  end do

  call HistoryPut( trim(adjustl(resvsbli)), tmpd, history=res_hst )

  !-- Trivial (not reuse)
  call HistoryPut( 'xd', x(1:ix), history=res_hst )
  call HistoryPut( 'yd', y(1:jy), history=res_hst )

  if(present(nbm_opt))then

     do jj=1,jy
        do ii=1,ix
           tmpd(ii,jj)=dble(nbm_opt(ii,jj))
        end do
     end do

     call HistoryPut( trim(adjustl(res_nbm_optr)), tmpd, history=res_hst )

     do jj=1,jy
        do ii=1,ix
           tmpd(ii,jj)=dimag(nbm_opt(ii,jj))
        end do
     end do

     call HistoryPut( trim(adjustl(res_nbm_opti)), tmpd, history=res_hst )

  end if

  if(present(sbl_optu))then

     do jj=1,jy
        do ii=1,ix
           tmpd(ii,jj)=dble(sbl_optu(ii,jj))
        end do
     end do

     call HistoryPut( trim(adjustl(res_sbl_optur)), tmpd, history=res_hst )

     do jj=1,jy
        do ii=1,ix
           tmpd(ii,jj)=dimag(sbl_optu(ii,jj))
        end do
     end do

     call HistoryPut( trim(adjustl(res_sbl_optui)), tmpd, history=res_hst )

  end if

  if(present(sbl_optv))then

     do jj=1,jy
        do ii=1,ix
           tmpd(ii,jj)=dble(sbl_optv(ii,jj))
        end do
     end do

     call HistoryPut( trim(adjustl(res_sbl_optvr)), tmpd, history=res_hst )

     do jj=1,jy
        do ii=1,ix
           tmpd(ii,jj)=dimag(sbl_optv(ii,jj))
        end do
     end do

     call HistoryPut( trim(adjustl(res_sbl_optvi)), tmpd, history=res_hst )

  end if

  call HistoryClose( history=res_hst )

end subroutine make_restart


subroutine read_restart( filename, psik, zk_nbm, uk_sbl, vk_sbl,  &
  &                      nbm_opt, sbl_optu, sbl_optv )
!-- output restart file
  use savegloval_define
  use gtool_history
  implicit none
  character(*), intent(in) :: filename
  complex(kind(0d0)), dimension(:,:), intent(out) :: psik
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), intent(out) :: zk_nbm
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), intent(out) :: uk_sbl
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), intent(out) :: vk_sbl
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), optional, intent(out) :: nbm_opt
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), optional, intent(out) :: sbl_optu
  complex(kind(0d0)), dimension(size(psik,1),size(psik,2)), optional, intent(out) :: sbl_optv
  double precision, dimension(size(psik,1),size(psik,2)) :: tmpr, tmpi
  type(GT_HISTORY) :: res_hst
  integer :: ix, jy, ii, jj
  complex(kind(0d0)) :: img_unit

  ix=size(psik,1)
  jy=size(psik,2)
  img_unit=(0.0d0,1.0d0)

  call HistoryGet( trim(adjustl(filename)), trim(adjustl(respsir)), tmpr )
  call HistoryGet( trim(adjustl(filename)), trim(adjustl(respsii)), tmpi )

  do jj=1,jy
     do ii=1,ix
        psik(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
     end do
  end do

  call HistoryGet( trim(adjustl(filename)), trim(adjustl(reszetar)), tmpr )
  call HistoryGet( trim(adjustl(filename)), trim(adjustl(reszetai)), tmpi )

  do jj=1,jy
     do ii=1,ix
        zk_nbm(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
     end do
  end do

  call HistoryGet( trim(adjustl(filename)), trim(adjustl(resusblr)), tmpr )
  call HistoryGet( trim(adjustl(filename)), trim(adjustl(resusbli)), tmpi )

  do jj=1,jy
     do ii=1,ix
        uk_sbl(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
     end do
  end do

  call HistoryGet( trim(adjustl(filename)), trim(adjustl(resvsblr)), tmpr )
  call HistoryGet( trim(adjustl(filename)), trim(adjustl(resvsbli)), tmpi )

  do jj=1,jy
     do ii=1,ix
        vk_sbl(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
     end do
  end do

  if(present(nbm_opt))then
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_nbm_optr)), tmpr )
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_nbm_opti)), tmpi )

     do jj=1,jy
        do ii=1,ix
           nbm_opt(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
        end do
     end do

  end if

  if(present(sbl_optu))then
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_sbl_optur)), tmpr )
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_sbl_optui)), tmpi )

     do jj=1,jy
        do ii=1,ix
           sbl_optu(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
        end do
     end do

  end if

  if(present(sbl_optv))then
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_sbl_optvr)), tmpr )
     call HistoryGet( trim(adjustl(filename)), trim(adjustl(res_sbl_optvi)), tmpi )

     do jj=1,jy
        do ii=1,ix
           sbl_optv(ii,jj)=dble(tmpr(ii,jj))+img_unit*tmpi(ii,jj)
        end do
     end do

  end if

end subroutine read_restart

subroutine output_initialization( history )
!-- initialize the output file
  use savegloval_define
  use gtool_history
  implicit none
  integer :: i, subm
  integer :: access, status
  type(GT_HISTORY), intent(inout) :: history

  if(resopt==0)then
     call HistoryCreate( file=trim(adjustl(foname)),  &
  &       title='NBM-SBL result data', source='test',  &
  &       institution='test', dims=(/'x', 'y', 't'/),  &
  &       dimsizes=(/ nx, ny, 0 /),  & 
  &       longnames=(/'X-coordinate','Y-coordinate', 'time        '/),  &
  &       units=(/'m', 'm', 's'/), origin=0.0,  &
  &       interval=real(dmpstp)*real(dt), history=history )

  else if(resopt==1)then

     do i=1,subn
        status=access( 'swap'//trim(adjustl(subhead(i)))//'.'//  &
  &                    trim(adjustl(foname)), ' ' )
        if(status/=0)then
           subm=i
           exit
        end if
     end do

     call HistoryCreate( file='swap'//trim(adjustl(subhead(subm)))//'.'//  &
  &                           trim(adjustl(foname)),  &
  &       title='BAROTRO result data', &
  &       source='test', institution='test', dims=(/'x', 'y', 't'/),  &
  &       dimsizes=(/ nx, ny, 0 /),  & 
  &       longnames=(/'X-coordinate','Y-coordinate', 'time        '/),  &
  &       units=(/'m', 'm', 's'/), origin=restime,  &
  &       interval=real(dmpstp)*real(dt), history=history )
  
  end if

  call HistoryPut( 'x', xd, history=history )
  call HistoryPut( 'y', yd, history=history )

  call HistoryAddVariable( varname='psi', dims=(/'x','y','t'/), &
  &                        longname='stream line function',  &
  &                        units='m2 s-1', xtype='float', history=history )

  call HistoryAddVariable( varname='zeta', dims=(/'x','y','t'/), &
  &                        longname='vorticity', units='s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='unbm', dims=(/'x','y','t'/), &
  &                        longname='X wind in NBM', units='m s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='vnbm', dims=(/'x','y','t'/), &
  &                        longname='Y wind in NBM', units='m s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='p', dims=(/'x','y','t'/), &
  &                        longname='pressure in NBM', units='Pa',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='usbl', dims=(/'x','y','t'/), &
  &                        longname='X wind in SBL', units='m s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='vsbl', dims=(/'x','y','t'/), &
  &                        longname='Y wind in SBL', units='m s-1',  &
  &                        xtype='float', history=history )

  call HistoryAddVariable( varname='wsbl', dims=(/'x','y','t'/), &
  &                        longname='Vertical velocity at the top of SBL', units='m s-1',  &
  &                        xtype='float', history=history )

end subroutine output_initialization


end module file_output
