program make_init
!-- producing initial data of zeta
!-- Version Schubert et al. (1999).

  use gtool_history
  use mt_stream

  implicit none

  integer, parameter :: nc=10

!-- namelist variables

  integer :: nx, ny
  integer :: nnum, mnum
  real, allocatable, dimension(:) :: xr, yr
  double precision :: xmin, ymin, dx, dy
  double precision, dimension(nc) :: zetabar, zetap, rn, dn
  double precision :: zetaa
  character(1000) :: fname, sig

!-- MT variables
  type(mt_state) :: mts, mts_tmp
  type(mt_state), allocatable, dimension(:) :: mtsn
  integer, external :: time
  double precision, allocatable, dimension(:) :: mtv

  integer :: i, j, k
  double precision :: r, theta
  double precision, dimension(nc) :: tcx, tcy
  double precision, allocatable, dimension(:) :: x, y
  double precision, allocatable, dimension(:,:) :: zeta
  double precision :: makez

  namelist /initial /nx, ny, xmin, ymin, dx, dy, fname,  &
  &                  tcx, tcy
  namelist /vprof /zetabar, zetap, rn, dn, nnum, mnum, zetaa, sig
  read(5,nml=initial)
  read(5,nml=vprof)

  if(nnum>nc)then
     write(*,*) "*** ERROR (main) *** : namelist variable 'nnum' is <=", nnum, '.'
     write(*,*) "STOP."
     stop
  end if

  allocate(mtv(mnum))
  allocate(mtsn(mnum))

!-- operating MT-19937

  call set_mt19937

  call new( mts )
  call init( mts, time() )

  do i=1,mnum
     mts_tmp=mts
     call create_stream( mts_tmp, mtsn(i), i )
     mtv(i)=genrand_double1( mtsn(i) )
  end do

  write(*,*) "check mtv", mtv

  allocate(x(nx))
  allocate(y(ny))
  allocate(xr(nx))
  allocate(yr(ny))
  allocate(zeta(nx,ny))

  x=(/((xmin+dx*dble(i-1)),i=1,nx)/)
  y=(/((ymin+dy*dble(j-1)),j=1,ny)/)

  xr=(/((xmin+dx*real(i-1)),i=1,nx)/)
  yr=(/((ymin+dy*real(j-1)),j=1,ny)/)

  zeta=0.0d0

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,r,theta)

  do j=1,ny
     do i=1,nx
        r=dsqrt((x(i)-tcx(1))**2+(y(j)-tcy(1))**2)
        if(x(i)-tcx(1)>0.0d0.and.y(j)-tcy(1)>0.0d0)then
           theta=datan((y(j)-tcy(1))/(x(i)-tcx(1)))
        else if(x(i)-tcx(1)<0.0d0.and.y(j)-tcy(1)>0.0d0)then
           theta=dabs(dacos(-1.0d0))-datan((y(j)-tcy(1))/dabs(x(i)-tcx(1)))
        else if(x(i)-tcx(1)<0.0d0.and.y(j)-tcy(1)<0.0d0)then
           theta=dabs(dacos(-1.0d0))+datan(dabs(y(j)-tcy(1))/dabs(x(i)-tcx(1)))
        else if(x(i)-tcx(1)>0.0d0.and.y(j)-tcy(1)<0.0d0)then
           theta=2.0d0*dabs(dacos(-1.0d0))-datan(dabs(y(j)-tcy(1))/(x(i)-tcx(1)))
        else if(x(i)-tcx(1)==0.0d0.and.y(j)-tcy(1)<0.0d0)then
           theta=1.5d0*dabs(dacos(-1.0d0))
        else if(x(i)-tcx(1)==0.0d0.and.y(j)-tcy(1)>0.0d0)then
           theta=0.5d0*dabs(dacos(-1.0d0))
        else if(x(i)-tcx(1)>0.0d0.and.y(j)-tcy(1)==0.0d0)then
           theta=0.0d0
        else if(x(i)-tcx(1)<0.0d0.and.y(j)-tcy(1)==0.0d0)then
           theta=dabs(dacos(-1.0d0))
        end if
        zeta(i,j)=makez( r, theta, nnum, zetabar(1:nnum), zetap(1:nnum),  &
  &                      rn(1:nnum-1), dn(1:nnum-1), sig(1:nnum-1),  &
  &                      mnum, zetaa, mtv )
     end do
  end do

!$omp end do
!$omp end parallel

  call HistoryCreate( file=trim(adjustl(fname)), title='BAROTRO initial data', &
  & source='test', institution='test', dims=(/'x', 'y'/),  &
  & dimsizes=(/ nx, ny /),  &
  & longnames=(/'X-coordinate','Y-coordinate'/),  &
  & units=(/'m', 'm'/) )

  call HistoryPut( 'x', xr )
  call HistoryPut( 'y', yr )

  call HistoryAddVariable( varname='zeta', dims=(/'x','y'/), &
  &    longname='vorticity', units='s-1', xtype='double' )

  call HistoryAddVariable( varname='xd', dims=(/'x'/), &
  &    longname='X-coord double', units='m', xtype='double' )

  call HistoryAddVariable( varname='yd', dims=(/'y'/), &
  &    longname='Y-coord double', units='m', xtype='double' )

  call HistoryPut( 'zeta', zeta )
  call HistoryPut( 'xd', x )
  call HistoryPut( 'yd', y )

  call HistoryClose()

end program

!contains



double precision function makez( radi, ang, nnum, zbar, zp, rn, dn, sig,  &
  &                              mnum, zamp, randp )

  use Math_Const

  implicit none

  double precision :: radi  ! radius [m]
  double precision :: ang   ! angle [rad]
  integer :: nnum
  double precision :: zbar(nnum)
  double precision :: zp(nnum)
  double precision :: rn(nnum-1)
  double precision :: dn(nnum-1)
  character(nnum) :: sig
  integer :: mnum
  double precision :: zamp
  double precision :: randp(mnum)
  integer :: i, k
  double precision :: tmpz, FS, val, coe, s, s1, s2, zptmp

  FS(val)=1.0d0-3.0d0*(val**2)+2.0d0*(val**3)

  if(radi>=0.0d0.and.radi<rn(1)-dn(1))then
     makez=zbar(1)

  else if(radi>=rn(nnum-1)+dn(nnum-1))then
     makez=zbar(nnum)

  else if(radi>=rn(1)-dn(1).and.radi<rn(nnum-1)+dn(nnum-1))then
     do k=1,nnum-1
        if(radi>=rn(k)-dn(k).and.radi<rn(k)+dn(k))then  ! Hermite
           tmpz=0.0d0
           zptmp=0.0d0
           coe=0.5d0/dn(k)
           s1=coe*(radi-rn(k)+dn(k))
           s2=coe*(rn(k)+dn(k)-radi)
           s=0.0d0

           if(sig(k:k)=='+')then
              s=s2
              if(zp(k+1)/=0.0d0)then
                 zptmp=zp(k+1)
              end if
           else if(sig(k:k)=='-')then
              s=s1
              if(zp(k)/=0.0d0)then
                 zptmp=zp(k)
              end if
           end if

           if(zptmp/=0.0d0)then
              do i=1,mnum
                 tmpz=tmpz+dcos(dble(i)*ang+randp(i)*2.0d0*pi_dp)
              end do
           end if

           makez=zbar(k)*FS(s1)+zbar(k+1)*FS(s2)+zamp*zptmp*FS(s)*tmpz

           exit

        else if(radi>=rn(k)+dn(k))then
           if(radi<rn(k+1)-dn(k+1))then  ! constant
        !-- k=nnum-1 の場合, rn(nnum) となるので, 配列の領域外参照が起こるが,
        !   その場合の条件, radi>=rn(nnum-1)+dn(nnum-1) はこの if 文の
        !   別エントリーにあるので, そもそも k=nnum-1 はこの else if に
        !   入ってこない.
              tmpz=0.0d0
              if(zp(k+1)/=0.0d0)then
                 do i=1,mnum
                    tmpz=tmpz+dcos(dble(i)*ang+randp(i)*2.0d0*pi_dp)
                 end do
              end if

              makez=zbar(k+1)+zamp*zp(k+1)*tmpz

              exit

           end if
        end if
     end do

  end if

  return

end function makez

!end program
