module force_solv
! 強制項を計算するモジュール
  use Derivation
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use real_initialize
  use sub_calc

contains

subroutine force()

  implicit none

  integer :: i, j
  real :: dbeta

  dbeta=-1.0

  !-- 強制項の初期化

  call real_init( force_omega )

  !-- 勾配の計算

  call grad_2d( x, y, omega_old, dodx, dody, undeff=undef )
  call grad_2d( x, y, psi_old, dpdx, dpdy, undeff=undef )

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
  do j=1,ny
     do i=1,nx
        if(calc_flag(i,j).eqv..true.)then
           pdoy(i,j)=psi_old(i,j)*dody(i,j)
           pdox(i,j)=psi_old(i,j)*dodx(i,j)
           odpy(i,j)=omega_old(i,j)*dpdy(i,j)
           odpx(i,j)=omega_old(i,j)*dpdx(i,j)
        end if
     end do
  end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i)
  do i=1,nx
     call grad_1d( y, pdox(i,:), dpdoxdy(i,:), undef=undef )
     call grad_1d( y, odpx(i,:), dodpxdy(i,:), undef=undef )
     call laplacian_1d( y, omega_old(i,:), do2dy2(i,:), undef=undef )
  end do
!$omp end do
!$omp end parallel

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j)
  do j=1,ny
     call grad_1d( x, pdoy(:,j), dpdoydx(:,j), undef=undef )
     call grad_1d( x, odpy(:,j), dodpydx(:,j), undef=undef )
     call laplacian_1d( x, omega_old(:,j), do2dx2(:,j), undef=undef )
  end do
!$omp end do
!$omp end parallel

  !-- 方程式の各項を計算, 強制項へ代入

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)

  do j=1,ny
     do i=1,nx
        if(calc_flag(i,j).eqv..true.)then
           AJ(i,j,1)=dpdx(i,j)*dody(i,j)-dpdy(i,j)*dodx(i,j)
           AJ(i,j,2)=dpdoydx(i,j)-dpdoxdy(i,j)
           AJ(i,j,3)=dodpxdy(i,j)-dodpydx(i,j)
           ADV(i,j)=x_inv(i)*(AJ(i,j,1)+AJ(i,j,2)+AJ(i,j,3))/3.0
           BETA(i,j)=-dbeta*dpdy(i,j)*x_inv(i)
           DIFF(i,j)=nu*(do2dx2(i,j)+dodx(i,j)*x_inv(i)+do2dy2(i,j)*x2_inv(i))
           force_omega(i,j)=ADV(i,j)+BETA(i,j)+DIFF(i,j)
        end if
     end do
  end do

!$omp end do
!$omp end parallel

end subroutine

end module force_solv
