program umpk05

  use dcl
  use Math_Const
  use map_function
  use typhoon_analy

  implicit none

  real, parameter :: xmin=60.0, xmax=220.0, ymin=-80.0, ymax=80.0
!  real, parameter :: xmin=100.0, xmax=180.0, ymin=-90.0, ymax=90.0
  real, parameter :: vxmin=0.1, vxmax=0.9, vymin=0.1, vymax=0.9
  real :: d2r, r2d

  integer :: i, j, k, nx, ny, iws, cnum
  integer, allocatable, dimension(:) :: col_map
  real, dimension(5) :: recx, recy
  real, allocatable, dimension(:,:) :: alon, alat, clon, clat, p, q
  real, allocatable, dimension(:) :: col_val
  double precision, allocatable, dimension(:,:) :: dlon, dlat, dh, dclon, dclat
  character(10) :: label

  external  imod

  call SGISET( 'IFONT', 1 )
  call SWLSET( 'LSYSFNT', .true. )
  CALL SWCSET('FONTNAME', 'Nimbus Sans 12')

  nx=400
  ny=400

  allocate(alon(nx,ny))
  allocate(alat(nx,ny))
  allocate(clon(nx,ny))
  allocate(clat(nx,ny))
  allocate(p(nx,ny))
  allocate(q(nx,ny))
  allocate(dlon(nx,ny))
  allocate(dlat(nx,ny))
  allocate(dh(nx,ny))
  allocate(dclon(nx,ny))
  allocate(dclat(nx,ny))

  cnum=12
  allocate(col_val(cnum))
  allocate(col_map(cnum-1))

  col_val=(/0.0, 2.5, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0,  &
  &         40.0, 45.0, 50.0/)
  col_map=(/18999, 28999, 32999, 36999, 43999, 50999, 55999,  &
  &         65999, 70999, 75999, 90999/)

  call glrset( 'rmiss', -100.0 )
  call gllset( 'lmiss', .true. )

  d2r=pi_dp/180.0d0
  r2d=180.0d0/pi_dp

  do i = 1, nx
     alon(i,1:ny) = xmin + (xmax-xmin) * real(i-1) / real(nx-1)
  end do
  dlon=dble(alon)*d2r

  do j = 1, ny
     alat(1:nx,j) = ymin + (ymax-ymin) * real(j-1) / real(ny-1)
  end do
  dlat=dble(alat)*d2r

  dh=15.0d3

  call Parallax_Himawari( dlon, dlat, dh, dclon, dclat )

  do j=1,ny
     do i=1,nx
        p(i,j)=real(ll2radi( dlon(i,j), dlat(i,j), dclon(i,j), dclat(i,j) ))*1.0e-3
        if(p(i,j)>50.0)then
           p(i,j)=-100.0
        end if
     end do
  end do

  call sgscmn(63)

  write(*,*) ' workstation id (i)  ? ;'
  call sgpwsn
  read (*,*) iws

  call gropn( iws )
!  call grfrm

!  call grswnd( xmin, xmax, ymin, ymax )
!  call grsvpt( vxmin, vxmax, vymin, vymax )
!  call grssim( 0.4, 0.0, 0.0 )
!  call grsmpl( 140.7, 0.0, 0.0 )
!  call grstxy( -180.0, 180.0, 0.0, 90.0 )
!  call grstrn( 30 )
!  call grstrf
!  call sglset( 'lclip', .true. )

!  do i=1,cnum-1
!     call DclSetShadeLevel( col_val(i), col_val(i+1), col_map(i) )
!  end do

!  call DclShadeContour( p )

!  call DclSetShadeLevel( 0.0, 0.0001, 15999 )
!  call DclSetShadeLevel( 0.0001, 0.0002, 25999 )
!  call DclSetShadeLevel( 0.0002, 0.0003, 35999 )
!  call DclSetShadeLevel( 0.0003, 0.0012, 45999 )
!  call DclSetShadeLevel( 0.0012, 0.00125, 55999 )
!  call DclSetShadeLevel( 0.00125, 0.00135, 65999 )
!  call DclSetShadeLevel( 0.00135, 0.00175, 75999 )
!  call DclSetShadeLevel( 0.001375, 0.0014, 85999 )

!  call DclShadeContour( pdeg )

!  call umpmap( 'coast_world' )
!  call umpglb

!  call DclSetContourLevel( 0.001, 0.003, 0.0002 )
!  call DclDrawContour( pdeg )

  call Parallax_Himawari_THap( dlon, dlat, dh, dclon, dclat )

  do j=1,ny
     do i=1,nx
        q(i,j)=real(ll2radi( dlon(i,j), dlat(i,j), dclon(i,j), dclat(i,j) ))*1.0e-3
        if(q(i,j)>50.0)then
           q(i,j)=-100.0
        end if
     end do
  end do

!  call grfrm

!  call grswnd( xmin, xmax, ymin, ymax )
!  call grsvpt( 0.1, 0.9, 0.1, 0.9 )
!  call grssim( 0.4, 0.0, 0.0 )
!  call grsmpl( 140.7, 0.0, 0.0 )
!  call grstxy( -180.0, 180.0, 0.0, 90.0 )
!  call grstrn( 30 )
!  call grstrf
!  call sglset( 'lclip', .true. )

!  do i=1,cnum-1
!     call DclSetShadeLevel( col_val(i), col_val(i+1), col_map(i) )
!  end do

!  call DclShadeContour( q )

!  call umpmap( 'coast_world' )
!  call umpglb

  do j=1,ny
     do i=1,nx
        if(q(i,j)/=-100.0d0.and.p(i,j)/=-100.0d0)then
           q(i,j)=abs(p(i,j)-q(i,j))*1.0e3
        end if
     end do
  end do

  call grfrm

  call grswnd( xmin, xmax, ymin, ymax )
  call grsvpt( 0.1, 0.9, 0.1, 0.9 )
  call grssim( 0.4, 0.0, 0.0 )
  call grsmpl( 140.7, 0.0, 0.0 )
  call grstxy( -180.0, 180.0, 0.0, 90.0 )
  call grstrn( 30 )
  call grstrf
  call sglset( 'lclip', .true. )

  call DclSetShadeLevel( 0.0, 10.0, 15999 )
  call DclSetShadeLevel( 10.0, 20.0, 25999 )
  call DclSetShadeLevel( 20.0, 50.0, 35999 )
  call DclSetShadeLevel( 50.0, 100.0, 45999 )
  call DclSetShadeLevel( 100.0, 150.0, 55999 )
  call DclSetShadeLevel( 150.0, 200.0, 65999 )
  call DclSetShadeLevel( 200.0, 500.0, 75999 )
  call DclSetShadeLevel( 500.0, 1.0e3, 85999 )

  call DclShadeContour( q )

!  call DclSetShadeLevel( 0.0, 0.0001, 15999 )
!  call DclSetShadeLevel( 0.0001, 0.0002, 25999 )
!  call DclSetShadeLevel( 0.0002, 0.0003, 35999 )
!  call DclSetShadeLevel( 0.0003, 0.0012, 45999 )
!  call DclSetShadeLevel( 0.0012, 0.00125, 55999 )
!  call DclSetShadeLevel( 0.00125, 0.00135, 65999 )
!  call DclSetShadeLevel( 0.00135, 0.00175, 75999 )
!  call DclSetShadeLevel( 0.001375, 0.0014, 85999 )

!  call DclShadeContour( pdeg )

  call umpmap( 'coast_world' )
  call umpglb

!  call DclSetContourLevel( 0.001, 0.003, 0.0002 )
!  call DclDrawContour( pdeg )

  call DclNewFig

  call sglset( 'lclip', .false. )
  call SGLSET( 'LSOFTF', .false. )

  recx(1:2)=vxmax+0.02
  recx(3:4)=vxmax+0.05
  recx(5)=vxmax+0.02
  do k=1,cnum-1
     recy(1)=vymin+(vymax-vymin)*real(k-1)/real(cnum-1)
     recy(2:3)=vymin+(vymax-vymin)*real(k)/real(cnum-1)
     recy(4:5)=recy(1)
     write(label,'(f4.1)') col_val(k)
     call DclShadeRegionNormalized( recx, recy, col_map(k) )
     call DclDrawLineNormalized( recx, recy, index=13 )
     call DclDrawTextNormalized( vxmax+0.06, recy(1),  &
  &                              trim(adjustl(label)),  &
  &                              height=0.5*DclGetTextHeight(),  &
  &                              index=13, centering=-1 )
  end do
  write(label,'(f4.1)') col_val(cnum)
  call DclDrawTextNormalized( vxmax+0.06, vymax,  &
  &                           trim(adjustl(label)),  &
  &                           height=0.5*DclGetTextHeight(),  &
  &                           index=13, centering=-1 )

  call sglset( 'lclip', .true. )

  call grcls

end
