*-----------------------------------------------------------------------
*     UMPQNP / UMPQID / UMPQCP / UMPQVL / UMPSVL
*-----------------------------------------------------------------------
      SUBROUTINE UMPQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA=17)

      INTEGER   IX(NPARA)
      REAL      RX(NPARA)
      LOGICAL   LX(NPARA),LCHREQ,LFIRST
      CHARACTER CPARA(NPARA)*8,CMSG*80

      EQUIVALENCE (IX,RX,LX)

      EXTERNAL  LCHREQ,LENC

      SAVE

      DATA      CPARA( 1)/'INDEXMJ '/, IX( 1)/3/
      DATA      CPARA( 2)/'INDEXMN '/, IX( 2)/1/
      DATA      CPARA( 3)/'ITYPEMJ '/, IX( 3)/1/
      DATA      CPARA( 4)/'ITYPEMN '/, IX( 4)/3/
      DATA      CPARA( 5)/'DGRIDMJ '/, RX( 5)/30/
      DATA      CPARA( 6)/'DGRIDMN '/, RX( 6)/10/
      DATA      CPARA( 7)/'DGRPLMJ '/, RX( 7)/0/
      DATA      CPARA( 8)/'DGRPLMN '/, RX( 8)/0/
      DATA      CPARA( 9)/'LGRIDMJ '/, LX( 9)/.TRUE./
      DATA      CPARA(10)/'LGRIDMN '/, LX(10)/.TRUE./
      DATA      CPARA(11)/'INDEXBND'/, IX(11)/3/
      DATA      CPARA(12)/'MAXBND  '/, IX(12)/300/
      DATA      CPARA(13)/'IGROUP  '/, IX(13)/1/
      DATA      CPARA(14)/'INDEXOUT'/, IX(14)/1/
      DATA      CPARA(15)/'ITYPEOUT'/, IX(15)/1/
      DATA      CPARA(16)/'LGLOBE  '/, LX(16)/.FALSE./
      DATA      CPARA(17)/'LWHINT  '/, LX(17)/.TRUE./

      DATA      LFIRST/.TRUE./


      NCP=NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY UMPQID(CP,IDX)

      DO 10 N=1,NPARA
        IF (LCHREQ(CP,CPARA(N))) THEN
          IDX=N
          RETURN
        END IF
   10 CONTINUE
      CMSG='PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','UMPQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY UMPQCP(IDX,CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP=CPARA(IDX)
      ELSE
        CALL MSGDMP('E','UMPQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UMPQVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UM:',CPARA,IX,NPARA)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IPARA=IX(IDX)
      ELSE
        CALL MSGDMP('E','UMPQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY UMPSVL(IDX,IPARA)

      IF (LFIRST) THEN
        CALL RTPGET('UM:',CPARA,IX,NPARA)
        LFIRST=.FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IX(IDX)=IPARA
      ELSE
        CALL MSGDMP('E','UMPSVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
      END
