!-----------------------------------------------------------------------
!     Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved.
!-----------------------------------------------------------------------
      PROGRAM G2PK01

	use dcl

	integer,parameter :: nx=15,ny=15

	real,dimension(nx) :: ux,uyw
	real,dimension(ny) :: uy,uxw
	real,dimension(nx,ny) :: cx,cy,z

!*     / SET PARAMETERS /

      DO I=1,NX
        UX(I)=(I-1.0)/(NX-1.0)
	end do
      DO J=1,NY
        UY(J)=(J-1.0)/(NY-1.0)
	end do

      DO J=1,NY
        DO I=1,NX
          CX(I,J) = UX(I) + 0.1*UY(J)
          CY(I,J) = 0.2*UX(I) + UY(J)
    	end do
	end do

      CXMIN = 0.0
      CXMAX = 1.1
      CYMIN = 0.0
      CYMAX = 1.1

!*     / GRAPHIC /
	call DclOpenGraphics
	call DclNewFrame
	call DclSetViewPort(0.15,0.85,0.15,0.85)
	call DclSetWindow(UX(1),UX(NX),UY(1),UY(NY))
	call DclGrid2DSetCoordinateTransform(UX,UY,CX,CY)
	call DclSetTransNumber(51)

!!!!! 
!     CALL SGSCWD(CXMIN,CXMAX,CYMIN,CYMAX)
	call DclSetGrid2DWindow(CXMIN,CXMAX,CYMIN,CYMAX)
	call DclSetTransFunction
	call DclSetParm('ENABLE_CLIPPING',.TRUE.)

!*     / TONE /

      DO J=1,NY
        DO I=1,NX
          Z(I,J) = UX(I) + UY(J)
		end do
	end do

	call DclSetParm('ENABLE_AUTO_SHADE_LEVEL',.TRUE.)
	call DclSetXGrid(UX)
	call DclSetYGrid(UY)
	call DclShadeContour(z)

!*     / GRID LINES /

      DO J=1,NY
        DO I=1,NX
          UYW(I) = UY(J)
		end do
	call DclDrawLine(UX,UYW)
	end do

      DO I=1,NX
        DO J=1,NY
          UXW(J) = UX(I)
		end do

	call DclDrawLine(UXW,UY)
	end do

!*     / AXES (Switch to ITR==1) /

	call DclSetWindow(CXMIN,CXMAX,CYMIN,CYMAX)
	call DclSetTransNumber(1)
	call DclSetTransFunction
	call DclDrawScaledAxis
	call DclDrawTitle('T','BOTH X & Y TRANSFORMED',0.0)

	call DclCloseGraphics

      END
