/* Copyright (C) by GFD-Dennou Club, 1999-2000.  All rights reserved. */
/* szsgcl.f -- translated by f2c (version 19990503).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static real c_b2 = 1e-5f;

/* ----------------------------------------------------------------------- */
/* Subroutine */ int szsgcl_0_(int n__, real *tx0, real *ty0, real *tx1, real 
	*ty1, real *tx, real *ty)
{
    /* System generated locals */
    real r__1, r__2, r__3, r__4;

    /* Builtin functions */
    double tan(doublereal), cos(doublereal), sin(doublereal), atan2(
	    doublereal, doublereal), r_sign(real *, real *), atan(doublereal),
	     acos(doublereal);

    /* Local variables */
    static logical lmer;
    extern doublereal rfpi_(void);
    static real alpha;
    extern logical lreqa_(real *, real *, real *);
    static real pi, tt, cs0, cs1, dx1;
    extern doublereal szxmod_(real *);
    static real xla, xlm, txx, tyy, tan0, tan1;

    switch(n__) {
	case 1: goto L_szqgcy;
	case 2: goto L_szqgcx;
	}

    pi = rfpi_();
    txx = *tx0;
    tyy = *ty0;
    r__1 = dabs(*ty0);
    r__2 = pi / 2;
    r__3 = dabs(*ty1);
    r__4 = pi / 2;
    if (lreqa_(&r__1, &r__2, &c_b2) || lreqa_(&r__3, &r__4, &c_b2)) {
	lmer = TRUE_;
    } else {
	tan0 = tan(*ty0);
	tan1 = tan(*ty1);
	if (tan0 == 0.f && tan1 == 0.f) {
	    xla = 0.f;
	} else {
	    xla = atan2(tan1 * cos(*tx0) - tan0 * cos(*tx1), tan0 * sin(*tx1) 
		    - tan1 * sin(*tx0));
	}
	r__1 = *tx1 - *tx0;
	dx1 = szxmod_(&r__1);
	r__1 = *tx0 + dx1 / 2 - xla;
	xlm = szxmod_(&r__1);
	cs0 = cos(*tx0 - xla);
	cs1 = cos(*tx1 - xla);
	if (dabs(cs0) >= dabs(cs1)) {
	    alpha = tan0 / cs0;
	    lmer = FALSE_;
	} else if (dabs(cs1) != 0.f) {
	    alpha = tan1 / cs1;
	    lmer = FALSE_;
	} else {
	    lmer = TRUE_;
	}
    }
    if (lmer) {
	r__1 = pi / 2;
	r__2 = *ty0 + *ty1;
	tyy = r_sign(&r__1, &r__2);
    }
    return 0;
/* ----------------------------------------------------------------------- */

L_szqgcy:
    if (lmer) {
	*ty = tyy;
    } else {
	*ty = atan(alpha * cos(*tx - xla));
    }
    return 0;
/* ----------------------------------------------------------------------- */

L_szqgcx:
    if (lmer) {
	*tx = txx;
    } else {
	if (alpha == 0.f) {
	    *tx = txx;
	} else {
	    tt = tan(*ty) / alpha;
	    if (dabs(tt) >= 1.f) {
		*tx = r_sign(&pi, &xlm) + xla;
	    } else {
		r__1 = acos(tt);
		*tx = r_sign(&r__1, &xlm) + xla;
	    }
	}
    }
    return 0;
} /* szsgcl_ */

/* Subroutine */ int szsgcl_(real *tx0, real *ty0, real *tx1, real *ty1)
{
    return szsgcl_0_(0, tx0, ty0, tx1, ty1, (real *)0, (real *)0);
    }

/* Subroutine */ int szqgcy_(real *tx, real *ty)
{
    return szsgcl_0_(1, (real *)0, (real *)0, (real *)0, (real *)0, tx, ty);
    }

/* Subroutine */ int szqgcx_(real *ty, real *tx)
{
    return szsgcl_0_(2, (real *)0, (real *)0, (real *)0, (real *)0, tx, ty);
    }

