*-----------------------------------------------------------------------
*     BASIC TEXT PRIMITIVE ON VC
*-----------------------------------------------------------------------
*     Copyright (C) 2000 GFD Dennou Club. All rights reserved.
*-----------------------------------------------------------------------
      SUBROUTINE SZTXWV(VX,VY,CHARS)

      CHARACTER CHARS*(*)

      PARAMETER (NCHAR=256,LEN=6000)
      PARAMETER (WUNIT=24,ZUNIT=24)

      INTEGER   IPOSX(NCHAR)
      REAL      WX1(NCHAR),WX2(NCHAR)
      CHARACTER CKX(LEN)*1,CKY(LEN)*1,CBUF*80,COBJ*80

      COMMON    /SZBTX1/ QSIZE,CT,ST,ICENTZ
      COMMON    /SZBTX2/ LCNTL,JSUP,JSUB,JRST,SMALL,SHIFT
      LOGICAL   LCNTL

      EXTERNAL  LENC,ISGC

      SAVE

      DATA      NCNTZ/0/


*     / GET FONT INFORMATION /

      CALL SZFINT(NCNT)
      IF (NCNTZ.NE.NCNT) THEN
        CALL SZQFNT(IPOSX,CKX,CKY)
        CALL SZQFNW(WX1,WX2)
        NCNTZ=NCNT
      END IF

*     / CHECK CHARACTER WIDTH AND HEIGHT /

      NCZ=LENC(CHARS)
      CALL SZQTXW(CHARS,NC,WXCH,WYCH)

*     / WRITE INFORMATION FOR PS DRIVER /

      CALL STFWTR(VX,VY,WX,WY)
      CBUF=' '
      NP=0
      DO 5 N=1,NCZ
        ICZ=ISGC(CHARS(N:N))
        NP=NP+1
        IF (32.LE.ICZ .AND. ICZ.LE.127 .AND. ICZ.NE.37) THEN
          CBUF(NP:NP)=CHARS(N:N)
        ELSE
          WRITE(CBUF(NP:NP+3),'(A,I3.3)') '%',ICZ
          NP=NP+3
        END IF
    5 CONTINUE
      WRITE(COBJ,'(2I8)') INT(WX),INT(WY)
      CALL CDBLK(COBJ)
      WRITE(COBJ(LENC(COBJ)+1:80),'(A)') ' "'//CBUF(1:NP)//'"'
      CALL SWOOPN('SZTXZ',COBJ)

*     / CALCULATE OFFSET VALUES /

      OFFX=-0.5*WXCH*WUNIT*(ICENTZ+1)
      OFFY=0.0
      XC=VX+OFFX*CT-OFFY*ST
      YC=VY+OFFX*ST+OFFY*CT

*     / INITIALIZATION /

      MODE0=0
      MODE=0
      FACTZ=1.0
      VX1=0

*     / PROCESS EACH CHARACTER /

      DO 20 K=1,NCZ

*       / CHARACTER CONVERSION /

        IDX=ISGC(CHARS(K:K))+1
        IPS=IPOSX(IDX)+1

*       / CHECK CONTROL CHARACTERS /

        IF (LCNTL .AND.
     +    (IDX.EQ.JSUB .OR. IDX.EQ.JSUP .OR. IDX.EQ.JRST)) THEN
          IF (IDX.EQ.JSUB) THEN
            MODE=-1
            FACTZ=SMALL
          ELSE IF (IDX.EQ.JSUP) THEN
            MODE=+1
            FACTZ=SMALL
          ELSE IF (IDX.EQ.JRST) THEN
            MODE=0
            FACTZ=1.0
          END IF
          GO TO 20
        END IF

        VX2=-WX1(IDX)
        IF (MODE0.EQ.MODE) THEN
          IF (MODE.EQ.0) THEN
            FNX=VX1+VX2
          ELSE
            FNX=(VX1+VX2)*SMALL
          END IF
          FNY=0
        ELSE
          IF (MODE0*MODE.EQ.0) THEN
            IF (MODE.EQ.0) THEN
              FNX=VX1*SMALL+VX2
            ELSE
              FNX=VX2+VX1*SMALL
            END IF
          ELSE
*           'IS THIS BLOCK REALLY NECESSARY?'
            FNX=(VX1+VX2)*SMALL
          END IF
          FNY=ZUNIT*SHIFT*(MODE-MODE0)
        END IF
        MODE0=MODE

        XC=XC+FNX*CT-FNY*ST
        YC=YC+FNX*ST+FNY*CT

        VX1=WX2(IDX)

        CALL SZOPSV

        IP=0

   10   CONTINUE

          NX=ICHAR(CKX(IPS))-64
          FNX=+NX*FACTZ
          NY=ICHAR(CKY(IPS))-64
          FNY=-NY*FACTZ

          IF (NX.NE.-64) THEN
            XP=XC+FNX*CT-FNY*ST
            YP=YC+FNX*ST+FNY*CT
            IF (IP.EQ.0) THEN
              CALL SZMVSV(XP,YP)
            ELSE IF (IP.EQ.1) THEN
              CALL SZPLSV(XP,YP)
            END IF
            IP=1
          ELSE
            IP=0
          END IF

          IPS=IPS+1

        IF (.NOT.(NX.EQ.-64 .AND. NY.EQ.-64)) GO TO 10

        CALL SZCLSV

   20 CONTINUE

      CALL SWOCLS('SZTXZ')

      END
