!= ʬʿѤ
!
!= Operation for integral and average
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: intavr_operate.f90,v 1.6 2007-09-21 13:38:05 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module intavr_operate
  !
  != ʬʿѤ
  !
  != Operation for integral and average
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ʬѤɸŤߤθʬʿΤδؿ󶡤ޤ. 
  ! {SPMODEL 饤֥}[http://www.gfd-dennou.org/library/spmodel]
  !  w_integral_module.f90 򻲹ͤ˺ޤ. 
  !
  ! Functions for integral or average operation with weight for integration
  ! are provided
  ! This program is created referring to 
  ! "w_integral_module.f90" in 
  ! {SPMODEL library}[http://www.gfd-dennou.org/library/spmodel]
  !
  !== Procedures List
  !
  ! Create                 :: INTAVROPR ѿν
  ! Close                  :: INTAVROPR ѿνλ
  ! PutLine                :: INTAVROPR ѿ˳ǼƤΰ
  ! initialized            :: INTAVROPR ѿꤵƤ뤫ݤ
  ! IntLonLat_xy           :: ٷʬ
  ! y_IntLon_xy, IntLon_x  :: ʬ
  ! x_IntLat_xy, IntLat_y  :: ʬ
  ! AvrLonLat_xy           :: ٷʿ
  ! y_AvrLon_xy, AvrLon_x  :: ʿ
  ! x_AvrLat_xy, AvrLat_y  :: ʿ
  ! ---------------------  :: ---------------------
  ! Create                 :: Constructor of "INTAVROPR"
  ! Close                  :: Deconstructor of "INTAVROPR"
  ! PutLine                :: Print information of "INTAVROPR"
  ! initialized            :: Check initialization of "INTAVROPR"
  ! y_IntLon_xy, IntLon_x  :: Meridional integral
  ! x_IntLat_xy, IntLat_y  :: Zonal integral
  ! AvrLonLat_xy           :: Zonal and meridional average
  ! y_AvrLon_xy, AvrLon_x  :: Meridional average
  ! x_AvrLat_xy, AvrLat_y  :: Zonal average
  !
  !== Usage
  !
  ! Ϥ, INTAVROPR ѿ, Create ǽԤޤ.
  ! θ, ʬʿΤδؿѤƤ.
  ! INTAVROPR ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "INTAVROPR" by "Create".
  ! Then, use functions for integral and average. 
  ! In order to terminate "INTAVROPR", use "Close".
  !

  use dc_types, only: DP, TOKEN
  implicit none
  private
  public:: INTAVROPR, Create, Close, PutLine, initialized
  public:: IntLonLat_xy
  public:: y_IntLon_xy, IntLon_x
  public:: x_IntLat_xy, IntLat_y
  public:: AvrLonLat_xy
  public:: y_AvrLon_xy, AvrLon_x
  public:: x_AvrLat_xy, AvrLat_y

  type INTAVROPR
    !
    ! ޤ, Create  "INTAVROPR" ѿꤷƲ.
    ! ꤵ줿 "INTAVROPR" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "INTAVROPR" variable by "Create" before usage.
    ! If you reuse "INTAVROPR" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    real(DP), pointer:: x_Lon_Weight (:) =>null()
                   ! ʬѺɸŤ. 
                   ! Weight for integration in longitude
    real(DP), pointer:: y_Lat_Weight (:) =>null()
                   ! ʬѺɸŤ. 
                   ! Weight for integration in latitude
    real(DP):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
  end type INTAVROPR

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: intavr_operate.f90,v 1.6 2007-09-21 13:38:05 morikawa Exp $'

  interface Create
    module procedure IntAvrOperateCreate
  end interface

  interface Close
    module procedure IntAvrOperateClose
  end interface

  interface PutLine
    module procedure IntAvrOperatePutLine
  end interface

  interface initialized
    module procedure IntAvrOperateInitialized
  end interface

  interface NmlRead
    module procedure IntAvrOperateNmlRead
  end interface

  interface IntLonLat_xy
    module procedure IntLonLat_xy
  end interface

  interface y_IntLon_xy
    module procedure y_IntLon_xy
  end interface

  interface IntLon_x
    module procedure IntLon_x
  end interface

  interface x_IntLat_xy
    module procedure x_IntLat_xy
  end interface

  interface IntLat_y
    module procedure IntLat_y
  end interface

  interface AvrLonLat_xy
    module procedure AvrLonLat_xy
  end interface

  interface y_AvrLon_xy
    module procedure y_AvrLon_xy
  end interface

  interface AvrLon_x
    module procedure AvrLon_x
  end interface

  interface x_AvrLat_xy
    module procedure x_AvrLat_xy
  end interface

  interface AvrLat_y
    module procedure AvrLat_y
  end interface

!!$  interface Sample
!!$    module procedure IntAvrOperateSample
!!$  end interface

contains

  subroutine IntAvrOperateCreate( intavr_opr, &
    & imax, jmax, &
    & PI, &
    & x_Lon_Weight, y_Lat_Weight, &
    & nmlfile, err )
    !
    ! INTAVROPR ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! INTAVROPR ѿꤷƤ.
    !
    ! *x_Lon_Weight*, *y_Lat_Weight* ˤ, 줾
    ! , ʬΤκɸŤߤͿޤ. 
    ! *x_Lon_Weight* ¤ 2 $ \pi $ , 
    ! *y_Lat_Weight* ¤ 2 Ȥʤ뤳ȤꤷƤޤ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    !--
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#intavr_operate_nml 򻲾ȤƤ. 
    !++
    !
    ! Constructor of "INTAVROPR".
    ! Initialize *intavr_opr* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Give weight for integration in longitude to *x_Lon_Weight*, 
    ! weight for integration in latitude to *y_Lat_Weight*. 
    ! It is expected that the summation of *x_Lon_Weight* is 2 $ \pi $ ,
    ! and *y_Lat_Weight* is 2.
    !
    ! Note that if *intavr_opr* is already initialized 
    ! by this procedure, error is occurred.
    !
    !--
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#intavr_operate_nml"
    ! for details about a NAMELIST group.
    !++
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    implicit none
    type(INTAVROPR), intent(inout):: intavr_opr
    integer, intent(in):: imax ! ٳʻ. 
                               ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                               ! Number of grid points in latitude
    real(DP), intent(in):: PI         ! $ \pi $ .    ߼Ψ.         Circular constant
    real(DP), intent(in), optional:: x_Lon_Weight(0:imax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in longitude
    real(DP), intent(in), optional:: y_Lat_Weight(0:jmax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in latitude
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#intavr_operate_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#intavr_operate_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'IntAvrOperateCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( intavr_opr % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'INTAVROPR'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ȿʻ
    !  Configure wave number and grid point
    !-----------------------------------------------------------------
    intavr_opr % imax = imax
    intavr_opr % jmax = jmax

    !-----------------------------------------------------------------
    !  ߼Ψ
    !  Configure PI
    !-----------------------------------------------------------------
    intavr_opr % PI = PI

    !-----------------------------------------------------------------
    !  ʬѺɸŤߤ
    !  Configure weight for integration
    !-----------------------------------------------------------------
    allocate( intavr_opr % x_Lon_Weight (0:intavr_opr % imax-1) )
    allocate( intavr_opr % y_Lat_Weight (0:intavr_opr % jmax-1) )
    if ( present(x_Lon_Weight) ) then
      intavr_opr % x_Lon_Weight = x_Lon_Weight
    else
      intavr_opr % x_Lon_Weight = 2.0_DP * PI / imax
    end if
    if ( present(y_Lat_Weight) ) then
      intavr_opr % y_Lat_Weight = y_Lat_Weight
    else
      intavr_opr % y_Lat_Weight = 2.0_DP / jmax
    end if

    !-----------------------------------------------------------------
    !  "INTAVROPR" 
    !  Configure the settings for "INTAVROPR"
    !-----------------------------------------------------------------

    !-------------------------
    !  ǥե
    !  Default values
!!$    intavr_opr % param_r = 0.0_DP
!!$    intavr_opr % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    intavr_opr % param_i = param_i
!!$    if ( present(param_r) )  intavr_opr % param_r = param_r
!!$    if ( present(param_c) )  intavr_opr % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1=trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = intavr_opr % param_i, &   ! (inout)
!!$        & param_r = intavr_opr % param_r, &   ! (inout)
!!$        & param_c_ = intavr_opr % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1=trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( intavr_opr % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    intavr_opr % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine IntAvrOperateCreate

  subroutine IntAvrOperateClose( intavr_opr, err )
    !
    ! INTAVROPR ѿνλԤޤ.
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "INTAVROPR".
    ! Note that if *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(INTAVROPR), intent(inout):: intavr_opr
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'IntAvrOperateClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. intavr_opr % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'INTAVROPR'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "INTAVROPR" ξõ
    !  Clear the settings for "INTAVROPR"
    !-----------------------------------------------------------------
    deallocate( intavr_opr % x_Lon_Weight )
    deallocate( intavr_opr % y_Lat_Weight )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    intavr_opr % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine IntAvrOperateClose

  subroutine IntAvrOperatePutLine( intavr_opr, unit, indent, err )
    !
    !  *intavr_opr* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *intavr_opr*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'IntAvrOperatePutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "INTAVROPR" ΰ
    !  Print the settings for "INTAVROPR"
    !-----------------------------------------------------------------
    if ( intavr_opr % initialized ) then
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<INTAVROPR:: @initialized=%y', &
        & l=(/intavr_opr % initialized/))

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d', &
        & i=(/intavr_opr % imax, intavr_opr % jmax/) )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & ' @PI=%f', &
        & d=(/intavr_opr % PI/) )

      call PutLine( intavr_opr % x_Lon_Weight, unit = out_unit, &
        & lbounds = lbound(intavr_opr % x_Lon_Weight), &
        & ubounds = ubound(intavr_opr % x_Lon_Weight), &
        & indent = indent_str(1:indent_len) // &
        & ' @x_Lon_Weight=' )

      call PutLine( intavr_opr % y_Lat_Weight, unit = out_unit, &
        & lbounds = lbound(intavr_opr % y_Lat_Weight), &
        & ubounds = ubound(intavr_opr % y_Lat_Weight), &
        & indent = indent_str(1:indent_len) // &
        & ' @y_Lat_Weight=' )

      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<INTAVROPR:: @initialized=%y>', &
        & l=(/intavr_opr % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine IntAvrOperatePutLine

  logical function IntAvrOperateInitialized( intavr_opr ) result(result)
    !
    ! *intavr_opr* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *intavr_opr* is initialized, .true. is returned.
    ! If *intavr_opr* is not initialized, .false. is returned.
    !
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
  continue
    result = intavr_opr % initialized
  end function IntAvrOperateInitialized

  subroutine IntAvrOperateNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /intavr_operate_nml/ &
!!$      & param_i, param_r, param_c
                              ! intavr_operate ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! intavr_operate#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "intavr_operate" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "intavr_operate#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'IntAvrOperateNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = intavr_operate_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1='intavr_operate_nml', c2=trim(nmlfile) )
!!$      write(STDOUT, nml = intavr_operate_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1='intavr_operate_nml', c2=trim(nmlfile), &
!!$        & i=(/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine IntAvrOperateNmlRead

  function IntLonLat_xy( xy_Data, intavr_opr )
    !
    ! 2 ٷٳʻǡΰʬ(1 ). 
    !
    ! ºݤˤϳʻǡ x_Lon_Weight, y_Lat_Weight ݤ
    ! ¤׻Ƥ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Global integration of 2-dimensional (latitude and longitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "x_Lon_Weight" and "y_Lat_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: xy_Data (0:intavr_opr%imax-1, 0:intavr_opr%jmax-1)
    real(DP):: IntLonLat_xy
!!$    character(*), parameter:: subname = 'IntLonLat_xy'
  continue
    IntLonLat_xy = IntLon_x( x_IntLat_xy( xy_Data, intavr_opr ), intavr_opr )
  end function IntLonLat_xy

  function x_IntLat_xy( xy_Data, intavr_opr )
    !
    ! 2 ٷٳʻǡΰʬ(1 ). 
    !
    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
    ! ¤׻Ƥ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Meridional integration of 2-dimensional (latitude and longitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "y_Lat_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: xy_Data (0:intavr_opr%imax-1, 0:intavr_opr%jmax-1)
    real(DP):: x_IntLat_xy (0:intavr_opr%imax-1)

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: y_Lat_Weight(0:intavr_opr%jmax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in latitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: j               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
!!$    character(*), parameter:: subname = 'x_IntLat_xy'
  continue
    jmax = intavr_opr % jmax
    y_Lat_Weight = intavr_opr % y_Lat_Weight
    x_IntLat_xy = 0.0_DP
    do j = 0, jmax - 1
      x_IntLat_xy = x_IntLat_xy + xy_Data (:,j) * y_Lat_Weight(j)
    enddo
  end function x_IntLat_xy

  function y_IntLon_xy( xy_Data, intavr_opr )
    !
    ! 2 ٷٳʻǡηʬ(1 ). 
    !
    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
    ! ¤׻Ƥ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Zonal integration of 2-dimensional (latitude and longitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "x_Lon_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: xy_Data (0:intavr_opr%imax-1, 0:intavr_opr%jmax-1)
    real(DP):: y_IntLon_xy (0:intavr_opr%jmax-1)

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    real(DP):: x_Lon_Weight(0:intavr_opr%imax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in longitude
    integer:: i               ! DO 롼Ѻѿ
                              ! Work variables for DO loop
!!$    character(*), parameter:: subname = 'y_IntLon_xy'
  continue
    imax = intavr_opr % imax
    x_Lon_Weight = intavr_opr % x_Lon_Weight
    y_IntLon_xy = 0.0_DP
    do i = 0, imax - 1
      y_IntLon_xy = y_IntLon_xy + xy_Data (i,:) * x_Lon_Weight(i)
    enddo
  end function y_IntLon_xy

  function IntLat_y( y_Data, intavr_opr )
    !
    ! 1 ٳʻǡΰʬ(1 ). 
    !
    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
    ! ¤׻Ƥ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Meridonal integration of 1-dimensional (latitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "y_Lat_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: y_Data (0:intavr_opr%jmax-1)
    real(DP):: IntLat_y

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: y_Lat_Weight(0:intavr_opr%jmax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in latitude
!!$    character(*), parameter:: subname = 'IntLat_y'
  continue
    y_Lat_Weight = intavr_opr % y_Lat_Weight

    IntLat_y = sum( y_Data * y_Lat_Weight )
  end function IntLat_y

  function IntLon_x( x_Data, intavr_opr )
    !
    ! 1 ٳʻǡηʬ(1 ). 
    !
    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
    ! ¤׻Ƥ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Zonal integration of 1-dimensional (longitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "x_Lon_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: x_Data (0:intavr_opr%imax-1)
    real(DP):: IntLon_x

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: x_Lon_Weight(0:intavr_opr%imax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in longitude
!!$    character(*), parameter:: subname = 'IntLon_x'
  continue
    x_Lon_Weight = intavr_opr % x_Lon_Weight

    IntLon_x = sum( x_Data * x_Lon_Weight )
  end function IntLon_x

  function AvrLonLat_xy( xy_Data, intavr_opr )
    !
    ! 2 ٷٳʻǡΰʿ(1 ). 
    !
    ! ºݤˤϳʻǡ x_Lon_Weight, y_Lat_Weight ݤ
    ! ¤׻, x_Lon_Weight * y_Lat_Weight ¤ǳ뤳Ȥ
    ! ʿѤƤ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Global mean of 2-dimensional (latitude and longitude)
    ! grid data.
    !
    ! Practically, the mean grid data is calculated
    ! by multiplying in each grid "x_Lon_Weight" and "y_Lat_Weight"
    ! and deviding by the sum total of "x_Lon_Weight" * "y_Lat_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: xy_Data (0:intavr_opr%imax-1, 0:intavr_opr%jmax-1)
    real(DP):: AvrLonLat_xy
!!$    character(*), parameter:: subname = 'AvrLonLat_xy'
  continue
    AvrLonLat_xy = AvrLon_x( x_AvrLat_xy( xy_Data, intavr_opr ), intavr_opr )
  end function AvrLonLat_xy

  function x_AvrLat_xy( xy_Data, intavr_opr )
    !
    ! 2 ٷٳʻǡΰʿ(1 ). 
    !
    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
    ! ¤׻, y_Lat_Weight ¤ǳ뤳Ȥ
    ! ʿѤƤ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Meridional mean of 2-dimensional (latitude and longitude)
    ! grid data.
    !
    ! Practically, the mean grid data is calculated
    ! by multiplying in each grid "y_Lat_Weight" 
    ! and deviding by the sum total of "y_Lat_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: xy_Data (0:intavr_opr%imax-1, 0:intavr_opr%jmax-1)
    real(DP):: x_AvrLat_xy (0:intavr_opr%imax-1)

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: y_Lat_Weight(0:intavr_opr%jmax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in latitude
!!$    character(*), parameter:: subname = 'x_AvrLat_xy'
  continue
    y_Lat_Weight = intavr_opr % y_Lat_Weight
    x_AvrLat_xy = x_IntLat_xy ( xy_Data, intavr_opr ) / sum( y_Lat_Weight )
  end function x_AvrLat_xy

  function y_AvrLon_xy( xy_Data, intavr_opr )
    !
    ! 2 ٷٳʻǡηʿ(1 ). 
    !
    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
    ! ¤׻, x_Lon_Weight ¤ǳ뤳Ȥ
    ! ʿѤƤ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Zonal mean of 2-dimensional (latitude and longitude)
    ! grid data.
    !
    ! Practically, the mean grid data is calculated
    ! by multiplying in each grid "x_Lon_Weight" 
    ! and deviding by the sum total of "x_Lon_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: xy_Data (0:intavr_opr%imax-1, 0:intavr_opr%jmax-1)
    real(DP):: y_AvrLon_xy (0:intavr_opr%jmax-1)

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: x_Lon_Weight(0:intavr_opr%imax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in longitude
!!$    character(*), parameter:: subname = 'y_AvrLon_xy'
  continue
    x_Lon_Weight = intavr_opr % x_Lon_Weight
    y_AvrLon_xy = y_IntLon_xy( xy_Data, intavr_opr) / sum( x_Lon_Weight )
  end function y_AvrLon_xy

  function AvrLat_y( y_Data, intavr_opr )
    !
    ! 1 ٳʻǡΰʿ(1 ). 
    !
    ! ºݤˤϳʻǡ y_Lat_Weight ݤ
    ! ¤׻, y_Lat_Weight ¤ǳ뤳Ȥ
    ! ʿѤƤ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Meridonal mean of 1-dimensional (latitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "y_Lat_Weight" 
    ! and deviding by the sum total of "y_Lat_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: y_Data (0:intavr_opr%jmax-1)
    real(DP):: AvrLat_y

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: y_Lat_Weight(0:intavr_opr%jmax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in latitude
!!$    character(*), parameter:: subname = 'AvrLat_y'
  continue
    y_Lat_Weight = intavr_opr % y_Lat_Weight

    AvrLat_y = IntLat_y( y_Data, intavr_opr ) / sum( y_Lat_Weight )
  end function AvrLat_y

  function AvrLon_x( x_Data, intavr_opr )
    !
    ! 1 ٳʻǡηʿ(1 ). 
    !
    ! ºݤˤϳʻǡ x_Lon_Weight ݤ
    ! ¤׻, x_Lon_Weight ¤ǳ뤳Ȥ
    ! ʿѤƤ. 
    !
    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Zonal mean of 1-dimensional (longitude)
    ! grid data.
    !
    ! Practically, the sum total of grid data is calculated
    ! by multiplying in each grid "x_Lon_Weight" 
    ! and deviding by the sum total of "x_Lon_Weight".
    !
    ! If *intavr_opr* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_types, only: DP
    implicit none
    type(INTAVROPR), intent(in):: intavr_opr
    real(DP), intent(in):: x_Data (0:intavr_opr%imax-1)
    real(DP):: AvrLon_x

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: x_Lon_Weight(0:intavr_opr%imax-1)
                   ! ʬѺɸŤ. 
                   ! Weight for integration in longitude
!!$    character(*), parameter:: subname = 'AvrLon_x'
  continue
    x_Lon_Weight = intavr_opr % x_Lon_Weight

    AvrLon_x = IntLon_x( x_Data, intavr_opr ) / sum( x_Lon_Weight )
  end function AvrLon_x

!!$  subroutine IntAvrOperateSample( intavr_opr, err )
!!$    !--
!!$    ! IntAvrOperateSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of IntAvrOperateSample
!!$    !++
!!$    ! If *intavr_opr* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(INTAVROPR), intent(inout):: intavr_opr
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'IntAvrOperateSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. intavr_opr % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'INTAVROPR'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *intavr_opr* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *intavr_opr*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = intavr_opr % param_i
!!$!!$    param_r = intavr_opr % param_r
!!$!!$    param_c = intavr_opr % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine IntAvrOperateSample

!!$  function SampleFunction( intavr_opr )
!!$    !--
!!$    ! SampleFunction 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *intavr_opr*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of SampleFunction
!!$    !++
!!$    ! If *intavr_opr* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_types, only: DP
!!$    implicit none
!!$    type(INTAVROPR), intent(in):: intavr_opr
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: imax ! ٳʻ. 
!!$                   ! Number of grid points in longitude
!!$    integer:: jmax ! ٳʻ. 
!!$                   ! Number of grid points in latitude
!!$
!!$    real(DP):: x_Lon_Weight(0:intavr_opr%imax-1)
!!$                   ! ʬѺɸŤ. 
!!$                   ! Weight for integration in longitude
!!$    real(DP):: y_Lat_Weight(0:intavr_opr%jmax-1)
!!$                   ! ʬѺɸŤ. 
!!$                   ! Weight for integration in latitude
!!$
!!$    character(*), parameter:: subname = 'SampleFunction'
!!$  continue
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *intavr_opr* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *intavr_opr*
!!$    !-----------------------------------------------------------------
!!$    imax = intavr_opr % imax
!!$    jmax = intavr_opr % jmax
!!$    x_Lon_Weight = intavr_opr % x_Lon_Weight
!!$    y_Lat_Weight = intavr_opr % y_Lat_Weight
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$  end function SampleFunction

end module intavr_operate
