!--
! *** Caution!! ***
! 
! This file is generated from "timefilter.rb2f90" by Ruby 1.8.2.
! Please do not edit this file directly.
!
! [JAPANESE]
!
!  !!! 
!
! Υե "timefilter.rb2f90"  Ruby 1.8.2
! ˤäƼư줿եǤ.
! ΥեľԽޤ褦ꤤפޤ.
!
!
!++
!= ե륿
!
!= Time filter
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: timefilter.f90,v 1.13 2007-09-04 01:35:56 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module timefilter
  !
  != ե륿
  !
  != Time filter
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ׻⡼ɤޤ뤿Υե륿 (Asselin, 1972)
  ! ŬѤ뤿Υ⥸塼Ǥ.
  !
  ! ʤ
  ! \[
  !   \bar{A}^{t}
  !   = {A}^{t}
  !     + \epsilon_f
  !        \left( 
  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
  !        \right) \] \[
  !   \qquad
  !   = ( 1-2 \epsilon_f ) {A}^{t}
  !     + \epsilon_f 
  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
  ! \]
  ! Ȥ $ \bar{A}^{t} $ ޤ. ź
  ! $ t-\Delta t, t, t+\Delta t $ Ϥ줾֥ƥåפɽ,
  ! ե륿ŬѤ줿ˤϾ ( $ \bar{\quad} $ ) 
  ! դƤޤ.
  !
  ! ե륿η $\epsilon_f$  Create κݤꤷޤ.
  !
  !--
  ! \[
  !   \bar{\mathscr A}^{t}
  !     = ( 1-2 \epsilon_f ) {\mathscr A}^{t}
  !     +  \epsilon_f 
  !         \left( \bar{\mathscr A}^{t-\Delta t} + {\mathscr A}^{t+\Delta t} \right)
  ! \]
  ! Ȥ$\bar{\mathscr A}^{t}$ޤ. ź
  !++
  !
  ! Time filter (Asselin, 1972) for suppression of computational mode 
  ! is applied.
  !
  ! Concretely, $ \bar{A}^{t} $ is derived as follows.
  ! \[
  !   \bar{A}^{t}
  !   = {A}^{t}
  !     + \epsilon_f
  !        \left( 
  !               \bar{A}^{t-\Delta t} - 2{A}^{t} + {A}^{t+\Delta t}
  !        \right) \] \[
  !   \qquad
  !   = ( 1-2 \epsilon_f ) {A}^{t}
  !     + \epsilon_f 
  !        \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right),
  ! \]
  ! where suffices $ t-\Delta t, t, t+\Delta t $ represent time step, 
  ! and over-bar $ \bar{\quad} $ represents the terms applied 
  ! time filter.
  !
  ! Time filter coefficient $ \epsilon_f $ is specified by "Create".
  !
  !== Procedures List
  !
  ! Create        :: TFILTER ѿν
  ! Close         :: TFILTER ѿνλ
  ! Filter        :: ե륿Ŭ
  ! Progress      :: οʹ
  ! PutLine       :: TFILTER ѿ˳ǼƤΰ
  ! initialized   :: TFILTER ѿꤵƤ뤫ݤ
  ! ------------  :: ------------
  ! Create        :: Constructor of "TFILTER"
  ! Close         :: Deconstructor of "TFILTER"
  ! Filter        :: Apply time filter
  ! Progress      :: Progress time
  ! PutLine       :: Print information of "TFILTER"
  ! initialized   :: Check initialization of "TFILTER"
  !
  !== Usage
  !
  ! Ϥ, TFILTER ѿ, Create ǽꤷޤ. 
  ! Filter  TFILTER ѿ,  $ t-\Delta t, t, t+\Delta t $ 
  ! ΥǡͿ뤳Ȥ, ե륿ŬѤޤ.
  !
  ! First, initialize "TFILTER" by "Create".
  ! Give "TFILTER" variable and data at $ t-\Delta t, t, t+\Delta t $, 
  ! then time filter is applied to the data.
  !
  !== References
  !
  ! * Asselin, R. A., 1972: 
  !   Frequency filter for time integrations.
  !   <i>Mon. Wea. Rev.</i>, <b>100</b>, 487--490.
  !

  !---------------------------------------------------------
  !  ѥ桼ƥƥ
  !  Common utilities
  !---------------------------------------------------------
  use dc_types, only: DP
  use dc_date_types, only: DC_DIFFTIME
  implicit none
  private
  public:: TFILTER, Create, Close, Filter, Progress, PutLine
  public:: initialized

  type TFILTER
    !
    ! "TFILTER" ѿѤݤˤɬ Create ˤäƽ
    ! ԤäƤ.
    ! ꤵ줿 "TFILTER" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "TFILTER" variable by "Create" before usage.
    ! If you reuse "TFILTER" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.
                              ! ե饰. 
                              ! Initialization flag
    logical:: dummy0          ! 8 ӥåȶѤΥߡѿ. 
                              ! Dummy variable for 8 bit boundary
    real(DP):: filter_param = 0.0_DP
                              ! ե륿η. 
                              ! Time filter coefficient
    integer:: int_step = -1   ! ե륿ŬѤֳ
                              ! (ֲƥåפǻ). 
                              ! Step interval of time filter application
    integer:: cur_step = 0    ! ߤΥƥå׿. 
                              ! Current step
    type(DC_DIFFTIME):: int_time
                              ! ե륿ŬѤֳ 
                              ! (*int_step* ͥ褵). 
                              ! Time interval of time filter application
                              ! (*int_step* has priority)
    type(DC_DIFFTIME):: cur_time
                              ! ߻. 
                              ! Current time
    logical:: nofilter = .false.
                              ! ե륿ŬѤԤʤȤ򼨤ե饰. 
                              ! Flag for no filter application
    logical:: dummy1          ! 8 ӥåȶѤΥߡѿ. 
                              ! Dummy variable for 8 bit boundary
  end type TFILTER

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: timefilter.f90,v 1.13 2007-09-04 01:35:56 morikawa Exp $'

  interface Create
    module procedure TimeFilterCreate
  end interface

  interface Close
    module procedure TimeFilterClose
  end interface

  interface Progress
    module procedure TimeFilterProgress
  end interface

  interface PutLine
    module procedure TimeFilterPutLine
  end interface

  interface Filter
                                              module procedure TimeFilterFilterReal0
                      
    module procedure TimeFilterFilterReal1
                      
    module procedure TimeFilterFilterReal2
                      
    module procedure TimeFilterFilterReal3
                      
    module procedure TimeFilterFilterReal4
                      
    module procedure TimeFilterFilterReal5
                      
    module procedure TimeFilterFilterReal6
                      
    module procedure TimeFilterFilterReal7
                      
                    
                          module procedure TimeFilterFilterDouble0
                      
    module procedure TimeFilterFilterDouble1
                      
    module procedure TimeFilterFilterDouble2
                      
    module procedure TimeFilterFilterDouble3
                      
    module procedure TimeFilterFilterDouble4
                      
    module procedure TimeFilterFilterDouble5
                      
    module procedure TimeFilterFilterDouble6
                      
    module procedure TimeFilterFilterDouble7
                      
                    
  end interface

  interface initialized
    module procedure TimeFilterInitialized
  end interface

  interface NmlRead
    module procedure TimeFilterNmlRead
  end interface

contains

  subroutine TimeFilterCreate( tfilt, &
    & filter_param, int_step, int_time, cur_step, cur_time, &
    & nmlfile, err )
    !
    !  *tfilt* ˥ե륿Ԥޤ.
    ! Filter ѤɬΥ֥롼ˤä TFILTER 
    ! ѿꤷƤ.
    !
    !  *filter_param* ˤϥե륿η $ \epsilon_f $
    ! ͿƤ.
    ! ƥåפȤ˥ե륿ͭˤ뤫
    !  *int_time*, ⤷ *int_step* ǻꤷޤ.
    ! ֲƥåפȤƻꤹ, ͤ *int_step* Ϳ
    ! . 0 Ϳȥե륿ŬѤޤ.
    ! ֲ, ʬ, ֤ˡפȤˤ *int_time*
    !  DC_DIFFTIME ѿͿƤ.
    !
    ! Ʊ,  *cur_step* ޤ *cur_time* ظߤΥƥå׿
    ! ޤϻ֤ͿƤ. *int_step* ꤷ *cur_step*
    ! , *int_time* ꤷ *cur_time* ͿƤ.
    !
    !  *filter_param*  *int_step* ͤͿ, ɬפʰ­
    ! ʤʤɤξˤϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#timefilter_nml 򻲾ȤƤ. 
    !
    !
    ! Configure the setting of time filter to argument *tfilt*.
    ! Before use Filter, initialize "TFILTER" variable by this
    ! subroutine.
    !
    ! Give time filter coefficient $ \epsilon_f $ to argument *filter_param*.
    ! Interval of time filter application is specified to
    ! argument *int_time* or *int_step*.
    ! If you want to specify the interval as "How many step", 
    ! give positive integer to *int_step*.
    ! If 0 is given, time filter is not applied.
    ! If you want to specify the interval as 
    ! "How many seconds, minutes, or hours", 
    ! give "DC_DIFFTIME" variable to *int_time*.
    !
    ! At the same time, give current step or time to argument *cur_step*
    ! or *cur_time*. When *int_step* is given, give *cur_step*.
    ! Otherwise, give *cur_time*.
    !
    ! If negative value is given to argument *filter_param* or *int_step*, or 
    ! necessary arguments are lack, error is occured.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#timefilter_nml"
    ! for details about a NAMELIST group.
    !
    use dc_types, only: DP, STRING, TOKEN
    use dc_date_types, only: DC_DIFFTIME
    use dc_date, only: EvalSec, Create
    use dc_trace, only: BeginSub, EndSub
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: DC_ENOFILEREAD
    use dcpam_error, only: StoreError, DC_NOERR, &
      & DCPAM_ENEGATIVE, DCPAM_EARGLACK, DCPAM_EALREADYINIT
    implicit none
    type(TFILTER), intent(out):: tfilt
    real(DP), intent(in):: filter_param
    integer, intent(in), optional:: int_step
    type(DC_DIFFTIME), intent(in), optional:: int_time
    integer, intent(in), optional:: cur_step
    type(DC_DIFFTIME), intent(in), optional:: cur_time
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#timefilter_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#timefilter_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: int_time_val
    character(TOKEN):: int_time_unit
    real(DP):: cur_time_val
    character(TOKEN):: cur_time_unit

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreate'
  continue
    call BeginSub(subname, 'filter_param=%f', d=(/filter_param/), version=version)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (tfilt % initialized) then
      stat = DCPAM_EALREADYINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (.not. present(int_step) .and. .not. present(int_time)) then
      stat = DCPAM_EARGLACK
      cause_c = '"int_step" or "int_time"'
      goto 999
    end if
    if (present(int_step)) then
      if (.not. present(cur_step)) then
        stat = DCPAM_EARGLACK
        cause_c = '"cur_step"'
        goto 999
      end if
    else
      if (.not. present(cur_time)) then
        stat = DCPAM_EARGLACK
        cause_c = '"cur_time"'
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  tfilt 
    !  Configure the settings of tfilt
    !-----------------------------------------------------------------
    tfilt % filter_param = filter_param

    call Create( tfilt % int_time, &    ! (out)
      &          0.0_DP, unit = 'sec' ) ! (in)
    call Create( tfilt % cur_time, &    ! (out)
      &          0.0_DP, unit = 'sec' ) ! (in)

    if ( present(int_step) ) then
      if ( int_step == 0 ) tfilt % nofilter = .true.
      tfilt % int_step = int_step
      tfilt % cur_step = cur_step
    else
      if ( EvalSec(int_time) == 0.0_DP ) tfilt % nofilter = .true.
      tfilt % int_time = int_time
      tfilt % cur_time = cur_time
      tfilt % int_step = -1
    end if

    !-----------------------------------------------------------------
    !  NAMELIST ͤ
    !  Input values from NAMELIST
    !-----------------------------------------------------------------
    int_time_val  = EvalSec( tfilt % int_time )
    int_time_unit = 'sec'
    cur_time_val  = EvalSec( tfilt % cur_time )
    cur_time_unit = 'sec'

    if ( present_and_not_empty(nmlfile) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1=trim(nmlfile) )
      call NmlRead ( nmlfile = nmlfile, &        ! (in)
        & filter_param = tfilt % filter_param, & ! (inout)
        & int_step = tfilt % int_step, &         ! (inout)
        & cur_step = tfilt % cur_step, &         ! (inout)
        & int_time_val   = int_time_val, &       ! (inout)
        & int_time_unit_ = int_time_unit, &      ! (inout)
        & cur_time_val   = cur_time_val, &       ! (inout)
        & cur_time_unit_ = cur_time_unit, &      ! (inout)
        & err = err )                            ! (out)
      if ( present_and_true(err) ) then
        call MessageNotify( 'W', subname, &
          & '"%c" can not be read.', &
          & c1=trim(nmlfile) )
        stat = DC_ENOFILEREAD
        cause_c = nmlfile
        goto 999
      end if
    end if

    if ( tfilt % int_step == -1 ) then
      call Create( tfilt % int_time, &           ! (out)
        &          int_time_val, int_time_unit ) ! (in)
      call Create( tfilt % cur_time, &           ! (out)
        &          cur_time_val, cur_time_unit ) ! (in)
      if ( EvalSec( tfilt % int_time ) == 0.0_DP ) tfilt % nofilter = .true.
    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validation of setting values
    !-----------------------------------------------------------------
    if ( tfilt % filter_param < 0.0_DP ) then
      stat = DCPAM_ENEGATIVE
      cause_c = 'filter_param'
      goto 999
    end if

    if ( tfilt % int_step == -1 ) then
      if ( EvalSec( tfilt % int_time ) < 0.0_DP ) then
        stat = DCPAM_ENEGATIVE
        cause_c = 'int_time'
        goto 999
      end if
    else
      if ( tfilt % int_step < 0 ) then
        stat = DCPAM_ENEGATIVE
        cause_c = 'int_step'
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    tfilt % initialized = .true.
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine TimeFilterCreate

  subroutine TimeFilterClose( tfilt, err )
    !
    ! TFILTER ѿνλԤޤ.
    ! ʤ, Ϳ줿 *tfilt*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "TFILTER".
    ! Note that if *tfilt* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(inout):: tfilt
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. tfilt % initialized ) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "TFILTER" ξõ
    !  Clear the settings for "TFILTER"
    !-----------------------------------------------------------------
    tfilt % filter_param = 0.0_DP
    tfilt % int_step = -1
    tfilt % cur_step = 0
    tfilt % nofilter = .false.

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    tfilt % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine TimeFilterClose


  subroutine TimeFilterProgress( tfilt, step, time, err )
    !
    !  *tfilt* λʤޤ. *step*, *time* Ϳʤ
    ! ˤ *step*  1 ʤ᤿ΤƱˤʤޤ.
    !  Create  *int_time* Ǵֳ֤ꤷƤ,
    ! ɬ *time* ǻʤɬפޤ.
    !
    !  *step*  *time* ͤͿ, ɬפʰ­
    ! ʤʤɤξˤϥ顼ȯޤ. *err* Ϳˤ *err*
    !  .true. ֤, ץ³Ԥޤ.
    !
    ! Progress time in argument *tfilt*. When neither *step* nor *time*
    ! are given, 1 is given to *step* implicitly.
    ! Note if *int_time* is given to Create,
    ! progress time with argument *time*.
    !
    ! If negative value is given to argument *filter_param* or *int_step*, or 
    ! necessary arguments are lack, error is occured.
    !
    use dc_types, only: DP, STRING
    use dc_date_types, only: DC_DIFFTIME
    use dc_date, only: EvalSec, operator(+)
    use dc_trace, only: BeginSub, EndSub
    use dcpam_error, only: StoreError, DC_NOERR, &
      & DCPAM_ENEGATIVE, DCPAM_EARGLACK, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(inout):: tfilt
    integer, intent(in), optional:: step
    type(DC_DIFFTIME), intent(in), optional:: time
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterProgress'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validation of arguments
    !-----------------------------------------------------------------
    if (.not. present(time)) then
      if (tfilt % int_step == -1) then
        stat = DCPAM_EARGLACK
        cause_c = 'time'
        goto 999
      end if
    else
      if (EvalSec(time) < 0.0_DP) then
        stat = DCPAM_ENEGATIVE
        cause_c = 'time'
        goto 999
      end if
    end if
    if (present(step)) then
      if (step < 0) then
        stat = DCPAM_ENEGATIVE
        cause_c = 'step'
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  tfilt λʹ
    !  Progress time in tfilt
    !-----------------------------------------------------------------
    if (tfilt % int_step == -1) then
      tfilt % cur_time = tfilt % cur_time + time
    else
      if (present(step)) then
        tfilt % cur_step = tfilt % cur_step + step
      else
        tfilt % cur_step = tfilt % cur_step + 1
      end if
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine TimeFilterProgress


  subroutine TimeFilterPutLine( tfilt, unit, indent, err )
    !
    !  *tfilt* ξޤ.
    ! ǥեȤǤɸϤ˰ޤ. *unit* ֹ
    ! ꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *tfilt*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_types, only: STRING, STDOUT
    use dc_date, only: toChar
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: Printf
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'TimeFilterPutLine'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (present(unit)) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if (present(indent)) then
      if (len(indent) /= 0) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "TFILTER" ΰ
    !  Print the settings for "TFILTER"
    !-----------------------------------------------------------------

    if (tfilt % initialized) then
      if (tfilt % int_step == -1) then
        call Printf(out_unit, &
          & indent_str(1:indent_len) // &
          & '#<TFILTER:: @filter_param=%f @int_time=%c @cur_time=%c @nofilter=%y>', &
          & d=(/tfilt % filter_param/), c1=trim(toChar(tfilt % int_time)), &
          & c2=trim(toChar(tfilt % cur_time)), l=(/tfilt % nofilter/))
      else
        call Printf(out_unit, &
          & indent_str(1:indent_len) // &
          & '#<TFILTER:: @filter_param=%f @int_step=%d @cur_step=%d @nofilter=%y>', &
          & d=(/tfilt % filter_param/), &
          & i=(/tfilt % int_step, tfilt % cur_step/), l=(/tfilt % nofilter/))
      end if
    else
      call Printf(out_unit, &
        & indent_str(1:indent_len) // &
        & '#<TFILTER:: @initialized=%y>', &
        & l=(/tfilt % initialized/))
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine TimeFilterPutLine

  logical function TimeFilterInitialized( tfilt ) result(result)
    !
    ! *tfilt* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *tfilt* is initialized, .true. is returned.
    ! If *tfilt* is not initialized, .false. is returned.
    !
    implicit none
    type(TFILTER), intent(in):: tfilt
  continue
    result = tfilt % initialized
  end function TimeFilterInitialized

  subroutine TimeFilterNmlRead( nmlfile, &
    & filter_param, &
    & int_step, cur_step, &
    & int_time_val, int_time_unit_, &
    & cur_time_val, cur_time_unit_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
    real(DP), intent(inout):: filter_param
                              ! ե륿η. 
                              ! Time filter coefficient
    integer, intent(inout):: int_step
                              ! ե륿ŬѤֳ
                              ! (ֲƥåפǻ). 
                              ! Step interval of time filter application
    integer, intent(inout):: cur_step
                              ! ߤΥƥå׿. 
                              ! Current step
    real(DP), intent(inout):: int_time_val
                              ! ե륿ŬѤֳ
                              ! (int_step = -1 ξˤ餬ͥ褵). 
                              ! Time interval of time filter application
                              ! (This has priority when int_step = -1)
    character(*), intent(inout):: int_time_unit_
    character(TOKEN):: int_time_unit
                              ! int_time_val ñ. 
                              ! Ѳǽñ̤˴ؤƤ gt4f90io 饤֥
                              !  dc_date ⥸塼򻲾ȤΤ. 
                              ! Unit of 'int_time_val'. 
                              ! See 'dc_date' module in 'gt4f90io' library
                              ! about available units.
    real(DP), intent(inout):: cur_time_val
                              ! ߻. 
                              ! Current time
    character(*), intent(inout):: cur_time_unit_
    character(TOKEN):: cur_time_unit
                              ! cur_time_val ñ. 
                              ! Ѳǽñ̤˴ؤƤ gt4f90io 饤֥
                              !  dc_date ⥸塼򻲾ȤΤ. 
                              ! Unit of 'cur_time_val'. 
                              ! See 'dc_date' module in 'gt4f90io' library
                              ! about available units.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    namelist /timefilter_nml/ &
      & filter_param, &
      & int_step, cur_step, &
      & int_time_val, int_time_unit, &
      & cur_time_val, cur_time_unit
                              !
                              ! timefilter ⥸塼 NAMELIST ѿ̾.
                              !
                              ! timefilter#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for "timefilter" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "timefilter#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml
    integer:: iostat_nml
    character(*), parameter:: subname = 'TimeFilterNmlRead'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''


    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
    int_time_unit = int_time_unit_
    cur_time_unit = cur_time_unit_

    !-----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !-----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if

    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
    read( unit = unit_nml, & ! (in)
      & nml = timefilter_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='timefilter_nml', c2=trim(nmlfile) )
      write(STDOUT, nml = timefilter_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='timefilter_nml', c2=trim(nmlfile), &
        & i=(/iostat_nml/) )
    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
    int_time_unit_ = int_time_unit
    cur_time_unit_ = cur_time_unit

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname)
  end subroutine TimeFilterNmlRead




  subroutine TimeFilterFilterReal0( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real, intent(in):: before
    real, intent(inout):: now
    real, intent(in):: after
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateReal0'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0 &
      &     - 2.0 * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterReal0


  subroutine TimeFilterFilterReal1( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real, intent(in):: before(:)
    real, intent(inout):: now(:)
    real, intent(in):: after(:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateReal1'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0 &
      &     - 2.0 * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterReal1


  subroutine TimeFilterFilterReal2( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real, intent(in):: before(:,:)
    real, intent(inout):: now(:,:)
    real, intent(in):: after(:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateReal2'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0 &
      &     - 2.0 * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterReal2


  subroutine TimeFilterFilterReal3( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real, intent(in):: before(:,:,:)
    real, intent(inout):: now(:,:,:)
    real, intent(in):: after(:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateReal3'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0 &
      &     - 2.0 * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterReal3


  subroutine TimeFilterFilterReal4( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real, intent(in):: before(:,:,:,:)
    real, intent(inout):: now(:,:,:,:)
    real, intent(in):: after(:,:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateReal4'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0 &
      &     - 2.0 * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterReal4


  subroutine TimeFilterFilterReal5( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real, intent(in):: before(:,:,:,:,:)
    real, intent(inout):: now(:,:,:,:,:)
    real, intent(in):: after(:,:,:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateReal5'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0 &
      &     - 2.0 * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterReal5


  subroutine TimeFilterFilterReal6( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real, intent(in):: before(:,:,:,:,:,:)
    real, intent(inout):: now(:,:,:,:,:,:)
    real, intent(in):: after(:,:,:,:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateReal6'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0 &
      &     - 2.0 * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterReal6


  subroutine TimeFilterFilterReal7( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real, intent(in):: before(:,:,:,:,:,:,:)
    real, intent(inout):: now(:,:,:,:,:,:,:)
    real, intent(in):: after(:,:,:,:,:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateReal7'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0 &
      &     - 2.0 * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterReal7


  subroutine TimeFilterFilterDouble0( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real(DP), intent(in):: before
    real(DP), intent(inout):: now
    real(DP), intent(in):: after
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateDouble0'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0_DP &
      &     - 2.0_DP * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterDouble0


  subroutine TimeFilterFilterDouble1( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real(DP), intent(in):: before(:)
    real(DP), intent(inout):: now(:)
    real(DP), intent(in):: after(:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateDouble1'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0_DP &
      &     - 2.0_DP * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterDouble1


  subroutine TimeFilterFilterDouble2( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real(DP), intent(in):: before(:,:)
    real(DP), intent(inout):: now(:,:)
    real(DP), intent(in):: after(:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateDouble2'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0_DP &
      &     - 2.0_DP * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterDouble2


  subroutine TimeFilterFilterDouble3( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real(DP), intent(in):: before(:,:,:)
    real(DP), intent(inout):: now(:,:,:)
    real(DP), intent(in):: after(:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateDouble3'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0_DP &
      &     - 2.0_DP * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterDouble3


  subroutine TimeFilterFilterDouble4( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real(DP), intent(in):: before(:,:,:,:)
    real(DP), intent(inout):: now(:,:,:,:)
    real(DP), intent(in):: after(:,:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateDouble4'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0_DP &
      &     - 2.0_DP * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterDouble4


  subroutine TimeFilterFilterDouble5( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real(DP), intent(in):: before(:,:,:,:,:)
    real(DP), intent(inout):: now(:,:,:,:,:)
    real(DP), intent(in):: after(:,:,:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateDouble5'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0_DP &
      &     - 2.0_DP * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterDouble5


  subroutine TimeFilterFilterDouble6( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real(DP), intent(in):: before(:,:,:,:,:,:)
    real(DP), intent(inout):: now(:,:,:,:,:,:)
    real(DP), intent(in):: after(:,:,:,:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateDouble6'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0_DP &
      &     - 2.0_DP * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterDouble6


  subroutine TimeFilterFilterDouble7( tfilt, &
    & before, now, after, err )
    !
    ! ȼȤбϰʲ̤Ǥ.
    ! $ \epsilon_f $  Create ǻꤷޤ.
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> () :: $ A^{t} $
    ! <b>now</b> (֤) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    !
    ! Arguments respond to the equation as follows.
    ! $ \epsilon_f $ is specified in Create .
    !
    ! \[
    !   \bar{A}^{t}
    !     = ( 1-2 \epsilon_f ) {A}^{t}
    !     +  \epsilon_f 
    !         \left( \bar{A}^{t-\Delta t} + {A}^{t+\Delta t} \right)
    ! \]
    !
    ! <b>before</b>       :: $ \bar{A}^{t-\Delta t} $
    ! <b>now</b> (Input)  :: $ A^{t} $
    ! <b>now</b> (Output) :: $ \bar{A}^{t} $
    ! <b>after</b>        :: $ \bar{A}^{t+\Delta t} $
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_types, only: STRING, STDOUT, DP
    use dc_date, only: operator(==), mod
    use dcpam_error, only: StoreError, DC_NOERR, DCPAM_ENOTINIT
    implicit none
    type(TFILTER), intent(in):: tfilt
    real(DP), intent(in):: before(:,:,:,:,:,:,:)
    real(DP), intent(inout):: now(:,:,:,:,:,:,:)
    real(DP), intent(in):: after(:,:,:,:,:,:,:)
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 
    logical:: skip
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'TimeFilterCreateDouble7'
  continue
    call BeginSub(subname)
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if (.not. tfilt % initialized) then
      stat = DCPAM_ENOTINIT
      cause_c = 'TFILTER'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ե륿Ŭ
    !  Application of time filter
    !-----------------------------------------------------------------
    skip = .true.

    if (tfilt % int_step == -1) then
      if (.not. mod(tfilt % cur_time, tfilt % int_time) == 0) then
        goto 999
      end if
    else
      if (.not. mod(tfilt % cur_step, tfilt % int_step) == 0) then
        goto 999
      end if
    end if

    skip = .false.
    now = ( &
      &     1.0_DP &
      &     - 2.0_DP * tfilt % filter_param &
      &   ) * now &
      &   + tfilt % filter_param * ( before + after )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError(stat, subname, err, cause_c)
    call EndSub(subname, 'skip=%y', l=(/skip/))
  end subroutine TimeFilterFilterDouble7

end module timefilter

!--
! vi:set readonly sw=4 ts=8:
!
!Local Variables:
!mode: f90
!buffer-read-only: t
!End:
!
!++
