!= phy_saturate_nha92 ⥸塼Υƥȥץ
!
!= Test program for "phy_saturate_nha92"
!
! Authors::   Masaki ISHIWATARI, Yasuhiro MORIKAWA
! Version::   $Id: phy_saturate_nha92_test.f90,v 1.5 2008-04-20 18:44:16 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_saturate_nha92 ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_saturate_nha92" module.
! Confirm compilation and execution of this program.
!

program phy_saturate_nha92_test
  use phy_saturate_nha92, only: PHYSATNHA, PhySatNhaCreate, &
    & CalcQVapSat, CalcDQVapSatDTemp, PhySatNhaClose, &
    & PhySatNhaPutLine, PhySatNhaInitialized
!!$    & PhySatNhaSetTime
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING
  use dc_string, only: StoA, PutLine
  use dc_args, only: ARGS, DCArgsOpen, DCArgsHelpMsg, DCArgsOption, &
    & DCArgsDebug, DCArgsHelp, DCArgsStrict, DCArgsClose
  implicit none

  !-------------------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !-------------------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_saturate_nha92_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "phy_saturate_nha92" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
!!$  integer, parameter:: imax = 8
!!$                              ! ٳʻ. 
!!$                              ! Number of grid points in longitude
!!$  integer, parameter:: jmax = 4
!!$                              ! ٳʻ. 
!!$                              ! Number of grid points in latitude

  !-------------------------------------------------------------------
  !  ǡ
  !  Axes data
  !-------------------------------------------------------------------
!!$  real(DP):: x_Lon (0:imax-1)
!!$                              ! . Longitude
!!$  real(DP):: y_Lat (0:jmax-1)
!!$                              ! . Latitude

  !-------------------------------------------------------------------
  !  ʪ
  !  Physical values
  !-------------------------------------------------------------------
  real(DP):: EpsV             ! $ \epsilon_v $ .
                              ! ʬ. Molecular weight ratio of water vapor

  real(DP), allocatable:: xyz_Temp (:,:,:)
                              ! $ T $ .  . Temperature
  real(DP), allocatable:: xyz_Press (:,:,:)
                              ! $ p $ . . 
                              ! Air pressure
  real(DP):: QVapSat
                              ! $ q^{*} $ . ˰漾. 
                              ! Saturation specific humidity. 
  real(DP), allocatable:: xy_QVapSat (:,:)
                              ! $ q^{*} $ . ˰漾. 
                              ! Saturation specific humidity. 
  real(DP), allocatable:: xyz_QVapSat (:,:,:)
                              ! $ q^{*} $ . ˰漾. 
                              ! Saturation specific humidity. 
  real(DP):: DQVapSatDTemp
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 
  real(DP), allocatable:: xy_DQVapSatDTemp (:,:)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 
  real(DP), allocatable:: xyz_DQVapSatDTemp (:,:,:)
                              ! $ \DP{q^{*}}{T} $ . ˰漾βʬ. 
                              ! Temperature derivative of saturation specific humidity. 

!!$  real(DP):: x_Data1 (0:imax-1)
!!$                              ! ǡ 1. Data 1
!!$  real(DP):: y_Data2 (0:jmax-1)
!!$                              ! ǡ 2. Data 2

  !-------------------------------------------------------------------
  !  
  !  Constants
  !-------------------------------------------------------------------
!!$  real(DP), parameter:: PI = 3.1415926535897930_DP
!!$                              ! $ \pi $ . ߼Ψ. Circular constant

  !-------------------------------------------------------------------
  !  ѿ
  !  Work variables
  !-------------------------------------------------------------------
!!$  integer:: i, j              ! DO 롼Ѻѿ
!!$                              ! Work variables for DO loop
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line options
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option

  type(PHYSATNHA):: phy_sat_nha00, phy_sat_nha01
!!$  type(PHYSATNHA):: phy_sat_nha02, phy_sat_nha03
  logical:: err
  character(*), parameter:: subname = 'phy_saturate_nha92_test'
continue

  !-------------------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line options handling
  !-------------------------------------------------------------------
  call cmdline_optparse ! ֥롼. This is an internal subroutine


  !-------------------------------------------------------------------
  !  ʪ
  !  Configure physical constants
  !-------------------------------------------------------------------
  EpsV = 0.622646_DP


  !-------------------------------------------------------------------
  !  ǡ
  !  Configure axes data
  !-------------------------------------------------------------------
!!$  x_Lon = (/   0.0,  45.0,  90.0, 135.0, &
!!$    &        180.0, 225.0, 270.0, 315.0 /) * PI / 180.0_DP
!!$  y_Lat = (/ -59.4444, -19.8757, 19.8757, 59.4444 /) * PI / 180.0_DP

  !-------------------------------------------------------------------
  !  ܤν, λƥ
  !  Basic initialization and termination test
  !-------------------------------------------------------------------
  call PhySatNhaCreate( &
    & phy_sat_nha = phy_sat_nha00, &  ! (out)
    & imax = 1, jmax = 1, kmax = 1, & ! (in)
    & EpsV = EpsV )                   ! (in)
  call AssertEqual( 'basic initialization test 1', &
    & answer = .true., check = PhySatNhaInitialized(phy_sat_nha00) )
  call PhySatNhaPutLine( phy_sat_nha = phy_sat_nha00 ) ! (in)

  call PhySatNhaClose( phy_sat_nha = phy_sat_nha00 ) ! (inout)
  call AssertEqual( 'basic termination test 1', &
    & answer = .false., check = PhySatNhaInitialized(phy_sat_nha00) )
  call PhySatNhaPutLine( phy_sat_nha = phy_sat_nha00 ) ! (in)


  !-------------------------------------------------------------------
  !  ʣ˴ؤ륨顼Υƥ
  !  Error handling related to duplicated initialization test
  !-------------------------------------------------------------------
  call PhySatNhaCreate( &
    & phy_sat_nha = phy_sat_nha00, & ! (inout)
    & imax = 1, jmax = 1, kmax = 1, & ! (in)
    & EpsV = EpsV )                   ! (in)
  call PhySatNhaCreate( &
    & phy_sat_nha = phy_sat_nha00, &  ! (inout)
    & imax = 1, jmax = 1, kmax = 1, & ! (in)
    & EpsV = EpsV, &                  ! (in)
    & err = err )                     ! (out)
  call AssertEqual( 'error handling related to duplicated initialization test 1', &
    & answer = .true., check = err )
  call PhySatNhaPutLine( phy_sat_nha = phy_sat_nha00 ) ! (in)
  call PhySatNhaClose( phy_sat_nha = phy_sat_nha00 ) ! (inout)


  !-------------------------------------------------------------------
  !  λ˴ؤ륨顼Υƥ
  !  Error handling related to termination test
  !-------------------------------------------------------------------
  call PhySatNhaClose( &
    & phy_sat_nha = phy_sat_nha00, & ! (inout)
    & err = err )                                    ! (out)
  call AssertEqual( 'error handling related to termination test 1', &
    & answer = .true., check = err )


  !-------------------------------------------------------------------
  !  ˰漾׻ƥ
  !  Saturation specific humidity calculation test
  !-------------------------------------------------------------------
  call PhySatNhaCreate( &
    & phy_sat_nha = phy_sat_nha01, &  ! (out)
    & imax = 1, jmax = 1, kmax = 1, & ! (in)
    & EpsV = EpsV )                   ! (in)

  allocate( xyz_Temp(1,1,1), xyz_Press(1,1,1) )
  allocate( xy_QVapSat(1,1), xy_DQVapSatDTemp(1,1) )
  allocate( xyz_QVapSat(1,1,1), xyz_DQVapSatDTemp(1,1,1) )

  xyz_Temp(1,1,1) = 273.0_DP
  xyz_Press(1,1,1) = 1.0e+5_DP

  call CalcQVapSat( phy_sat_nha = phy_sat_nha01,  &       ! (inout)
    & Temp = xyz_Temp(1,1,1), Press = xyz_Press(1,1,1), & ! (in)
    & QVapSat = QVapSat )                                 ! (out)
  call AssertEqual( 'CalcQVapSat test 1', &
    & answer = 3.866415753356e-3_DP, check = QVapSat, &
    & significant_digits = 15, ignore_digits = -15 )

  call CalcQVapSat( phy_sat_nha = phy_sat_nha01,  &              ! (inout)
    & xy_Temp = xyz_Temp(:,:,1), xy_Press = xyz_Press(:,:,1), &  ! (in)
    & xy_QVapSat = xy_QVapSat )                                  ! (out)
  call AssertEqual( 'CalcQVapSat test 2', &
    & answer = 3.866415753356e-3_DP, check = xy_QVapSat(1,1), &
    & significant_digits = 15, ignore_digits = -15 )

  call CalcQVapSat( phy_sat_nha = phy_sat_nha01,  &  ! (inout)
    & xyz_Temp = xyz_Temp, xyz_Press = xyz_Press, &  ! (in)
    & xyz_QVapSat = xyz_QVapSat )                    ! (out)
  call AssertEqual( 'CalcQVapSat test 3', &
    & answer = 3.866415753356e-3_DP, check = xyz_QVapSat(1,1,1), &
    & significant_digits = 15, ignore_digits = -15 )


  call CalcDQVapSatDTemp( phy_sat_nha = phy_sat_nha01,  &  ! (inout)
    & Temp = xyz_Temp(1,1,1), Press = xyz_Press(1,1,1), &  ! (in)
    & DQVapSatDTemp = DQVapSatDTemp )                      ! (out)
  call AssertEqual( 'CalcDQVapSatDTemp test 1', &
    & answer = 2.724000794636e-4_DP, check = DQVapSatDTemp, &
    & significant_digits = 15, ignore_digits = -15 )

  call CalcDQVapSatDTemp( phy_sat_nha = phy_sat_nha01,  &        ! (inout)
    & xy_Temp = xyz_Temp(:,:,1), xy_Press = xyz_Press(:,:,1), &  ! (in)
    & xy_DQVapSatDTemp = xy_DQVapSatDTemp )                      ! (out)
  call AssertEqual( 'CalcDQVapSatDTemp test 2', &
    & answer = 2.724000794636e-4_DP, check = xy_DQVapSatDTemp(1,1), &
    & significant_digits = 15, ignore_digits = -15 )

  call CalcDQVapSatDTemp( phy_sat_nha = phy_sat_nha01,  &  ! (inout)
    & xyz_Temp = xyz_Temp, xyz_Press = xyz_Press, &  ! (in)
    & xyz_DQVapSatDTemp = xyz_DQVapSatDTemp )        ! (out)
  call AssertEqual( 'CalcDQVapSatDTemp test 3', &
    & answer = 2.724000794636e-4_DP, check = xyz_DQVapSatDTemp(1,1,1), &
    & significant_digits = 15, ignore_digits = -15 )

  call PhySatNhaClose( phy_sat_nha = phy_sat_nha01 ) ! (inout)

  !-------------------------------------------------------------------
  !  NAMELIST եɤ߹ߥƥ
  !  NAMELIST file loading test
  !-------------------------------------------------------------------
!!$  call PhySatNhaCreate( &
!!$    & phy_sat_nha = phy_sat_nha01, & ! (out)
!!$    & imax = imax, jmax = jmax, &                  ! (in)
!!$    & x_Lon = x_Lon, y_Lat = y_Lat, &              ! (in)
!!$    & CoefAlpha = - 0.0001_DP, DelTime = 0.5_DP, & ! (in)
!!$    & nmlfile = VAL_namelist )                ! (in)
!!$  call AssertEqual( 'NAMELIST file loading test 1', &
!!$    & answer = .true., check = PhySatNhaInitialized(phy_sat_nha01) )
!!$  call PhySatNhaPutLine( phy_sat_nha = phy_sat_nha01 ) ! (in)
!!$  call PhySatNhaClose( phy_sat_nha = phy_sat_nha01 ) ! (inout)

  !-------------------------------------------------------------------
  !  ̵ͤ˴ؤ륨顼Υƥ
  !  Error handling related to invalid values test
  !-------------------------------------------------------------------
!!$  call PhySatNhaCreate( &
!!$    & phy_sat_nha = phy_sat_nha02, & ! (out)
!!$    & imax = imax, jmax = jmax, &                  ! (in)
!!$    & x_Lon = x_Lon, y_Lat = y_Lat, &              ! (in)
!!$    & CoefAlpha = - 0.0001_DP, DelTime = 0.5_DP, & ! (in)
!!$    & err = err )                                  ! (out)
!!$  call AssertEqual( 'error handling related to invalid values test 1', &
!!$    & answer = .true., check = err )

!!$  call PhySatNhaCreate( &
!!$    & phy_sat_nha = phy_sat_nha02, & ! (inout)
!!$    & imax = imax, jmax = jmax, &                  ! (in)
!!$    & x_Lon = x_Lon, y_Lat = y_Lat, &              ! (in)
!!$    & CoefAlpha = 0.0001_DP, DelTime = - 0.5_DP, & ! (in)
!!$    & err = err )                                  ! (out)
!!$  call AssertEqual( 'error handling related to invalid values test 2', &
!!$    & answer = .true., check = err )

  !-------------------------------------------------------------------
  !  ҥȥǡϥƥ
  !  History data output test
  !-------------------------------------------------------------------
!!$  call PhySatNhaCreate( &
!!$    & phy_sat_nha = phy_sat_nha03, & ! (out)
!!$    & imax = imax, jmax = jmax, &              ! (in)
!!$    & x_Lon = x_Lon, y_Lat = y_Lat, &          ! (in)
!!$    & CoefAlpha = 0.01_DP, DelTime = 0.5_DP, & ! (in)
!!$    & current_time_value = 0.0, &              ! (in)
!!$    & current_time_unit = 'sec', &             ! (in)
!!$    & history_varlist = 'Data2', &             ! (in)
!!$    & history_interval_value = 2.0, &          ! (in)
!!$    & history_interval_unit = 'sec', &         ! (in)
!!$    & history_precision = 'float', &           ! (in)
!!$    & history_fileprefix = 'AP_' )             ! (in)
!!$  call PhySatNhaPutLine( phy_sat_nha = phy_sat_nha03 ) ! (in)
!!$
!!$  do i = 0, imax-1
!!$    x_Data1(i) = i * 1.0_DP
!!$  end do
!!$  do j = 0, jmax-1
!!$    y_Data2(j) = j * 1.1_DP
!!$  end do
!!$
!!$  do i = 1, 12
!!$    call PhySatNhaCalculation( &
!!$      & phy_sat_nha = phy_sat_nha03, & ! (inout)
!!$      & x_Data1 = x_Data1, y_Data2 = y_Data2 ) ! (inout)
!!$  end do
!!$
!!$  call PhySatNhaSetTime( &
!!$    & phy_sat_nha = phy_sat_nha03, & ! (inout)
!!$    & current_time_value = 1.0, current_time_unit = 'minute' ) ! (in)
!!$
!!$  call PhySatNhaCalculation( &
!!$    & phy_sat_nha = phy_sat_nha03, & ! (inout)
!!$    & x_Data1 = x_Data1, y_Data2 = y_Data2, & ! (inout)
!!$    & historyput_flag = .true. )              ! (in)
!!$
!!$  call PhySatNhaClose( phy_sat_nha = phy_sat_nha03 ) ! (inout)

contains

  subroutine cmdline_optparse
    !
    ! ޥɥ饤νԤޤ
    !
    ! Handle command line options
    !
    call DCArgsOpen( arg = arg )               ! (out)

    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Title', msg = title )      ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Usage', &                  ! (in)
      & msg = './' // trim(subname) // &
      &       ' [Options]' )                   ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Source', msg = source )    ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Institution', &            ! (in)
      & msg = institution )                    ! (in)

    call DCArgsOption( arg = arg, &           ! (inout)
      & options = StoA('-N', '--namelist'), & ! (in)
      & flag = OPT_namelist, &                ! (out)
      & value = VAL_namelist, &               ! (out)
      & help = "Namelist filename")           ! (in)

    call DCArgsDebug( arg = arg )  ! (inout)
    call DCArgsHelp( arg = arg )   ! (inout)
    call DCArgsStrict( arg = arg ) ! (inout)

    call DCArgsClose( arg = arg )  ! (inout)
  end subroutine cmdline_optparse

end program phy_saturate_nha92_test
