!= Dynamical core module
!
! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: dynamics.f90,v 1.9 2006/08/21 08:06:14 morikawa Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2004-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module dynamics_mod
  !
  !== Overview
  !
  ! Calculate Dynamical Core.
  !
  ! ϳإʬ黻⥸塼롣黻Ƥϡ
  ! Υμˡϰʲ̤ꡣ
  !
  !  : Governing Equations
  ! * ɸץߥƥ :
  !   Primitive Equations in Spherical Coordinate
  !
  ! ʿΥ : Horizontal Discretization
  ! * ڥȥˡ : Spectral Method
  !   * ѷ   : Triangle Truncation
  !   * Ѵˡ       : Transform Method
  !
  ! ľΥ : Vertical Discretization
  ! * Һɸ    : Sigma Coordinate (Arakawa and Suarez(1983))
  !   * Lorenz ʻ : Lorenz Grid
  !
  ! ʬ : Time Integral
  ! * leap frog : ꡼ץեå
  !
  !== Reference
  !
  ! * Arakawa, A., Suarez, M. J., 1983:
  !   Vertical differencing of the primitive equations
  !   in sigma coordinates.
  !   Mon. Wea. Rev., 111, 34--35.
  !
  !== Error Handling
  !
  !== Known Bugs
  !
  ! * Ǵ׻ wa_NumVis_wa  wa_NumVisScaler_wa Ȥꤢ SPMODEL
  !   ܿᡢ̾ΤʤɤΤޤޤǤ롣
  !   ϥ⥸塼ΤΤȤ̾Τ¾θƤɬפǤ
  !
  !== Note
  !
  !== Future Plans
  !
  !ߡϳزƤΥ⥸塼ˤ롣ʤС
  !μˤäƥ⥸塼벽ʤ٤Ǥ롣
  !

  use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
  implicit none
  private
  public :: dynamics_init, dynamics_leapfrog  ! subroutines
  public :: dynamics_diagnostic, dynamics_end ! subroutines
  public :: dynamics_diffusion                ! subroutines

  !-------------------------------------------------------------------
  !   dynamics_init ˤͤꤹ
  !-------------------------------------------------------------------
  real(DBKIND) :: Kappa               ! =ҡã (/갵Ǯ)
  real(DBKIND), pointer, save:: xy_Coli(:,:) =>null()
                                      ! ʻǡ(ꥪ)
  real(DBKIND), pointer, save:: xy_UVFact(:,:) =>null()
                                      ! uU, vV Υե
  real(DBKIND), pointer, save:: z_DelSigma(:) =>null()
                                      ! (٥)
  real(DBKIND), pointer, save:: wz_DiffVorDiv(:,:) =>null()
                                      ! ư (ȯ) ʿȻ
  real(DBKIND), pointer, save:: wz_DiffTherm(:,:) =>null()
                                      ! Ǯ漾 ʿȻ

  real(DBKIND), pointer, save:: z_TempAvrXY(:) =>null()
                                      ! ʿѲ (٥)
  real(DBKIND), pointer, save:: r_TempAvrXY(:) =>null()
                                      ! ʿѲ (Ⱦ٥)

  real(DBKIND), pointer, save:: z_HydroAlpha(:) =>null()
                                      ! ſ尵μη 
  real(DBKIND), pointer, save:: z_HydroBeta(:) =>null()
                                      ! ſ尵μη 
  real(DBKIND), pointer, save:: z_TempInpolKappa(:) =>null()
                                      ! ٱľ֤η
  real(DBKIND), pointer, save:: z_TempInpolA(:) =>null()
                                      ! ٱľ֤η
  real(DBKIND), pointer, save:: z_TempInpolB(:) =>null()
                                      ! ٱľ֤η

  ! semi-implicitѹ
  real(DBKIND), pointer, save:: z_siMtxG(:)   =>null()
                                      !  = ãʣ
  real(DBKIND), pointer, save:: zz_siMtxGCt(:,:)  =>null()
                                      ! ǣ^{Transposed}
                                      !   ( = )
  real(DBKIND), pointer, save:: zz_siMtxW(:,:)   =>null()
                                      ! :ȯμǤβ
                                      !    (ȹθ)
  real(DBKIND), pointer, save:: zz_siMtxWH(:,:)  =>null()
                                      ! ף:
  real(DBKIND), pointer, save:: zz_siMtxH(:,:)  =>null()
                                      ! : ѣ (Ұή) - 
  real(DBKIND), pointer, save:: zz_siMtxQ(:,:) =>null()
                                      ! : d/d (ȹθ)
  real(DBKIND), pointer, save:: zz_siMtxS(:,:) =>null()
                                      ! : d/d (ȹθ)
  real(DBKIND), pointer, save:: zz_siMtxQS(:,:) =>null()
                                      ! ѣ:
  real(DBKIND), pointer, save:: zz_siMtxR(:,:) =>null()
                                      ! : ң =
                                      !      ʣԡʢߦ/ߣܣ/ҡ
                                      !     Ѳθ̤η
                                      !     (ȹθ)


  !-------------------------------------------------------------------
  !   dynamics_leapfrog ˤѤ
  !-------------------------------------------------------------------
  real(DBKIND), pointer, save:: xy_lnPs(:,:) =>null()
                                        ! С ln s (t)
  real(DBKIND), pointer, save:: xy_DlnPsDtN(:,:) =>null()
                                        ! ФλѲ d/dt (t)
  real(DBKIND), pointer, save:: w_DlnPsDtN(:) =>null()
                                        ! ФλѲ (ڥȥ) (t)
  real(DBKIND), pointer, save:: w_lnPsN(:) =>null()
                                        !  (t)
  real(DBKIND), pointer, save:: xy_GradLonlnPsN(:,:) =>null()
                                        ! d/dx (t)
  real(DBKIND), pointer, save:: xy_GradLatlnPsN(:,:) =>null()
                                        ! d/dy (t)
  real(DBKIND), pointer, save:: wz_TempN(:,:) => null()
                                        !  (t)
  real(DBKIND), pointer, save:: w_lnPsA(:) =>null()
                                        !  (t+t)

  real(DBKIND), pointer, save:: xyz_lnPsAdv(:,:,:) =>null()
                                        !  ΰή 
  real(DBKIND), pointer, save:: xyz_lnPsAdvSum(:,:,:) =>null()
                                        ! аήѲ [kK]()
  real(DBKIND), pointer, save:: xyz_DivSum(:,:,:) =>null()
                                        ! ȯѲ [kK] Ħ
  real(DBKIND), pointer, save:: xyr_VSigma(:,:,:) =>null()
                                        ! ľ®(Ⱦ٥) (t)
  real(DBKIND), pointer, save:: xyr_VSigmaNonG(:,:,:) => null()
                                        ! ľ® ʬ
                                        !         (Ⱦ٥) (t)

  real(DBKIND), pointer, save:: xyz_TempEdd(:,:,:) =>null()
                                        ! ' ٤ξ (٥) (t)
  real(DBKIND), pointer, save:: xyr_TempEdd(:,:,:) =>null()
                                        ! ' ٤ξ (Ⱦ٥)(t)
  real(DBKIND), pointer, save:: xyz_TempVir(:,:,:) =>null()
                                        ! v        (t)
  real(DBKIND), pointer, save:: xyz_TempVirEdd(:,:,:) =>null()
                                        ! v'٤ξ (t)

  real(DBKIND), pointer, save:: xyz_UAN(:,:,:) =>null()
                                        ! ưѲգ
  real(DBKIND), pointer, save:: xyz_VAN(:,:,:) =>null()
                                        ! ̱ưѲ֣

  real(DBKIND), pointer, save:: wz_DVorDtN(:,:) =>null()
                                        ! ѲΥڥȥǡ (t)
  real(DBKIND), pointer, save:: wz_VorA(:,:) =>null()
                                        ! ٤Υڥȥǡ    (t+t)

  real(DBKIND), pointer, save:: xyz_KE(:,:,:) =>null()
                                        ! ưͥ륮 + 
                                        ! **2+**2    + (v-)
  real(DBKIND), pointer, save:: xy_Phi(:,:) =>null()
                                        ! ɽݥƥ󥷥릵

  real(DBKIND), pointer, save:: wz_DDivDtN(:,:) =>null()
                                        ! ȯѲΥڥȥǡ (t)
  real(DBKIND), pointer, save:: wz_DivA(:,:) =>null()
                                        ! ȯΥڥȥǡ (t+t)
  real(DBKIND), pointer, save:: wz_PresTendTemp(:,:) =>null()
                                        ! ٤ˤ밵Ϸ٤Υڥȥǡ
  real(DBKIND), pointer, save:: wz_PresTendPs(:,:) =>null()
                                        ! ɽϤˤ밵Ϸ٤Υڥȥǡ

  real(DBKIND), pointer, save:: xyz_DTempLocalDtN(:,:,:) => null()
                                        ! ٤ζɽѲ  
                                        ! (ʿȯ ' + Ұή
                                        !  + Ѳθ) (ȹ)

  real(DBKIND), pointer, save:: wz_DTempDtN(:,:) =>null()
                                        ! ٤Ѳڥȥǡ (t)
  real(DBKIND), pointer, save:: wz_TempA(:,:) =>null()
                                        ! ٤Υڥȥǡ   (t+t)

  real(DBKIND), pointer, save:: xyz_QVapDivVSigmaAdv(:,:,:) => null()
                                        ! ҡġܦҰή
  real(DBKIND), pointer, save:: wz_DQVapDtN(:,:) =>null()
                                        ! 漾Ѳڥȥǡ (t)
  real(DBKIND), pointer, save:: wz_QVapA(:,:) =>null()
                                        ! 漾Υڥȥǡ   (t+t)

  !-------------------------------------------------------------------
  !   dynamics_diagnostic Ƿ׻ѿ
  !-------------------------------------------------------------------
  real(DBKIND), pointer:: wz_PsiA(:,:) =>null() ! ڥȥ(ήؿ) (t+t)
  real(DBKIND), pointer:: wz_ChiA(:,:) =>null() ! ڥȥ(ݥƥ󥷥) (t+t)

  logical, save :: dynamics_initialized = .false.
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: dynamics.f90,v 1.9 2006/08/21 08:06:14 morikawa Exp $'

contains

  subroutine dynamics_init( &
    & x_Lon, y_Lat, z_Sigma, r_Sigma & !(in)
    & )
    !
    ! Initialize module and Calculate Non-Predictional Value.
    !
    ! ʹߤΥ֥롼Ѥѿ allocate 
    ! ȯŸʤ̤α黻Ԥʤ
    ! ޤѿǡϤΤνԤʤ
    !
    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use grid_3d_mod,         only: im, jm, km
    use grid_wavenumber_mod, only: nm
    use constants_mod, only: constants_init, R0, Omega, Cp, RAir, &
         &                   TempAve, VisOrder, EFoldTime
    use time_mod,    only: DelTime
    use spml_mod,    only: spml_init, xy_Lat, rn
    use io_gt4_out_mod,only: io_gt4_out_init, io_gt4_out_SetVars
    use dc_trace,    only: DbgMessage, BeginSub, EndSub, DataDump
    use dc_string,   only: toChar
    implicit none
    real(DBKIND), intent(in) :: x_Lon(:)   ! ٺɸ
    real(DBKIND), intent(in) :: y_Lat(:)   ! ٺɸ
    real(DBKIND), intent(in) :: z_Sigma(:) ! ҥ٥()ɸ
    real(DBKIND), intent(in) :: r_Sigma(:) ! ҥ٥(Ⱦ)ɸ

    !----- Ȼ׻ѿ -----
    real(DBKIND)          :: VisCoef             ! ĶǴ
    real(DBKIND), pointer :: wz_rn(:,:) =>null() ! ץ饷η -n*(n+1)

    !----- ѿ -----
    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)   :: i, j, k, kk, l

    character(STRING),  parameter:: subname = "dynamics_init"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname, version)
    if (dynamics_initialized) then
       call EndSub( subname, '%c is already called.', c1=trim(subname) )
       return
    else
       dynamics_initialized = .true.
    endif

    !-------------------------------------------------------------------
    !   ʪμ
    !-------------------------------------------------------------------
    call constants_init

    !-------------------------------------------------------------------
    !   SPMODEL ν
    !-------------------------------------------------------------------
    call spml_init

    !-------------------------------------------------------------------
    !   io_gt4_out ν
    !-------------------------------------------------------------------
    call io_gt4_out_init

    !-------------------------------------------------------------------
    !   ꥪϤ
    !-------------------------------------------------------------------
    allocate( xy_Coli(im, jm) )
    xy_Coli = 2.0 * Omega * sin(xy_Lat)

!--
!!$    call DataDump('xy_Coli', xy_Coli, strlen=80)
!!$    call DataDump('xy_Lat', xy_Lat, strlen=80)
!++

    !-------------------------------------------------------------------
    !   uU, vV Υեη׻
    !-------------------------------------------------------------------
    allocate( xy_UVFact(im, jm) )
    xy_UVFact = cos( xy_Lat )

!--
!!$    call DataDump('xy_UVFact', xy_UVFact, strlen=80)
!++

    !-------------------------------------------------------------------
    !    (Ⱦ) η׻
    !-------------------------------------------------------------------
    allocate( z_DelSigma(km) )

    do k = 1, km
      z_DelSigma(k) = r_Sigma(k) - r_Sigma(k+1)
    enddo

!--
!!$    call DataDump('z_Delsigma', z_DelSigma, strlen=80)
!++

    !-------------------------------------------------------------------
    !   ư (ȯ) Ȼ wz_DiffVorDiv, 
    !   ǮȻ wz_DiffTherm η׻
    !-------------------------------------------------------------------
    allocate( wz_DiffVorDiv((nm+1)*(nm+1), km) )
    allocate( wz_DiffTherm ((nm+1)*(nm+1), km) )
    allocate( wz_rn        ((nm+1)*(nm+1), km) )

    do k = 1, km
      wz_rn(:,k) = rn(:,1)
    enddo

    ! Ǵη׻ (ȿ e-folding time  EFoldTime Ȥʤ褦)
    VisCoef = (real( (nm * (nm+1)), DBKIND ) / R0**2 )**(-VisOrder / 2) &
      &        / EFoldTime

    call DbgMessage('VisCoef=<%f>', d=(/VisCoef/))

    wz_DiffTherm  = - VisCoef * ( (-wz_rn / R0**2)**(VisOrder / 2) )

    wz_DiffVorDiv =   wz_DiffTherm  &
       &            - VisCoef * ( - (2.0d0 / R0**2)**(VisOrder / 2))

!--
!!$    call DataDump('wz_DiffTherm' , wz_DiffTherm,  strlen=80)
!!$    call DataDump('wz_DiffVorDiv', wz_DiffVorDiv, strlen=80)
!++

    deallocate(wz_rn)


    !-------------------------------------------------------------------
    !   ſ尵μη¤η׻
    !-------------------------------------------------------------------
    allocate(z_HydroAlpha(km))
    allocate(z_HydroBeta(km))

    Kappa = RAir / Cp    ! =ҡã (/갵Ǯ)
    do k = 1, km
      z_HydroAlpha(k) = ( r_Sigma(k) / z_Sigma(k) )**Kappa - 1.0
      z_HydroBeta(k)  = 1.0 - ( r_Sigma(k+1) / z_Sigma(k) )**Kappa
    enddo

!--
!!$    call DbgMessage('Kappa=<%f>',  d=(/Kappa/) )
!!$    call DataDump('z_HydroAlpha', z_HydroAlpha, strlen=80)
!!$    call DataDump('z_HydroBeta', z_HydroBeta, strlen=80)
!++

    !-------------------------------------------------------------------
    !   ٱľ֤ηᡢη׻
    !-------------------------------------------------------------------
    allocate(z_TempInpolA(km))
    allocate(z_TempInpolB(km))
    allocate(z_TempInpolKappa(km))

    do k = 1, km
      z_TempInpolA(k) = &
        & z_HydroAlpha(k) / ( 1.0 - (z_Sigma(k) / z_Sigma(k-1))**Kappa )

      z_TempInpolB(k) = &
        & z_HydroBeta(k) / ( (z_Sigma(k) / z_Sigma(k+1))**Kappa - 1.0 )

      z_TempInpolKappa(k) = &
        & ( r_Sigma(k) * z_HydroAlpha(k) &
        &   + r_Sigma(k+1) * z_HydroBeta(k) ) / z_DelSigma(k)
    enddo
    z_TempInpolA(1) = 0.0
    z_TempInpolB(km) = 0.0

!--
!!$    call DataDump('z_TempInpolA', z_TempInpolA, strlen=80)
!!$    call DataDump('z_TempInpolB', z_TempInpolB, strlen=80)
!!$    call DataDump('z_TempInpolKappa', z_TempInpolKappa, strlen=80)
!++

    !-------------------------------------------------------------------
    !   ʿѲ (٥롢Ⱦ٥) η׻
    !-------------------------------------------------------------------
    allocate( z_TempAvrXY(km) )
    allocate( r_TempAvrXY(km+1) )

    z_TempAvrXY = TempAve

    !----- üʿѲ -----
    !  ̯Ѥͤʤ褦
    r_TempAvrXY = 0.0d0

    do k = 2, km
      r_TempAvrXY(k) = &
        &   z_TempInpolA(k)   * z_TempAvrXY(k)   &
        & + z_TempInpolB(k-1) * z_TempAvrXY(k-1)
    enddo

!--
!!$    call DataDump('z_TempAvrXY', z_TempAvrXY, strlen=80)
!!$    call DataDump('r_TempAvrXY', r_TempAvrXY, strlen=80)
!++


    !-------------------------------------------------------------------
    !   semi-implicit ѹη׻
    !-------------------------------------------------------------------
    allocate( z_siMtxG(km) )
    allocate( zz_siMtxGCt(km,km) )
    allocate( zz_siMtxW(km,km) )
    allocate( zz_siMtxWH(km,km) )
    allocate( zz_siMtxH(km,km) )
    allocate( zz_siMtxQ(km,km) )
    allocate( zz_siMtxS(km,km) )
    allocate( zz_siMtxQS(km,km) )
    allocate( zz_siMtxR(km,km) )

    !  = ãʣ
    z_siMtxG = Cp * z_TempInpolKappa * z_TempAvrXY

    ! ǣ^{Transposed}     ( = )
    do k = 1, km
      do kk = 1, km
        zz_siMtxGCt(k, kk) = z_siMtxG(k) * z_DelSigma(kk)
      end do
    end do


    ! :ȯμǤβ (ȹθ)

    ! 
    zz_siMtxW = 0.0

    do k = 1, km
      do kk = 1, k
        zz_siMtxW(k, kk) = Cp * z_HydroAlpha(kk)
      enddo

      do kk = 1, k-1
        zz_siMtxW(k, kk) = zz_siMtxW(k, kk) + Cp * z_HydroBeta(kk)
      enddo
    enddo

    ! : d/d (ȹθ)

    ! 
    zz_siMtxS = 0.0

    do k = 1, km
      do kk = 1, km
        zz_siMtxS(k,kk) = r_Sigma(k) * z_DelSigma(kk)
      enddo

      do kk = k, km
        zz_siMtxS(k,kk) = zz_siMtxS(k,kk) - z_DelSigma(kk)
      enddo

    enddo
!--
!!$    call DataDump('zz_siMtxS', zz_siMtxS, strlen=80)
!++

    ! : d/d (ȹθ)

    ! 
    zz_siMtxQ = 0.0

    do k = 1, km
      zz_siMtxQ(k,k) = ( r_TempAvrXY(k) - z_TempAvrXY(k) ) / z_DelSigma(k)
    enddo
    do k = 1, km - 1
      zz_siMtxQ(k,k+1) = ( z_TempAvrXY(k) - r_TempAvrXY(k+1) ) / z_DelSigma(k)
    enddo
!--
!!$    call DataDump('zz_siMtxQ', zz_siMtxQ, strlen=80)
!++

    ! ѣ

    ! 
    zz_siMtxQS = 0.0

    zz_siMtxQS = matmul(zz_siMtxQ, zz_siMtxS)


    ! : ң = ʣԡʢߦ/ߣܣ/ҡ
    !     Ѳθ̤η  (ȹθ)

    ! 
    zz_siMtxR = 0.0

    do k = 1, km
      do kk = k, km
        zz_siMtxR(k,kk) = &
          & - z_HydroAlpha(k) / z_DelSigma(k) * z_DelSigma(kk) * z_TempAvrXY(k)
      enddo

      do kk = k+1, km
        zz_siMtxR(k,kk) = zz_siMtxR(k,kk)  &
          & - z_HydroBeta(k) / z_DelSigma(k) * z_DelSigma(kk) * z_TempAvrXY(k)
      enddo
    enddo
!--
!!$    call DataDump('zz_siMtxR', zz_siMtxR, strlen=80)
!++

    ! : ѣ (Ұή) - 

    ! 
    zz_siMtxH = 0.0

    zz_siMtxH = zz_siMtxQS - zz_siMtxR

    ! ף:

    ! 
    zz_siMtxWH = 0.0

    zz_siMtxWH = matmul(zz_siMtxW, zz_siMtxH)

!--
!!$    call DataDump('zz_siMtxH', zz_siMtxH, strlen=80)
!++

    !-------------------------------------------------------------------
    !   ǡѤν
    !-------------------------------------------------------------------
    call io_gt4_out_SetVars('xyz_DivSum')
    call io_gt4_out_SetVars('xyz_lnPsAdv')
    call io_gt4_out_SetVars('xyz_lnPsAdvSum')
    call io_gt4_out_SetVars('xyz_UAN')
    call io_gt4_out_SetVars('xyz_VAN')
    call io_gt4_out_SetVars('xyz_KE')
    call io_gt4_out_SetVars('xyz_PresTendTemp')
    call io_gt4_out_SetVars('xyz_PresTendPs')
    call io_gt4_out_SetVars('xyr_VSigma')
    call io_gt4_out_SetVars('xyr_VSigmaNonG')
    call io_gt4_out_SetVars('xyz_DTempLocalDtN')
    call io_gt4_out_SetVars('xyz_TempAdv')
    call io_gt4_out_SetVars('xyr_TempEdd')
    call io_gt4_out_SetVars('xyz_Temp_T')
    call io_gt4_out_SetVars('xyz_DTempLocalDtN_lnPsAdvSum')

    call io_gt4_out_SetVars('TotalMass')

    call io_gt4_out_SetVars('xyz_Vor_Diffusion')
    call io_gt4_out_SetVars('xyz_Div_Diffusion')
    call io_gt4_out_SetVars('xyz_Temp_Diffusion')
    call io_gt4_out_SetVars('xyz_QVap_Diffusion')

    !-------------------------------------------------------------------
    !   dynamics_leapfrog Ƿ׻ѿ allocate 
    !-------------------------------------------------------------------
    allocate  & 
      & ( xy_lnPs (im, jm)          , & ! С ln s           (t)
      &   xyz_lnPsAdv(im, jm, km)   , & !  ΰή 
      &   xyz_lnPsAdvSum(im, jm, km), & ! аήѲ [kK]()
      &   xyz_DivSum(im, jm, km)    , & ! ȯѲ [kK] Ħ

      &   xy_DlnPsDtN( im, jm )       , & ! ФλѲ d/dt   (t)
      &   w_DlnPsDtN( (nm+1)*(nm+1) ) , & ! ФλѲ (ڥȥ) (t)
      &   w_lnPsN( (nm+1)*(nm+1) ) , & !  (t)
      &   xy_GradLonlnPsN( im, jm ), & ! d/dx (t)
      &   xy_GradLatlnPsN( im, jm ), & ! d/dy (t)
      &   wz_TempN( (nm+1)*(nm+1), km ) , & !  (t)
      &   w_lnPsA( (nm+1)*(nm+1) ) , & !  (t+t)

      &   xyr_VSigma(im, jm, km+1) , & ! ľ®(Ⱦ٥) (t)
      &   xyr_VSigmaNonG(im, jm, km+1) , & ! ľ® ʬ (Ⱦ٥) (t)

      &   xyz_TempEdd(im, jm, km)   , & ! ' ٤ξ (٥) (t)
      &   xyz_TempVir(im, jm, km)   , & ! v  (virtual temperature)(t)
      &   xyz_TempVirEdd(im, jm, km ), &! v'٤ξ               (t)
      &   xyr_TempEdd(im, jm, km+1), &! ' ٤ξ (Ⱦ٥)   (t)

      &   xyz_UAN(im, jm, km)      , & ! ưѲգ
      &   xyz_VAN(im, jm, km)      , & ! ̱ưѲ֣

      &   wz_DVorDtN( (nm+1)*(nm+1), km ) , & ! ѲΥڥȥǡ (t) 
      &   wz_VorA( (nm+1)*(nm+1), km ) , & ! ٤Υڥȥǡ    (t+t)

      &   xyz_KE(im, jm, km)      , & ! ưͥ륮 + 
                                      ! **2+**2    + (v-)

      &   wz_DDivDtN( (nm+1)*(nm+1), km) , & ! ȯΥڥȥǡ (t)
      &   wz_DivA( (nm+1)*(nm+1), km) , & ! ȯΥڥȥǡ (t+t)
      &   wz_PresTendTemp( (nm+1)*(nm+1), km) , & ! ٤ˤ밵Ϸ٤Υڥȥǡ
      &   wz_PresTendPs( (nm+1)*(nm+1), km) , & ! ɽϤˤ밵Ϸ٤Υڥȥǡ

      &   xyz_DTempLocalDtN(im, jm, km)  , & ! ٤ζɽѲ  
                                           ! (ʿȯ ' + Ұή
                                           !  + Ѳθ) (ȹ)

      &   wz_DTempDtN( (nm+1)*(nm+1), km ) , & ! ٤Ѳڥȥǡ (t)
      &   wz_TempA( (nm+1)*(nm+1), km ) , & ! ٤Υڥȥǡ   (t+t)

      &   xyz_QVapDivVSigmaAdv( im, jm, km), & ! ҡġܦҰή
      &   wz_DQVapDtN( (nm+1)*(nm+1), km) , & ! 漾Ѳڥȥǡ (t)
      &   wz_QVapA( (nm+1)*(nm+1), km)   & ! 漾Υڥȥǡ   (t+t)
      & )


    !-------------------------------------------------------------------
    !   dynamics_diagnostic Ƿ׻ѿ allocate 
    !-------------------------------------------------------------------
    allocate  &
      & ( wz_PsiA( (nm+1)*(nm+1), km) , & ! ڥȥ(ήؿ)
      &   wz_ChiA( (nm+1)*(nm+1), km) )   ! ڥȥ(ݥƥ󥷥)


    call EndSub(subname)
  end subroutine dynamics_init


  subroutine dynamics_leapfrog &
    & ( x_Lon      , y_Lat      , z_Sigma , r_Sigma  , & !(in)

    &   xyz_VelLonB, xyz_VelLatB, xyz_VorB, xyz_DivB , & !(in)
    &   xyz_TempB  , xyz_QVapB  , xy_PsB  ,            & !(in)

    &   xyz_VelLonN, xyz_VelLatN, xyz_VorN, xyz_DivN , & !(in)
    &   xyz_TempN  , xyz_QVapN  , xy_PsN  ,            & !(in)

    &   xyz_VelLonA, xyz_VelLatA, xyz_VorA, xyz_DivA , & !(out)
    &   xyz_TempA  , xyz_QVapA  , xy_PsA             )   !(out)
    !
    ! Calculate Predictional Values.
    !
    ! ȯŸ̤α黻Ԥʤ
    ! 黻ǡνϤԤʤ
    !
    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use grid_3d_mod,         only: im, jm, km
    use grid_wavenumber_mod, only: nm
    use constants_mod, only: R0, Cp, EpsVT
    use time_mod,    only: DelTime, CurrentTime
    use spml_mod,    only: w_xy, xy_w , xy_GradLon_w, xy_GradLat_w, &
      &                    w_Div_xy_xy, w_LaplaInv_w,               &
      &                    wa_xya, xya_wa, wa_Div_xya_xya, wa_Lapla_wa
    use io_gt4_out_mod,only: io_gt4_out_Put
    use dc_trace,    only: DbgMessage, BeginSub, EndSub, DataDump
    use dc_string,   only: toChar
    implicit none

    real(DBKIND), intent(in) ::  x_Lon(:)           ! ٺɸ
    real(DBKIND), intent(in) ::  y_Lat(:)           ! ٺɸ
    real(DBKIND), intent(in) ::  z_Sigma(:)         ! ҥ٥()ɸ
    real(DBKIND), intent(in) ::  r_Sigma(:)         ! ҥ٥(Ⱦ)ɸ
    
    real(DBKIND), intent(in) ::  xyz_VelLonB(:,:,:)  ! ®ٷʬ (t-t)
    real(DBKIND), intent(in) ::  xyz_VelLatB(:,:,:)  ! ®ٰʬ (t-t)
    real(DBKIND), intent(in) ::  xyz_VorB(:,:,:)     !          (t-t)
    real(DBKIND), intent(in) ::  xyz_DivB(:,:,:)     ! ȯ         (t-t)
    real(DBKIND), intent(in) ::  xyz_TempB(:,:,:)    !          (t-t)
    real(DBKIND), intent(in) ::  xyz_QVapB(:,:,:)    ! 漾         (t-t)
    real(DBKIND), intent(in) ::  xy_PsB(:,:)         ! ɽ̵   (t-t)
    
    real(DBKIND), intent(in) ::  xyz_VelLonN(:,:,:)  ! ®ٷʬ (t)
    real(DBKIND), intent(in) ::  xyz_VelLatN(:,:,:)  ! ®ٰʬ (t)
    real(DBKIND), intent(in) ::  xyz_VorN(:,:,:)     !          (t)
    real(DBKIND), intent(in) ::  xyz_DivN(:,:,:)     ! ȯ         (t)
    real(DBKIND), intent(in) ::  xyz_TempN(:,:,:)    !          (t)
    real(DBKIND), intent(in) ::  xyz_QVapN(:,:,:)    ! 漾         (t)
    real(DBKIND), intent(in) ::  xy_PsN(:,:)         ! ɽ̵   (t)

    real(DBKIND), intent(out) ::  xyz_VelLonA(:,:,:)! ®ٷʬ (t+t)
    real(DBKIND), intent(out) ::  xyz_VelLatA(:,:,:)! ®ٰʬ (t+t)
    real(DBKIND), intent(out) ::  xyz_VorA(:,:,:)   !          (t+t)
    real(DBKIND), intent(out) ::  xyz_DivA(:,:,:)   ! ȯ         (t+t)
    real(DBKIND), intent(out) ::  xyz_TempA(:,:,:)  !          (t+t)
    real(DBKIND), intent(out) ::  xyz_QVapA(:,:,:)  ! 漾         (t+t)
    real(DBKIND), intent(out) ::  xy_PsA(:,:)       ! ɽ̵   (t+t)

    !----- ѿ -----
    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)   :: i, j, k, kk, l


    character(STRING),  parameter:: subname = "dynamics_leapfrog"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname, version)
    if (.not. dynamics_initialized) then
      call EndSub( subname, 'Call dynamics_init before call %c',  &
        &       c1=trim(subname) )
      return
    endif

    !-------------------------------------------------------------------
    !   ɽѲľ®٤η׻  (Ϣ³μǮμѤ)
    !-------------------------------------------------------------------

    xy_lnPs = log( xy_PsN )

    w_lnPsN = w_xy(xy_lnPs)
    xy_GradLonlnPsN = xy_GradLon_w( w_lnPsN )
    xy_GradLatlnPsN = xy_GradLat_w( w_lnPsN )

    ! ɽ̵  ΰή = 
    do k = 1, km
      xyz_lnPsAdv(:,:,k) = &
        &  ( xyz_VelLonN(:,:,k) * xy_GradLonlnPsN &
        &    + xyz_VelLatN(:,:,k) * xy_GradLatlnPsN &
        &   ) / R0
    enddo
    call io_gt4_out_Put('xyz_lnPsAdv', xyz_lnPsAdv)
!--
!!$    call DataDump('xyz_lnPsAdv', xyz_lnPsAdv, strlen=80)
!++


    ! аήѤ߲ [kK] () 
    xyz_lnPsAdvSum(:,:,km) = xyz_lnPsAdv(:,:, km ) * z_DelSigma( km )

    do k = km-1 , 1, -1
      xyz_lnPsAdvSum(:,:,k) = &
        &   xyz_lnPsAdvSum(:,:,k+1) &
        & + xyz_lnPsAdv(:,:,k) * z_DelSigma(k)
    enddo
    call io_gt4_out_Put('xyz_lnPsAdvSum', xyz_lnPsAdvSum)
!--
!!$    call DataDump('xyz_lnPsAdvSum', xyz_lnPsAdvSum, strlen=80)
!++


    ! ȯѲ [kK] Ħ
    xyz_DivSum(:,:,km) = xyz_DivN(:,:, km ) * z_DelSigma( km )

    do k = km -1 , 1, -1
      xyz_DivSum(:,:,k) = &
        &   xyz_DivSum(:,:,k+1) + xyz_DivN(:,:,k) * z_DelSigma(k)
    enddo

    call io_gt4_out_Put('xyz_DivSum', xyz_DivSum)
!--
!!$    call DataDump('xyz_DivSum', xyz_DivSum, strlen=80)
!++

    !-------------------------------------------------------------------
    !   Ps η׻Ϣ³μ
    !-------------------------------------------------------------------

    !-----  = lns λѲ d/dt η׻ -----
    !
    ! аήѤ߲ [1K] ()  ʻǲ򤯡
    !
    xy_DlnPsDtN = - xyz_lnPsAdvSum(:,:,1)   ! - [1K]()

!--
!!$    call DataDump('xy_DlnPsDtN', xy_DlnPsDtN, strlen=80)
!++


    !----- ȯѤ߲ -[1K] Ħ 򥹥ڥȥ֤ǲä롣-----
    w_DlnPsDtN = w_xy( xy_DlnPsDtN ) - w_xy( xyz_DivSum(:,:,1) )

    !----- A = B + 2t * T-----
    w_lnPsA = w_xy(  log( xy_PsB )  ) + 2.0*DelTime * ( w_DlnPsDtN )

!--
!!$    call DataDump('xy_PsB', xy_PsB, strlen=80)
!!$    call DataDump('w_lnPsB', w_xy(  log( xy_PsB )  ), strlen=80)
!!$    call DataDump('w_lnPsA', w_lnPsA, strlen=80)
!++

    !----- xy_PsA -----
    xy_PsA = exp(  xy_w( w_lnPsA )  )

!--
!!$    call DataDump('xy_PsA', xy_PsA, strlen=80)
!++

    !-------------------------------------------------------------------
    !   ľ® (Ⱦ٥) ξ徺ήη׻
    !-------------------------------------------------------------------

    ! ® (3/2  K-1/2)
    ! - [k-1/2]  ( [1K]( + ) )
    ! - [kK] ( + ) 

    do k = 2, km+1 - 1
      xyr_VSigma(:,:,k) =  &
        & r_Sigma(k) * ( xyz_lnPsAdvSum(:,:,1) + xyz_DivSum(:,:,1) ) &
        & - ( xyz_lnPsAdvSum(:,:,k) + xyz_DivSum(:,:,k) )

    ! - [k-1/2]  ( [1K]() )
    ! - [kK] () 

      xyr_VSigmaNonG(:,:,k) =  &
        & r_Sigma(k) * xyz_lnPsAdvSum(:,:,1) - xyz_lnPsAdvSum(:,:,k)
    enddo

    ! ® (1/2, K+1/2)
    xyr_VSigma(:,:,1) = 0.0
    xyr_VSigma(:,:,km+1) = 0.0
    xyr_VSigmaNonG(:,:,1) = 0.0
    xyr_VSigmaNonG(:,:,km+1) = 0.0

    call io_gt4_out_Put('xyr_VSigma', xyr_VSigma)
    call io_gt4_out_Put('xyr_VSigmaNonG', xyr_VSigmaNonG)
!--
!!$    call DataDump('xyr_VSigma', xyr_VSigma, strlen=80)
!++

    !-------------------------------------------------------------------
    !   ١٤δܾ줫Τ  (ʹߤ գգ֡ȤʤɤƤ)
    !-------------------------------------------------------------------
    do k = 1, km
      xyz_TempVir(:,:,k)   = &
        & xyz_TempN(:,:,k) * ( 1.0 + (EpsVT * xyz_QVapN(:,:,k)) )

      xyz_TempEdd(:,:,k)   = xyz_TempN(:,:,k) - z_TempAvrXY(k)
      xyz_TempVirEdd(:,:,k) = xyz_TempVir(:,:,k) - z_TempAvrXY(k)
    enddo

!--
!!$    call DataDump('xyz_Temp', xyz_Temp, strlen=80)
!!$    call DataDump('xyz_TempEdd', xyz_TempEdd, strlen=80)
!!$    call DataDump('xyz_TempVir', xyz_TempVir, strlen=80)
!!$    call DataDump('xyz_TempVirEdd', xyz_TempVirEdd, strlen=75)
!++

    !-------------------------------------------------------------------
    !   Ⱦ٥β٤ξ  (ʹߤ գգ֡ȤʤɤƤ)
    !-------------------------------------------------------------------

    do k = 2, km+1 - 1
      xyr_TempEdd(:,:,k) = &
        &   z_TempInpolA(k)   * xyz_TempN(:,:,k)   &
        & + z_TempInpolB(k-1) * xyz_TempN(:,:,k-1) &
        & - r_TempAvrXY(k)
    enddo

    call io_gt4_out_Put('xyr_TempEdd', xyr_TempEdd)
!--
!!$    call DataDump('xyr_TempEdd', xyr_TempEdd, strlen=80)
!++

    !-------------------------------------------------------------------
    !   գ֦ơܦҰή֣զơܦҰή (٤ȯμ)
    !    AGCM5 Υޥ˥奢 գ ȰۤʤꡢUVFact = cosդ
    !      ݤäƤʤΤա
    !-------------------------------------------------------------------

    do k = 1, km
       ! ( + ) 
       ! - (p  (1/) 'v (d/d) ) / cos

      xyz_UAN(:,:,k) = &
        & ( xyz_VorN(:,:,k) + xy_Coli ) * xyz_VelLatN(:,:,k) &
        & - Cp * z_TempInpolKappa(k) &
        &           * xyz_TempVirEdd(:,:,k) * xy_GradLonlnPsN / R0

       ! - ( + ) 
       ! - (p  (1/) 'v (d/d) ) / cos

      xyz_VAN(:,:,k) = &
        & - ( xyz_VorN(:,:,k) + xy_Coli ) * xyz_VelLonN(:,:,k) &
        & - Cp * z_TempInpolKappa(k) &
        &           * xyz_TempVirEdd(:,:,k) * xy_GradLatlnPsN / R0
    enddo

!--
!!$    do k = 1, km
!!$       call DataDump('xyz_Div(pi)', &
!!$            & xy_w( &
!!$            & w_Div_xy_xy( &
!!$            & - Cp * z_TempInpolKappa(k) &
!!$            &           * xyz_TempVirEdd(:,:,k)  &
!!$            &             * xy_GradLon_w(  w_xy( xy_lnPs )  ) &
!!$            &                / R0 &
!!$            & , &
!!$            &
!!$            & - Cp * z_TempInpolKappa(k) &
!!$            &           * xyz_TempVirEdd(:,:,k) &
!!$            &             * xy_GradLat_w(  w_xy( xy_lnPs )  ) &
!!$            &               / R0 &
!!$            &
!!$            &     )  &
!!$            &    ) / R0 &
!!$            &
!!$            & , strlen=80, multi=(/k/))
!!$    enddo
!++

!--
!!$    call DataDump('xyz_VelLon', xyz_VelLon, strlen=80)
!!$    call DataDump('xyz_VelLat', xyz_VelLat, strlen=80)
!!$    call DataDump('xyz_VAN', xyz_VAN(1,1,:), strlen=80, multi=(/-1/))
!!$    call DataDump('xyz_UAN', xyz_UAN(1,1,:), strlen=80, multi=(/-1/))
!!$    call DataDump('xyz_VAN', xyz_VAN(1,1,:), strlen=80, multi=(/-1/))
!++

    do k = 2, km

      ! - (1/2[k]) * (d/dt)[k-1/2] * ([k-1] - [k])

      xyz_UAN(:,:,k) = xyz_UAN(:,:,k) &
        & - 1.0 / (2.0 * z_DelSigma(k)) &
        &    * xyr_VSigma(:,:,k) * ( xyz_VelLonN(:,:,k-1) - xyz_VelLonN(:,:,k) )

      ! - (1/2[k]) * (d/dt)[k-1/2] * ([k-1] - [k])

      xyz_VAN(:,:,k) = xyz_VAN(:,:,k) &
        & - 1.0 / (2.0 * z_DelSigma(k)) &
        &    * xyr_VSigma(:,:,k) * ( xyz_VelLatN(:,:,k-1) - xyz_VelLatN(:,:,k) )
    enddo

!--
!!$    call DataDump('xyz_UAN', xyz_UAN(1,1,:), strlen=80, multi=(/-2/))
!!$    call DataDump('xyz_VAN', xyz_VAN(1,1,:), strlen=80, multi=(/-2/))
!++

    do k = 1, km - 1

      ! - (1/2[k]) * (d/dt)[k+1/2] * ([k] - [k+1])

      xyz_UAN(:,:,k) = xyz_UAN(:,:,k) &
        & - 1.0 / (2.0 * z_DelSigma(k)) &
        &    * xyr_VSigma(:,:,k+1) * ( xyz_VelLonN(:,:,k) - xyz_VelLonN(:,:,k+1) )

      ! - (1/2[k]) * (d/dt)[k+1/2] * ([k] - [k+1])

      xyz_VAN(:,:,k) = xyz_VAN(:,:,k) &
        & - 1.0 / (2.0 * z_DelSigma(k)) &
        &    * xyr_VSigma(:,:,k+1) * ( xyz_VelLatN(:,:,k) - xyz_VelLatN(:,:,k+1) )
    enddo

!--
!!$    call DataDump('xyz_UAN', xyz_UAN(1,1,:), strlen=80, multi=(/-3/))
!!$    call DataDump('xyz_VAN', xyz_VAN(1,1,:), strlen=80, multi=(/-3/))
!++

!--
!!$    call DataDump('xyz_UAN', xyz_UAN, strlen=80)
!!$    call DataDump('xyz_VAN', xyz_VAN, strlen=80)
!++

    call io_gt4_out_Put('xyz_UAN', xyz_UAN)
    call io_gt4_out_Put('xyz_VAN', xyz_VAN)

    !-------------------------------------------------------------------
    !    Vor η׻
    !-------------------------------------------------------------------

    ! d/dt η׻

    wz_DVorDtN = wa_Div_xya_xya( xyz_VAN, - xyz_UAN ) / R0
         !& + w_DiffV(k) * wa_xya(xyz_Vor(:,:,k))
         !  ȻƳФʤΤǸ

    !----- A = B + 2t * T-----
    wz_VorA = wa_xya( xyz_VorB ) + 2.0d0*DelTime * ( wz_DVorDtN )
!!!         & + 2.0d0*DelTime * wa_NumVis_wa(  wa_xya( xyz_VorB )  )


    !----- xyz_VorA -----
    xyz_VorA = xya_wa( wz_VorA )

!--
!!$    call DataDump('wz_DVorDtN', wz_DVorDtN, strlen=70)
!!$    call DataDump('xyz_VorB', xyz_VorB, strlen=80)
!!$    call DataDump('xyz_Vor', xyz_Vor, strlen=80)
!!$    call DataDump('xyz_Vor_T', xya_wa(wz_DVorDtN), strlen=80)
!!$    call DataDump('xyz_VorA', xyz_VorA, strlen=80)
!++

    !-------------------------------------------------------------------
    !   =**2+**2 +  ( (v-) )  (ȯμ)
    !-------------------------------------------------------------------

    !  ( (v-) ) η׻ʻѤ߾夲

    ! 
    xyz_KE = 0.0

    xyz_KE(:,:,1) = Cp * z_HydroAlpha(1) &
      & * ( xyz_TempVir(:,:,1) - xyz_TempN(:,:,1) )

    do k = 2, km
      xyz_KE(:,:,k) = xyz_KE(:,:,k-1)   &
        & + Cp * z_HydroAlpha(k) &
        &     * ( xyz_TempVir(:,:,k) - xyz_TempN(:,:,k) ) &
        & + Cp * z_HydroBeta(k-1) &
        &     * ( xyz_TempVir(:,:,k-1) - xyz_TempN(:,:,k-1) )
    enddo

!--
!!$    call DataDump('xyz_Temp', xyz_Temp, strlen=80)
!!$    call DataDump('xyz_TempVir', xyz_TempVir, strlen=80)
!!$    call DataDump('xyz_KE-w(Tv-T)', xyz_KE, strlen=80)
!++

    ! ưͥ륮 **2+**2 βû

    xyz_KE = xyz_KE + ( xyz_VelLonN**2 + xyz_VelLatN**2 ) / 2.0

!--
!!$    call DataDump('xyz_KE-u**2+v**2', xyz_KE, strlen=80)
!++
    call io_gt4_out_Put('xyz_KE', xyz_KE)

    !-------------------------------------------------------------------
    !   ȯ Div η׻ȯ
    !-------------------------------------------------------------------

    ! ף = p  [k] + p  [k-1] 򥹥ڥȥ֤Ѥ߾夲

    ! 
    wz_PresTendTemp = 0.0

    wz_TempN = wa_xya(xyz_TempN)

    wz_PresTendTemp(:,1) = Cp * z_HydroAlpha(1) * wz_TempN(:,1)

    do k = 2, km
      wz_PresTendTemp(:,k) = wz_PresTendTemp(:,k-1) &
        & + Cp * z_HydroAlpha(k)  * wz_TempN(:,k)   &
        & + Cp * z_HydroBeta(k-1) * wz_TempN(:,k-1)
    enddo

!--
!!$    call io_gt4_out_Put('xyz_PresTendTemp', xya_wa(wa_Lapla_wa(wz_PresTendTemp))/R0**2)
!++


!--
!!$    call DataDump('wz_PresTendTemp', wz_PresTendTemp, strlen=70)
!!$    call DataDump('xyz_Lapla(wz_PresTendTemp)/R0**2', &
!!$         & xya_wa(  wa_Lapla_wa( wz_PresTendTemp )  )/R0**2, strlen=60)
!++


    ! Ǧ = (p  ) 
    do k = 1, km
      wz_PresTendPs(:,k) = &
        & Cp * z_TempInpolKappa(k) * z_TempAvrXY(k) * w_xy(  log( xy_PsN )  )
    enddo

!--
!!$    call io_gt4_out_Put('xyz_PresTendPs', xya_wa(wa_Lapla_wa(wz_PresTendPs))/R0**2)
!++

!--
!!$    call DataDump('wz_PresTendPs', wz_PresTendPs, strlen=70)
!!$    call DataDump('xyz_Lapla(wz_PresTendPs)/R0**2', &
!!$         & xya_wa(  wa_Lapla_wa( wz_PresTendPs )  )/R0**2, strlen=60)
!++

!--
!!$    call DataDump('Div(wz_UAN - wz_VAN)', &
!!$         & wa_Div_xya_xya( xyz_UAN, - xyz_VAN ), &
!!$         & strlen=70)
!!$    call DataDump('Div(wz_UAN - wz_VAN)/R0', &
!!$         & wa_Div_xya_xya( xyz_UAN, - xyz_VAN ) /R0, &
!!$         & strlen=70)
!!$    call DataDump('xyz_Div(wz_UAN - wz_VAN)/R0', &
!!$         & xya_wa(  wa_Div_xya_xya( xyz_UAN, - xyz_VAN )  ) /R0, &
!!$         & strlen=70)
!!$    call DataDump('Lapla(wz_KE)', &
!!$         & wa_Lapla_wa( wa_xya(xyz_KE) ), strlen=70)
!++

    ! d/dt η׻
    !  - **2 ( + ף + Ǧ)

    wz_DDivDtN = &
      & wa_Div_xya_xya( xyz_UAN, xyz_VAN ) / R0 &
      & - wa_Lapla_wa( wa_xya(xyz_KE) ) / R0**2 &
      !
      !& + w_DiffV(k) * wa_xya(xyz_Div(:,:,k)) !, Ȼθ̤
                                               !dynamics_diffusion ͿƤ.
      ! semi-implicitȤˤ̵ã
      & - wa_Lapla_wa( &
      !&    w_xy( xy_Phi )  &  ! ɽݥƥ󥷥릵ϸ
      &    wz_PresTendTemp   & ! ף
      &    + wz_PresTendPs   & ! Ǧ = (p  )
      &   ) / R0**2

    !----- A = B + 2t * T-----
    wz_DivA = wa_xya( xyz_DivB ) + 2.0d0*DelTime * ( wz_DDivDtN )
!!!         & + 2.0d0*DelTime * wa_NumVis_wa(  wa_xya( xyz_DivB )  )

    !----- xyz_DivA -----
    xyz_DivA = xya_wa( wz_DivA )

!--
!!$    call DataDump('xyz_DivB', xyz_DivB, strlen=80)
!!$    call DataDump('xyz_Div', xyz_Div, strlen=80)
!!$    call DataDump('xyz_Div_T', xya_wa(wz_DDivDtN), strlen=80)
!!$    call DataDump('xyz_DivA', xyz_DivA, strlen=80)
!++


    !-------------------------------------------------------------------
    !   ȡʿȯ ' + Ұή + Ѳθ  (Ǯϳؤμ)
    !-------------------------------------------------------------------

    ! ٤ζɽѲ   η׻

    ! ' 
    ! ʣv ()  : Фΰήθ
    ! - (/) {v [kK] () + v' [kK] (Ħ)}

    do k = 1, km
      xyz_DTempLocalDtN(:,:,k) = &
        
        & xyz_TempEdd(:,:,k) * xyz_DivN(:,:,k) &
        
        & + z_TempInpolKappa(k) * xyz_TempVir(:,:,k)  &
        &    * xyz_lnPsAdv(:,:,k)                   &
        
        & - z_HydroAlpha(k) / z_DelSigma(k)                 &
        &    * (                                            &
        &       xyz_TempVir(:,:,k) * xyz_lnPsAdvSum(:,:,k)  &
        &       + xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k) &
        &      )
    enddo

    ! - (d/dt) * (/) * ('[k-1/2]  '[k])
    ! - (d/dt)^NG * (/) * (ԡ[k-1/2]  ԡ[k])

    do k = 2, km
      xyz_DTempLocalDtN(:,:,k) = xyz_DTempLocalDtN(:,:,k) &
        
        & - xyr_VSigma(:,:,k) / z_DelSigma(k)               &
        &     * ( xyr_TempEdd(:,:,k) - xyz_TempEdd(:,:,k) ) &
        
        & - xyr_VSigmaNonG(:,:,k) / z_DelSigma(k)           &
        &     * ( r_TempAvrXY(k) - z_TempAvrXY(k) )
    enddo

    ! - (d/dt) * (/) * ('[k]  '[k+1/2])
    ! - (d/dt)^NG * (/) * (ԡ[k]  ԡ[k+1/2])
    ! - (/) {   v  [k+1K] ()
    !               + v' [k+1K] (Ħ)}

    do k = 1, km - 1
      xyz_DTempLocalDtN(:,:,k) = xyz_DTempLocalDtN(:,:,k) &
        
        & - xyr_VSigma(:,:,k+1) / z_DelSigma(k)               &
        &     * ( xyz_TempEdd(:,:,k) - xyr_TempEdd(:,:,k+1) ) &
        
        & - xyr_VSigmaNonG(:,:,k+1) / z_DelSigma(k)           &
        &     * ( z_TempAvrXY(k) - r_TempAvrXY(k+1) )             &
        
        & - z_HydroBeta(k) / z_DelSigma(k)                        &
        &    * (                                                  &
        &       xyz_TempVir(:,:,k) * xyz_lnPsAdvSum(:,:,k+1)      &
        &       + xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k+1)     &
        &      )
    enddo

!--
!!$    call io_gt4_out_Put('xyz_DTempLocalDtN_lnPsAdvSum',             &
!!$            & - z_HydroAlpha(2) / z_DelSigma(2)                   &
!!$            &    * (                                              &
!!$            &       xyz_TempVir(:,:,2) * xyz_lnPsAdvSum(:,:,2)    &
!!$            &      )                                              &
!!$            & - z_HydroBeta(2) / z_DelSigma(2)                    &
!!$            &    * (                                              &
!!$            &       xyz_TempVir(:,:,2) * xyz_lnPsAdvSum(:,:,2+1)  &
!!$            &      )                                              &
!!$            & )
!++


!--
!!$    call DataDump('xyz_DivSum*TempVirEdd*(Alpha+Beta)', &
!!$            & - z_HydroAlpha(k) / z_DelSigma(k)                    &
!!$            &    * ( xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k) )   &
!!$            & - z_HydroBeta(k) / z_DelSigma(k)                     &
!!$            &    * ( xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k+1) ) &
!!$            & , strlen=70)
!++

!--
!!$    call DataDump('xyz_DTempLocalDtN', xyz_DTempLocalDtN, strlen=80)
!++
    call io_gt4_out_Put('xyz_DTempLocalDtN',  xyz_DTempLocalDtN)


!--
    !-------------------------------------------------------------------
    !   գ' ֣'   (Ǯϳؤμ)
    !-------------------------------------------------------------------
!!$      DO 5100 K = 1, KMAX
!!$         DO 5100 IJ = 1, IDIM*JDIM
!!$            GTUT( IJ,K ) =  GAU ( IJ,K ) * GATED ( IJ,K )
!!$     &                                   * UVFACT ( IJ )
!!$            GTVT( IJ,K ) =  GAV ( IJ,K ) * GATED ( IJ,K )
!!$     &                                   * UVFACT ( IJ )
!!$ 5100 CONTINUE
!++

    !-------------------------------------------------------------------
    !     η׻Ǯϳؤμ
    !-------------------------------------------------------------------

    ! ȹʬ () ʬ˴ؤ벹Ѳ׻
    !
    ! dգ'/d + d֣'/d
    ! ٤ζɽѲ 

    do k = 1, km
      wz_DTempDtN(:,k) = &

        & - w_Div_xy_xy( &
        &               xyz_VelLonN(:,:,k) * xyz_TempEdd(:,:,k), &
        &               xyz_VelLatN(:,:,k) * xyz_TempEdd(:,:,k)  &
        &              ) / R0                                 &

        & + w_xy( xyz_DTempLocalDtN(:,:,k) )
      !&
      ! ǮǮ  ޤäƤʤ
      !&
      ! ໤ǮǮȻϸ
    enddo

!--
!!$    call DataDump('xyz_Temp_T_NonGrav', xya_wa(wz_DTempDtN), strlen=70)
!++


    ! ȹʬ () ʬ˴ؤ벹Ѳ׻
    !
    !  (ȹʬˤѲθ)

    do k = 1, km
      do kk = 1, km
        wz_DTempDtN(:,k) = wz_DTempDtN(:,k) &

          & - zz_siMtxH(k,kk) * w_xy( xyz_DivN(:,:,kk) )
        !&
        ! Ȼϸ
       enddo
    enddo


    !----- A = B + 2t * T-----
    wz_TempA = wa_xya( xyz_TempB ) + 2.0d0*DelTime * ( wz_DTempDtN )
!!!         & + 2.0d0*DelTime * wa_NumVisScaler_wa(  wa_xya( xyz_TempB )  )

    !----- xyz_TempA -----
    xyz_TempA = xya_wa( wz_TempA )


    call io_gt4_out_Put(  'xyz_Temp_T', xya_wa( wz_DTempDtN )  )
!--
!!$    call DataDump('xyz_TempB', xyz_TempB, strlen=80)
!!$    call DataDump('xyz_Temp', xyz_Temp, strlen=80)
!!$    call DataDump('xyz_Temp_T', xya_wa(wz_DTempDtN), strlen=80)
!!$    call DataDump('xyz_TempA', xyz_TempA, strlen=80)
!++

    !-------------------------------------------------------------------
    !   漾 QVap η׻μ򤯡
    !-------------------------------------------------------------------

    ! ҡġܦҰή (ȹ) ʻǷ׻
    xyz_QVapDivVSigmaAdv = xyz_QVapN * xyz_DivN

    do k = 2, km
      xyz_QVapDivVSigmaAdv(:,:,k) = xyz_QVapDivVSigmaAdv(:,:,k) &
        & - xyr_VSigma(:,:,k) / ( 2.0 * z_DelSigma(k) )  &
        &      * ( xyz_QVapN(:,:,k-1)  - xyz_QVapN(:,:,k) )
    enddo

    do k = 1, km - 1
      xyz_QVapDivVSigmaAdv(:,:,k) = xyz_QVapDivVSigmaAdv(:,:,k)  &
        & - xyr_VSigma(:,:,k+1) / ( 2.0 * z_DelSigma(k) ) &
        &      * ( xyz_QVapN(:,:,k) - xyz_QVapN(:,:,k+1) )
    enddo

    ! ʿή dգ/d + d֣/d ȿʿȻࡢ׻
    ! dգ/d + d֣/d
    ! ҡġܦҰή

    do k = 1, km
      wz_DQVapDtN(:,k) = &

        & - w_Div_xy_xy( &
        &               xyz_VelLonN(:,:,k) * xyz_QVapN(:,:,k), &
        &               xyz_VelLatN(:,:,k) * xyz_QVapN(:,:,k)  &
        &              ) / R0                              &

        & + w_xy( xyz_QVapDivVSigmaAdv(:,:,k) )
        !&
        ! ʿȻࡢϸ
    enddo

    !----- A = B + 2t * T-----
    wz_QVapA = wa_xya( xyz_QVapB ) + 2.0d0*DelTime * ( wz_DQVapDtN )
!!!         & + 2.0d0*DelTime * wa_NumVisScaler_wa(  wa_xya( xyz_QVapB )  )

    !----- xyz_QVapA -----
    xyz_QVapA = xya_wa( wz_QVapA )

!--
!!$    call DataDump('xyz_QVapB', xyz_QVapB, strlen=80)
!!$    call DataDump('xyz_QVap', xyz_QVap, strlen=80)
!!$    call DataDump('xyz_QVap_T', xya_wa(wz_DQVapDtN), strlen=80)
!!$    call DataDump('xyz_QVapA', xyz_QVapA, strlen=80)
!++

    call EndSub(subname)
  end subroutine dynamics_leapfrog

  subroutine dynamics_diffusion( &
    & xyz_VorB , xyz_DivB , xyz_TempB , xyz_QVapB  , &
    & xyz_VorA , xyz_DivA , xyz_TempA , xyz_QVapA        )

    ! Calculate Diffusion Term
    !
    ! t-t ͤʿȻᡢ t+t ͤ˲ä롣
    !
    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use time_mod,    only: DelTime, CurrentTime
    use grid_3d_mod, only: km
    use grid_wavenumber_mod, only: nm
    use spml_mod,    only: wa_xya, xya_wa, l_nm
    use io_gt4_out_mod,only: io_gt4_out_Put
    use dc_trace,    only: DbgMessage, BeginSub, EndSub, DataDump
    implicit none

    real(DBKIND), intent(in) :: xyz_VorB(:,:,:)   !  (t-t)
    real(DBKIND), intent(in) :: xyz_DivB(:,:,:)   ! ȯ (t-t)
    real(DBKIND), intent(in) :: xyz_TempB(:,:,:)  !  (t-t)
    real(DBKIND), intent(in) :: xyz_QVapB(:,:,:)  ! 漾 (t-t)

    real(DBKIND), intent(inout) :: xyz_VorA(:,:,:)   !  (t+t)
    real(DBKIND), intent(inout) :: xyz_DivA(:,:,:)   ! ȯ (t+t)
    real(DBKIND), intent(inout) :: xyz_TempA(:,:,:)  !  (t+t)
    real(DBKIND), intent(inout) :: xyz_QVapA(:,:,:)  ! 漾 (t+t)

    real(DBKIND)    :: wz_VorA((nm+1)**2, km)   !  (t+t)
    real(DBKIND)    :: wz_DivA((nm+1)**2, km)   ! ȯ (t+t)
    real(DBKIND)    :: wz_TempA((nm+1)**2, km)  !  (t+t)
    real(DBKIND)    :: wz_QVapA((nm+1)**2, km)  ! 漾 (t+t)
    integer(INTKIND) :: i
    character(STRING),  parameter:: subname = "dynamics_diffusion"
  continue
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname, version)
    if (.not. dynamics_initialized) then
      call EndSub( subname, 'Call dynamics_init before call %c',  &
        &       c1=trim(subname) )
      return
    endif

    !-------------------------------------------------------------------
    !   줾̤γȻ׻
    !-------------------------------------------------------------------
    xyz_VorA = &
      & xya_wa( wa_xya(xyz_VorA) &
      &         + 2.0d0*DelTime * wz_DiffVorDiv * wa_xya( xyz_VorB ) )

!--
!!$    call io_gt4_out_Put('xyz_Vor_Diffusion', &
!!$         & xya_wa(   2.0d0*DelTime                     &
!!$         &             * wz_DiffVorDiv * wa_xya( xyz_VorB )  )    )
!++

    xyz_DivA = &
      & xya_wa( wa_xya(xyz_DivA) &
      &         + 2.0d0*DelTime * wz_DiffVorDiv * wa_xya( xyz_DivB ) )

!--
!!$    call io_gt4_out_Put('xyz_Div_Diffusion', &
!!$         & xya_wa(   2.0d0*DelTime                     &
!!$         &             * wz_DiffVorDiv * wa_xya( xyz_DivB )   )    )
!++

    xyz_TempA = &
      & xya_wa( wa_xya(xyz_TempA) &
      &         + 2.0d0*DelTime * wz_DiffTherm * wa_xya( xyz_TempB ) )

!--
!!$    call io_gt4_out_Put('xyz_Temp_Diffusion', &
!!$         & xya_wa(   2.0d0*DelTime                     &
!!$         &             * wz_DiffTherm * wa_xya( xyz_TempB )   )    )
!++

    xyz_QVapA  = &
      & xya_wa( wa_xya(xyz_QVapA) &
      &         + 2.0d0*DelTime * wz_DiffTherm * wa_xya( xyz_QVapB ) )

!--
!!$    call io_gt4_out_Put('xyz_QVap_Diffusion', &
!!$         & xya_wa(   2.0d0*DelTime                     &
!!$         &             * wz_DiffTherm * wa_xya( xyz_QVapB )   )   )
!++


    ! ڥȥǡȤƸƳȻƤ뤫ǧ뤿
    ! ǡϤ򵭽Ҥܷ׻ˤϤޤäɬפǤʤ
    !!wz_VorA  = wa_xya(xyz_VorA )
    !!wz_DivA  = wa_xya(xyz_DivA )
    !!wz_TempA = wa_xya(xyz_TempA)
    !!wz_QVapA = wa_xya(xyz_QVapA)
    !!
    !!write(80, *) CurrentTime, &
    !!     &       wz_VorA( lNm(21,0), 1) , wz_DivA( lNm(21,0), 1) , &
    !!     &       wz_TempA( lNm(21,0), 1) , wz_QVapA( lNm(21,0), 1)
    !!call flush(80)

    call EndSub(subname)
  end subroutine dynamics_diffusion


  subroutine dynamics_diagnostic &
    & ( x_Lon      , y_Lat      , z_Sigma  , r_Sigma  , &         !(in)

    &   xyz_VelLonA, xyz_VelLatA, &                               !(out)
    &   xyz_VorA   , xyz_DivA   , xyz_TempA, xyz_QVapA, xy_PsA  ) !(in)
    !
    ! Calculate Diagnostic Values.
    !
    ! Ṳ̄α黻Ԥʤ
    ! ߤϱȯ®ʬ () α黻ԤʤΤߤǤ롣
    !

    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use grid_3d_mod,         only: im, jm, km
    use grid_wavenumber_mod, only: nm
    use constants_mod, only: R0, Grav
    use spml_mod,    only: wa_xya, xya_GradLon_wa, xya_GradLat_wa, &
      &                    wa_LaplaInv_wa, IntLonLat_xy
    use io_gt4_out_mod,only: io_gt4_out_Put
    use dc_trace,    only: DbgMessage, BeginSub, EndSub, DataDump
    use dc_string,   only: toChar
    implicit none

    
    real(DBKIND), intent(in):: x_Lon(:)        ! ٺɸ
    real(DBKIND), intent(in):: y_Lat(:)        ! ٺɸ
    real(DBKIND), intent(in):: z_Sigma(:)      ! ҥ٥()ɸ
    real(DBKIND), intent(in):: r_Sigma(:)      ! ҥ٥(Ⱦ)ɸ

    real(DBKIND), intent(in):: xyz_VorA(:,:,:) !          (t+t)
    real(DBKIND), intent(in):: xyz_DivA(:,:,:) ! ȯ         (t+t)
    real(DBKIND), intent(in):: xyz_TempA(:,:,:)!          (t+t)
    real(DBKIND), intent(in):: xyz_QVapA(:,:,:)! 漾         (t+t)
    real(DBKIND), intent(in):: xy_PsA(:,:)     ! ɽ̵   (t+t)

    real(DBKIND), intent(out) :: xyz_VelLonA(:,:,:)  ! ®ٷʬ (t+t)
    real(DBKIND), intent(out) :: xyz_VelLatA(:,:,:)  ! ®ٰʬ (t+t)

    real(DBKIND) :: TotalMass      ! 

    !----- ѿ -----
    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)   :: i, j, k, l

    character(STRING),  parameter:: subname = "dynamics_diagnostic"
    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname, version)
    if (.not. dynamics_initialized) then
      call EndSub( subname, 'Call dynamics_init before call %c',  &
        &          c1=trim(subname) )
      return
    endif

    !-------------------------------------------------------------------
    !      
    !-------------------------------------------------------------------
    wz_PsiA = wa_LaplaInv_wa(  wa_xya( xyz_VorA )  ) * R0**2
    wz_ChiA = wa_LaplaInv_wa(  wa_xya( xyz_DivA )  ) * R0**2

    xyz_VelLonA = &
      & ( xya_GradLon_wa( wz_ChiA ) - xya_GradLat_wa( wz_PsiA )  ) / R0

    xyz_VelLatA = &
      & ( xya_GradLon_wa( wz_PsiA ) + xya_GradLat_wa( wz_ChiA )  ) / R0

!--
!!$    call DataDump('xyz_VelLonA', xyz_VelLonA, strlen=80)
!!$    call DataDump('xyz_VelLatA', xyz_VelLatA, strlen=80)
!++

    !-------------------------------------------------------------------
    !   xy_Ps ̤롣
    !-------------------------------------------------------------------
    TotalMass = IntLonLat_xy( xy_PsA / Grav )

    call io_gt4_out_Put('TotalMass', TotalMass)

    call EndSub(subname)
  end subroutine dynamics_diagnostic


  subroutine dynamics_end
    !
    ! Terminate module
    !
    ! dynamics_init  allocate ѿ deallocate 
    ! 黻ͤ˴롣
    !

    use type_mod,    only: STRING, REKIND, DBKIND, INTKIND
    use dc_trace,    only: BeginSub, EndSub, DbgMessage
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    character(STRING),  parameter:: subname = "dynamics_end"

  continue

    !-----------------------------------------------------------------
    !   Check Initialization
    !-----------------------------------------------------------------
    call BeginSub(subname, version)
    if ( .not. dynamics_initialized) then
      call EndSub( subname, 'dynamics_init was not called', &
        &       c1=trim(subname) )
      return
    else
      dynamics_initialized = .false.
    endif

    !-----------------------------------------------------------------
    !   allocate ѿ nullify Ȥ
    !-----------------------------------------------------------------
    deallocate( xy_Coli       , &
      &      xy_UVFact        , &
      &      z_DelSigma       , &
      &      wz_DiffVorDiv    , &
      &      wz_DiffTherm     , &
      &      z_HydroAlpha     , &
      &      z_HydroBeta      , &
      &      z_TempInpolA     , &
      &      z_TempInpolB     , &
      &      z_TempInpolKappa , &
      &      z_TempAvrXY      , &
      &      r_TempAvrXY      , &
      &      z_siMtxG        , &
      &      zz_siMtxGCt     , &
      &      zz_siMtxW       , &
      &      zz_siMtxWH      , &
      &      zz_siMtxH       , &
      &      zz_siMtxQ      , &
      &      zz_siMtxS      , &
      &      zz_siMtxQS     , &
      &      zz_siMtxR      )


    deallocate  & 
      & ( xy_lnPs       , & ! С ln s           (t)
      &   xyz_lnPsAdv   , & !  ΰή 
      &   xyz_lnPsAdvSum, & ! аήѲ [kK]()
      &   xyz_DivSum    , & ! ȯѲ [kK] Ħ

      &   xy_DlnPsDtN     , & ! ФλѲ d/dt   (t)
      &   w_DlnPsDtN      , & ! ФλѲ (ڥȥ) (t)
      &   w_lnPsA      , & !  (t+t)

      &   xyr_VSigma     , & ! ľ®(Ⱦ٥) (t)
      &   xyr_VSigmaNonG , & ! ľ® ʬ (Ⱦ٥) (t)

      &   xyz_TempEdd    , &! ' ٤ξ (٥) (t)
      &   xyz_TempVir    , &! v  (virtual temperature)(t)
      &   xyz_TempVirEdd , &! v'٤ξ               (t)
      &   xyr_TempEdd, &! ' ٤ξ (Ⱦ٥)   (t)

      &   xyz_UAN      , & ! ưѲգ
      &   xyz_VAN      , & ! ̱ưѲ֣

      &   wz_DVorDtN      , & ! ѲΥڥȥǡ (t) 
      &   wz_VorA      , & ! ٤Υڥȥǡ    (t+t)

      &   xyz_KE        , & ! ưͥ륮 + 
                          ! **2+**2    + (v-)

      &   wz_DDivDtN        , & ! ȯΥڥȥǡ (t)
      &   wz_DivA        , & ! ȯΥڥȥǡ (t+t)
      &   wz_PresTendTemp , & ! ٤ˤ밵Ϸ٤Υڥȥǡ
      &   wz_PresTendPs   , & ! ɽϤˤ밵Ϸ٤Υڥȥǡ

      &   xyz_DTempLocalDtN , & ! ٤ζɽѲ  
                              ! (ʿȯ ' + Ұή
                              !  + Ѳθ) (ȹ)

      &   wz_DTempDtN       , & ! ٤Ѳڥȥǡ (t)
      &   wz_TempA       , & ! ٤Υڥȥǡ   (t+t)

      &   xyz_QVapDivVSigmaAdv, & ! ҡġܦҰή
      &   wz_DQVapDtN           , & ! 漾Ѳڥȥǡ (t)
      &   wz_QVapA             & ! 漾Υڥȥǡ   (t+t)
      & )

    deallocate  &
      & ( wz_PsiA , & ! ڥȥ(ήؿ)
      &   wz_ChiA   & ! ڥȥ(ݥƥ󥷥)
      & )

    call EndSub(subname)
  end subroutine dynamics_end


!--
!!  !=== Function wa_NumVis_wa : Ǵη׻
!!  !
!!  !Ǵ׻ؿǤ롣
!!  !
!!  function wa_NumVis_wa(wa_data)
!!  !==== Dependency
!!    use type_mod           , only: STRING, REKIND, DBKIND, INTKIND
!!    use constants_mod      , only: R0, VisOrder, EFoldTime
!!    use grid_3d_mod        , only: km
!!    use grid_wavenumber_mod, only: nm
!!    use dc_trace           , only: BeginSub, EndSub, DbgMessage, DataDump
!!    implicit none
!!    !==== Input
!!    !
!!    real(DBKIND), intent(in) :: wa_data((nm+1)*(nm+1), km)
!!    !
!!    !==== Output
!!    !
!!    real(DBKIND)             :: wa_NumVis_wa((nm+1)*(nm+1), km)
!!
!!    real(DBKIND)      :: VisCoef   ! ĶǴ
!!    character(STRING),  parameter:: subname = "wa_NumVis_wa"
!!  continue
!!    call BeginSub(subname)
!!
!!    VisCoef = (   real(  ( nm*(nm+1) ), DBKIND  )  &
!!         &          / R0**2   )**(-VisOrder/2) &
!!         &     / EFoldTime
!!
!!!!$    call DbgMessage('VisCoef=<%f>', d=(/VisCoef/))
!!
!!    wa_NumVis_wa = &
!!         & wa_NumVisScaler_wa(wa_data)  &
!!         &   - VisCoef                  &
!!         &      * (  - (2.0d0/R0**2)**(VisOrder/2)  ) * wa_data
!!
!!!!$    call DbgMessage('-VisCoef*(2/R0**2)**(VisOrder/2)=<%f>', &
!!!!$         & d=(/ - VisCoef * (  - (2.0d0/R0**2)**(VisOrder/2)  ) /)   )
!!
!!
!!!!!$  hdc    = ( dble( (hdmaxn*(hdmaxn+1) ) ) / pradisq )**(-hdord/2) &
!!!!!$       / hdts
!!!!!$
!!!!!$  hdord   : ʿȻμʥʥ֥ hdord 衢ץ饷 hdord/2 
!!!!!$  hdmaxn  : Ǥڤȿ T21 ʤ 21T42 ʤ 42... 
!!!!!$  pradisq : Ⱦ¤ [m2]
!!!!!$  hdts    : ȿ hdmaxn ˤ븺λ [s]
!!
!!    call EndSub(subname)
!!  end function wa_NumVis_wa
!!
!!  !=== Function wa_NumVisScaler_wa : 顼ФǴη׻
!!  !
!!  !顼ФǴ׻ؿǤ롣
!!  !
!!  function wa_NumVisScaler_wa(wa_data)
!!    !==== Dependency
!!    use type_mod           , only: STRING, REKIND, DBKIND, INTKIND
!!    use constants_mod      , only: R0, VisOrder, EFoldTime
!!    use grid_3d_mod        , only: km
!!    use grid_wavenumber_mod, only: nm
!!    use spml_mod           , only: rn
!!    use dc_trace           , only: BeginSub, EndSub, DbgMessage, DataDump
!!    implicit none
!!    !==== Input
!!    !
!!    real(DBKIND), intent(in) :: wa_data((nm+1)*(nm+1), km)
!!    !
!!    !==== Output
!!    !
!!    real(DBKIND)             :: wa_NumVisScaler_wa((nm+1)*(nm+1), km)
!!
!!    real(DBKIND)             :: VisCoef   ! ĶǴ
!!    real(DBKIND)             :: wa_rn((nm+1)*(nm+1), km)
!!    integer(INTKIND)         :: k
!!    character(STRING),  parameter:: subname = "wa_NumVisScaler_wa"
!!    continue
!!    call BeginSub(subname)
!!
!!    do k = 1, km
!!       wa_rn(:,k) = rn(:,1)
!!    enddo
!!
!!    VisCoef = (   real(  ( nm*(nm+1) ), DBKIND  )  &
!!         &          / R0**2   )**(-VisOrder/2) &
!!         &     / EFoldTime
!!
!!!!$    call DbgMessage('VisCoef=<%f>', d=(/VisCoef/))
!!
!!    wa_NumVisScaler_wa  =   &
!!         & - VisCoef * ( ( - wa_rn / R0**2 )**(VisOrder/2) ) * wa_data
!!
!!    call EndSub(subname)
!!  end function wa_NumVisScaler_wa
!++

end module dynamics_mod
 
