!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------

module phys_vfilter_conserve_mod
  !
  != ʪ ľե륿(¸С)⥸塼
  !
  !== 
  !
  ! ľ˥ե륿.
  ! $\sum T_{k} \Delta p_{k}$
  ! ¸褦Ԥ.
  !
  !== TODO
  ! * ե륿ˤѲ̤ϤǤ褦ˤʤȤʤ
  ! * ե륿򤫤ΰǽˤɤ⤷ʤ.
  !
  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: phys_vfilter

  logical, save :: physics_vfilter_conserve_initialized = .false.

contains

  subroutine phys_vfilter( & 
    & xyz_Temp   , & !(inout)
    & xyz_VelLon , & !(inout)
    & xyz_VelLat , & !(inout)
    & xyr_Temp   , & !(in) 
    & xyr_Press  , & !(in)
    & DelTimePhy )   !(in)
    !
    != ľե륿 3 ȥꥪ¸
    !
    !== 
    !
    ! ľΥõ뤿ľ˥ե륿
    ! .
    ! پФƥե륿򤫤뤳ȤŪǤ뤬
    ! , ˥ե륿򤫤뤳ȤƤ.
    ! ؤĴ᤹.
    !  3 ȥꥪĴᤷƤ, Ϥ 3 ˤФޤ.
    !
    !== HISTORY
    ! * 2006-12-1  M.Ishiwatari AGCM5 ϥС p2grstU.F ܿ
    !
    use type_mod,      only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod,   only: im, jm, km
    use nmlfile_mod, only: nmlfile_init, nmlfile_open, nmlfile_close
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    use dc_message, only: MessageNotify

    real(DBKIND), intent(inout) :: xyz_Temp   ( im*jm, km )   ! ٣
    real(DBKIND), intent(inout) :: xyz_VelLon   ( im*jm, km ) ! 
    real(DBKIND), intent(inout) :: xyz_VelLat   ( im*jm, km ) ! 

    real(DBKIND), intent(in) :: xyr_Press ( im*jm, km+1 ) ! 
    real(DBKIND), intent(in) :: xyr_Temp  ( im*jm, km+1 ) ! 
    real(DBKIND), intent(in) :: DelTimePhy                ! 2 t

    real(DBKIND) :: xyz_DTempDtVertFiltCons (im*jm,km) !ѲΨ(ľե륿)
    real(DBKIND) :: xyz_DVelLonDtVertFiltCons (im*jm,km) !ѲΨ(ľե륿)
    real(DBKIND) :: xyz_DVelLatDtVertFilstCons ( im*jm, km ) !ѲΨ(ľե륿)

    ! (2007-5-21 ) ѿ̾ѹ
    ! FGS -> CoeffFilterTemp
    ! FGSU -> CoeffFilterVel
    real(DBKIND) :: CoeffFilterTemp            ! ե륿 (T)
    real(DBKIND) :: CoeffFilterVel             ! Ĵ᤹ٹ(u,v)

    real(DBKIND) :: xyz_DelPress  ( im*jm, km )   !" 
    real(DBKIND) :: xyz_TempBasic    ( im*jm, km )   !" T ܾ
    real(DBKIND) :: xyz_VelLonBasic    ( im*jm, km )   !" T ܾ
    real(DBKIND) :: xyz_VelLatBasic    ( im*jm, km )   !" T ܾ
    real(DBKIND) :: xyz_TempOrg  ( im*jm, km )   !" (Ĵ)
    real(DBKIND) :: xyz_VelLonOrg  ( im*jm, km )   !" (Ĵ)
    real(DBKIND) :: xyz_VelLatOrg  ( im*jm, km )   !" (Ĵ)
    real(DBKIND) :: SumTempDelPress
    real(DBKIND) :: SumVelLonDelPress
    real(DBKIND) :: SumVelLatDelPress
    real(DBKIND) :: SumDelPress
    character(STRING),  parameter:: subname = "phys_vfilter_conserve"
    integer(INTKIND) :: ij
    integer(INTKIND) :: k

    logical                     :: nmlreadable
    integer(INTKIND)            :: nmlunit, nmlstat

    namelist /physics_vfilter_conserve_nml/ &
      & CoeffFilterTemp, &
      & CoeffFilterVel

    continue

    ! Ͻ
    call BeginSub(subname)

    ! ե륿Υѥ᡼Υǥե
    CoeffFilterTemp = 0.1d0
    CoeffFilterVel = 0.1d0

    ! read physics_vfilter_conserve_nml
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=physics_vfilter_conserve_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST physics_vfilter_conserve_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=physics_vfilter_conserve_nml)
    else
       call DbgMessage('Not Read NAMELIST physics_vfilter_conserve_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST physics_vfilter_conserve_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    ! ե׻
    do k = 1, km
      xyz_DelPress  (:,k) = xyr_Press(:,k) - xyr_Press(:,k+1)
      xyz_TempBasic (:,k) = ( xyr_Temp(:,k) + xyr_Temp(:,k+1) )/2.0d0
    enddo

    do ij = 1, im*jm
      xyz_VelLonBasic (ij,1) &
        & = ( 3.0d0 * xyz_VelLon(ij,1) + xyz_VelLon(ij,2) )/4.0d0
      xyz_VelLatBasic (ij,1) &
        & = ( 3.0d0 * xyz_VelLat(ij,1) + xyz_VelLat(ij,2) )/4.0d0
      do k = 2, km-1
        xyz_VelLonBasic (ij,k) &
          & = (   xyz_VelLon(ij,k-1) + 2.0d0 * xyz_VelLon(ij,k) &
          &     + xyz_VelLon(ij,k+1) )/4.0d0
        xyz_VelLatBasic (ij,k) &
          & = (   xyz_VelLat(ij,k-1) + 2.0 * xyz_VelLat(ij,k) &
          &     + xyz_VelLat(ij,k+1) )/4.0d0
      enddo
      xyz_VelLonBasic (ij,km) &
        & = ( xyz_VelLon(ij,km-1) + 3.0d0 * xyz_VelLon(ij,km) )/4.0d0
      xyz_VelLatBasic (ij,km) &
        & = ( xyz_VelLat(ij,km-1) + 3.0d0 * xyz_VelLat(ij,km) )/4.0d0
    enddo

    ! Ĵͤ¸
    xyz_TempOrg = xyz_Temp
    xyz_VelLonOrg = xyz_VelLon
    xyz_VelLatOrg = xyz_VelLat

    !  2. Ĵ
    xyz_DTempDtVertFiltCons = 0.0d0
    xyz_DVelLonDtVertFiltCons = 0.0d0
    xyz_DVelLatDtVertFilstCons = 0.0d0

    SumTempDelPress=0.0
    SumDelPress=0.0

    do k = 2, km-1
      do ij = 1, im*jm
        SumTempDelPress = (xyz_TempBasic(ij,k-1) - xyz_Temp(ij,k-1) ) &
          &      * xyz_DelPress(ij,k-1) &
          & + (xyz_TempBasic(ij,k) - xyz_Temp(ij,k) ) * xyz_DelPress(ij,k) &
          & + (xyz_TempBasic(ij,k+1) - xyz_Temp(ij,k+1) ) & 
          &   * xyz_DelPress(ij,k+1)
        SumVelLonDelPress = (xyz_VelLonBasic(ij,k-1) - xyz_VelLon(ij,k-1) ) &
          &   * xyz_DelPress(ij,k-1) &
          & + (xyz_VelLonBasic(ij,k) - xyz_VelLon(ij,k) ) &
          &   * xyz_DelPress(ij,k) &
          & + (xyz_VelLonBasic(ij,k+1) - xyz_VelLon(ij,k+1) ) &
          &   * xyz_DelPress(ij,k+1)
        SumVelLatDelPress = (xyz_VelLatBasic(ij,k-1) - xyz_VelLat(ij,k-1) ) &
          &   * xyz_DelPress(ij,k-1) &
          & + (xyz_VelLatBasic(ij,k) - xyz_VelLat(ij,k) ) &
          &   * xyz_DelPress(ij,k) &
          & + (xyz_VelLatBasic(ij,k+1) - xyz_VelLat(ij,k+1) ) &
          &   * xyz_DelPress(ij,k+1)
        SumDelPress =  xyz_DelPress(ij,k-1) + xyz_DelPress(ij,k) &
          & + xyz_DelPress(IJ,K+1)

        xyz_Temp(ij,k-1) = xyz_Temp(ij,k-1) &
          & + CoeffFilterTemp*(   xyz_TempBasic(ij,k-1) - xyz_Temp(ij,k-1) &
          &         - SumTempDelPress/SumDelPress )
        xyz_VelLon(ij,k-1) = xyz_VelLon(ij,k-1) &
          & + CoeffFilterVel*(   xyz_VelLonBasic(ij,k-1) - xyz_VelLon(ij,k-1) &
          &          - SumVelLonDelPress/SumDelPress )
        xyz_VelLat(ij,k-1) = xyz_VelLat(ij,k-1) &
          & + CoeffFilterVel*(   xyz_VelLatBasic(ij,k-1) - xyz_VelLat(ij,k-1) &
          &          - SumVelLatDelPress/SumDelPress )

        xyz_Temp(ij,k) = xyz_Temp(ij,k) &
          & + CoeffFilterTemp*(   xyz_TempBasic(ij,k) - xyz_Temp(ij,k) &
          &         - SumTempDelPress/SumDelPress )
        xyz_VelLon(ij,k) = xyz_VelLon(ij,k) &
          & + CoeffFilterVel*(   xyz_VelLonBasic(ij,k) - xyz_VelLon(ij,k) &
          &          - SumVelLonDelPress/SumDelPress )
        xyz_VelLat(ij,k) = xyz_VelLat(ij,k) &
          & + CoeffFilterVel*(   xyz_VelLatBasic(ij,k) - xyz_VelLat(ij,k) &
          &          - SumVelLatDelPress/SumDelPress )

        xyz_Temp(ij,k+1) = xyz_Temp(ij,k+1) &
          & + CoeffFilterTemp*(    xyz_TempBasic(ij,k+1) - xyz_Temp(ij,k+1) &
          &          - SumTempDelPress/SumDelPress )
        xyz_VelLon(ij,k+1) = xyz_VelLon(ij,k+1) &
          & + CoeffFilterVel*(   xyz_VelLonBasic(ij,k+1) - xyz_VelLon(ij,k+1) &
          &          - SumVelLonDelPress/SumDelPress )
        xyz_VelLat(ij,k+1) = xyz_VelLat(ij,k+1) &
          & + CoeffFilterVel*(   xyz_VelLatBasic(ij,k+1) - xyz_VelLat(ij,k+1) &
          &          - SumVelLatDelPress/SumDelPress )
      enddo
    enddo

    do k =1,km
      do ij = 1,im*jm
        xyz_DTempDtVertFiltCons(ij,k) = ( xyz_Temp(ij,k) - xyz_TempOrg(ij,k) )/DelTimePhy
        xyz_DVelLonDtVertFiltCons(ij,k) = ( xyz_VelLon(ij,k) - xyz_VelLonOrg(ij,k) )/DelTimePhy
        xyz_DVelLatDtVertFilstCons(ij,k) = ( xyz_VelLat(ij,k) - xyz_VelLatOrg(ij,k) )/DelTimePhy
      enddo
    enddo

    ! λ
    call EndSub(subname)

  end subroutine phys_vfilter

end module phys_vfilter_conserve_mod

