!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_cumulus_adjust.f90 
!
! History
!   2005/09/19 Yamada Yukiko     create
!

module physics_cumulus_adjust_mod

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: physics_cumulus_adjust

contains

  subroutine physics_cumulus_adjust( & 
       & xyz_Temp          , & ! (inout) 
       & xyz_Qvap          , & ! (inout) 漾
       & xy_CumulusRain    , & ! (out) ߿
       & xyz_DCumulusTempDt, & ! (out) ѲΨ
       & xyz_DCumulusQvapDt, & ! (out) 漾ѲΨ
       & xyz_Press         , & ! (in)  ()
       & xyr_Press         , & ! (in)  (Ⱦ)
       & DelTimePhy         )  ! (in) 2t

    !==== Dependency
    use type_mod,      only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod,   only: im, jm, km
    use constants_mod, only: Cp    ,& ! 絤갵Ǯ 
         &                   EL    ,& ! ζŷǮ 
         &                   EpsV  ,& ! 絤ʬ
         &                   ES0   ,& ! ˰¾У
         &                   RVap  ,& ! 
         &                   RAir  ,& ! 絤
         &                   Grav     ! ϲ®
    use physics_qvapsat_tetens, only: QvapSat
    use dc_trace,      only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Input
    !
    real(DBKIND), intent(in) ::   &
         & xyz_Press(im,jm,km)   ,& ! (in)  ()
         & xyr_Press(im,jm,km+1) ,& ! (in)  (Ⱦ)
         & DelTimePhy               ! (in) 2t

    !==== Output
    !
    real(DBKIND), intent(out) ::  &
         & xy_CumulusRain(im,jm)       ,& ! (out) ߿
         & xyz_DCumulusTempDt(im,jm,km),& ! (out) ѲΨ
         & xyz_DCumulusQvapDt(im,jm,km)   ! (out) 漾ѲΨ

    !==== In/Out
    !
    real(DBKIND), intent(inout) ::  &
         & xyz_Temp(im,jm,km)      ,& ! (inout) 
         & xyz_Qvap(im,jm,km)         ! (inout) 漾

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_cumulus_adjust"
    real(DBKIND)        ::  & 
         & xyz_Qvap_b(im,jm,km)              , & ! Ĵ漾
         & xyz_Temp_b(im,jm,km)              , & ! Ĵβ
         & xy_Adjust(im,jm)                  , & ! Ĵᤵ줿ݤ
         & xy_Adjust_b(im,jm)                , & ! Ĵᤵ줿ݤ
         & xyz_DPressDz(im,jm,km)            , & ! 
         ! xyz_DelPress ɤ (2006-10-28 )
         & xyz_QvapSat(im,jm,km)             , & ! ˰漾
         & xyz_DDPressDDPress(im,jm,km)      , & ! /
         & xyz_DPFact(im,jm,km)              , & ! ե
         & TempSat                           , & ! ˰²
         ! (2006-10-30 )  Stability ʤ???? 
         & DelTempSat                        , & ! Ĵ᤹˰²
         & DelQvap                           , & ! Ĵ᤹漾
         & DelTempUpper                      , & ! Ĵ᤹벹 (k)
         & DelTempUnder                      , & ! Ĵ᤹벹 (k-1)
         & DQvapSatDTempUpper                , & ! D(˰漾)/D() (k)
         & DQvapSatDTempUnder                , & ! D(˰漾)/D() (k-1)
         & DHDTempUpper                      , & ! D(h)/D() (k)
         & DHDTempUnder                      , & ! D(h)/D() (k-1)
         & Adjust                ! ΰˤư٤ǤĴᤵ줿ݤ

    real(DBKIND), parameter     :: CrtlRH = 0.990d0   ! ׳м
    integer(INTKIND), parameter :: IterationMax = 10 ! ƥ졼
    
    real(DBKIND) ::  TempSatMax(IterationMax)   ! ԰εƸ
    data TempSatMax  / 0.01  , 0.02  , 0.02  , 0.05  , 0.05  , &
         &             0.10  , 0.10  , 0.20  , 0.20  , 0.40  /

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i, j, k
    integer(INTKIND)    :: Iteration 

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !  ήĴ
    !----------------------------------------------------------------

    !----- Ĵ Qvap ¸ -----    
    xyz_Qvap_b  = xyz_Qvap
    xyz_Temp_b  = xyz_Temp

    !----- ѿ -----    
    xy_CumulusRain     = 0.0d0
    xyz_DCumulusTempDt = 0.0d0
    xyz_DCumulusQvapDt = 0.0d0
    
    !----- ե׻ -----    
    do k = 1, km
       xyz_DPressDz(:,:,k) = xyr_Press(:,:,k) - xyr_Press(:,:,k+1)
    end do

    ! 饦ڥμ˰漾׻
!    xyz_QvapSat = EpsV * ES0  &
!         & *  EXP( EL / RVap * ( 1./273. - 1./xyz_Temp ) ) / xyz_Press

    do i = 1, im
      do j = 1, jm
        do k = 1, km
          xyz_QvapSat(i,j,k) = QvapSat(xyz_Temp(i,j,k), xyz_Press(i,j,k))
        enddo
      enddo
    enddo

    do k = 2, km
       xyz_DDPressDDPress(:,:,k) = xyz_DPressDz(:,:,k) / xyz_DPressDz(:,:,k-1)
       xyz_DPFact(:,:,k) = RAir / Cp &
            & * ( xyz_Press(:,:,k-1) - xyz_Press(:,:,k) ) &
            & / xyr_Press(:,:,k) / 2.
    end do

    !----- Ĵ ------    
    xy_Adjust_b = 1.0d0

    !----- 3.1 ƥ졼 ------    
    do Iteration = 1, IterationMax
       xy_Adjust = 0.0d0

       do k = 2, km
          do i = 1, im
             do j = 1, jm 
                if ( xy_Adjust_b(i,j) .GT. 0.9 ) then
                   
                   TempSat = xyz_Temp(i,j,k-1) - xyz_Temp(i,j,k) &
                        &   + ( xyz_QvapSat(i,j,k-1) - xyz_QvapSat(i,j,k) ) * EL/Cp &
                        &   - xyz_DPFact(i,j,k) &
                        &    * ( xyz_Temp(i,j,k-1) + xyz_Temp(i,j,k) )

                   ! ԰Ǥʤ
                   if ( TempSat .GT. TempSatMax(Iteration) ) then
                      ! , ˰¤Ƥʤ
                      if (   ( xyz_Qvap(i,j,k)/xyz_QvapSat(i,j,k) .GE. CrtlRH ) &
                           & .AND. &
                           & ( xyz_Qvap(i,j,k-1)/xyz_QvapSat(i,j,k-1) .GE. CrtlRH ) &
                           &    ) then
                         
                         DelQvap = xyz_DPressDz(i,j,k-1) &
                              &   * (xyz_Qvap(i,j,k-1) - xyz_QvapSat(i,j,k-1) ) &
                              & +  xyz_DPressDz(i,j,k) &
                              &   * (xyz_Qvap(i,j,k) - xyz_QvapSat(i,j,k) ) 
                         
                         DQvapSatDTempUpper = EL * xyz_QvapSat(i,j,k) &
                              & / ( RVap * xyz_Temp(i,j,k) * xyz_Temp(i,j,k) )
                         
                         DQvapSatDTempUnder = EL * xyz_QvapSat(i,j,k-1) &
                              & / ( RVap * xyz_Temp(i,j,k-1) * xyz_Temp(i,j,k-1) )

                         DHDTempUpper = 1. + EL/Cp * DQvapSatDTempUpper
                         DHDTempUnder = 1. + EL/Cp * DQvapSatDTempUnder

                         DelTempSat = TempSat &
                              & + ( 1. - xyz_DPFact(i,j,k) / DHDTempUnder ) &
                              & * EL/Cp * DelQvap / xyz_DPressDz(i,j,k-1)

                         ! ٤Ĵ
                         DelTempUpper = DelTempSat / ( & 
                              & ( 1. + xyz_DDPressDDPress(i,j,k)  ) * DHDTempUpper &
                              & + xyz_DPFact(i,j,k) &
                              & * ( 1. - xyz_DDPressDDPress(i,j,k)  &
                              &         * DHDTempUpper / DHDTempUnder ) )

                         DelTempUnder = &
                              & - DHDTempUpper / DHDTempUnder &
                              &  * xyz_DDPressDDPress(i,j,k) * DelTempUpper &
                              & + EL/Cp * DelQvap & 
                              &  / ( xyz_DPressDz(i,j,k-1) * DHDTempUnder )

                         xyz_Temp(i,j,k)   = xyz_Temp(i,j,k) + DelTempUpper
                         xyz_Temp(i,j,k-1) = xyz_Temp(i,j,k-1) + DelTempUnder

                         ! 漾Ĵ
                         xyz_Qvap(i,j,k)   = xyz_QvapSat(i,j,k) &
                              & + DQvapSatDTempUpper * DelTempUpper
                         xyz_Qvap(i,j,k-1) = xyz_QvapSat(i,j,k-1) &
                              & + DQvapSatDTempUnder * DelTempUnder
                         xyz_QvapSat(i,j,k)   = xyz_Qvap(i,j,k) 
                         xyz_QvapSat(i,j,k-1) = xyz_Qvap(i,j,k-1) 

                         ! Ĵᤷݤ
                         xy_Adjust(i,j) = 1.
                      end if

                   end if

                end if
             end do
          end do
       end do

       Adjust = 0. 
       do i = 1, im
          do j = 1, jm
             xy_Adjust_b(i,j) = xy_Adjust(i,j)
             Adjust           = Adjust +  xy_Adjust(i,j)
          end do
       end do
       
       if ( Adjust .LT. 1. ) exit
       
    end do

    !----- 漾ѲΨ, ѲΨ, ߿̤λ ----- 
    do k = 1, km
       do i = 1, im
          do j = 1, jm

             ! 漾ѲΨ
             xyz_DCumulusQvapDt(i,j,k) = xyz_DCumulusQvapDt(i,j,k) & 
                  &  + ( xyz_Qvap(i,j,k) - xyz_Qvap_b(i,j,k) ) / DelTimePhy

             ! ѲΨ
             xyz_DCumulusTempDt(i,j,k) = xyz_DCumulusTempDt(i,j,k) &
                  & + ( xyz_Temp(i,j,k) - xyz_Temp_b(i,j,k) ) / DelTimePhy

             ! ߿
             xy_CumulusRain(i,j) = xy_CumulusRain(i,j)  &
                  &  + ( xyz_Qvap_b(i,j,k) - xyz_Qvap(i,j,k) ) &
                  & * xyz_DPressDz(i,j,k) / Grav * EL  / DelTimePhy

          end do
       end do
    end do
    
    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_cumulus_adjust

end module physics_cumulus_adjust_mod




