!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_implicit.f90 
!
! History
!   2005/09/21 Yamada Yukiko     create
!

module physics_implicit_mod
  !
  != ʪ ˡѥ⥸塼
  !
  !== 
  !
  ! ɽ̥եå, ͥեå, ɽ̲٤򱢲ˡ
  ! ׻.
  !
  !==  (˽񤯤ΤɤΤʤ?)
  ! (2006-7-30 ) subroutine physics_implicit_fluxcorrection ɲ
  !
  implicit none

  private
  public :: physics_implicit_init
  public :: physics_implicit_integrate
  public :: physics_implicit_fluxcorrection
contains

  subroutine physics_implicit_init( &
    & xyr_VelLonFlux       , & ! (out) ®ٷʬեå
    & xyr_VelLatFlux       , & ! (out) ®ٰʬեå
    & xyr_TempFlux         , & ! (out) ٥եå
    & xyr_QvapFlux         , & ! (out) 漾եå
    & xyzo_VelMatrix       , & ! (out) ®ٱ
    & xyzo_TempMatrix      , & ! (out) ٱ
    & xyzo_QvapMatrix      , & ! (out) 漾
    & xyr_Press            , & ! (in)  (Ⱦ)
    & DelTimePhy           , & ! (in) t
    & xy_SurfHeatCapacity  , & ! (in) ɽǮ
    & xy_SurfCondition       ) ! (in) ɽ
    !
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: Cp, Grav
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none
    real(DBKIND), intent(out) :: &
         & xyr_VelLonFlux(im*jm,km+1)        , & !®ٷʬեå
         & xyr_VelLatFlux(im*jm,km+1)        , & !®ٰʬեå
         & xyr_TempFlux(im*jm,km+1)          , & !٥եå
         & xyr_QvapFlux(im*jm,km+1)          , & !漾եå
         & xyzo_VelMatrix(im*jm,km,-1:1)     , & !®ٱ
         & xyzo_TempMatrix(im*jm,0:km,-1:1)  , & !ٱ
         & xyzo_QvapMatrix(im*jm,km,-1:1)        !漾
    real(DBKIND), intent(in) :: &
         & xyr_Press(im*jm,km+1)             , & !  (Ⱦ)
         & DelTimePhy                        , & ! t
         & xy_SurfHeatCapacity(im*jm)            ! ɽǮ
    integer(INTKIND), intent(in) :: &
         & xy_SurfCondition(im*jm)               ! ɽ
    character(STRING),  parameter:: subname = "physics_implicit_init"
    integer(INTKIND)    :: ij, k
        ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)

    continue

    !   Ͻ
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   
    !----------------------------------------------------------------

    ! ---- 1. , Ǯ̤ι ----
    xyzo_VelMatrix  = 0.0 
    xyzo_TempMatrix = 0.0 
    xyzo_QvapMatrix = 0.0 

    do k = 1, km 
       xyzo_VelMatrix(:,k,0)  = ( xyr_Press(:,k) - xyr_Press(:,k+1) ) &
            &                   / Grav / DelTimePhy  
       xyzo_TempMatrix(:,k,0) = xyzo_VelMatrix(:,k,0) * Cp
       xyzo_QvapMatrix(:,k,0) = xyzo_VelMatrix(:,k,0) * Cp
    end do

    do ij = 1, im*jm
       if ( xy_SurfCondition(ij) .GE. 1 ) then 
          xyzo_TempMatrix(ij,0,0) = xy_SurfHeatCapacity(ij) / DelTimePhy 
       else
          xyzo_TempMatrix(ij,0,0) = 1.
       end if
    end do

    ! ---- 2. եåꥻå ----
    xyr_VelLonFlux = 0.0 
    xyr_VelLatFlux = 0.0 
    xyr_TempFlux   = 0.0 
    xyr_QvapFlux   = 0.0 

    ! λ
    call EndSub(subname)

  end subroutine physics_implicit_init

! (2006-7-28 )
! Verdiff Ȥ̾ɤʤ. T η׻ˤͤäƤ뤫.
!
  subroutine physics_implicit_integrate( &
    & xyz_DVerdiffVelLonDt    , & ! (out) ʬ ľȻ®
    & xyz_DVerdiffVelLatDt    , & ! (out) ʬ ľȻ®
    & xyz_DVerdiffTempDt      , & ! (out) ľȻǮΨ
    & xyz_DVerdiffSurfTempDt  , & ! (out) ɽ ľȻǮΨ
    & xyz_DVerdiffQvapDt      , & ! (out) ľȻüΨ
    & xyr_VelLonFlux          , & ! (in) ®ٷʬեå
    & xyr_VelLatFlux          , & ! (in) ®ٰʬեå
    & xyr_TempFlux            , & ! (in) ٥եå
    & xyr_SurfRadSFlux        , & ! (in) ͥեå
    & xyr_SurfRadLFlux        , & ! (in) Ĺȥեå
    & xy_GroundTempFlux       , & ! (in) Ǯեå
    & xyr_QvapFlux            , & ! (in) 漾եå
    & xyzo_VelMatrix          , & ! (in) ®ٱ
    & xyzo_TempMatrix         , & ! (in) ٱ
    & xyzo_QvapMatrix         , & ! (in) 漾
    & xy_SurfVelMatrix        , & ! (in) ®ٱ: ɽ
    & xyoo_SurfTempMatrix     , & ! (in) ٱ: ɽ
    & xyoo_SurfQvapMatrix     , & ! (in) 漾: ɽ
    & xyo_SurfRadLMatrix      , & ! (in) Ա
    & DelTimePhy              , & ! (in) t
    & xy_SurfCondition          ) ! (in) ɽ
    !
    ! ѲΨη׻ (implicit)
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: EL, Cp 
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    implicit none
    real(DBKIND), intent(out) :: &
      & xyz_DVerdiffVelLonDt(im*jm,km), & ! ʬ ľȻ®
      & xyz_DVerdiffVelLatDt(im*jm,km), & ! ʬ ľȻ®
      & xyz_DVerdiffTempDt(im*jm,km), & ! ľȻǮΨ
      & xyz_DVerdiffSurfTempDt(im*jm), & ! ɽ ľȻǮΨ
      & xyz_DVerdiffQvapDt(im*jm,km) ! ľȻüΨ
    real(DBKIND), intent(in) :: &
      & xyr_VelLonFlux(im*jm,km+1), & ! ®ٷʬեå
      & xyr_VelLatFlux(im*jm,km+1), & ! ®ٰʬեå
      & xyr_TempFlux(im*jm,km+1), & ! ٥եå
      & xyr_SurfRadSFlux(im*jm), & ! ͥեå
      & xyr_SurfRadLFlux(im*jm), & ! Ĺȥեå
      & xy_GroundTempFlux(im*jm)            , & ! Ǯեå
      & xyr_QvapFlux(im*jm,km+1)            , & ! 漾եå
      & xyzo_VelMatrix(im*jm,km,-1:1)       , & ! ®ٱ
      & xyzo_TempMatrix(im*jm,0:km,-1:1)    , & ! ٱ
      & xyzo_QvapMatrix(im*jm,km,-1:1)      , & ! 漾
      & xy_SurfVelMatrix(im*jm)             , & ! ®ٱ: ɽ
      & xyoo_SurfTempMatrix(im*jm,0:1,-1:1) , & ! ٱ: ɽ
      & xyoo_SurfQvapMatrix(im*jm,0:1,-1:1) , & ! 漾: ɽ
      & xyo_SurfRadLMatrix(im*jm,-1:1)      , & ! Ա
      & DelTimePhy                              ! t
    integer(INTKIND) :: xy_SurfCondition(im*jm) ! ɽ

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_implicit_integrate"
    integer(INTKIND)    :: ij, k, l
      ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    real(DBKIND) :: & 
      & xyz_DelTempQvap(im*jm,-km:km)            , & ! ԣѲ
      & xyzo_TempQvapLUMatrix(im*jm,-km:km,-1:1) , & ! ̣չ
      & xyzo_VelLUMatrix(im*jm,km,-1:1)              ! ̣չ

    continue

    ! Ͻ
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ׻
    !----------------------------------------------------------------

    ! ---- 1. ® (Vlon, Vlat) β ----

    xyzo_VelLUMatrix  = xyzo_VelMatrix
    xyzo_VelLUMatrix(:,1,0)  = xyzo_VelLUMatrix(:,1,0) + xy_SurfVelMatrix(:)

    call lu_decomposition_tridiagonal( &
         & xyzo_VelLUMatrix, im*jm, km )

    do k = 1, km
       xyz_DVerdiffVelLonDt(:,k) = xyr_VelLonFlux(:,k) - xyr_VelLonFlux(:,k+1)
       xyz_DVerdiffVelLatDt(:,k) = xyr_VelLatFlux(:,k) - xyr_VelLatFlux(:,k+1)
    end do

    call lu_solve_tridiagonal( &
         & xyz_DVerdiffVelLonDt , & 
         & xyzo_VelLUMatrix     , & 
         & 1, im*jm, km )

    call lu_solve_tridiagonal( &
         & xyz_DVerdiffVelLatDt , & 
         & xyzo_VelLUMatrix     , & 
         & 1, im*jm, km )

    ! ---- 2. ٤漾β ----

    do l = -1, 1

       do k = 1, km
          xyzo_TempQvapLUMatrix(:,k,l)   = xyzo_TempMatrix(:,k,l)
          xyzo_TempQvapLUMatrix(:,-k,-l) = xyzo_QvapMatrix(:,k,l)
       end do
       
       xyzo_TempQvapLUMatrix(:,1,l)   = xyzo_TempMatrix(:,1,l) &
            &                          + xyoo_SurfTempMatrix(:,1,l)
       xyzo_TempQvapLUMatrix(:,-1,-l) = xyzo_QvapMatrix(:,1,l) & 
            &                          + xyoo_SurfQvapMatrix(:,1,l)

    end do

    xyzo_TempQvapLUMatrix(:,0,0) = xyzo_TempMatrix(:,0,0) &
         & + xyoo_SurfTempMatrix(:,0,0) + xyoo_SurfQvapMatrix(:,0,0) &
         & + xyo_SurfRadLMatrix(:,0)

    xyzo_TempQvapLUMatrix(:,0,1) = &
         & + xyoo_SurfTempMatrix(:,0,1) + xyo_SurfRadLMatrix(:,1)

    xyzo_TempQvapLUMatrix(:,0,-1) =  xyoo_SurfQvapMatrix(:,0,1) 

    call lu_decomposition_tridiagonal( &
         & xyzo_TempQvapLUMatrix, im*jm, 2*km+1 )

    do k = 1, km
       xyz_DelTempQvap(:,k)  = xyr_TempFlux(:,k) - xyr_TempFlux(:,k+1)
       xyz_DelTempQvap(:,-k) = xyr_QvapFlux(:,k) - xyr_QvapFlux(:,k+1)
    end do

    xyz_DelTempQvap(:,0) = - xyr_SurfRadSFlux  - xyr_SurfRadLFlux  &
         &                 - xyr_TempFlux(:,1) - xyr_QvapFlux(:,1) &
         &                 + xy_GroundTempFlux


    call lu_solve_tridiagonal( &
         & xyz_DelTempQvap       , & 
         & xyzo_TempQvapLUMatrix , & 
         & 1, im*jm, 2*km+1 )

    ! ---- 2. ѲΨ ----
    do k = 1, km
       xyz_DVerdiffVelLonDt(:,k) = xyz_DVerdiffVelLonDt(:,k) / DeltimePhy 
       xyz_DVerdiffVelLatDt(:,k) = xyz_DVerdiffVelLatDt(:,k) / DeltimePhy 
       xyz_DVerdiffTempDt(:,k)   = xyz_DelTempQvap(:,k) / DeltimePhy 
       xyz_DVerdiffQvapDt(:,k)   = xyz_DelTempQvap(:,-k) / DeltimePhy / EL * Cp
    end do
    
    do ij = 1, im*jm
       if ( xy_SurfCondition(ij) .GE. 1 ) then 
          xyz_DVerdiffSurfTempDt(ij) = xyz_DelTempQvap(ij,0) / DeltimePhy 
       else
          xyz_DVerdiffSurfTempDt(ij) = 0.
       end if
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_implicit_integrate


  subroutine lu_decomposition_tridiagonal( &
       & jno_LUMatrix, JDimMax, NDimMax )

    !==== Dependency
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Parameter
    !
    integer(INTKIND), intent(in)    :: &
         JDimMax, NDimMax 

    !==== In/Out
    !
    real(DBKIND), intent(inout) :: &
         jno_LUMatrix(JDimMax, NDimMax, -1:1) ! ϡ̣չ

    !----- ѿ -----
    character(STRING),  parameter:: subname = "lu_decomposition_tridiagonal"
    integer(INTKIND)    :: j, n ! do 롼Ѻѿ

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   Σ̣ʬ [ гѹ ]
    !----------------------------------------------------------------

    do j = 1, JDimMax
       jno_LUMatrix(j,1,1) = jno_LUMatrix(j,1,1) / jno_LUMatrix(j,1,0)
    end do

    do n = 2, NDimMax-1
       do j = 1, JDimMax

       jno_LUMatrix(j,n,0) = jno_LUMatrix(j,n,0) &
            &               - jno_LUMatrix(j,n,-1) * jno_LUMatrix(j,n-1,1) 

       jno_LUMatrix(j,n,1) = jno_LUMatrix(j,n,1) /jno_LUMatrix(j,n,0) 

       end do
    end do

    do j = 1, JDimMax
       jno_LUMatrix(j,NDimMax,0) = jno_LUMatrix(j,NDimMax,0) &
            &    - jno_LUMatrix(j,NDimMax,-1) * jno_LUMatrix(j,NDimMax-1,1) 
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine lu_decomposition_tridiagonal


  subroutine lu_solve_tridiagonal( &
         & ijn_Vector       , & 
         & jno_LUMatrix     , & 
         & IDimMax, JDimMax, NDimMax )

    !==== Dependency
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Parameter
    !
    integer(INTKIND), intent(in)    :: &
         IDimMax, JDimMax, NDimMax 

    !==== In/Out
    !
    real(DBKIND), intent(inout) :: &
         & ijn_Vector(IDimMax, JDimMax, NDimMax) ! ե٥ȥ롿

    !==== Input
    !
    real(DBKIND), intent(in) :: &
         jno_LUMatrix(JDimMax, NDimMax, -1:1) ! ̣չ

    !----- ѿ -----
    character(STRING),  parameter:: subname = "lu_solve_tridiagonal"
    integer(INTKIND)    :: i, j, n    ! do 롼Ѻѿ

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ̣ʬˤη׻ [ гѹ ]
    !----------------------------------------------------------------

    ! ---- 1.  ----    

    do i = 1, IDimMax
       do j = 1, JDimMax
          ijn_Vector(i,j,1) = ijn_Vector(i,j,1) / jno_LUMatrix(j,1,0)
       end do
    end do

    do n = 2, NDimMax
       do i = 1, IDimMax
          do j = 1, JDimMax
             ijn_Vector(i,j,n) = ( ijn_Vector(i,j,n) &
                  & - ijn_Vector(i,j,n-1) * jno_LUMatrix(j,n,-1) ) &
                  &               / jno_LUMatrix(j,n,0)
          end do
       end do       
    end do

    ! ---- 2.  ----    

    do n = NDimMax-1, 1, -1
       do i = 1, IDimMax
          do j = 1, JDimMax
             ijn_Vector(i,j,n) = ijn_Vector(i,j,n) &
                  & - ijn_Vector(i,j,n+1) * jno_LUMatrix(j,n,1)
          end do
       end do       
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine lu_solve_tridiagonal

  subroutine physics_implicit_fluxcorrection ( &
    & xyr_VelLonFlux, & !(inout)
    & xyr_VelLatFlux, & !(inout)
    & xyr_TempFlux, & !(inout)
    & xyr_QvapFlux, & !(inout)
    & xyz_DVerdiffVelLonDt, & !(in)
    & xyz_DVerdiffVelLatDt, & !(in)
    & xyz_DVerdiffTempDt, & !(in)
    & xyz_DVerdiffSurfTempDt, & !(in)
    & xyz_DVerdiffQvapDt, & !(in)
    & xyzo_VelMatrix, & !(in)
    & xyzo_TempMatrix, & !(in)
    & xyzo_QvapMatrix, & !(in)
    & xy_SurfVelMatrix, & !(in)
    & xyoo_SurfTempMatrix, & !(in)
    & xyoo_SurfQvapMatrix, & !(in)
    & DelTimePhy  & !(in)
    & )
    !
    ! եå
    ! 
    ! 
    use type_mod,    only: DBKIND, INTKIND, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: EL, Cp 
    use dc_trace,  only: BeginSub, EndSub
    real(DBKIND), intent(inout) :: xyr_VelLonFlux(im,jm,km+1) ! դΥեå
    real(DBKIND), intent(inout) :: xyr_VelLatFlux(im,jm,km+1) ! ֤Υեå
    real(DBKIND), intent(inout) :: xyr_TempFlux(im,jm,km+1) ! ԤΥեå
    real(DBKIND), intent(inout) :: xyr_QvapFlux(im,jm,km+1) ! Υեå
    real(DBKIND), intent(in) :: xyz_DVerdiffVelLonDt(im,jm,km)
                                                      ! ưѲգ
    real(DBKIND), intent(in) :: xyz_DVerdiffVelLatDt(im,jm,km) 
                                                      ! ̱ưѲ֣
    real(DBKIND), intent(in) :: xyz_DVerdiffTempDt(im,jm,km) ! ٻѲ
    real(DBKIND), intent(in) :: xyz_DVerdiffSurfTempDt(im,jm) ! ɽѲΨ
    real(DBKIND), intent(in) :: xyz_DVerdiffQvapDt(im,jm,km) ! 漾Ѳ
    real(DBKIND), intent(in) :: xyzo_VelMatrix(im,jm,km,-1:1) ! 
    real(DBKIND), intent(in) :: xyzo_TempMatrix(im,jm,0:km,-1:1) ! Ա
    real(DBKIND), intent(in) :: xyzo_QvapMatrix(im,jm,km,-1:1) ! 񱢲
    real(DBKIND), intent(in) :: xy_SurfVelMatrix(im,jm) ! ɽ
    real(DBKIND), intent(in) :: xyoo_SurfTempMatrix(im,jm,0:1,-1:1) 
                                                       ! Աɽ
    real(DBKIND), intent(in) :: xyoo_SurfQvapMatrix(im,jm,0:1,-1:1)
                                                       ! 񱢲ɽ
    real(DBKIND), intent(in) :: DelTimePhy ! ֹߦt

    real(DBKIND) :: ELF
    INTEGER(INTKIND) :: k
    character(STRING), parameter:: subname = "physics_implicit_fluxcorrection"

    ! Ͻ
    call BeginSub(subname)

    ELF = EL/Cp

    DO k = 2, km
      xyr_VelLonFlux(:,:,k) = xyr_VelLonFlux(:,:,K) &
        & - (   xyzo_VelMatrix(:,:,k,-1)* xyz_DVerdiffVelLonDt(:,:,k-1) &
        &     - xyzo_VelMatrix(:,:,k-1,1)* xyz_DVerdiffVelLonDt(:,:,k) &
        &   ) * DelTimePhy

      xyr_VelLatFlux(:,:,k) = xyr_VelLatFlux(:,:,k) &
        & - (   xyzo_VelMatrix(:,:,k,-1) * xyz_DVerdiffVelLatDt(:,:,k-1) &
        &     - xyzo_VelMatrix(:,:,k-1,1) * xyz_DVerdiffVelLatDt(:,:,k) &
        &   ) * DelTimePhy

      xyr_TempFlux(:,:,k) = xyr_TempFlux(:,:,k) &
        & - (   xyzo_TempMatrix(:,:,k,-1) * xyz_DVerdiffTempDt(:,:,k-1) &
        &     - xyzo_TempMatrix(:,:,k-1,1) * xyz_DVerdiffTempDt(:,:,k) &
        &   ) * DelTimePhy

      xyr_QvapFlux(:,:,k) = xyr_QvapFlux(:,:,k) &
        & - (  xyzo_QvapMatrix(:,:,k,-1) * xyz_DVerdiffQvapDt(:,:,k-1) &
        &    - xyzo_QvapMatrix(:,:,k-1,1) * xyz_DVerdiffQvapDt(:,:,k) &
        &   ) * DelTimePhy * ELF
     end do

     xyr_VelLonFlux(:,:,1) = xyr_VelLonFlux(:,:,1) &
       & - xy_SurfVelMatrix(:,:) * xyz_DVerdiffVelLonDt(:,:,1) * DelTimePhy

     xyr_VelLatFlux(:,:,1) = xyr_VelLatFlux(:,:,1) &
       & - xy_SurfVelMatrix(:,:) * xyz_DVerdiffVelLatDt(:,:,1) * DelTimePhy

     xyr_TempFlux(:,:,1) = xyr_TempFlux(:,:,1) &
       & - (   xyoo_SurfTempMatrix(:,:,1,-1) * xyz_DVerdiffSurfTempDt(:,:) &
       &     + xyoo_SurfTempMatrix(:,:,1,0) * xyz_DVerdiffTempDt(:,:,1) ) &
       &   * DelTimePhy

     xyr_QvapFlux(:,:,1) = xyr_QvapFlux(:,:,1) &
       & - (  xyoo_SurfQvapMatrix(:,:,1,-1) * xyz_DVerdiffSurfTempDt(:,:) &
       &    + xyoo_SurfQvapMatrix(:,:,1,0) * xyz_DVerdiffQvapDt(:,:,1) &
       &      * ELF ) * DelTimePhy

    ! λ
    call EndSub(subname)
     
  end subroutine physics_implicit_fluxcorrection

end module physics_implicit_mod
