!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005-2007. All rights reserved.
!---------------------------------------------------------------------
! physics_radiation_incoming.f90 
!
! History
!   2005/09/21 Yamada Yukiko     create
!   2007-05-04 Masaki Ishiwatari  Interface is changed.
!                                 x_Lon is added
! == description
! * , ѲʤѲʤξˤбƤʤ.
! * ѲӵѲ뤿ˤ
!   դǤ褦ˤʤȤʤ.
!

module physics_radiation_incoming_mod

  implicit none

  private
  public :: physics_radiation_incoming

contains

  subroutine physics_radiation_incoming( &
         & xy_IncomRadSFlux        , & ! (out) Ĺȥեå
         & xy_InAngle              , & ! (out) sec(ͳ)
         & x_Lon                   , & !(in) 
         & y_Lat                    ) ! (in) 

    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use nmlfile_mod, only: nmlfile_init, nmlfile_open, nmlfile_close
    use constants_mod, only: PI  
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    use dc_message, only: MessageNotify

    implicit none

    real(DBKIND), intent(out) :: xy_IncomRadSFlux(im,jm) ! Ĺȥեå
    real(DBKIND), intent(out) :: xy_InAngle(im,jm)     ! sec(ͳ)
    real(DBKIND), intent(in) :: x_Lon(im) ! 
    real(DBKIND), intent(in) :: y_Lat(jm) ! 

    character(STRING),  parameter:: subname = "physics_radiation_incoming"

    integer(INTKIND)    :: i, j

    real(DBKIND) :: SolarCoeff = 1380.0d0 !" 
    real(DBKIND) :: AtmosAlbedo = 0.2     !" 絤٥
    real(DBKIND) :: AINS   = 0.127        !" ǯʿͤη
    real(DBKIND) :: BINS   = 0.183        !" ǯʿͤη
    real(DBKIND) :: AZET   = 0.410        !" ǯʿͳѤη
    real(DBKIND) :: BZET   = 0.590        !" ǯʿͳѤη
    
    logical                     :: nmlreadable
    integer(INTKIND)            :: nmlunit, nmlstat

    namelist /physics_radiation_incoming_nml/ &
      & SolarCoeff, &
      & AtmosAlbedo, &
      & AINS, &
      & BINS, &
      & AZET, &
      & BZET

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    ! ѥ᡼
    ! read physics_radiation_incomfing_nml
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=physics_radiation_incoming_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST physics_radiation_incoming_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=physics_radiation_incoming_nml)
    else
       call DbgMessage('Not Read NAMELIST physics_radiation_incoming_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST physics_radiation_incoming_nml. Force Use Default Value.')
    end if
    call nmlfile_close


    !----------------------------------------------------------------
    !   ͷ׻
    !----------------------------------------------------------------

    ! ---- ǯʿ ----
    do i = 1, im
       do j = 1, jm
          xy_IncomRadSFlux(i,j) = - SolarCoeff * (1. - AtmosAlbedo ) &
               &  * ( AINS + BINS * Cos( y_Lat( J )*PI/180. )**2 )
          
          if ( xy_IncomRadSFlux(i,j) .LT. 0. ) then
             xy_InAngle(i,j) = &
                  & 1. / ( AZET + BZET * Cos( y_Lat( J )*PI/180. )**2 )
          else
             xy_IncomRadSFlux(i,j) = 0.0d0
             xy_InAngle(i,j) = 0.0d0
          ENDIF
       end do
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_radiation_incoming

end module physics_radiation_incoming_mod
















