!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2007. All rights reserved.
!---------------------------------------------------------------------

module physics_radiation_incoming_sr_mod
!= ʪ ͷ׻(ʬ)⥸塼
!
!== 
!
!  * Τ, ѲѲͭʬۤ׻.
!    , ǤդǤʤΤ
!    ɤ˥ϡɥɤ줿դʬۤ
!    ׻Ǥʤ.
!    Ʊž絤η׻ϤǤϤ.
!
!== History
!   2007-05-02 Masaki Ishiwatari
!
!== TODO 
! * (2007-5-2 )
!   * դ礻Ǥ褦ˤʤФʤʤ.
!   * ɥȤϱѸǽ񤯤Τä?
!   * ѥ᡼ͤѤ
!   * ⥸塼̾Ĺ. phys_ ˤȤƤФƤ?
!   *  SolarConst Ȥ
!   * x_Lon ɲä. interface ͤľ٤.
!     xy_InAngle (AGCM5  SECZET) Ϥɬ?
!   * ѿˤϼޤǽ񤤤ɤΤǤ?

  use type_mod,    only : REKIND, DBKIND, INTKIND, TOKEN, STRING

  implicit none

  private
  public :: physics_radiation_incoming

contains

  subroutine physics_radiation_incoming( &
    & xy_IncomRadSFlux        , & ! (out) Ĺȥեå
    & xy_InAngle              , & ! (out) sec(ͳ)
    & x_Lon                   , & !(in) 
    & y_Lat                    ) !(in) 

    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use nmlfile_mod, only: nmlfile_init, nmlfile_open, nmlfile_close
    use constants_mod, only: PI  
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump
    use dc_message, only: MessageNotify

    implicit none

    real(DBKIND), intent(out) :: xy_IncomRadSFlux(im,jm) ! ûȥեå
    real(DBKIND), intent(out) :: xy_InAngle(im,jm) ! sec(ͳ)
    real(DBKIND), intent(in) :: x_Lon(im) ! 
    real(DBKIND), intent(in) :: y_Lat(jm) ! 

    character(STRING),  parameter:: subname = "physics_radiation_incoming_sr"
    integer(INTKIND)    :: i, j
 
    real(DBKIND) :: SolarCoeff = 1380.0d0 !  [W/m^2]
    real(DBKIND) :: AtmosAlbedo = 0.0d0 ! 絤٥
    real(DBKIND) :: LatSubSolar = 180.0d0 ! ľ (ñ:degree)
    real(DBKIND) :: LonSubSolar = 0.0d0 ! ľ (ñ:degree)
    real(DBKIND) :: SinDel ! ͳ
    real(DBKIND) :: ANGHR ! 
    real(DBKIND) :: COSZET ! cos(ͳ)

    logical                     :: nmlreadable
    integer(INTKIND)            :: nmlunit, nmlstat

    namelist /physics_radiation_incoming_sr_nml/ &
      & SolarCoeff, &
      & AtmosAlbedo, &
      & LonSubSolar, &
      & LatSubSolar

    continue

    call BeginSub(subname)
  
    ! read physics_radiation_incomfing_sr_nml
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=physics_radiation_incoming_sr_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST physics_radiation_incoming_sr_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=physics_radiation_incoming_sr_nml)
    else
       call DbgMessage('Not Read NAMELIST physics_radiation_incoming_sr_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST physics_radiation_incoming_sr_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    SinDel =  sin( LatSubSolar*PI/180.0d0  )

    do i = 1, im
      do j = 1, jm
        ANGHR  = (LonSubSolar - x_Lon(i))*PI/180.0d0
        COSZET = sin(y_Lat(j)*PI/180.0d0)*SinDel &
          & + cos(y_Lat(j)*PI/180.0d0)* sqrt(1.0d0 - SinDel**2) * cos(ANGHR)

        IF ( COSZET .GT. 0. ) THEN
          xy_IncomRadSFlux (i,j) = - SolarCoeff*(1.0d0 - AtmosAlbedo)*COSZET
          xy_InAngle (i,j) = 1.0d0 / COSZET
        ELSE
          xy_IncomRadSFlux  (i,j) = 0.0d0
          xy_InAngle (i,j) = 0.0d0
        ENDIF
      end do
    end do

    call EndSub(subname)

  end subroutine physics_radiation_incoming

end module physics_radiation_incoming_sr_mod
