!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
! physics_verdiff_main.f90 
!
! History
!   2005/09/21 Yamada Yukiko     create
!

module physics_verdiff_main_mod

  implicit none

  private
  public :: physics_verdiff_main

contains

  subroutine physics_verdiff_main( &
         & xyr_VelLonFlux       , & ! (out) ®ٷʬեå
         & xyr_VelLatFlux       , & ! (out) ®ٰʬեå
         & xyr_TempFlux         , & ! (out) ٥եå
         & xyr_QvapFlux         , & ! (out) 漾եå
         & xyzo_VelMatrix       , & ! (inout) ®ٱ
         & xyzo_TempMatrix      , & ! (inout) ٱ
         & xyzo_QvapMatrix      , & ! (inout) 漾
         & xyz_VelLon           , & ! (in) ®ٷʬ
         & xyz_VelLat           , & ! (in) ®ٰʬ
         & xyz_Temp             , & ! (in)  ()
         & xyr_Temp             , & ! (in)  (Ⱦ)
         & xyz_Qvap             , & ! (in) 漾 ()
         & xyz_Press            , & ! (in)  ()
         & xyr_Press            , & ! (in)  (Ⱦ)
         & xyz_GeoPot           , & ! (in)  ()
         & xyr_GeoPot             ) ! (in)  (Ⱦ)

    !==== Dependency
    use type_mod,    only: REKIND, DBKIND, INTKIND, TOKEN, STRING
    use grid_3d_mod, only: im, jm, km
    use constants_mod, only: RAir, Cp, Grav, EL
    use physics_verdiff_coeff_mod,  only: physics_verdiff_coeff
    use dc_trace,    only: SetDebug, BeginSub, EndSub, DbgMessage, DataDump

    implicit none

    !==== Output
    !
    real(DBKIND), intent(out) :: &
         & xyr_VelLonFlux(im,jm,km+1)        , & ! (out) ®ٷʬեå
         & xyr_VelLatFlux(im,jm,km+1)        , & ! (out) ®ٰʬեå
         & xyr_TempFlux(im,jm,km+1)          , & ! (out) ٥եå
         & xyr_QvapFlux(im,jm,km+1)              ! (out) 漾եå

    !==== Input
    !
    real(DBKIND), intent(in) :: &
         & xyz_VelLon(im,jm,km)              , & ! (in) ®ٷʬ
         & xyz_VelLat(im,jm,km)              , & ! (in) ®ٰʬ
         & xyz_Temp(im,jm,km)                , & ! (in)  ()
         & xyr_Temp(im,jm,km+1)              , & ! (in)  (Ⱦ)
         & xyz_Qvap(im,jm,km)                , & ! (in) 漾 ()
         & xyz_Press(im,jm,km)               , & ! (in)  ()
         & xyr_Press(im,jm,km+1)             , & ! (in)  (Ⱦ)
         & xyz_GeoPot(im,jm,km)              , & ! (in)  ()
         & xyr_GeoPot(im,jm,km+1)                ! (in)  (Ⱦ)

    !==== In/Out
    !
    real(DBKIND), intent(inout) :: &
         & xyzo_VelMatrix(im,jm,km,-1:1)    , & ! (inout) ®ٱ
         & xyzo_TempMatrix(im,jm,0:km,-1:1) , & ! (inout) ٱ
         & xyzo_QvapMatrix(im,jm,km,-1:1)       ! (inout) 漾

    !----- ѿ -----
    character(STRING),  parameter:: subname = "physics_verdiff_main"

    ! do 롼Ѻѿ ( i* j*ľ k*ȿ l*)
    integer(INTKIND)    :: i,j, k

    real(DBKIND), parameter :: RefPress        = 100000.0D0 ! ȵ
    real(DBKIND), parameter :: BasePotTemp     = 300.0D0    ! ܲ
    real(DBKIND), parameter :: SquareVelMin    = 0.1D0      ! 躹Ǿ
    real(DBKIND), parameter :: BulkRiNumMin    = - 100.0D0  ! Х륯ңǾ

    real(DBKIND) :: &
         & xyr_DVelDz(im,jm,km+1)            , & ! d|v|/dz
         & xyr_BulkRiNum(im,jm,km+1)         , & ! Х륯ң
         & xyr_TempTransCoeff(im,jm,km+1)    , & ! ͢
         & xyr_QvapTransCoeff(im,jm,km+1)    , & ! ͢漾
         & xyr_VelTransCoeff(im,jm,km+1)     , & ! ͢ư
         & xyr_TempDiffuCoeff(im,jm,km+1)    , & ! Ȼ
         & xyr_QvapDiffuCoeff(im,jm,km+1)    , & ! Ȼ漾
         & xyr_VelDiffuCoeff(im,jm,km+1)     , & ! Ȼư
         & xyz_Exner(im,jm,km)               , & ! Exnerؿ ()
         & xyr_Exner(im,jm,km+1)                 ! Exnerؿ (Ⱦ)

    continue

    !----------------------------------------------------------------
    !   Ͻ
    !----------------------------------------------------------------
    call BeginSub(subname)

    !----------------------------------------------------------------
    !   ľȻ׻
    !----------------------------------------------------------------

    ! ---- 1. ׻ ----
    xyz_Exner = ( xyz_Press / RefPress ) ** (RAir/Cp)
    xyr_Exner = ( xyr_Press / RefPress ) ** (RAir/Cp)

    ! ---- 2. Х륯ң ----

    xyr_DVelDz    = 0.0d0
    xyr_BulkRiNum = 0.0d0

    do k = 2, km 
       do i = 1, im
          do j = 1, jm
             xyr_DVelDz(i,j,k) = &
                  &  SQRT( MAX( SquareVelMin , &
                  &            ( xyz_VelLon(i,j,k) - xyz_VelLon(i,j,k-1) )**2 & 
                  &          + ( xyz_VelLat(i,j,k) - xyz_VelLat(i,j,k-1) )**2 &
                  &       )    ) &
                  &  / ( xyz_GeoPot(i,j,k) - xyz_GeoPot(i,j,k-1) )

             xyr_BulkRiNum(i,j,k) = &
                  &  Grav / BasePotTemp &
                  &  *  (   xyz_Temp(i,j,k)   / xyz_Exner(i,j,k)     &
                  &       - xyz_Temp(i,j,k-1) / xyz_Exner(i,j,k-1) ) &
                  &  / ( xyz_GeoPot(i,j,k) - xyz_GeoPot(i,j,k-1) )   &
                  &  / xyr_DVelDz(i,j,k)**2

             xyr_BulkRiNum(i,j,k) = MAX( xyr_BulkRiNum(i,j,k) , BulkRiNumMin )

          end do
       end do
    end do

    ! ---- 3. Ȼ ----    

    call physics_verdiff_coeff( &
       & xyr_VelDiffuCoeff , & ! (out) 
       & xyr_TempDiffuCoeff, & ! (out) 
       & xyr_QvapDiffuCoeff, & ! (out) 
       & xyr_BulkRiNum     , & ! (in) 
       & xyr_DVelDz        , & ! (in) 
       & xyr_GeoPot )          ! (in) 

    ! ----  *. ѱή ----
    
    ! ----  *. Ȼν ----
    
!    CALL HISTIN ( DFM  , 'DFM'  )
!    CALL HISTIN ( DFH  , 'DFH'  )
!    CALL HISTIN ( DFE  , 'DFE'  )

   ! ----  5. ͢ ----
    
    xyr_VelTransCoeff  = 0.0d0
    xyr_TempTransCoeff = 0.0d0
    xyr_QvapTransCoeff = 0.0d0

    do k = 2, km
       xyr_VelTransCoeff(:,:,k) = xyr_VelDiffuCoeff(:,:,k) &
            &                       * xyr_Press(:,:,k) / RAir / xyr_Temp(:,:,k) &
            &                       / ( xyz_GeoPot(:,:,k) - xyz_GeoPot(:,:,k-1) )
       xyr_TempTransCoeff(:,:,k) = xyr_TempDiffuCoeff(:,:,k) &
            &                       * xyr_Press(:,:,k) / RAir / xyr_Temp(:,:,k) &
            &                       / ( xyz_GeoPot(:,:,k) - xyz_GeoPot(:,:,k-1) )
       xyr_QvapTransCoeff(:,:,k) = xyr_QvapDiffuCoeff(:,:,k) &
            &                       * xyr_Press(:,:,k) / RAir / xyr_Temp(:,:,k) &
            &                       / ( xyz_GeoPot(:,:,k) - xyz_GeoPot(:,:,k-1) )
    end do

   ! ----  5. եå----

    ! k =0, km+1  0 ǤΤ. 
    xyr_VelLonFlux  = 0.0d0
    xyr_VelLatFlux  = 0.0d0
    xyr_TempFlux    = 0.0d0
    xyr_QvapFlux    = 0.0d0

    do k = 2, km

       xyr_VelLonFlux(:,:,k) = xyr_VelLonFlux(:,:,k) &
            &                 + xyr_VelTransCoeff(:,:,k) &
            &                   * ( xyz_VelLon(:,:,k-1) - xyz_VelLon(:,:,k) )


       xyr_VelLatFlux(:,:,k) = xyr_VelLatFlux(:,:,k) &
            &                 + xyr_VelTransCoeff(:,:,k) &
            &                   * ( xyz_VelLat(:,:,k-1) - xyz_VelLat(:,:,k) )

       xyr_TempFlux(:,:,k) = xyr_TempFlux(:,:,k) &
            &               + Cp * xyr_TempTransCoeff(:,:,k) * xyr_Exner(:,:,k) &
            &                * (   xyz_Temp(:,:,k-1) / xyz_Exner(:,:,k-1) &
            &                    - xyz_Temp(:,:,k)   / xyz_Exner(:,:,k)  )

       xyr_QvapFlux(:,:,k) = xyr_QvapFlux(:,:,k) &
            &                 + EL * xyr_QvapTransCoeff(:,:,k) &
            &                   * ( xyz_Qvap(:,:,k-1) - xyz_Qvap(:,:,k) )

    end do

   ! ----  5. ѹ ----

    do k = 2, km 
       xyzo_VelMatrix(:,:,k,0)  = xyzo_VelMatrix(:,:,k,0) + xyr_VelTransCoeff(:,:,k)
       xyzo_VelMatrix(:,:,k,-1) =                         - xyr_VelTransCoeff(:,:,k)

       xyzo_TempMatrix(:,:,k,0)  = xyzo_TempMatrix(:,:,k,0) &
            &                      + Cp * xyr_TempTransCoeff(:,:,k) &
            &                        * xyr_Exner(:,:,k) / xyz_Exner(:,:,k) 
       xyzo_TempMatrix(:,:,k,-1) = - Cp * xyr_TempTransCoeff(:,:,k) &
            &                        * xyr_Exner(:,:,k) / xyz_Exner(:,:,k-1) 

       xyzo_QvapMatrix(:,:,k,0)  = xyzo_QvapMatrix(:,:,k,0) &
            &                      + Cp * xyr_QvapTransCoeff(:,:,k)
       xyzo_QvapMatrix(:,:,k,-1) = - Cp * xyr_QvapTransCoeff(:,:,k) 
    end do

    do k = 1, km-1
       xyzo_VelMatrix(:,:,k,0)  = xyzo_VelMatrix(:,:,k,0) & 
            &                     + xyr_VelTransCoeff(:,:,k+1)
       xyzo_VelMatrix(:,:,k,1)  = - xyr_VelTransCoeff(:,:,k+1) 

       xyzo_TempMatrix(:,:,k,0)  = xyzo_TempMatrix(:,:,k,0) &
            &                       + Cp * xyr_TempTransCoeff(:,:,k+1) &
            &                        * xyr_Exner(:,:,k+1) / xyz_Exner(:,:,k) 
       xyzo_TempMatrix(:,:,k,1)  = - Cp * xyr_TempTransCoeff(:,:,k+1) &
            &                        * xyr_Exner(:,:,k+1) / xyz_Exner(:,:,k+1) 

       xyzo_QvapMatrix(:,:,k,0)  = xyzo_QvapMatrix(:,:,k,0) &
            &                      + Cp * xyr_QvapTransCoeff(:,:,k+1)
       xyzo_QvapMatrix(:,:,k,1)  = - Cp * xyr_QvapTransCoeff(:,:,k+1) 
    end do

    !----------------------------------------------------------------
    !   λ
    !----------------------------------------------------------------
    call EndSub(subname)

  end subroutine physics_verdiff_main


end module physics_verdiff_main_mod
















