!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2005. All rights reserved.
!---------------------------------------------------------------------
                                                                 !=begin
!= Module constants_mod
!
!   * Developers: Morikawa Yasuhiro
!   * Version: $Id: constants.f90,v 1.1.1.1 2005/11/08 14:10:23 morikawa Exp $
!   * Tag Name: $Name:  $
!   * Change History: 
!
!== Overview
!
!This module set physical constants.
!Default value is standard condition on the earth.
!These values could be changed by NAMELIST.
!
!ʪꤹ뤿Υ⥸塼Ǥ롣
!ǥեȤǤϵɸ֤ͤäƤ뤬
!NAMELIST ˤѹ뤳ȤǽǤ롣
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!
                                                                 !=end

module constants_mod
                                                                 !=begin
  !== Dependency
  use type_mod, only : REKIND, DBKIND, INTKIND, TOKEN, STRING
                                                                 !=end
  implicit none
                                                                 !=begin
  !== Public Interface
  private
  public :: constants_init, constants_end  ! subroutines
  public :: & ! variables
       &    PI, R0, Omega, Grav, Cp, RAir, EL, CpVap, RVap,  &
       &    DH2O, EpsV, ES0, StB, FKarm, EpsVT, SecPerDay,   &
       &    EFoldTime, TempAve, TimeFilter, VisOrder,        &
       &    TimeFilterStepInt

  ! follow data is default values.

  real(DBKIND), save  :: PI        = 3.141592653589793 ! ߼Ψ
  real(DBKIND), save  :: R0        = 6.371d6           ! Ⱦ
  real(DBKIND), save  :: Omega     = 7.292d-5          ! ž®
  real(DBKIND), save  :: Grav      = 9.8d0             ! ϲ®

  real(DBKIND), save  :: Cp        = 1004.6d0          ! 絤갵Ǯ
  real(DBKIND), save  :: RAir      = 287.04d0          ! 絤
  real(DBKIND), save  :: EL        = 2.5d6             ! ζŷǮ
  real(DBKIND), save  :: CpVap     = 1810.0d0          ! 갵Ǯ
  real(DBKIND), save  :: RVap      = 461.0d0           ! 
  real(DBKIND), save  :: DH2O      = 1000.0d0          ! ̩
  real(DBKIND), save  :: EpsV      = 0.6226464208      ! 絤ʬ
  real(DBKIND), save  :: ES0       = 611.0d0           ! ˰¾У
  real(DBKIND), save  :: StB       = 5.67d-8           ! Stefan-Boltzman
  real(DBKIND), save  :: FKarm     = 0.4d0             ! Karman 
  real(DBKIND), save  :: EpsVT     = 0.6060479376      ! 1/-1

  real(DBKIND), save  :: SecPerDay = 86400.0d0         ! 1ÿ 

  real(DBKIND), save  :: EFoldTime = 8640.0d0          ! ȿФ e-folding time
  real(DBKIND), save  :: TempAve   = 300.0             ! ʿѲ
  real(DBKIND), save  :: TimeFilter= 0.05              ! ֥ե륿

  integer(INTKIND), save ::  VisOrder  = 4             ! ĶǴμ
  integer(INTKIND), save :: TimeFilterStepInt = 1     ! ֥ե륿륹ƥå״ֳ
                                                                 !=end

  logical           ,save:: constants_initialized = .false.
  character(STRING),parameter:: version = &
       & '$Id: constants.f90,v 1.1.1.1 2005/11/08 14:10:23 morikawa Exp $'
  character(STRING),parameter:: tagname = '$Name:  $'

contains
                                                                 !=begin
  !== Procedure Interface
  !
  !=== Initialize module and acquire NAMELIST
  !
  !⥸塼NAMELIST ͤ롣
  !NAMELIST ͤǤʤΤ˴ؤƤϾ嵭Υǥեͤ
  !Ѥ롣
  !
  !NAMELIST եϡᥤץˤ ((< nmlfile_mod >)) 
  !((< nmlfile_init >)) ǻꤵ뤳ȤꤵƤ뤬
  !⤷⤳ν롼˻ꤵƤʤС
  !((< nmlfile_init >)) ΥǥեȤǻꤵ NAMELIST ե
  !ɤࡣ
  !
  subroutine constants_init
  !==== Dependency
    use type_mod   , only : REKIND, DBKIND, INTKIND, TOKEN, STRING
    use nmlfile_mod, only : nmlfile_init, nmlfile_open, nmlfile_close
    use dc_trace   , only : BeginSub, EndSub, DbgMessage
    use dc_message , only : MessageNotify
                                                                 !=end
    implicit none
    !
    ! This namelist is require physical constants
    namelist /constants_nml/ &

         & PI                , & ! ߼Ψ
         & R0                , & ! Ⱦ
         & Omega             , & ! ž®
         & Grav              , & ! ϲ®

         & Cp                , & ! 絤갵Ǯ
         & RAir              , & ! 絤
         & EL                , & ! ζŷǮ
         & CpVap             , & ! 갵Ǯ
         & RVap              , & ! 
         & DH2O              , & ! ̩
         & EpsV              , & ! 絤ʬ
         & ES0               , & ! ˰¾У
         & StB               , & ! Stefan-Boltzman
         & FKarm             , & ! Karman 
         & EpsVT             , & ! 1/-1

         & SecPerDay         , & ! 1ÿ

         & EFoldTime         , & ! ȿФ e-folding time
         & TempAve           , & ! ʿѲ
         & TimeFilter        , & ! ֥ե륿
         & TimeFilterStepInt , & ! ֥ե륿륹ƥå״ֳ
         & VisOrder              ! ĶǴμ
                                                                 !=end

    integer(INTKIND)            :: nmlstat, nmlunit
    logical                     :: nmlreadable
    character(STRING), parameter:: subname = "constants_init"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if (constants_initialized) then
       call EndSub( subname, '%c is already called', c1=trim(subname) )
       return
    else
       constants_initialized = .true.
    endif

    !----------------------------------------------------------------
    !   Version identifier
    !----------------------------------------------------------------
    call DbgMessage('%c :: %c', c1=trim(version), c2=trim(tagname))

    !----------------------------------------------------------------
    !   read constants_nml
    !----------------------------------------------------------------
    call nmlfile_init
    call nmlfile_open(nmlunit, nmlreadable)
    if (nmlreadable) then
       read(nmlunit, nml=constants_nml, iostat=nmlstat)
       call DbgMessage('Stat of NAMELIST constants_nml Input is <%d>', &
            &           i=(/nmlstat/))
       write(0, nml=constants_nml)
    else
       call DbgMessage('Not Read NAMELIST constants_nml')
       call MessageNotify('W', subname, &
            & 'Can not Read NAMELIST constants_nml. Force Use Default Value.')
    end if
    call nmlfile_close

    call EndSub( subname )
  end subroutine constants_init


                                                                 !=begin
  !=== Terminate module
  !
  !NAMELIST ɤ߹ͤ˴ǥեȤ᤹ͤ
  !
  subroutine constants_end
  !==== Dependency
    use dc_trace,    only : BeginSub, EndSub, DbgMessage
                                                                 !=end
    implicit none

    !-----------------------------------------------------------------
    !   ѿ
    !-----------------------------------------------------------------
    !----- ѿ -----
    character(len = *),  parameter:: subname = "constants_end"
  continue

    !----------------------------------------------------------------
    !   Check Initialization
    !----------------------------------------------------------------
    call BeginSub(subname)
    if ( .not. constants_initialized) then
       call EndSub( subname, 'constants_init was not called', &
            &       c1=trim(subname) )
       return
    else
       constants_initialized = .false.
    endif

    !----------------------------------------------------------------
    !   Reset to default value
    !----------------------------------------------------------------
    PI        = 3.141592653589793  ! ߼Ψ
    R0        = 6.371d6            ! Ⱦ
    Omega     = 7.292d-5           ! ž®
    Grav      = 9.8d0              ! ϲ®

    Cp        = 1004.6d0           ! 絤갵Ǯ
    RAir      = 287.04d0           ! 絤
    EL        = 2.5d6              ! ζŷǮ
    CpVap     = 1810.0d0           ! 갵Ǯ
    RVap      = 461.0d0            ! 
    DH2O      = 1000.0d0           ! ̩
    EpsV      = 0.6226464208       ! 絤ʬ
    ES0       = 611.0d0            ! ˰¾У
    StB       = 5.67d-8            ! Stefan-Boltzman
    FKarm     = 0.4d0              ! Karman 
    EpsVT     = 0.6060479376       ! 1/-1

    SecPerDay = 86400.0d0          ! 1ÿ

    EFoldTime = 8640.0d0           ! ȿФ e-folding time
    TempAve   = 300.0              ! ʿѲ
    TimeFilter= 0.05               ! ֥ե륿
    TimeFilterStepInt = 1          ! ֥ե륿륹ƥå״ֳ

    call EndSub(subname)
  end subroutine constants_end


end module constants_mod
