!= ϳز (ڥȥˡ, Arakawa and Suarez (1983))
!
!= Dynamical process (Spectral method, Arakawa and Suarez (1983))
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dynamics_hspl_vas83.F90,v 1.40 2009-03-16 06:29:27 morikawa Exp $
! Tag Name::  $Name: dcpam5-20090405 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module dynamics_hspl_vas83
  !
  != ϳز (ڥȥˡ, Arakawa and Suarez (1983))
  !
  != Dynamical Core (Spectral method, Arakawa and Suarez (1983))
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ϳز黻⥸塼Ǥ. 
  ! ʿΥ˥ڥȥˡ (Bourke, 1988) , 
  ! ľΥˤ Arakawa and Suarez (1983) ѤƤޤ.
  !
  ! ʬˡˤϥ꡼ץեåѤƤޤ.
  ! ǥեȤǤ, $ \Delta t $ 礭Ȥ뤿, ȹ 
  ! ߥץꥷåˡŬѤƤޤ. 
  ! NAMELIST#dynamics_hspl_vas83_nml  TimeIntegScheme ѹ뤳Ȥ, 
  ! ȹ򥨥ץꥷåˡˤäƲ򤯤ȤǽǤ.
  !
  ! This is a dynamical core module. Spectral method (Bourke, 1988)
  ! (for horizontal) and Arakawa and Suarez (1983) 
  ! method (for vertical) are used.
  !
  ! Leap-frog scheme is used as time integration. 
  ! By default, semi-implicit scheme is applied to gravitational terms 
  ! for extension of $ \Delta t $ . 
  ! Explicit scheme can be applied to gravitational terms by changing
  ! "TimeIntegScheme" in "NAMELIST#dynamics_hspl_vas83_nml". 
  !
  !== Procedures List
  !
  ! Dynamics         :: ϳط׻
  ! DynamicsFinalize :: λ (⥸塼ѿγդ)
  ! ------------     :: ------------
  ! Dynamics         :: Calculate dynamics
  ! DynamicsFinalize :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
  ! NAMELIST#dynamics_hspl_vas83_nml
  !
  !== References
  !
  ! * Bourke, W. P., 1988:
  !   Spectral methods in global climate and weather 
  !   prediction models.
  !   <i> Physically Based Modelling and Simulation of
  !   Climates and Climatic Change. Part I.</i>,
  !   M.E. Schlesinger (ed.),
  !   Kluwer Academic Publishers, Dordrecht, 169--220.
  !
  ! * Arakawa, A., Suarez, M. J., 1983:
  !   Vertical differencing of the primitive equations
  !   in sigma coordinates.
  !   <i>Mon. Wea. Rev.</i>, <b>111</b>, 34--35.

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: nmax, & ! ȿ. 
                             ! Maximum truncated wavenumber
    &                imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &  ! ټ¿. Double precision. 
    &                 TOKEN  ! .   Keywords. 

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: Dynamics, DynamicsFinalize

  ! ѿ
  ! Public variables
  !
  logical, save, public:: dynamics_hspl_vas83_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !

  character(TOKEN), save:: TimeIntegScheme
                              ! ʬˡ. 
                              ! ʲˡǽ. 
                              !
                              ! Time integration scheme. 
                              ! Available schemes are as follows.
                              ! 
                              ! * "Semi-implicit"
                              ! * "Explicit"
                              ! 

  real(DP), save:: DelTimeSave
                              !  $ \Delta t $ [s]. 
                              ! ˡΤηκɬ
                              ! å˻Ѥ. 
                              ! 
                              ! $ \Delta t $ [s] at previous step
                              ! This is used to check necessity of 
                              ! regeneration of coefficients for 
                              ! implicit method. 

  ! ʿȻ
  ! Coefficient of horizontal diffusion
  !
  real(DP), allocatable:: wz_LaplaCoef (:,:)
                              ! $ \nabla^2_{\sigma} = -n \times (n+1) $ . 
                              ! ץ饷η. 
                              ! Laplacian coefficient
  real(DP), allocatable:: wz_HDifCoefM (:,:)
                              ! $ -K_{HD} [(-1)^{N_D/2}\nabla^{N_D}- (2/a^2)^{N_D/2}] $ . 
                              ! ư̿ʿȻ. 
                              ! Coefficient of horizontal momentum diffusion
  real(DP), allocatable:: wz_HDifCoefT (:,:)
                              ! $ -(-1)^{N_D/2}K_{HD}\nabla^{N_D} $ . 
                              ! Ǯ, ʿȻ. 
                              ! Coefficient of horizontal thermal and water diffusion

  ! NonLinearOnGrid ǻѤ뷸
  ! Coefficients for "NonLinearOnGrid", etc.
  !
  real(DP), allocatable:: xy_SinLat (:,:)
                              ! $ \sin \varphi $ . 
  real(DP), allocatable:: xy_CosLat (:,:)
                              ! $ \cos \varphi $ . 
  real(DP), allocatable:: xy_Cori (:,:)
                              ! $ f\equiv 2\Omega\sin\varphi $ . 
                              ! ꥪѥ᡼. Coriolis parameter
  real(DP), allocatable:: z_HydroAlpha (:)
                              ! $ \alpha $ . ſ尵μη. 
                              ! Coefficient in hydrostatic equation.
  real(DP), allocatable:: z_HydroBeta (:)
                              ! $ \beta $ . ſ尵μη. 
                              ! Coefficient in hydrostatic equation.
  real(DP), allocatable:: z_TInpCoefA (:)
                              ! $ a $ . ٱľ֤η. 
                              ! Coefficient for vertical interpolation of temperature
  real(DP), allocatable:: z_TInpCoefB (:)
                              ! $ b $ . ٱľ֤η. 
                              ! Coefficient for vertical interpolation of temperature
  real(DP), allocatable:: z_TInpCoefK (:)
                              ! $ \kappa $ . ٱľ֤η. 
                              ! Coefficient for vertical interpolation of temperature
  real(DP), allocatable:: z_RefTemp (:)
                              ! $ \overline{T} $ . ಹ (٥). 
                              ! Reference temperature on full sigma level
  real(DP), allocatable:: r_RefTemp (:)
                              ! $ \hat{\overline{T}} $ . ಹ (Ⱦ٥). 
                              ! Reference temperature on half sigma level

  ! TimeIntegration ǻѤ뷸
  ! Coefficients for "TimeIntegration"
  !
  real(DP), allocatable:: z_siMtxG (:)
                              ! $ G = C_p \kappa T $
  real(DP), allocatable:: zz_siMtxH (:,:)
                              ! $ h = QS - R $
  real(DP), allocatable:: zz_siMtxWH (:,:)
                              ! $ W h $
  real(DP), allocatable:: zz_siMtxGCt (:,:)
                              ! $ G C^{T} $ ( $ C = \Delta \sigma $ )

  real(DP), allocatable:: wzz_siMtxLU(:,:,:)
                              ! ߥץꥷåȹ LU ʬ. 
                              ! LU decomposition for semi-implicit matrix
  integer, allocatable:: wz_siMtxPiv(:,:)
                              ! ߥץꥷåȹΥԥܥå. 
                              ! Pivot for semi-implicit matrix

  ! ֥롼 SemiImplMatrix ǻѤ뷸
  ! Coefficients used in a subroutine "SemiImplMatrix"
  !
  real(DP), save, allocatable:: zz_siMtxW (:,:)
                              ! $ W $ . 
                              ! ȯμǤȹθ̤ˤ벹η. 
                              ! Coefficient for correction of temperature 
                              ! by effort of linear gravitational terms

  real(DP), save, allocatable:: zz_siMtxQ (:,:)
                              ! $ Q = \DD{T}{\sigma} $
  real(DP), save, allocatable:: zz_siMtxS (:,:)
                              ! $ S = \DD{\sigma}{t} $
  real(DP), save, allocatable:: zz_siMtxQS (:,:)
                              ! $ QS $ . 
                              ! ѿ $ \sigma $ ήθ̤. 
                              ! This variable  corresponds to effort of $ \sigma $ advection
  real(DP), save, allocatable:: zz_siMtxR (:,:)
                              ! $ R $ . 
                              ! ȯȳݤ碌뤳ȤǵѲθ̤Ȥʤ.
                              ! Product R and divergence become effort of 
                              ! surface pressure tendency.
                              ! $ RD = \kappa T 
                              ! (\DD{\pi}{t} + \Dinv{\sigma}\DD{\sigma}{t}) $ .
  integer, save, allocatable:: nmo (:,:,:)
                              ! ڥȥź. 
                              ! Spectral subscript expression
  real(DP), save, allocatable:: zz_siMtxM (:,:)
                              !  $ \underline{M} $. 
                              ! Matrix $ \underline{M} $
  integer, save, allocatable:: z_siMtxPivWork(:)
                              ! ΥԥܥåȺκѿ. 
                              ! Work variable for pivot

  character(*), parameter:: module_name = 'dynamics_hspl_vas83'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20090405 $' // &
    & '$Id: dynamics_hspl_vas83.F90,v 1.40 2009-03-16 06:29:27 morikawa Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface Dynamics
    module procedure Dynamics
  end interface

  interface DynamicsFinalize
    module procedure DynamicsFinalize
  end interface

contains

  subroutine Dynamics( &
    & xyz_UB,      xyz_VB,      xyz_TempB,      xyz_QVapB,   xy_PsB, & ! (in)
    & xyz_UN,      xyz_VN,      xyz_TempN,      xyz_QVapN,   xy_PsN, & ! (in)
    & xyz_DUDtPhy, xyz_DVDtPhy, xyz_DTempDtPhy, xyz_DQVapDtPhy, &      ! (in)
    & xy_SurfHeight, &                                                 ! (in)
    & xyz_UA,      xyz_VA,      xyz_TempA,      xyz_QVapA,   xy_PsA  & ! (out)
    & )
    !
    ! ϳزα黻Ԥ, Ϳ줿 $ t-\Delta t $  $ t $ 
    ! ® (xyz_UB, xyz_UN), ® (xyz_VB, xyz_VN), 
    !  (xyz_TempB, xyz_TempN), 漾 (xyz_QVapB, xyz_QVapN), 
    ! ɽ̵ (xyz_PsB, xyz_PsN), ɽ̹ (xy_SurfHeight) , 
    ! $ t+\Delta t $ 
    ! ® (xyz_UA), ® (xyz_VA),  (xyz_TempA), 
    ! 漾 (xyz_QVapA), ɽ̵ (xyz_PsA) ֤ޤ. 
    !
    ! ̤ʪץˤ뱲, ȯ, , 漾Ѳ, 
    ! ϳزѲ­ƼΥƥåפ׻ˤ, 
    ! Ѳ xyz_DUDtPhy, xyz_DVDtPhy, xyz_DTempDtPhy, xyz_DQVapDtPhy
    ! ͿƤ. 
    !
    ! ʬˡˤϥ꡼ץեåѤƤޤ.
    ! ǥեȤǤ, $ \Delta t $ 礭Ȥ뤿, ȹ 
    ! ߥץꥷåˡŬѤƤޤ.
    ! NAMELIST#dynamics_hspl_vas83_nml  TimeIntegScheme ѹ뤳Ȥ, 
    ! ȹ򥨥ץꥷåˡˤäƲ򤯤ȤǽǤ.
    !
    ! Calculate dynamical processes. 
    ! Eastward wind (xyz_UB, xyz_UN), 
    ! northward wind (xyz_VB, xyz_VN), 
    ! temperature (xyz_TempB, xyz_TempN), 
    ! specific humidity (xyz_QVapB, xyz_QVapN), 
    ! surface pressure (xyz_PsB, xyz_PsN) at $ t-\Delta t $ and $ t $, 
    ! and surface height (xy_SurfHeight) are input, 
    ! and 
    ! eastward wind (xyz_UA), northward wind (xyz_VA), 
    ! temperature (xyz_TempA), 
    ! specific humidity (xyz_QVapA), surface pressure (xyz_PsA) 
    ! are returned.
    !
    ! In order to add tendencies of vorticity, divergence, 
    ! temperature and specific humidity by another physical process to 
    ! tendencies of this dynamical process 
    ! and to calculate the values at next time step, 
    ! give these tendencies to 
    ! "xyz_DUDtPhy", "xyz_DVDtPhy", "xyz_DTempDtPhy", "xyz_DQVapDtPhy"
    !
    ! Leap-frog scheme is used as time integration. 
    ! By default, semi-implicit scheme is applied to gravitational terms 
    ! for extension of $ \Delta t $ . 
    ! Explicit scheme can be applied to gravitational terms by changing
    ! "TimeIntegScheme" in "NAMELIST#dynamics_hspl_vas83_nml". 
    !

    ! ⥸塼 ; USE statements
    !

    use constants, only: &
      & RPlanet, &
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & Grav
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ. 
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ. 
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ. 
                               ! Number of vertical level

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $ [s]
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

#ifdef LIB_MPI
    ! MPI  SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library MPI version, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_mpi_module, only: wa_Lapla_wa, w_Lapla_w, wa_LaplaInv_wa, &
      & wa_DivLambda_xya => wa_DivLambda_xva, &
      & wa_DivMu_xya => wa_DivMu_xva, &
      & xy_GradLambda_w => xv_GradLambda_w, &
      & xya_GradLambda_wa => xva_GradLambda_wa, &
      & xy_GradMu_w => xv_GradMu_w, &
      & xya_GradMu_wa => xva_GradMu_wa, &
      & w_xy   => w_xv,   xy_w   => xv_w, &
      & wa_xya => wa_xva, xya_wa => xva_wa
#else
    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_module, only: wa_Lapla_wa, w_Lapla_w, wa_LaplaInv_wa, &
      & wa_DivLambda_xya, &
      & wa_DivMu_xya, &
      & xy_GradLambda_w, &
      & xya_GradLambda_wa, &
      & xy_GradMu_w, &
      & xya_GradMu_wa, &
      & w_xy, xy_w, &
      & wa_xya, xya_wa
#endif

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: DP      ! ټ¿. Double precision. 

    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in):: xyz_UB    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t-\Delta t) $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_VB    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t-\Delta t) $ .   ®. Northward wind
    real(DP), intent(in):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t-\Delta t) $ .   . Temperature
    real(DP), intent(in):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t-\Delta t) $ .   漾. Specific humidity
    real(DP), intent(in):: xy_PsB    (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . ɽ̵. Surface pressure

    real(DP), intent(in):: xyz_UN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ .     ®. Eastward wind
    real(DP), intent(in):: xyz_VN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ .     ®. Northward wind
    real(DP), intent(in):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ .     . Temperature
    real(DP), intent(in):: xyz_QVapN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t) $ .     漾. Specific humidity
    real(DP), intent(in):: xy_PsN    (0:imax-1, 1:jmax)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure

    real(DP), intent(in):: xyz_DUDtPhy    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{u}{t}\right)^{phy} $ . 
                              ! Ϲ (ʪ) ˤ®Ѳ. 
                              ! Eastward wind tendency by external force terms (physical processes)
    real(DP), intent(in):: xyz_DVDtPhy    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{v}{t}\right)^{phy} $ . 
                              ! Ϲ (ʪ) ˤ®Ѳ. 
                              ! Northward wind tendency by external force terms (physical processes)
    real(DP), intent(in):: xyz_DTempDtPhy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{T}{t}\right)^{phy} $ . 
                              ! Ϲ (ʪ) ˤ벹Ѳ. 
                              ! Temperature tendency by external force terms (physical processes)
    real(DP), intent(in):: xyz_DQVapDtPhy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{q}{t}\right)^{phy} $ . 
                              ! Ϲ (ʪ) ˤ漾Ѳ. 
                              ! Temperature tendency by external force terms (physical processes)

    real(DP), intent(in):: xy_SurfHeight (0:imax-1, 1:jmax)
                              ! $ z_s $ . ɽ̹. 
                              ! Surface height. 

    real(DP), intent(out):: xyz_UA    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t+\Delta t) $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_VA    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t+\Delta t) $ .   ®. Northward wind
    real(DP), intent(out):: xyz_TempA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t+\Delta t) $ .   . Temperature
    real(DP), intent(out):: xyz_QVapA (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t+\Delta t) $ .   漾. Specific humidity
    real(DP), intent(out):: xy_PsA    (0:imax-1, 1:jmax)
                              ! $ p_s (t+\Delta t) $ . ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_UCosLatN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ U (t) = u (t) \times \cos \varphi $ .
    real(DP):: xyz_VCosLatN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ V (t) = v (t) \times \cos \varphi $ .
    real(DP):: xyz_VorN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \zeta (t) $ . . Vorticity
    real(DP):: xyz_DivN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ D (t) $ .     ȯ. Divergence

    real(DP):: xy_PiN (0:imax-1, 1:jmax)
                              ! $ \pi = \ln p_s $
    real(DP):: w_PiN ((nmax+1)**2)
                              ! $ \pi $ ڥȥ
    real(DP):: xy_GradLambdaPiN (0:imax-1, 1:jmax)
                              ! $ \DP{\pi}{\lambda} $
    real(DP):: xy_GradMuPiN (0:imax-1, 1:jmax)
                              ! $ (1-\mu^2) \DP{\pi}{\mu} $

    real(DP):: xyz_UAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ U_A (t) $ . ư̰ή. 
                              ! Eastward advection of momentum
    real(DP):: xyz_VAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ V_A (t) $ . ̱ư̰ή. 
                              ! Northward advection of momentum
    real(DP):: xyz_TempNonLinearN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ H (t) $ . ٻѲ. 
                              ! Temperature tendency
    real(DP):: xyz_QVapNonLinearN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ R (t) $ . 漾Ѳ. 
                              ! Specific humidity tendency
    real(DP):: xyz_KinEngyN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ KE (t) $ . ưͥ륮. 
                              ! Kinetic energy
    real(DP):: xyz_TempUAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ UT' (t) $ . ή. 
                              ! Eastward advection of temperature
    real(DP):: xyz_TempVAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ VT' (t) $ . ̰ή. 
                              ! Northward advection of temperature
    real(DP):: xyr_SigDotN (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \dot{\sigma} $ .
                              ! ľή. Vertical flow
    real(DP):: xy_DPiDtN (0:imax-1, 1:jmax)
                              ! $ Z $ . ɽ̵Ѳ. 
                              ! Surface pressure tendency
    real(DP):: xyz_QVapUAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ Uq (t) $ . 漾ή. 
                              ! Eastward advection of specific humidity
    real(DP):: xyz_QVapVAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ Vq (t) $ . 漾̰ή. 
                              ! Northward advection of specific humidity
    real(DP):: wz_DVorDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{\zeta}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Vorticity tendency (spectral)
    real(DP):: wz_DDivDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{D}{t} (t) $ . ȯѲ (ڥȥ). 
                              ! Divergence tendency (spectral)
    real(DP):: wz_DTempDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{T}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Temperature tendency (spectral)
    real(DP):: wz_DQVapDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{q}{t} (t) $ . 漾Ѳ (ڥȥ). 
                              ! Specific humidity tendency (spectral)
    real(DP):: w_DPiDtN ((nmax+1)**2)
                              ! $ \DD{p_s}{t} (t) $ . ɽ̵Ѳ (ڥȥ). 
                              ! Surface pressure tendency (spectral)
    real(DP):: xyz_UCosLatB   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ U (t-\Delta t) = u (t-\Delta t) \times \cos \varphi $ .
    real(DP):: xyz_VCosLatB   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ V (t-\Delta t) = v (t-\Delta t) \times \cos \varphi $ .
    real(DP):: wz_VorB ((nmax+1)**2, 1:kmax)
                              ! $ \zeta (t-\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP):: wz_DivB ((nmax+1)**2, 1:kmax)
                              ! $ D (t-\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP):: wz_TempB ((nmax+1)**2, 1:kmax)
                              ! $ T (t-\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP):: w_PiB ((nmax+1)**2)
                              ! $ \pi = \ln p_s (t-\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP):: wz_QVapB ((nmax+1)**2, 1:kmax)
                              ! $ q (t-\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)
    real(DP):: xyz_DUDtPhyCosLat   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{u}{t}\right)^{phy} \times \cos \varphi $ .
    real(DP):: xyz_DVDtPhyCosLat   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \left(\DP{v}{t}\right)^{phy} \times \cos \varphi $ . 
    real(DP):: wz_VorA ((nmax+1)**2, 1:kmax)
                              ! $ \zeta (t+\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP):: wz_DivA ((nmax+1)**2, 1:kmax)
                              ! $ D (t+\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP):: wz_TempA ((nmax+1)**2, 1:kmax)
                              ! $ T (t+\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP):: w_PiA ((nmax+1)**2)
                              ! $ \pi = \ln p_s (t+\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP):: wz_QVapA ((nmax+1)**2, 1:kmax)
                              ! $ q (t+\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)

    real(DP):: wz_Psi ((nmax+1)**2, 1:kmax)
                              ! $ \psi $ . ήؿ. Streamline function 
    real(DP):: wz_Chi ((nmax+1)**2, 1:kmax)
                              ! $ \chi $ . ݥƥ󥷥. Potential
    real(DP):: xyz_UCosLatA   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ U (t+\Delta t) = u (t+\Delta t) \times \cos \varphi $ .
    real(DP):: xyz_VCosLatA   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ V (t+\Delta t) = v (t+\Delta t) \times \cos \varphi $ .

    real(DP):: wz_VorDiffA ((nmax+1)**2, 1:kmax)
                              ! $ \mathscr{D}(\zeta) $ . 
                              ! ư̿ʿȻˤ뱲Ѳ (ڥȥ). 
                              ! Vorticity tendency by 
                              ! horizontal momentum diffusion (spectral)
    real(DP):: wz_DivDiffA ((nmax+1)**2, 1:kmax)
                              ! $ \mathscr{D}(D) $ . 
                              ! ư̿ʿȻˤȯѲ (ڥȥ). 
                              ! Divergence tendency by 
                              ! horizontal momentum diffusion (spectral)
    real(DP):: wz_PsiDiff ((nmax+1)**2, 1:kmax)
                              ! ư̿ʿȻˤήؿ $ \psi $ Ѳ
                              ! Streamline function tendency by 
                              ! horizontal momentum diffusion
    real(DP):: wz_ChiDiff ((nmax+1)**2, 1:kmax)
                              ! ư̿ʿȻˤݥƥ󥷥 $ \chi $ Ѳ
                              ! Potential tendency by 
                              ! horizontal momentum diffusion
    real(DP):: xyz_UDiff (0:imax-1, 1:jmax, 1:kmax)
                              ! ư̿ʿȻˤѲ. 
                              ! Eastward wind tendency by 
                              ! horizontal momentum diffusion
    real(DP):: xyz_VDiff (0:imax-1, 1:jmax, 1:kmax)
                              ! ư̿ʿȻˤѲ. 
                              ! Northward wind tendency by 
                              ! horizontal momentum diffusion

    ! ɽ̹ٴϢ
    ! Surface height etc. 
    !
    real(DP):: w_SurfGeoPot ((nmax+1)**2)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential

    ! ץꥷåˡΤκѿ
    ! Work variables for explicit scheme
    !
    real(DP):: xyz_exWTGPi (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ .
    real(DP):: xyz_exWT (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \underline{W} \Dvect{T} $ .
    real(DP):: xyz_exGPi (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Dvect{G} \pi $ .

    real(DP):: xyz_exHDiv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \underline{h} \Dvect{D} $ .


    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. dynamics_hspl_vas83_inited ) call DynamicsInit

    ! TimeIntegration ǻѤ뷸
    ! Configure coefficients for "TimeIntegration"
    !
    call SemiImplMatrix

    ! ɽ̵ζѲη׻
    ! Calculate spatial surface pressure tendency
    !
    xy_PiN = log( xy_PsN )
    w_PiN = w_xy( xy_PiN )

    xy_GradLambdaPiN = xy_GradLambda_w( w_PiN ) / RPlanet
    xy_GradMuPiN     = xy_GradMu_w    ( w_PiN ) / RPlanet

    ! ®鱲ȯη׻
    ! Calculate vorticity and divergence from wind velocity
    ! 
    do k = 1, kmax
      xyz_UCosLatN(:,:,k) = xyz_UN(:,:,k) * xy_CosLat
      xyz_VCosLatN(:,:,k) = xyz_VN(:,:,k) * xy_CosLat
    end do
    xyz_VorN = xya_wa(   wa_DivLambda_xya( xyz_VCosLatN )  &
      &                - wa_DivMu_xya(     xyz_UCosLatN ) ) / RPlanet
    xyz_DivN = xya_wa(   wa_DivLambda_xya( xyz_UCosLatN )  &
      &                + wa_DivMu_xya(     xyz_VCosLatN ) ) / RPlanet

    ! ʻǤϳعη׻
    ! Calculate non-linear dynamical terms on grid points
    !
    call NonLinearOnGrid( &
      & xyz_UN,           xyz_VN, &        ! (in)
      & xyz_VorN,         xyz_DivN, &      ! (in)
      & xyz_TempN,        xyz_QVapN, &     ! (in)
      & xy_GradLambdaPiN, xy_GradMuPiN, &  ! (in)
!
      & xyz_UAdvN,        xyz_VAdvN, &     ! (out)
      & xyz_TempNonLinearN, &              ! (out)
      & xyz_QVapNonLinearN, &              ! (out)
      & xyz_KinEngyN, &                    ! (out)
      & xyz_TempUAdvN,    xyz_TempVAdvN, & ! (out)
      & xyr_SigDotN,      xy_DPiDtN, &     ! (out)
      & xyz_QVapUAdvN,    xyz_QVapVAdvN )  ! (out)


    ! ڥȥѲη׻
    ! Calculate spectral tendency terms
    !

    ! ٤λѲ (ڥȥ) η׻
    ! Calculate vorticity tendency (spectral)
    !
    wz_DVorDtN =   (   wa_DivLambda_xya( xyz_VAdvN )  &
      &              - wa_DivMu_xya(     xyz_UAdvN ) ) / RPlanet

    ! ȯλѲ (ڥȥ) η׻
    ! Calculate divergence tendency (spectral)
    !
    wz_DDivDtN =   (   wa_DivLambda_xya( xyz_UAdvN )  &
      &              + wa_DivMu_xya(     xyz_VAdvN ) ) / RPlanet &
      &          - wa_Lapla_wa( wa_xya(xyz_KinEngyN) ) / RPlanet**2

    ! ٤λѲ (ڥȥ) η׻
    ! Calculate temperature tendency (spectral)
    !
    wz_DTempDtN = - (   wa_DivLambda_xya( xyz_TempUAdvN )  &
      &               + wa_DivMu_xya(     xyz_TempVAdvN ) ) / RPlanet &
      &           + wa_xya( xyz_TempNonLinearN )

    ! ɽ̵λѲ (ڥȥ) η׻
    ! Calculate surface pressure tendency (spectral)
    !
    w_DPiDtN = w_xy( xy_DPiDtN )

    ! 漾λѲ (ڥȥ) η׻
    ! Calculate specific humidity tendency (spectral)
    !
    wz_DQVapDtN = - (   wa_DivLambda_xya( xyz_QVapUAdvN )  &
      &               + wa_DivMu_xya(     xyz_QVapVAdvN ) ) / RPlanet &
      &           + wa_xya( xyz_QVapNonLinearN )

    ! ɽݥƥ󥷥η׻
    ! Calculate surface geo-potential
    !
    w_SurfGeoPot = w_xy( Grav * xy_SurfHeight )

    ! ץꥷåˡѤݤη׻
    ! Calculate for explicit scheme
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('explicit')

      ! $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ γʻͤη׻
      ! Calculate $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ on grid
      !

      ! $ \underline{W} \Dvect{T} $ η׻
      ! Calculate $ \underline{W} \Dvect{T} $
      !
      call HydroGrid( xyz_TempN, & ! (in)
        &             xyz_exWT )   ! (out)

      ! $ \Dvect{G} \pi $ η׻
      ! Calculate $ \Dvect{G} \pi $
      !
      do k = 1, kmax
        xyz_exGPi(:,:,k) = &
          & CpDry * z_TInpCoefK(k) * z_RefTemp(k) * xy_PiN
      enddo

      ! $ \underline{W} \Dvect{T} + \Dvect{G} \pi $ η׻
      ! Calculate $ \underline{W} \Dvect{T} + \Dvect{G} \pi $
      !
      xyz_exWTGPi = xyz_exWT + xyz_exGPi


      ! $ \underline{h} \Dvect{D} $ γʻͤη׻
      ! Calculate $ \underline{h} \Dvect{D} $ on grid
      !
      xyz_exHDiv = 0.

      do k = 1, kmax
        do kk = 1, kmax
          xyz_exHDiv (:,:,k) = xyz_exHDiv (:,:,k) &
            & + zz_siMtxH (k,kk) * xyz_DivN (:,:,kk)
        enddo
      enddo


      ! ȯ,  (ڥȥ) λѲν
      ! Modify divergence and temperature tencency (spectral)
      !

      ! ȯλѲ (ڥȥ) η׻
      ! Calculate divergence tendency (spectral)
      !
      wz_DDivDtN = wz_DDivDtN &
        & - wa_Lapla_wa( wa_xya( xyz_exWTGPi ) ) / RPlanet**2

      do k = 1, kmax
        wz_DDivDtN(:,k) = wz_DDivDtN(:,k) &
          & - w_Lapla_w( w_SurfGeoPot ) / RPlanet**2
      end do

      ! ٤λѲ (ڥȥ) η׻
      ! Calculate temperature tendency (spectral)
      !
      wz_DTempDtN = wz_DTempDtN - wa_xya( xyz_exHDiv )

    end select


    ! ʻͤ򥹥ڥȥͤ ( $ t-\Delta t$ )
    ! Exchange grid values to spectral values ( $ t-\Delta t$ )
    !
    do k = 1, kmax
      xyz_UCosLatB(:,:,k) = xyz_UB(:,:,k) * xy_CosLat
      xyz_VCosLatB(:,:,k) = xyz_VB(:,:,k) * xy_CosLat
    end do
    wz_VorB =   (   wa_DivLambda_xya( xyz_VCosLatB )  &
      &           - wa_DivMu_xya(     xyz_UCosLatB ) ) / RPlanet
    wz_DivB =   (   wa_DivLambda_xya( xyz_UCosLatB )  &
      &           + wa_DivMu_xya(     xyz_VCosLatB ) ) / RPlanet
    wz_TempB = wa_xya( xyz_TempB )
    wz_QVapB = wa_xya( xyz_QVapB )
    w_PiB    = w_xy( log( xy_PsB ) )


    ! ץˤѲʻҥǡ򥹥ڥȥǡѴ
    ! Convert tendency data on grid by external processes into spectral data
    !
    do k = 1, kmax
      xyz_DUDtPhyCosLat(:,:,k) = xyz_DUDtPhy(:,:,k) * xy_CosLat
      xyz_DVDtPhyCosLat(:,:,k) = xyz_DVDtPhy(:,:,k) * xy_CosLat
    end do
    wz_DVorDtN  =   wz_DVorDtN &
      &           + (   wa_DivLambda_xya( xyz_DVDtPhyCosLat )  &
      &               - wa_DivMu_xya(     xyz_DUDtPhyCosLat ) ) / RPlanet
    wz_DDivDtN  =   wz_DDivDtN &
      &           + (   wa_DivLambda_xya( xyz_DUDtPhyCosLat )  &
      &               + wa_DivMu_xya(     xyz_DVDtPhyCosLat ) ) / RPlanet
    wz_DTempDtN = wz_DTempDtN + wa_xya( xyz_DTempDtPhy )
    wz_DQVapDtN = wz_DQVapDtN + wa_xya( xyz_DQVapDtPhy )

    ! ʬ
    ! Time integration
    !
    call TimeIntegration( &
      & wz_DVorDtN, wz_DDivDtN, wz_DTempDtN, wz_DQVapDtN, w_DPiDtN, & ! (in)
      & wz_VorB,    wz_DivB,    wz_TempB,    wz_QVapB,    w_PiB, &    ! (in)
      & w_SurfGeoPot, &                                               ! (in)
      & wz_VorA,    wz_DivA,    wz_TempA,    wz_QVapA,    w_PiA )     ! (out)

    ! ڥȥͤʻͤ ( $ t+\Delta t$ )
    ! Exchange spectral values to grid values ( $ t+\Delta t$ )
    !
    wz_Psi = wa_LaplaInv_wa( wz_VorA ) * RPlanet**2
    wz_Chi = wa_LaplaInv_wa( wz_DivA ) * RPlanet**2

    xyz_UCosLatA = &
      & (   xya_GradLambda_wa( wz_Chi ) &
      &   - xya_GradMu_wa(     wz_Psi ) ) / RPlanet

    xyz_VCosLatA = &
      & (   xya_GradLambda_wa( wz_Psi ) &
      &   + xya_GradMu_wa(     wz_Chi ) ) / RPlanet

    do k = 1, kmax
      xyz_UA(:,:,k) = xyz_UCosLatA(:,:,k) / xy_CosLat
      xyz_VA(:,:,k) = xyz_VCosLatA(:,:,k) / xy_CosLat
    end do

    xyz_TempA = xya_wa( wz_TempA )
    xyz_QVapA = xya_wa( wz_QVapA )
    xy_PsA = exp( xy_w( w_PiA ) )

    ! Ȼˤ
    ! Correction by diffusion
    !

    ! ư̿ʿȻˤ뱲ȯλѲ
    ! Vorticity and divergence tendency by horizontal diffusion of momentum
    !
    wz_VorDiffA = wz_VorA * wz_HDifCoefM
    wz_DivDiffA = wz_DivA * wz_HDifCoefM


    ! ư̿ʿȻˤ໤Ǯ
    ! Frictional thermal correction by horizontal momentum diffusion
    !
    wz_PsiDiff = wa_LaplaInv_wa( wz_VorDiffA ) * RPlanet**2
    wz_ChiDiff = wa_LaplaInv_wa( wz_DivDiffA ) * RPlanet**2

    xyz_UDiff = &
      & (   xya_GradLambda_wa( wz_ChiDiff ) &
      &   - xya_GradMu_wa(     wz_PsiDiff ) ) / RPlanet

    xyz_VDiff = &
      & (   xya_GradLambda_wa( wz_PsiDiff ) &
      &   + xya_GradMu_wa(     wz_ChiDiff ) ) / RPlanet

    do k = 1, kmax
      xyz_TempA(:,:,k) = xyz_TempA(:,:,k) &
        & - (   xyz_UA(:,:,k) * xyz_UDiff(:,:,k) &
        &     + xyz_VA(:,:,k) * xyz_VDiff(:,:,k)   ) &
        &   / xy_CosLat / CpDry * 2. * DelTime
    end do

    ! ҥȥǡ
    ! History data output
    !
    call DiagOutput( &
      & xyz_UN, xyz_VN, xyz_TempN, xyz_QVapN, xy_PsN, & ! (in)
      & xyr_SigDotN, xy_DPiDtN )                        ! (in)


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine Dynamics

  !-------------------------------------------------------------------

  subroutine NonLinearOnGrid( &
    & xyz_UN,           xyz_VN, &        ! (in)
    & xyz_VorN,         xyz_DivN, &      ! (in)
    & xyz_TempN,        xyz_QVapN, &     ! (in)
    & xy_GradLambdaPiN, xy_GradMuPiN, &  ! (in)
!
    & xyz_UAdvN,        xyz_VAdvN, &     ! (out)
    & xyz_TempNonLinearN, &              ! (out)
    & xyz_QVapNonLinearN, &              ! (out)
    & xyz_KinEngyN, &                    ! (out)
    & xyz_TempUAdvN,    xyz_TempVAdvN, & ! (out)
    & xyr_SigDotN,      xy_DPiDtN, &     ! (out)
    & xyz_QVapUAdvN,    xyz_QVapVAdvN &  ! (out)
    & )
    !
    !  (ȹ) ʻǷ׻ޤ.
    !
    ! Non-linear terms (non gravitational terms) are calculated on
    ! grid points
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & r_Sigma, &            ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma            ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & EpsV
                              ! $ \epsilon_v $ . 
                              ! ʬ. 
                              ! Molecular weight of water vapor

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    implicit none
    real(DP), intent(in):: xyz_UN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u (t) $ . ®. Eastward wind
    real(DP), intent(in):: xyz_VN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v (t) $ . ®. Northward wind
    real(DP), intent(in):: xyz_VorN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \zeta (t) $ . . Vorticity
    real(DP), intent(in):: xyz_DivN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ D (t) $ . ȯ. Divergence
    real(DP), intent(in):: xyz_TempN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T (t) $ . . Temperature
    real(DP), intent(in):: xyz_QVapN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q (t) $ . 漾. Specific humidity
    real(DP), intent(in):: xy_GradLambdaPiN (0:imax-1, 1:jmax)
                              ! $ \DP{\pi}{\lambda} $
    real(DP), intent(in):: xy_GradMuPiN (0:imax-1, 1:jmax)
                              ! $ (1-\mu^2) \DP{\pi}{\mu} $
    real(DP), intent(out):: xyz_UAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ U_A (t) $ . ư̰ή.
                              ! Eastward advection of momentum
    real(DP), intent(out):: xyz_VAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ V_A (t) $ . ̱ư̰ή. 
                              ! Northward advection of momentum
    real(DP), intent(out):: xyz_TempNonLinearN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \hat{H} (t) $ . ٻѲ. 
                              ! Temperature tendency
    real(DP), intent(out):: xyz_QVapNonLinearN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ R (t) $ . 漾Ѳ. 
                              ! Specific humidity tendency
    real(DP), intent(out):: xyz_KinEngyN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ KE (t) $ . ưͥ륮. 
                              ! Kinetic energy
    real(DP), intent(out):: xyz_TempUAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ UT' (t) $ . ή. 
                              ! Eastward advection of temperature
    real(DP), intent(out):: xyz_TempVAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ VT' (t) $ . ̰ή. 
                              ! Northward advection of temperature
    real(DP), intent(out):: xyr_SigDotN (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \dot{\sigma} (t) $ .
                              ! ľή. Vertical flow
    real(DP), intent(out):: xy_DPiDtN (0:imax-1, 1:jmax)
                              ! $ Z (t) $ . ɽ̵Ѳ. 
                              ! Surface pressure tendency
    real(DP), intent(out):: xyz_QVapUAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ Uq (t) $ . 漾ή. 
                              ! Eastward advection of specific humidity
    real(DP), intent(out):: xyz_QVapVAdvN (0:imax-1, 1:jmax, 1:kmax)
                              ! $ Vq (t) $ . 漾̰ή. 
                              ! Northward advection of specific humidity

    !-----------------------------------
    !  ѿ
    !  Work variables
    real(DP):: xyz_UCosLatN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ U (t) = u (t) \times \cos \varphi $ .
    real(DP):: xyz_VCosLatN   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ V (t) = v (t) \times \cos \varphi $ .
    real(DP):: xyz_PiAdv (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Dvect{v} \cdot \nabla \pi $ . 
                              ! $ \pi $ ΰή. Advection of $ \pi $
    real(DP):: xyz_PiAdvSum (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \sum_k^K(\Dvect{v}\cdot\nabla\pi)\Delta\sigma $ . 
                              ! $ \pi $ ήѲ. Integral downward of advection of $ \pi $
    real(DP):: xyz_DivSum (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \sum_k^K D\Delta\sigma $ .
                              ! ȯѲ. Integral downward of divergence
    real(DP):: xyr_SigDotNonG (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \dot{\sigma} $ .
                              ! ľή (). Vertical flow (non gravitational)
    real(DP):: xyz_TempEdd (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T' = T - \bar{T} $ . 
                              ! ٤ξ (٥). Temperature eddy (full level)
    real(DP):: xyr_TempEdd (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{T}' $ . 
                              ! ٤ξ (Ⱦ٥). Temperature eddy (half level)
    real(DP):: xyz_TempVir (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T_v $ . 
                              ! . Virtual temperature
    real(DP):: xyz_TempVirEdd (0:imax-1, 1:jmax, 1:kmax)
                              ! $ {T_v}' = T_v - \bar{T} $ . 
                              ! ٤ξ. Virtual temperature eddy

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! u -> U (= u cos \varphi), v -> V (= v cos \varphi)
    ! 
    do k = 1, kmax
      xyz_UCosLatN(:,:,k) = xyz_UN(:,:,k) * xy_CosLat
      xyz_VCosLatN(:,:,k) = xyz_VN(:,:,k) * xy_CosLat
    end do

    ! $ \pi $ ΰή, $ \pi $ ήѲ, ȯѲη׻
    ! Calculate advection of $ \pi $, integral downward of advection 
    !   of $ \pi $, integral downward of divergence
    !
    do k = 1, kmax
      xyz_PiAdv(:,:,k) = &
        & (   xyz_UCosLatN(:,:,k) * xy_GradLambdaPiN &
        &   + xyz_VCosLatN(:,:,k) * xy_GradMuPiN ) &
        & / ( 1. - xy_SinLat**2 )
    enddo

    xyz_PiAdvSum(:,:,kmax) = xyz_PiAdv(:,:,kmax) * z_DelSigma(kmax)
    do k = kmax-1, 1, -1
      xyz_PiAdvSum(:,:,k) = &
        & xyz_PiAdvSum(:,:,k+1) + xyz_PiAdv(:,:,k) * z_DelSigma(k)
    enddo

    xyz_DivSum(:,:,kmax) = xyz_DivN(:,:,kmax) * z_DelSigma(kmax)
    do k = kmax-1, 1, -1
      xyz_DivSum(:,:,k) = &
        & xyz_DivSum(:,:,k+1) + xyz_DivN(:,:,k) * z_DelSigma(k)
    enddo

    ! ɽ̵Ѳ $ Z $ η׻
    ! Calculate surface pressure tendency $ Z $
    !
    xy_DPiDtN = - xyz_PiAdvSum(:,:,1)

    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('explicit')

      xy_DPiDtN = xy_DPiDtN - xyz_DivSum(:,:,1)

    end select

    ! $ \dot{\sigma} $ η׻
    ! Calculate $ \dot{\sigma} $
    !
    do k = 1, kmax-1
      xyr_SigDotN(:,:,k) = &
        & r_Sigma(k) * ( xyz_PiAdvSum(:,:,1) + xyz_DivSum(:,:,1) ) &
        & - ( xyz_PiAdvSum(:,:,k+1) + xyz_DivSum(:,:,k+1) )

      xyr_SigDotNonG(:,:,k) = &
        & r_Sigma(k) * xyz_PiAdvSum(:,:,1) - xyz_PiAdvSum(:,:,k+1)
    enddo

    ! $ \dot{\sigma} $ ξ岼
    ! $ \dot{\sigma} $ on upper and lower boundary
    !
    xyr_SigDotN(:,:,0)    = 0.
    xyr_SigDotN(:,:,kmax) = 0.
    xyr_SigDotNonG(:,:,0)    = 0.
    xyr_SigDotNonG(:,:,kmax) = 0.

    ! ٤ξ (٥), , ٤ξη׻
    ! Calculate temperature eddy (full level), virtual temperature, 
    !   virtual temperature eddy
    !
    do k = 1, kmax
      xyz_TempVir(:,:,k) = &
        & xyz_TempN(:,:,k) &
        &   * ( 1. + ((( 1. / EpsV ) - 1. ) * xyz_QVapN(:,:,k)) )

      xyz_TempEdd(:,:,k) = xyz_TempN(:,:,k) - z_RefTemp(k)
      xyz_TempVirEdd(:,:,k) = xyz_TempVir(:,:,k) - z_RefTemp(k)
    enddo

    ! ٤ξ (Ⱦ٥) η׻
    ! Calculate temperature eddy (half level)
    !
    xyr_TempEdd(:,:,0) = 0.
    xyr_TempEdd(:,:,kmax) = 0.
    do k = 1, kmax-1
      xyr_TempEdd(:,:,k) = &
        &   z_TInpCoefA(k+1) * xyz_TempN(:,:,k+1) &
        & + z_TInpCoefB( k ) * xyz_TempN(:,:, k ) &
        & - r_RefTemp(k)
    enddo

    ! ư̰ήη׻
    ! Calculate advection of eastward momentum
    !
    xyz_UAdvN(:,:,1) = &
      &   ( xyz_VorN(:,:,1) + xy_Cori ) * xyz_VCosLatN(:,:,1) &
!
      & - 1. / ( 2. * z_DelSigma(1) ) * xyr_SigDotN(:,:,1) &
      &                               * ( xyz_UCosLatN(:,:,1) - xyz_UCosLatN(:,:,2) ) &
!
      & - CpDry * z_TInpCoefK(1) * xyz_TempVirEdd(:,:,1) * xy_GradLambdaPiN

    do k = 2, kmax-1
      xyz_UAdvN(:,:,k) = &
        &   ( xyz_VorN(:,:,k) + xy_Cori ) * xyz_VCosLatN(:,:,k) &
!
        & - 1. / ( 2. * z_DelSigma(k) ) &
        &   * ( &
        &        xyr_SigDotN(:,:,k-1) * ( xyz_UCosLatN(:,:,k-1) - xyz_UCosLatN(:,:,k) ) &
        &      + xyr_SigDotN(:,:,k)   * ( xyz_UCosLatN(:,:,k)   - xyz_UCosLatN(:,:,k+1) ) &
        &     ) &
!
        & - CpDry * z_TInpCoefK(k) * xyz_TempVirEdd(:,:,k) * xy_GradLambdaPiN
    end do

    xyz_UAdvN(:,:,kmax) = &
      &   ( xyz_VorN(:,:,kmax) + xy_Cori ) * xyz_VCosLatN(:,:,kmax) &
!
      & - 1. / ( 2. * z_DelSigma(kmax) ) * xyr_SigDotN(:,:,kmax-1) &
      &                                  * ( xyz_UCosLatN(:,:,kmax-1) - xyz_UCosLatN(:,:,kmax) ) &
!
      & - CpDry * z_TInpCoefK(kmax) * xyz_TempVirEdd(:,:,kmax) * xy_GradLambdaPiN


    ! ̱ư̰ήη׻
    ! Calculate advection of northward momentum
    !
    xyz_VAdvN(:,:,1) = &
      & - ( xyz_VorN(:,:,1) + xy_Cori ) * xyz_UCosLatN(:,:,1) &
!
      & - 1. / ( 2. * z_DelSigma(1) ) * xyr_SigDotN(:,:,1)&
      &                               * ( xyz_VCosLatN(:,:,1) - xyz_VCosLatN(:,:,2) ) &
!
      & - CpDry * z_TInpCoefK(1) &
      &          * xyz_TempVirEdd(:,:,1) * xy_GradMuPiN

    do k = 2, kmax-1
      xyz_VAdvN(:,:,k) = &
        & - ( xyz_VorN(:,:,k) + xy_Cori ) * xyz_UCosLatN(:,:,k) &
!
        & - 1. / ( 2. * z_DelSigma(k) ) &
        &   * ( &
        &        xyr_SigDotN(:,:,k-1) * ( xyz_VCosLatN(:,:,k-1) - xyz_VCosLatN(:,:,k) ) &
        &      + xyr_SigDotN(:,:,k)   * ( xyz_VCosLatN(:,:,k)   - xyz_VCosLatN(:,:,k+1) ) &
        &     ) &
!
        & - CpDry * z_TInpCoefK(k) * xyz_TempVirEdd(:,:,k) * xy_GradMuPiN
    end do

    xyz_VAdvN(:,:,kmax) = &
      & - ( xyz_VorN(:,:,kmax) + xy_Cori ) * xyz_UCosLatN(:,:,kmax) &
!
      & - 1. / ( 2. * z_DelSigma(kmax) ) * xyr_SigDotN(:,:,kmax-1) &
      &                                  * ( xyz_VCosLatN(:,:,kmax-1) - xyz_VCosLatN(:,:,kmax) ) &
!
      & - CpDry * z_TInpCoefK(kmax) * xyz_TempVirEdd(:,:,kmax) * xy_GradMuPiN


    ! ưͥ륮 (ޤ) η׻
    ! Calculate kinematic energy term 
    !   (including virtual temperature correction)
    !
    call HydroGrid( xyz_TempVir - xyz_TempN, & ! (in)
      &             xyz_KinEngyN )             ! (out)

    do k = 1, kmax
      xyz_KinEngyN(:,:,k) = &
        &    ( xyz_UCosLatN(:,:,k)**2 + xyz_VCosLatN(:,:,k)**2 ) &
        &       / ( 2. * ( 1. - xy_SinLat**2 ) ) &
        &  + xyz_KinEngyN(:,:,k)
    end do


    ! ή, ̰ήη׻
    ! Calculate eastward and northward advection of temperature
    !
    do k = 1, kmax
      xyz_TempUAdvN(:,:,k) =  xyz_UCosLatN(:,:,k) * xyz_TempEdd(:,:,k)
      xyz_TempVAdvN(:,:,k) =  xyz_VCosLatN(:,:,k) * xyz_TempEdd(:,:,k)
    end do

    ! ٤λѲ $ \hat{H} $ η׻
    ! Calculate temperature tendency term $ \hat{H} $
    !
    do k = 1, kmax-1
      xyz_TempNonLinearN(:,:,k) = &
        &   xyz_TempEdd(:,:,k) * xyz_DivN(:,:,k) &
!
        & - 1. / z_DelSigma(k) &
        &  * (   xyr_SigDotN(:,:,k-1) &
        &          * ( xyr_TempEdd(:,:,k-1) - xyz_TempEdd(:,:,k) ) &
        &      + xyr_SigDotN(:,:,k) &
        &          * ( xyz_TempEdd(:,:,k)   - xyr_TempEdd(:,:,k) ) ) &
!
        & - 1. / z_DelSigma(k) &
        &  * (   xyr_SigDotNonG(:,:,k-1) &
        &          * ( r_RefTemp(k-1) - z_RefTemp(k) ) &
        &      + xyr_SigDotNonG(:,:,k) &
        &          * ( z_RefTemp(k)   - r_RefTemp(k) ) ) &
!
        & + z_TInpCoefK(k) * xyz_TempVir(:,:,k) * xyz_PiAdv(:,:,k) &
!
        & - z_HydroAlpha(k) / z_DelSigma(k) &
        &    * (   xyz_TempVir(:,:,k)    * xyz_PiAdvSum(:,:,k) &
        &        + xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k) ) &
!
        & - z_HydroBeta(k) / z_DelSigma(k) &
        &    * (   xyz_TempVir(:,:,k)    * xyz_PiAdvSum(:,:,k+1) &
        &        + xyz_TempVirEdd(:,:,k) * xyz_DivSum(:,:,k+1) )
    enddo

    xyz_TempNonLinearN(:,:,kmax) = &
      &   xyz_TempEdd(:,:,kmax) * xyz_DivN(:,:,kmax) &
!
      & - 1. / z_DelSigma(kmax) &
      &  * (   xyr_SigDotN(:,:,kmax-1) &
      &          * ( xyr_TempEdd(:,:,kmax-1) - xyz_TempEdd(:,:,kmax) ) &
      &      + xyr_SigDotN(:,:,kmax) &
      &          * ( xyz_TempEdd(:,:,kmax)   - xyr_TempEdd(:,:,kmax) ) ) &
!
      & - 1. / z_DelSigma(kmax) &
      &  * (   xyr_SigDotNonG(:,:,kmax-1) &
      &          * ( r_RefTemp(kmax-1) - z_RefTemp(kmax) ) &
      &      + xyr_SigDotNonG(:,:,kmax) &
      &          * ( z_RefTemp(kmax)   - r_RefTemp(kmax) ) ) &
!
      & + z_TInpCoefK(kmax) * xyz_TempVir(:,:,kmax) * xyz_PiAdv(:,:,kmax) &
!
      & - z_HydroAlpha(kmax) / z_DelSigma(kmax) &
      &    * (   xyz_TempVir(:,:,kmax)    * xyz_PiAdvSum(:,:,kmax) &
      &        + xyz_TempVirEdd(:,:,kmax) * xyz_DivSum(:,:,kmax) )


    ! 漾ή, 漾̰ήη׻
    ! Calculate eastward and northward advection of specific humidity
    !
    do k = 1, kmax
      xyz_QVapUAdvN(:,:,k) =  xyz_UCosLatN(:,:,k) * xyz_QVapN(:,:,k)
      xyz_QVapVAdvN(:,:,k) =  xyz_VCosLatN(:,:,k) * xyz_QVapN(:,:,k)
    end do

    ! 漾Ѳ $ R $ η׻
    ! Calculate specific humidity tendency $ R $
    !
    xyz_QVapNonLinearN(:,:,1) =   &
      &    xyz_QVapN(:,:,1) * xyz_DivN(:,:,1) &
      &  - 1. / ( 2. * z_DelSigma(1) ) &
      &       * xyr_SigDotN(:,:,1) &
      &       * ( xyz_QVapN(:,:,1) - xyz_QVapN(:,:,2) )

    do k = 2, kmax - 1
      xyz_QVapNonLinearN(:,:,k) =   &
        &    xyz_QVapN(:,:,k) * xyz_DivN(:,:,k) &
        &  - 1. / ( 2. * z_DelSigma(k) ) &
        &       * ( &
        &             xyr_SigDotN(:,:,k-1) &
        &               * ( xyz_QVapN(:,:,k-1) - xyz_QVapN(:,:,k)   ) &
        &           + xyr_SigDotN(:,:,k) &
        &               * ( xyz_QVapN(:,:,k)   - xyz_QVapN(:,:,k+1) )   )
    end do

    xyz_QVapNonLinearN(:,:,kmax) =   &
      &    xyz_QVapN(:,:,kmax) * xyz_DivN(:,:,kmax) &
      &  - 1. / ( 2. * z_DelSigma(kmax) ) &
      &       * xyr_SigDotN(:,:,kmax-1) &
      &       * ( xyz_QVapN(:,:,kmax-1) - xyz_QVapN(:,:,kmax) )

  end subroutine NonLinearOnGrid

  !-------------------------------------------------------------------

  subroutine HydroGrid( xyz_Temp, & ! (in)
    &                   xyz_Phi   & ! (out)
    & )
    !
    ! ʻǡǤ벹 $ T $ , ſ尵μѤ
    ! ʻǡΥݥƥ󥷥 $ \Phi $ ޤ. 
    !

    ! ⥸塼 ; USE statements
    !

    use constants, only: &
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature
    real(DP), intent(out):: xyz_Phi (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \Phi $ .  ݥƥ󥷥. 
                              ! Getpotential height

    ! ѿ
    ! Work variables
    !
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction
    
    ! ¹ʸ ; Executable statement
    !
    xyz_Phi(:,:,1) = CpDry * z_HydroAlpha(1) * xyz_Temp(:,:,1)
    
    do k = 2, kmax
      xyz_Phi(:,:,k) =   xyz_Phi(:,:,k-1) &
        &              + CpDry * z_HydroAlpha(k)  * xyz_Temp(:,:,k)   &
        &              + CpDry * z_HydroBeta(k-1) * xyz_Temp(:,:,k-1)
    enddo

  end subroutine HydroGrid

  !-------------------------------------------------------------------

  subroutine TimeIntegration( &
    & wz_DVorDtN, wz_DDivDtN, wz_DTempDtN, wz_DQVapDtN, w_DPiDtN, & ! (in)
    & wz_VorB,    wz_DivB,    wz_TempB,    wz_QVapB,    w_PiB, &    ! (in)
    & w_SurfGeoPot, &                                               ! (in)
    & wz_VorA,    wz_DivA,    wz_TempA,    wz_QVapA,    w_PiA  &    ! (out)
    & )
    !
    ! ʬԤ, 
    !  $ t $ ʪ̤λѲ $ t-\Delta t$ ʪ̤
    !  $ t+\Delta t $ ʪ̤׻ޤ.
    !
    ! ʬˡˤϥ꡼ץեåѤƤޤ. 
    ! ȻˤʬѤƤޤ. 
    ! ǥեȤǤ, $ \Delta t $ 礭Ȥ뤿, ȹ 
    ! ߥץꥷåˡŬѤƤޤ.
    ! NAMELIST#dynamics_hspl_vas83_nml  TimeIntegScheme ѹ뤳Ȥ, 
    ! ȹ򥨥ץꥷåˡˤäƲ򤯤ȤǽǤ.
    ! 
    ! With time integration, calculate physical values at $ t+\Delta t $
    ! from tendency at $ t $ and physical values at $ t-\Delta t $ .
    !
    ! Leap-frog scheme is used as time integration scheme. 
    ! And forward difference is used to diffusion terms.
    ! By default, semi-implicit scheme is applied to gravitational terms 
    ! for extension of $ \Delta t $ . 
    ! Explicit scheme can be applied to gravitational terms by changing
    ! "TimeIntegScheme" in "NAMELIST#dynamics_hspl_vas83_nml". 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! 
    ! Time control
    !
    use timeset, only: DelTime ! $ \Delta t $ [s]

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_DelSigma            ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

    ! LU ʬˡˤϢΩ 1 򤯤δؿ
    ! Functions to solve linear simultaneous equation by LU decomposition
    !
    use lumatrix, only: LUSolve

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    implicit none
    real(DP), intent(in):: wz_DVorDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{\zeta}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Vorticity tendency (spectral)
    real(DP), intent(in):: wz_DDivDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{D}{t} (t) $ . ȯѲ (ڥȥ). 
                              ! Divergence tendency (spectral)
    real(DP), intent(in):: wz_DTempDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{T}{t} (t) $ . Ѳ (ڥȥ). 
                              ! Temperature tendency (spectral)
    real(DP), intent(in):: wz_DQVapDtN ((nmax+1)**2, 1:kmax)
                              ! $ \DD{q}{t} (t) $ . 漾Ѳ (ڥȥ). 
                              ! Specific humidity tendency (spectral)
    real(DP), intent(in):: w_DPiDtN ((nmax+1)**2)
                              ! $ \DD{p_s}{t} (t) $ . ɽ̵Ѳ (ڥȥ). 
                              ! Surface pressure tendency (spectral)
    real(DP), intent(in):: wz_VorB ((nmax+1)**2, 1:kmax)
                              ! $ \zeta (t-\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP), intent(in):: wz_DivB ((nmax+1)**2, 1:kmax)
                              ! $ D (t-\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP), intent(in):: wz_TempB ((nmax+1)**2, 1:kmax)
                              ! $ T (t-\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP), intent(in):: w_PiB ((nmax+1)**2)
                              ! $ \pi = \ln p_s (t-\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP), intent(in):: wz_QVapB ((nmax+1)**2, 1:kmax)
                              ! $ q (t-\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)
    real(DP), intent(in):: w_SurfGeoPot ((nmax+1)**2)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential

    real(DP), intent(out):: wz_VorA ((nmax+1)**2, 1:kmax)
                              ! $ \zeta (t+\Delta t) $ .  (ڥȥ). 
                              ! Vorticity (spectral)
    real(DP), intent(out):: wz_DivA ((nmax+1)**2, 1:kmax)
                              ! $ D (t+\Delta t) $ . ȯ (ڥȥ). 
                              ! Divergence (spectral)
    real(DP), intent(out):: wz_TempA ((nmax+1)**2, 1:kmax)
                              ! $ T (t+\Delta t) $ .  (ڥȥ). 
                              ! Temperature (spectral)
    real(DP), intent(out):: w_PiA ((nmax+1)**2)
                              ! $ \pi = \ln p_s (t+\Delta t) $ . ɽ̵ (ڥȥ). 
                              ! Surface pressure (spectral)
    real(DP), intent(out):: wz_QVapA ((nmax+1)**2, 1:kmax)
                              ! $ q (t+\Delta t) $ . 漾 (ڥȥ). 
                              ! Specific humidity (spectral)

    ! ѿ
    ! Work variables
    !
    real(DP):: wz_siTemp ((nmax+1)**2, 1:kmax)
                              !  (ߥץꥷåˡΤκѿ). 
                              ! Temperature (work variable for semi-implicit scheme)
    real(DP):: wz_siDTempDt ((nmax+1)**2, 1:kmax)
                              ! $ \DD{T}{t} (t) $ . Ѳ (ڥȥ) κѿ. 
                              ! Temperature tendency (spectral) work variable

    real(DP):: w_siPi ((nmax+1)**2)
                              ! $ \pi $ (ߥץꥷåˡΤκѿ). 
                              ! $ \pi $ (work variable for semi-implicit scheme)
    real(DP):: w_siDPiDt ((nmax+1)**2)
                              ! $ \DD{p_s}{t} (t) $ . ɽ̵Ѳ (ڥȥ). 
                              ! Surface pressure tendency (spectral)
    real(DP):: wz_siPhi ((nmax+1)**2, 1:kmax)
                              ! $ \Phi = \underline{W} \overline{ \Dvect{T} }^{t}$ .
                              ! (ߥץꥷåˡΤκѿ). 
                              ! (Work variable for semi-implicit scheme)
    real(DP):: wz_siDivAvrTime ((nmax+1)**2, 1:kmax)
                              ! $ \Dvect{f} $ . 
                              ! ʿѤ $ \Dvect{D} $ (ߥץꥷåˡΤκѿ). 
                              ! Time average $ \Dvect{D} $ (work variable for semi-implicit scheme)

    integer:: k, kk           ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ȹβʬ
    ! Integration non gravitational terms temporarily
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_siTemp = &
        &   ( 1. - DelTime * wz_HDifCoefT ) * wz_TempB &
        & + DelTime * wz_DTempDtN

      w_siPi = w_PiB + DelTime * w_DPiDtN

    end select

    ! ݥƥ󥷥η׻
    ! Calculate geopotential
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_siPhi (:,1) = CpDry * z_HydroAlpha(1) * wz_siTemp (:,1)

      do k = 2, kmax
        wz_siPhi (:,k) = wz_siPhi(:,k-1) &
          & + CpDry * z_HydroAlpha(k) * wz_siTemp (:,k) &
          & + CpDry * z_HydroBeta (k-1) * wz_siTemp (:,k-1)
      end do

    case ('explicit')

    end select

    ! ȯαդη׻
    ! Calculate right side of divergence equation
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      do k = 1, kmax
        wz_siDivAvrTime(:,k) = &
          &   ( 1. - 2. * DelTime * wz_HDifCoefT(:,k)  ) &
          & * ( 1. -      DelTime * wz_HDifCoefM(:,k) ) * wz_DivB(:,k) &
!
          & + ( 1. - 2. * DelTime * wz_HDifCoefT(:,k)  ) &
          &     * DelTime * wz_DDivDtN(:,k) &
!
          & - DelTime * wz_LaplaCoef(:,k) &
          &   * (   ( 1. - 2. * DelTime * wz_HDifCoefT(:,k) ) * w_SurfGeoPot &
          &       + wz_siPhi(:,k) &
          &       + ( 1. - 2. * DelTime * wz_HDifCoefT(:,k) ) &
          &             * z_siMtxG(k) * w_siPi                  )
      end do

    end select

    ! ʿѤ $ \Dvect{D} $  LU ǲ
    ! Solve time average $ \Dvect{D} $ with LU matrix
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_siDivAvrTime = LUSolve( wzz_siMtxLU, wz_siMtxPiv, wz_siDivAvrTime )

    end select

    ! , ɽλѲη׻
    ! Calculate tendency of temperature and surface pressure
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_siDTempDt = wz_DTempDtN
      do k = 1, kmax
        do kk = 1, kmax
          wz_siDTempDt(:,k) = &
            &   wz_siDTempDt(:,k) &
            & - zz_siMtxH(k,kk) * wz_siDivAvrTime(:,kk)
        end do
      end do

      w_siDPiDt = w_DPiDtN
      do kk = 1, kmax
        w_siDPiDt = &
          &   w_siDPiDt &
          & - z_DelSigma(kk) * wz_siDivAvrTime(:,kk)
      end do

    end select

    ! ʬ. Ȼʬ
    ! Time integration. Forward difference is applied to diffusion
    !

    !  ; Vorticity
    !
    wz_VorA = &
      & ( 1. / ( 1. - 2. * DelTime * wz_HDifCoefM ) ) &
      &   * ( wz_VorB + 2. * DelTime * wz_DVorDtN )

    ! ȯ ; Divergence
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_DivA  = &
        & 2. * wz_siDivAvrTime - wz_DivB

    case ('explicit')

      wz_DivA  = &
        & ( 1. / ( 1. - 2. * DelTime * wz_HDifCoefM ) ) &
        &   * ( wz_DivB + 2. * DelTime * wz_DDivDtN )

    end select

    !  ; Temperature
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      wz_TempA = &
        & ( 1.  / ( 1. - 2. * DelTime * wz_HDifCoefT ) ) &
        &   * ( wz_TempB + wz_siDTempDt * 2. * DelTime )

    case ('explicit')

      wz_TempA = &
        & ( 1.  / ( 1. - 2. * DelTime * wz_HDifCoefT ) ) &
        &   * ( wz_TempB + wz_DTempDtN * 2. * DelTime )

    end select

    ! 漾 ; Specific humidity
    !
    wz_QVapA = &
      & ( 1. / ( 1. - 2. * DelTime * wz_HDifCoefT ) ) &
      &   * ( wz_QVapB + wz_DQVapDtN * 2. * DelTime )

    ! ɽ̵ ; Surface pressure
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')

      w_PiA  = w_PiB + 2. * DelTime * w_siDPiDt

    case ('explicit')

      w_PiA  = w_PiB + 2. * DelTime * w_DPiDtN

    end select

  end subroutine TimeIntegration

  !-------------------------------------------------------------------

  subroutine DiagOutput( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps, & ! (in)
    & xyr_SigDot, xy_DPiDt &                   ! (in)
    & )
    !
    ! ̤νϤԤޤ. 
    !
    ! Diagnostic variables are output. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & RPlanet, &
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
      & Grav, &
                              ! $ g $ [m s-2]. 
                              ! ϲ®. 
                              ! Gravitational acceleration
      & CpDry, &
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & LatentHeat
                              ! $ L $ [J kg-1] . 
                              ! ŷǮ. 
                              ! Latent heat of condensation

    ! 
    ! Time control
    !
    use timeset, only: TimeN  ! ƥå $ t $ λ. Time of step $ t $. 

#ifdef LIB_MPI
    ! MPI  SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library MPI version, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_mpi_module, only: &
      & wa_DivLambda_xya => wa_DivLambda_xva, &
      & wa_DivMu_xya => wa_DivMu_xva, &
      & xya_wa => xva_wa
#else
    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_module, only: &
      & wa_DivLambda_xya, &
      & wa_DivMu_xya, &
      & xya_wa
#endif

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xyz_U    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(in):: xyz_V    (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(in):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   漾. Specific humidity
    real(DP), intent(in):: xy_Ps    (0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵. Surface pressure
    real(DP), intent(in):: xyr_SigDot (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \dot{\sigma} $ .
                              ! ľή. Vertical flow
    real(DP), intent(in):: xy_DPiDt (0:imax-1, 1:jmax)
                              ! $ Z $ . ɽ̵Ѳ. 
                              ! Surface pressure tendency

    ! ѿ
    ! Work variables
    !
    real(DP):: xyz_UCosLat   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ U = u \times \cos \varphi $ .
    real(DP):: xyz_VCosLat   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ V = v \times \cos \varphi $ .
    real(DP):: xyz_Vor (0:imax-1, 1:jmax, 1:kmax)
                              ! $ \zeta $ . . Vorticity
    real(DP):: xyz_Div (0:imax-1, 1:jmax, 1:kmax)
                              ! $ D $ . ȯ. Divergence
    real(DP):: xy_Mass (0:imax-1, 1:jmax)
                              ! . 
                              ! Mass
    real(DP):: xyz_KinEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ KE $ . ưͥ륮.
                              ! Kinetic energy
    real(DP):: xyz_IntEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ IE $ . ͥ륮. 
                              ! Internal energy
    real(DP):: xyz_PotEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ PE $ . ݥƥ󥷥륨ͥ륮. 
                              ! Potential energy
    real(DP):: xyz_LatEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ LE $ . Ǯͥ륮. 
                              ! Latent heat energy
    real(DP):: xyz_TotEngy (0:imax-1, 1:jmax, 1:kmax)
                              ! $ TE $ . ͥ륮. 
                              ! Total energy
    real(DP):: xyz_Enstro (0:imax-1, 1:jmax, 1:kmax)
                              ! 󥹥ȥե. 
                              ! Enstrophy

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement
    !

    ! ľήɽ̵Ѳν
    ! Output vertical flow and surface pressure tendency
    ! 
    call HistoryAutoPut( TimeN, 'SigDot', xyr_SigDot )
    call HistoryAutoPut( TimeN, 'DPiDt',  xy_DPiDt )

    ! ®鱲ȯη׻
    ! Calculate vorticity and divergence from wind velocity
    ! 
    do k = 1, kmax
      xyz_UCosLat(:,:,k) = xyz_U(:,:,k) * xy_CosLat
      xyz_VCosLat(:,:,k) = xyz_V(:,:,k) * xy_CosLat
    end do
    xyz_Vor = xya_wa(   wa_DivLambda_xya( xyz_VCosLat )  &
      &               - wa_DivMu_xya(     xyz_UCosLat ) ) / RPlanet
    xyz_Div = xya_wa(   wa_DivLambda_xya( xyz_UCosLat )  &
      &               + wa_DivMu_xya(     xyz_VCosLat ) ) / RPlanet

    call HistoryAutoPut( TimeN, 'Vor', xyz_Vor )
    call HistoryAutoPut( TimeN, 'Div', xyz_Div )

    ! ̤η׻
    ! Calculate mass
    !
    xy_Mass = xy_Ps / Grav

    ! ͥ륮, 󥹥ȥեη׻
    ! Calculate energy and enstrophy
    !
    call HydroGrid( xyz_Temp, &   ! (in)
      &             xyz_PotEngy ) ! (out)

    do k = 1, kmax
      xyz_KinEngy(:,:,k) = ( xyz_U(:,:,k) ** 2 + xyz_V(:,:,k) ** 2 ) / 2. &
        &                    * xy_Mass

      xyz_IntEngy(:,:,k) = CpDry * xyz_Temp(:,:,k) &
        &                    * xy_Mass

      xyz_PotEngy(:,:,k) = xyz_PotEngy(:,:,k) & 
        &                    * xy_Mass

      xyz_LatEngy(:,:,k) = LatentHeat * xyz_QVap(:,:,k) &
        &                    * xy_Mass
    end do

    xyz_TotEngy = xyz_KinEngy + xyz_IntEngy + xyz_PotEngy + xyz_LatEngy

    do k = 1, kmax
      xyz_Enstro(:,:,k) = xyz_Vor(:,:,k) ** 2 &
        &                   * xy_Mass
    end do

    call HistoryAutoPut( TimeN, 'Mass',    xy_Mass     )
    call HistoryAutoPut( TimeN, 'KinEngy', xyz_KinEngy )
    call HistoryAutoPut( TimeN, 'IntEngy', xyz_IntEngy )
    call HistoryAutoPut( TimeN, 'PotEngy', xyz_PotEngy )
    call HistoryAutoPut( TimeN, 'LatEngy', xyz_LatEngy )
    call HistoryAutoPut( TimeN, 'TotEngy', xyz_TotEngy )
    call HistoryAutoPut( TimeN, 'Enstro',  xyz_Enstro  )

  end subroutine DiagOutput

  !-------------------------------------------------------------------

  subroutine DynamicsInit
    !
    ! ׻ɬפʥѥ᥿ NAMELIST#dynamics_hspl_vas83_nml
    ! ɤ߹ߤԤޤ. 
    ! 
    ! Configure parameters for calculation, 
    ! and load "NAMELIST#dynamics_hspl_vas83_nml"
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & RPlanet, &
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
      & Omega, &
                              ! $ \Omega $ [s-1]. 
                              ! ž®. 
                              ! Angular velocity
      & GasRDry, &
                              ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & z_Sigma, &            ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
      & r_Sigma, &            ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma            ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)


#ifdef LIB_MPI
    ! MPI  SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library MPI version, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_mpi_module, only: xy_Lat => xv_Lat, w_xy => w_xv
#else

    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_module, only: xy_Lat, w_xy
#endif
    use w_module, only: rn

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! gtool4 ǡ
    ! Gtool4 data input
    !
    use gtool_history, only: HistoryGet

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: &
      & STDOUT, &             ! ɸϤֹ. Unit number of standard output
      & STRING                ! ʸ.       Strings. 

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
    use dc_date, only: DCDiffTimeCreate, EvalSec

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! Ȥ߹ߴؿ PRESENT γĥǴؿ
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_not_empty

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none


    ! ಹ٤Τκѿ
    ! Work variable for reference temperature
    !
    real(DP):: RefTemp
                              ! $ \overline{T} $ . ಹ. 
                              ! Reference temperature

    ! ʿȻΤκѿ
    ! Work variable for coefficient of horizontal diffusion
    !
    integer:: VisOrder        ! ĶǴμ.  Order of hyper-viscosity
    real(DP):: VisCoef        ! ĶǴ. Hyper-viscosity coefficient
    real(DP):: EFoldTimeValue ! ȿФ e-folding time. 
                              ! ͤͿ, ʿȻ򥼥ˤޤ. 
                              ! 
                              ! E-folding time for maximum wavenumber. 
                              ! If negative value is given, 
                              ! coefficients of horizontal diffusion become zero. 
    character(TOKEN):: EFoldTimeUnit
                              ! ȿФ e-folding time ñ. 
                              ! Unit of e-folding time for maximum wavenumber
    real(DP):: EFoldTime      ! ȿФ e-folding time [ñ: ]. 
                              ! E-folding time for maximum wavenumber [Unit: sec]
    type(DC_DIFFTIME):: dcdiff_efold

    ! NonLinearOnGrid ǻѤ뷸Τκѿ
    ! Work variable for coefficients for "NonLinearOnGrid", etc.
    !
    real(DP):: Kappa          ! $ \kappa = R/C_p $ .
                              ! 갵ǮФ. 
                              ! Ratio of gas constant to specific heat

    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /dynamics_hspl_vas83_nml/ &
      & TimeIntegScheme, &
      & VisOrder, &
      & EFoldTimeValue, EFoldTimeUnit, &
      & RefTemp
          !
          ! ǥեͤˤĤƤϽ³ "dynamics_hspl_vas83#DynamicsInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "dynamics_hspl_vas83#DynamicsInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement
    !

    if ( dynamics_hspl_vas83_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    TimeIntegScheme = 'Semi-implicit'

    VisOrder = 8
    EFoldTimeValue = 8640.
    EFoldTimeUnit  = 'sec'

    RefTemp = 300.


    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = dynamics_hspl_vas83_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = dynamics_hspl_vas83_nml )
    end if

    ! ʬˡΥå
    ! Check time integration scheme
    !
    select case ( LChar( trim( TimeIntegScheme ) ) )
    case ('semi-implicit')
    case ('explicit')
    case default
      call MessageNotify( 'E', module_name, &
        & '"TimeIntegScheme" must be "Semi-Implicit" or "Explicit".' )
    end select


    ! SemiImplMatrix ֥롼Ѥ $ \Delta t $ ¸ͤ˽ͤ. 
    ! Configure initial value to saved value of $ \Delta t $ for a subroutine "SemiImplMatrix"
    !
    DelTimeSave = - 1.

    ! NonLinearOnGrid ǻѤ뷸
    ! Configure coefficients for "NonLinearOnGrid", etc.
    !

    ! $ \sin \varphi $  $ \cos \varphi $ η׻
    ! Calculate $ \sin \varphi $ and $ \cos \varphi $
    !
    allocate( xy_SinLat (0:imax-1, 1:jmax) )
    allocate( xy_CosLat (0:imax-1, 1:jmax) )
    xy_SinLat = sin( xy_Lat )
    xy_CosLat = cos( xy_Lat )


    ! ꥪѥ᡼η׻
    ! Calculate Coriolis parameter
    !
    allocate( xy_Cori (0:imax-1, 1:jmax) )
    xy_Cori = 2. * Omega * xy_SinLat


    ! ſ尵μη $ \alpha $ , $ \beta $ η׻
    ! Calculate coefficients $ \alpha $ and $ \beta $ in hydrostatic equation.
    !
    allocate( z_HydroAlpha     (1:kmax) )
    allocate( z_HydroBeta      (1:kmax) )

    Kappa = GasRDry / CpDry

    do k = 1, kmax
      z_HydroAlpha(k) = &
        & ( r_Sigma(k-1) / z_Sigma(k) ) ** Kappa - 1.

      z_HydroBeta(k) = &
        & 1. - ( r_Sigma(k) / z_Sigma(k) ) ** Kappa
    enddo

    ! ٱľ֤η $ \kappa $, $ a $ , $ b $ η׻
    ! Calculate coefficients $ \kappa $, $ a $ , $ b $ 
    !   for interpolation of temperature
    !
    allocate( z_TInpCoefA     (1:kmax) )
    allocate( z_TInpCoefB     (1:kmax) )
    allocate( z_TInpCoefK (1:kmax) )

    do k = 1, kmax
      z_TInpCoefK(k) = &
        & (   r_Sigma(k-1) * z_HydroAlpha(k) &
        &   + r_Sigma(k  ) * z_HydroBeta(k)    ) / z_DelSigma(k)
    enddo

    z_TInpCoefA = 0.
    do k = 2, kmax
      z_TInpCoefA(k) = &
        & z_HydroAlpha(k) &
        &   * ( 1. - (z_Sigma(k) / z_Sigma(k-1)) ** Kappa ) ** ( -1 )
    end do

    z_TInpCoefB = 0.
    do k = 1, kmax - 1
      z_TInpCoefB(k) = &
        & z_HydroBeta(k) &
        &   * ( (z_Sigma(k) / z_Sigma(k+1) ) ** Kappa - 1. ) ** ( -1 )
    end do

    ! ಹ (Ⱦ٥) η׻
    ! Calculate reference temperature on half levels
    !
    allocate( z_RefTemp      (1:kmax) )
    allocate( r_RefTemp      (0:kmax) )

    z_RefTemp       = RefTemp
    r_RefTemp(0)    = 0.
    r_RefTemp(kmax) = 0.

    do k = 1, kmax - 1
      r_RefTemp(k) = &
        &   z_TInpCoefA(k+1) * z_RefTemp(k+1)   &
        & + z_TInpCoefB( k ) * z_RefTemp( k )
    enddo


    ! ʿȻ
    ! Configure coefficient of horizontal diffusion
    !
    allocate( wz_LaplaCoef  ((nmax+1)**2, 1:kmax) )
    allocate( wz_HDifCoefM ((nmax+1)**2, 1:kmax) )
    allocate( wz_HDifCoefT  ((nmax+1)**2, 1:kmax) )

    do k = 1, kmax
      wz_LaplaCoef(:,k) = rn(:,1) / RPlanet**2
    enddo

    ! Ǵη׻ (ȿ e-folding time  EFoldTime Ȥʤ褦)
    ! Calculate viscosity coefficient
    !
    call DCDiffTimeCreate( dcdiff_efold, &    ! (out)
      & EFoldTimeValue, EFoldTimeUnit )       ! (in)
    EFoldTime = EvalSec( dcdiff_efold )

    if ( EFoldTimeValue > 0. ) then
      VisCoef = ( (nmax*(nmax+1)) / RPlanet**2 )**(-VisOrder / 2) &
        &        / EFoldTime
    else
      VisCoef = 0.
    end if

    wz_HDifCoefT = &
      & - VisCoef * ( ( - wz_LaplaCoef )**( VisOrder / 2 ) )

    wz_HDifCoefM = wz_HDifCoefT &
      & - VisCoef * ( - ( 2. / RPlanet**2 )**( VisOrder / 2 ) )

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'SigDot', &
      & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
      & 'sigma-vertical velocity', '1 s-1' )
    call HistoryAutoAddVariable( 'DPiDt', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'Pi (log Ps) tendency)', 'Pa s-1' )

    call HistoryAutoAddVariable( 'Vor', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'vorticity', 's-1' )
    call HistoryAutoAddVariable( 'Div', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'divergence', 's-1' )

    call HistoryAutoAddVariable( 'Mass', &
      & (/ 'lon ', 'lat ', 'time' /), &
      & 'mass', 'kg' )
    call HistoryAutoAddVariable( 'KinEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'kinetic energy', 'J' )
    call HistoryAutoAddVariable( 'IntEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'internal energy', 'J' )
    call HistoryAutoAddVariable( 'PotEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'potential energy', 'J' )
    call HistoryAutoAddVariable( 'LatEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'latent energy', 'J' )
    call HistoryAutoAddVariable( 'TotEngy', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'total energy', 'J' )
    call HistoryAutoAddVariable( 'Enstro', &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
      & 'enstrophy', 'kg' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  TimeIntegScheme  = %c', c1 = trim( TimeIntegScheme ) )
    call MessageNotify( 'M', module_name, '  EFoldTime = %f [%c]', d = (/ EFoldTimeValue /), c1 = trim(EFoldTimeUnit) )
    call MessageNotify( 'M', module_name, '  VisOrder  = %d', i = (/ VisOrder /) )
    call MessageNotify( 'M', module_name, '  VisCoef   = %f', d = (/ VisCoef /) )
    call MessageNotify( 'M', module_name, '  RefTemp   = %f', d = (/ RefTemp /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    dynamics_hspl_vas83_inited = .true.
  end subroutine DynamicsInit

  !-------------------------------------------------------------------

  subroutine DynamicsFinalize
    !
    ! ⥸塼ѿγդԤޤ. 
    !
    ! Deallocate variables in this module. 
    !

    ! ʸ ; Declaration statements
    !
    implicit none

    ! ¹ʸ ; Executable statement
    !

    if ( .not. dynamics_hspl_vas83_inited ) return

    ! ǥե᤹ͤ
    ! Return to default values
    !
    DelTimeSave = - 1.

    ! դ
    ! Deallocation
    !
    if ( allocated( xy_SinLat ) )    deallocate( xy_SinLat )
    if ( allocated( xy_CosLat ) )    deallocate( xy_CosLat )

    if ( allocated( xy_Cori ) )      deallocate( xy_Cori )

    if ( allocated( z_HydroAlpha ) ) deallocate( z_HydroAlpha )
    if ( allocated( z_HydroBeta  ) ) deallocate( z_HydroBeta  )

    if ( allocated( z_TInpCoefA ) )  deallocate( z_TInpCoefA )
    if ( allocated( z_TInpCoefB ) )  deallocate( z_TInpCoefB )
    if ( allocated( z_TInpCoefK ) )  deallocate( z_TInpCoefK )

    if ( allocated( z_RefTemp ) )    deallocate( z_RefTemp )
    if ( allocated( r_RefTemp ) )    deallocate( r_RefTemp )

    if ( allocated( wz_LaplaCoef ) ) deallocate( wz_LaplaCoef )
    if ( allocated( wz_HDifCoefM ) ) deallocate( wz_HDifCoefM )
    if ( allocated( wz_HDifCoefT ) ) deallocate( wz_HDifCoefT )  

    if ( allocated( z_siMtxG   ) )  deallocate( z_siMtxG    )
    if ( allocated( zz_siMtxH  ) )  deallocate( zz_siMtxH   )
    if ( allocated( zz_siMtxWH ) )  deallocate( zz_siMtxWH  )
    if ( allocated( zz_siMtxGCt) )  deallocate( zz_siMtxGCt )

    if ( allocated( zz_siMtxW  ) )  deallocate( zz_siMtxW  )
    if ( allocated( zz_siMtxQ  ) )  deallocate( zz_siMtxQ  )
    if ( allocated( zz_siMtxS  ) )  deallocate( zz_siMtxS  )
    if ( allocated( zz_siMtxQS ) )  deallocate( zz_siMtxQS )
    if ( allocated( zz_siMtxR  ) )  deallocate( zz_siMtxR  )

    if ( allocated(nmo           ) )  deallocate( nmo            )
    if ( allocated(zz_siMtxM     ) )  deallocate( zz_siMtxM      )
    if ( allocated(z_siMtxPivWork) )  deallocate( z_siMtxPivWork )
    if ( allocated(wzz_siMtxLU   ) )  deallocate( wzz_siMtxLU    )
    if ( allocated(wz_siMtxPiv   ) )  deallocate( wz_siMtxPiv    )

    dynamics_hspl_vas83_inited = .false.
  end subroutine DynamicsFinalize

  !-------------------------------------------------------------------

  subroutine SemiImplMatrix
    !
    ! TimeIntegration ǻѤ뷸Ԥޤ. 
    ! 󤪤 $ \Delta t $ ѹ줿ʳ, 
    ! ꤷͤ򤽤ΤޤѤޤ. 
    !
    ! Configure coefficients for "TimeIntegration". 
    ! Setting values that are set last time are used, 
    ! except when first time and t are changed. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & RPlanet, &
                              ! $ a $ [m]. 
                              ! Ⱦ. 
                              ! Radius of planet
      & CpDry
                              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & r_Sigma, &            ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
      & z_DelSigma            ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)


    ! 
    ! Time control
    !
    use timeset, only: DelTime ! $ \Delta t $ [s]

    ! SPMODEL 饤֥, ̾ĴȡѴˤ(¿б) 
    ! SPMODEL library, problems on sphere are solved with spherical harmonics (multi layer is supported)
    !
    use wa_module, only: l_nm

    ! LU ʬˡˤϢΩ 1 򤯤δؿ
    ! Functions to solve linear simultaneous equation by LU decomposition
    !
    use lumatrix, only: LUDecomp

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ǥХåѥ桼ƥƥ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub, Debug

    ! ʸ ; Declaration statements
    !
    implicit none

    ! TimeIntegration ǻѤ뷸Τκѿ
    ! Work variable for coefficients for "TimeIntegration", etc.
    !
    real(DP):: flapla         ! $ \nabla_{\sigma}^{2} $


    integer:: k, l, kk        ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    integer:: mmax            ! ȿ. 
                              ! Maximum truncated eastward wavenumber
    integer:: lmax            ! ȿ. 
                              ! Maximum truncated northward wavenumber
    integer:: n, m, nm, mxnm
                              ! ȿ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in wavenumber direction

    logical:: lmax_err        ! ȿ˴ؤ륨顼ե饰. 
                              ! Error flag for maximum truncated northward wavenumber

    ! ¹ʸ ; Executable statement
    !

    ! $ \Delta t $ [s] Υå¸
    ! Check and save $ \Delta t $ [s]
    !
    if ( DelTimeSave == DelTime ) return
    DelTimeSave = DelTime

    call DbgMessage( '%c: %c: (DelTime=%f [sec]) coefficients for "TimeIntegration" is generated. ', &
      & c1 = module_name, c2 = 'SemiImplMatrix', d = (/ DelTime /) )

    ! TimeIntegration ǻѤ뷸
    ! Configure coefficients for "TimeIntegration"
    !
    if ( .not. allocated( z_siMtxG   ) )  allocate( z_siMtxG    (1:kmax) )
    if ( .not. allocated( zz_siMtxH  ) )  allocate( zz_siMtxH   (1:kmax, 1:kmax) )
    if ( .not. allocated( zz_siMtxWH ) )  allocate( zz_siMtxWH  (1:kmax, 1:kmax) )
    if ( .not. allocated( zz_siMtxGCt) )  allocate( zz_siMtxGCt (1:kmax, 1:kmax) )

    if ( .not. allocated( zz_siMtxW  ) )  allocate( zz_siMtxW  (1:kmax, 1:kmax) )
    if ( .not. allocated( zz_siMtxQ  ) )  allocate( zz_siMtxQ  (1:kmax, 1:kmax) )
    if ( .not. allocated( zz_siMtxS  ) )  allocate( zz_siMtxS  (1:kmax, 1:kmax) )
    if ( .not. allocated( zz_siMtxQS ) )  allocate( zz_siMtxQS (1:kmax, 1:kmax) )
    if ( .not. allocated( zz_siMtxR  ) )  allocate( zz_siMtxR  (1:kmax, 1:kmax) )


    z_siMtxG = CpDry * z_TInpCoefK * z_RefTemp

    do k = 1, kmax
      do l = 1, kmax
        zz_siMtxGCt(k,l) = z_siMtxG(k) * z_DelSigma(l)
      end do
    end do

    zz_siMtxW = 0.
    do k = 1, kmax
      do l = 1, k
        zz_siMtxW(k,l) = CpDry * z_HydroAlpha(l)
      enddo

      do l = 1, k-1
        zz_siMtxW(k,l) = zz_siMtxW(k,l) + CpDry * z_HydroBeta(l)
      enddo
    enddo

    zz_siMtxS = 0.
    do k = 1, kmax
      do l = 1, kmax
        zz_siMtxS(k,l) = r_Sigma(k-1) * z_DelSigma(l)
      enddo
      do l = k, kmax
        zz_siMtxS(k,l) = zz_siMtxS(k,l) - z_DelSigma(l)
      enddo
    enddo

    zz_siMtxQ = 0.
    do k = 1, kmax
      zz_siMtxQ(k,k) = ( r_RefTemp(k-1) - z_RefTemp(k) ) / z_DelSigma(k)
    enddo
    do k = 1, kmax-1
      zz_siMtxQ(k,k+1) = ( z_RefTemp(k) - r_RefTemp(k) ) / z_DelSigma(k)
    enddo

    zz_siMtxQS = 0.
    zz_siMtxQS = matmul(zz_siMtxQ, zz_siMtxS)

    zz_siMtxR = 0.
    do k = 1, kmax
      do l = k, kmax
        zz_siMtxR(k,l) = &
          & - z_HydroAlpha(k) / z_DelSigma(k) * z_DelSigma(l) * z_RefTemp(k)
      enddo
      do l = k + 1, kmax
        zz_siMtxR(k,l) = zz_siMtxR(k,l)  &
          & - z_HydroBeta(k) / z_DelSigma(k) * z_DelSigma(l) * z_RefTemp(k)
      enddo
    enddo

    zz_siMtxH = 0.
    zz_siMtxH = zz_siMtxQS - zz_siMtxR

    zz_siMtxWH = 0.
    zz_siMtxWH = matmul(zz_siMtxW, zz_siMtxH)

    if ( .not. allocated(nmo           ) )  allocate( nmo           (1:2, 0:nmax, 0:nmax) )
    if ( .not. allocated(zz_siMtxM     ) )  allocate( zz_siMtxM     (1:kmax, 1:kmax) )
    if ( .not. allocated(z_siMtxPivWork) )  allocate( z_siMtxPivWork(1:kmax) )
    if ( .not. allocated(wzz_siMtxLU   ) )  allocate( wzz_siMtxLU   ((nmax+1)**2, 1:kmax, 1:kmax) )
    if ( .not. allocated(wz_siMtxPiv   ) )  allocate( wz_siMtxPiv   ((nmax+1)**2, 1:kmax) )

    mmax = nmax
    lmax = nmax
    mxnm = 0

    ! ڥȥźμФ
    ! Fetch spectral subscript expression
    !
    nmo = 0
    do l = 0, lmax
      do m = 0, min(mmax, nmax-l)
        nmo(1,m,l) = l_nm(m+l,  m)
        nmo(2,m,l) = l_nm(m+l, -m)
      enddo
    enddo

    Loop_n: do n = 0, nmax
      flapla = - real(n) * real(n+1) / RPlanet**2

      ! ڥȥźμФ
      ! Fetch spectral subscript expression
      !
      lmax_err = .true.
      do m = 0, min(n,mmax)
        if ( n-m <= lmax ) then
          nm = nmo(1,m,n-m)
          lmax_err = .false.
          exit
        endif
      end do
      if ( lmax_err ) then
        call MessageNotify( 'E', module_name, &
          & 'n-m=<%d> must be less than or equal to lmax=<%d>.', &
          & i = (/ n-m, lmax /) )
      end if

      !  $ \underline{M} $ η׻
      ! Calculate matrix $ \underline{M} $
      !
      do k = 1, kmax
        do kk = 1, kmax
          zz_siMtxM ( k,kk ) = &
            & - DelTime**2 * flapla &
            &   * (   zz_siMtxWH( k,kk ) &
            &       + zz_siMtxGCt( k,kk ) &
            &         * ( 1. - 2. * DelTime * wz_HDifCoefT(nm,1) )  )
          if ( k == kk ) then
            zz_siMtxM ( k,kk ) = &
              & zz_siMtxM ( k,kk ) &
              & +   ( 1. - 2. * DelTime * wz_HDifCoefM(nm,1) ) &
              &   * ( 1. - 2. * DelTime * wz_HDifCoefT(nm,1) )
          endif
        end do
      end do

      ! LU ׻
      ! LU matrix calculation
      !
      call LUDecomp( &
        & zz_siMtxM, &     ! (inout)
        & z_siMtxPivWork ) ! (out)

      ! ߡͤ. ( kmax Ϥޤ̤ʤ).
      ! Dummy value is subtituted. (Because position kmax is undefined yet).
      !
      z_siMtxPivWork(kmax) = 0

      ! εͤؤ
      ! Repack matrices
      !
      do m = 0, mmax
        l = n - m
        if ( ( l >= 0 ) .and. ( l <= lmax ) ) then
          do k = 1, kmax
            do kk = 1, kmax
              wzz_siMtxLU ( nmo(1,m,l),k,kk ) = zz_siMtxM ( k,kk )
              wzz_siMtxLU ( nmo(2,m,l),k,kk ) = zz_siMtxM ( k,kk )
            end do
            wz_siMtxPiv ( nmo(1,m,l),k ) = z_siMtxPivWork ( k )
            wz_siMtxPiv ( nmo(2,m,l),k ) = z_siMtxPivWork ( k )
            mxnm = max( mxnm, nmo(1,m,l) )
            mxnm = max( mxnm, nmo(2,m,l) )
          end do
        endif
      end do

    end do Loop_n

    do nm = mxnm+1, (nmax+1)**2
      do k = 1, kmax
        do kk = 1, kmax
          wzz_siMtxLU ( nm,k,kk ) = zz_siMtxM ( k,kk )
        end do
        wz_siMtxPiv ( nm,k ) = z_siMtxPivWork ( k )
      end do
    end do

  end subroutine SemiImplMatrix

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module dynamics_hspl_vas83
