# -*- coding: euc-jp -*-
require "gphys_const_v1.1"
require "gphys_methods_v1.4"
require "numru/ggraph"
include NumRu


dir  = ARGV[0]
vname = ARGV[1]
iyrs = ARGV[2].to_i
iyre = ARGV[3].to_i
ls = ARGV[4].to_i
alt = ARGV[5].to_i

lse = ls + 5
title = 'Ls = '+ls.to_s+'-'+lse.to_s

gphys = GPhys::IO.open("./sagyou.nc", vname)


if vname == 'KMHF_d' then
  DCL.sgscmn(34) #Basic-Windspeed
elsif vname == 'NewmanF_d'
  DCL.sgscmn(34) #Basic-Windspeed
elsif vname == 'Tau'
  DCL.sgscmn(34) #Basic-Windspeed
elsif vname == 'SurfMajCompIce'
  DCL.sgscmn(27) #Basic->Blues
elsif vname == 'U'
  DCL.sgscmn(14)
elsif vname == 'V'
  DCL.sgscmn(14)
elsif vname == 'Geopotential'
  DCL.sgscmn(14)
end 

#< DCLΥץ >
DCL.gropn(2)
#DCL.sldiv('y',2,2)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
DCL.sgpset('lcntl', false)   # ʸᤷʤ
DCL.sgpset('lfull',true)     # ɽ
DCL.uzfact(0.75)             # ɸʸ󥵥 0.75 
DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ
#DCL::sglset('LSOFTF',true)
if dir == '..'
else
  rmiss = gphys.get_att('missing_value')[0]
  DCL.glpset('lmiss',true)
  DCL.glpset('rmiss',rmiss)
end
#< GGraph ˤ  >
#GGraph.set_fig 'itr'=>10, 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[0,360,-90,90]
GGraph.set_fig 'viewport'=>[0.15,0.85,0.1,0.6], 'window'=>[0,360,-90,90]
#GGraph.set_map 'coast_world'=>true, 'grid'=>false
GGraph.set_axes('yside'=>'lr','xside'=>'tb')
GGraph.set_axes('xlabelint'=>90)
GGraph.set_axes('ylabelint'=>30)

if dir =='..' then
  if ls == 0 then
    gphysout = gphys[false,alt,0..236].mean(-1)
  elsif ls == 90 then
    gphysout = gphys[false,alt,4642..4906].mean(-1)
#  gphysout = gphys.cut("Ls"=>ls)
  else
    gphysout = gphys[false,alt,true].cut("Ls"=>ls..lse).mean(-1)
  end
else
  if ls == 0 then
    gphysout = gphys[false,0..236].cut("level"=>alt).mean(-1)
  elsif ls == 90 then
    gphysout = gphys[false,4642..4906].cut("level"=>alt).mean(-1)
#  gphysout = gphys.cut("Ls"=>ls)
  else
    gphysout = gphys.cut("level"=>alt, "Ls"=>ls..lse).mean(-1)
  end
end

if vname == 'Geopotential' then
  gphysout = gphysout/Grav
end

p "kokomade"
# ٥ѥۤ˻
# ѥ1¿ޡޤ

if vname == 'U'
  levels = [-20.0, -18.0, -16.0, -14.0, -12.0, -10.0, -8.0, -6.0, -4.0, -2.0, 0.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0]
  patterns = [10999, 14999, 19999, 24999, 29999, 34999, 39999, 44999, 49999, 54999, 55999, 60999, 65999, 70999, 75999, 80999, 85999, 90999, 95999, 99999]
elsif vname == 'Temp'
  levels = [140, 145, 150, 155, 160, 165, 170, 175, 180, 185, 190, 195, 200, 205, 210, 215, 220, 225, 230, 235, 240, 245, 250, 255, 260]
  patterns = [20999, 23999, 26999, 29999, 32999, 35999, 38999, 41999, 44999, 47999, 50999, 53999, 56999, 59999, 62999, 65999, 68999, 71999, 74999, 77999, 80999, 83999, 86999, 89999, 92999]
elsif vname == 'Geopotential'
  #levels = [-10000, -9000, -8000, -7000, -6000, -5000, -4000, -3000, -2000, -1000, 0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000]
  #patterns = [10999, 14999, 19999, 24999, 29999, 34999, 39999, 44999, 49999, 54999, 55999, 60999, 65999, 70999, 75999, 80999, 85999, 90999, 95999, 99999]
infi = DCL.glpget('rmiss')
  levels = [infi, -5000, -4750, -4500, -4250, -4000, -3750, -3500, -3250, -3000, -2750, -2500, -2250, -2000, -1750, -1500, -1250, -1000, -750, -500, -250, 0, 250, 500, 750, 1000, 1250, 1500, 1750, 2000, 2250, 2500, 2750, 3000, 3250, 3500, 3750, 4000, 4250, 4500, 4750, 5000, infi ]
  patterns = [10999, 12999, 14999, 16999, 18999, 20999, 22999, 24999, 26999, 28999, 30999, 32999, 34999, 36999, 38999, 40999, 42999, 44999, 46999, 50999, 54999, 55999, 57999, 59999, 61999, 63999, 65999, 67999, 69999, 71999, 73999, 75999, 77999, 79999, 81999, 83999, 85999, 87999, 89999, 91999, 93999, 95999]
elsif vname == 'V'
  levels = [-24, -22, -20, -18, -16, -14, -12, -10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24]
  patterns = [10999, 12999, 13999, 14999, 19999, 24999, 29999, 34999, 39999, 44999, 49999, 54999, 55999, 60999, 65999, 70999, 75999, 80999, 85999, 90999, 95999, 96999, 98999, 99999]
end

if vname == 'Rain'
  gphysout= gphysout / 2.5e6
end


GGraph.tone( gphysout, true, 'lev'=>levels, 'pat'=>patterns, 'map_axes'=>true, 'annotate'=>false )
GGraph.color_bar
if vname == 'KMHF_d' or vname == 'NewmanF_d'
  ice = GPhys::NetCDF_IO.open('sagyou2.nc', 'SurfMajCompIce')
  iceout = ice.cut("Ls"=>ls)
#  iceout = dcpam_clim_mon_mean( iyrs, iyre, imon, ice )
#  iceout = iceout * (-1)
#  DCL.uepset('LTONE',false)
#  tlev1 = 10.0
#  tlev2 = DCL.glpget('RMISS')

  levels = [0,1]
#p tlev2
#  DCL::uestlv(tlev1,tlev2,301)
GGraph.contour(iceout,false,'levels'=>levels,'line_type'=>2,'label'=>false)
#  DCL::uetone(iceout.val)
#  DCL::udcntr(iceout.val) 

#GGraph.tone(iceout,false,'ltone'=>false)
  DCL::ueitlv
end
topog = GPhys::IO.open('./sp_for_Mars_T021_MGS.nc','topog')
#levels = 0*(NArray.float(7).indgen!)
levels = [0.0e0]
GGraph.set_contour_levels('levels'=>levels)
GGraph.contour(topog,false)

DCL::uxmttl('T', title, 1.0)

DCL.grcls

