!c Description: 
!c   2 ϳإǥ
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-11    ⶶ 
!c   1.1        2003-11-12    ̰ϯ 
!c   1.1        2003-11-17    ̰ϯ 
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

program arare
  use gtool_history
  use fileset
  use gridset
  use integrat
  use physprm
  use expname
  use if_jacobian

  !--- ۤηػ
  implicit none

  !--- 롼פ󤹤Τ˻Ȥѿ
  integer(8) :: i, k

  !--- ѿ
  real(8), allocatable :: u(:,:)       ! x ®
  real(8), allocatable :: w(:,:)       ! z* ®
  real(8), allocatable :: pi(:,:)      ! ʡؿ
  real(8), allocatable :: pres(:,:)    ! 
  real(8), allocatable :: temp(:,:)    ! 
  real(8), allocatable :: vtemp(:,:)   ! 
  real(8), allocatable :: theta(:,:)   ! 
  real(8), allocatable :: vtheta(:,:)  ! 
  real(8), allocatable :: dens(:,:)    ! ̩
  real(8), allocatable :: qv(:,:)      ! 
  real(8), allocatable :: e_sub(:,:)   ! ֥åɱưͥ륮
  real(8), allocatable :: km_sub(:,:)  ! 緸 K_{m}

  !--- å
  real(8), allocatable :: x(:)
  real(8), allocatable :: z(:)

  !--- Ϸ
  real(8), allocatable :: jcb(:,:)
  real(8), allocatable :: jcb_z(:,:)
  real(8), allocatable :: g13(:,:)
  real(8), allocatable :: g13_x(:,:)
  real(8), allocatable :: g13_z(:,:)
  real(8), allocatable :: g13_xz(:,:)
  
  !--- ȤꤢɬפȤʤ(ˤޤ˷׻)
  real(8), parameter :: dtdz = 6.0d-3   ! ǮٸΨ
  real(8), parameter :: rho = 2.9d-2    ! 絤 mol μ
  real(8), parameter :: cp = 1.952d3    ! 갵Ǯ
  real(8), parameter :: cv = 1.463d3    ! Ǯ

  
  !----------------------------------------------
  !⥸塼ν
  !----------------------------------------------
  call fileset_init
  call gridset_init
  call integrat_init
  call physprm_init
  call expname_init


  !-------------------------------------------------
  ! ϷϢ
  !-------------------------------------------------
  allocate(x(0:im+1), z(0:km+1))
  do i = 0, im+1
     x(i) = xmin + dx * real(i, 8)
  end do
  do k = 0, km+1
     z(k) = zmin + dz * real(k, 8)
  end do

  allocate(jcb(0:im+1,0:km+1), &
       & jcb_z(0:im+1,0:km+1), &
       & g13(0:im+1,0:km+1), &
       & g13_x(0:im+1,0:km+1), &
       & g13_z(0:im+1,0:km+1), &
       & g13_xz(0:im+1,0:km+1))
  call jacobian(jcb, jcb_z, g13, g13_x, g13_z, g13_xz)


  !-------------------------------------------------
  ! gtool_history ν
  !-------------------------------------------------
  call output_gtool4_init


  !-------------------------------------------------
  ! ܾ
  !-------------------------------------------------
  allocate(u(0:im+1,0:km+1), &
       &   w(0:im+1,0:km+1), &
       &   pi(0:im+1,0:km+1), &
       &   pres(0:im+1,0:km+1), &
       &   temp(0:im+1,0:km+1), &
       &   vtemp(0:im+1,0:km+1), &
       &   theta(0:im+1,0:km+1), &
       &   vtheta(0:im+1,0:km+1), &
       &   dens(0:im+1,0:km+1), &
       &   qv(0:im+1,0:km+1), &
       &   e_sub(0:im+1,0:km+1), &
       &   km_sub(0:im+1,0:km+1))

  !--- ٤ϼǮΨǸ
  do i = 0, km+1
     temp(:,i) = temp_sfc - dtdz * z(i) 
  end do
  
  !--- ŷʪ̵
  qv = 0.0d0
  u = 0.0d0
  w = 0.0d0
  e_sub = 0.0d0
  km_sub = 0.0d0

  !--- ɽ̤Ǥγ
  !---- 
  pres(:,0) = pres_sfc  
  !---- ̵
  pi(:,0) = (pres(:,0) / pres_sfc) ** ((gasr / rho) / cp)
  !---- 
  vtemp(:,0) = temp(:,0)
  !---- 
  theta(:,0) = temp(:,0) / pi(:,0)
  !---- 
  vtheta(:,0) = vtemp(:,0) / pi(:,0)
  !---- ̩ ()
  dens(:,0) = (pres_sfc / ((gasr / rho) * vtheta(:,0))) &
       & * (pi(:,0)) ** (cp / (gasr / rho)) 
  
  !--- ɽ̤Ǥγ
  do k = 1, km+1
     do i = 0, im+1
        !----  (ſ尵ʿ) 
        pres(i,k) = pres(i,k-1) - dens(i,k-1) * grav * jcb(i, k) * dz
        !---- ̵ (ſ尵ʿ)
        pi(i,k) = pi(i,k-1) - dz * jcb(i,k) * grav / (cp * vtheta(i,k-1))
        !---- 
        theta(i,k) = temp(i,k) / pi(i,k)
        !---- 
        vtheta(i,k) = theta(i,k) * (1.0d0 + 6.1d-1 * qv(i,k))
        !---- ̩
        dens(i,k) = (pres_sfc / ((gasr / rho) * vtheta(i,k))) &
             & * (pi(i,k)) ** (cp/(gasr / rho)) 
     end do
  end do
  
  !--- 
  call output_gtool4



contains

  !--- gtool4 ϴϢ
  subroutine output_gtool4_init
    ! ҥȥ꡼
    call HistoryCreate(                                    &
         & file = ncfile,                                &
         & title = exptitle,                             &
         & source = expsrc,                              &
         & institution = expinst,                        &
         & dims=(/'x','z','t'/),                           &
         & dimsizes=(/int(im+2, 4), int(km+2, 4), 0/), &
         & longnames=(/'X-coordinate','Z-coordinate',      &
         &             'Time        '/),                   &
         & units=(/'m','m','s'/), origin=0.0,              &
         & interval=real(dtsml))
    
    ! ѿ
    call HistoryPut('x',x)    
    call HistoryPut('z',z)
    
    ! 
    call HistoryAddVariable(                            &
         & varname='pres', dims=(/'x','z'/),             &
         & longname='pressure', units='Pa', xtype='double')
    ! ̵
    call HistoryAddVariable(                            &
         & varname='pi', dims=(/'x','z'/),             &
         & longname='nondimensional pressure', units='1',&
         & xtype='double')
    ! ̩
    call HistoryAddVariable(                            &
         & varname='dens', dims=(/'x','z'/),             &
         & longname='density', units='kg/m3',           &
         & xtype='double')
    ! 
    call HistoryAddVariable(                            &
         & varname='qv', dims=(/'x','z'/),             &
         & longname='mixing ratio of water vapor',      &
         &  units='g/g', xtype='double')
    ! 
    call HistoryAddVariable(                            &
         & varname='temp', dims=(/'x','z'/),             &
         & longname='temperature', units='K', xtype='double')
    ! 
    call HistoryAddVariable(                            &
         & varname='theta', dims=(/'x','z'/),             &
         & longname='potential temperature',         &
         & units='K', xtype='double')    
    
  end subroutine output_gtool4_init


  subroutine output_gtool4
    call HistoryPut('pres', pres)
    call HistoryPut('pi', pi)
    call HistoryPut('dens', dens)
    call HistoryPut('qv', qv)
    call HistoryPut('temp', temp)
    call HistoryPut('theta', theta)
  end subroutine output_gtool4

end program arare
