!c Description: 
!c   $BB.EY(B u $B$N7W;;(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-12-04    $B?y;39L0lO/(B $B:n@.(B
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_snddiv
  interface

     subroutine snddiv(u, w, div)
       real(8), intent(in)         :: u(:,:)
       real(8), intent(in)         :: w(:,:)
       real(8), intent(out)        :: div(:,:)
     end subroutine snddiv
     
  end interface
end module if_snddiv




subroutine snddiv(u, w, div)
  !--- $B%b%8%e!<%k$NFI$_9~$_(B
  use jacobian, only: g13_bxbz, jcb
  use if_heikin
  use if_bibun

  !--- $B0EL[$N7?@k8@6X;_(B
  implicit none

  !--- $BF~=PNOJQ?t(B
  real(8), intent(in)      :: u(:,:)
  real(8), intent(in)      :: w(:,:)
  real(8), intent(out)     :: div(:,:)

  !--- $BFbItJQ?t(B
  real(8), allocatable     :: u_x(:,:)
  real(8), allocatable     :: u_z(:,:)
  real(8), allocatable     :: w_z(:,:)

  !--- $BHyJ,1i;;(B
  call bibun(121, u, u_x)
  call bibun(122, u, u_z)
  call bibun(132, w, w_z)

  !--- $B2;GH8:?j9`(B
  div = u_x + g13_bxbz * u_z + (w_z / jcb)

  !---$BG[Ns$N2rJ|(B
  deallocate(u_x, u_z, w_z)

end subroutine snddiv


