!c Description: 
!c   $BB.EY(B u $B$N7W;;(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-04    $B9b66$3$&;R(B $B:n@.(B
!c   1.1        2003-11-20    $B?y;39L0lO/(B $B=$@5(B
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_vel_u
  interface

     subroutine vel_u(vtheta_bs, pi, div, u_adv, u_cori, u_trb, u)
       real(8), intent(in)               :: vtheta_bs(:,:)
       real(8), intent(in)               :: pi(:,:)
       real(8), intent(in)               :: div(:,:)
       real(8), intent(in)               :: u_adv(:,:)
       real(8), intent(in)               :: u_cori(:,:)
       real(8), intent(in)               :: u_trb(:,:)
       real(8), intent(out), allocatable :: u(:,:)       
     end subroutine vel_u

  end interface
end module if_vel_u




subroutine vel_u(vtheta_bs, pi, div, u_adv, u_cori, u_trb, u)

  !--- $B%b%8%e!<%k$NFI$_9~$_(B
  use jacobian, only: g13_bz 
  use integrt, only: dts
  use prm, only: cp, alpha
  use if_heikin
  use if_bibun

  !--- $B0EL[$N7?@k8@6X;_(B
  implicit none

  !--- $BF~=PNOJQ?t(B
  real(8), intent(in)               :: vtheta_bs(:,:)
  real(8), intent(in)               :: pi(:,:)
  real(8), intent(in)               :: div(:,:)
  real(8), intent(in)               :: u_adv(:,:)
  real(8), intent(in)               :: u_cori(:,:)
  real(8), intent(in)               :: u_trb(:,:)
  real(8), intent(out), allocatable :: u(:,:)

  !--- $BFbItJQ?t(B
  real(8), allocatable     :: vtheta_bx(:,:)
  real(8), allocatable     :: pi_x(:,:)
  real(8), allocatable     :: pi_z(:,:)
  real(8), allocatable     :: div_x(:,:)
  real(8), allocatable     :: div_z(:,:)

  !--- $BJ?6Q2=A`:n(B
  call heikin(21, vtheta_bs, vtheta_bx)
  
  !--- $BHyJ,1i;;(B
  call bibun(211, pi, pi_x)
  call bibun(212, pi, pi_z)
  call bibun(211, div, div_x)
  call bibun(212, div, div_z)

  !--- $BB.EY(B u
  u = &
       & u                                      &
       &   + dts * (                            &
       &      - cp * vtheta_bx * pi_x           &
       &      - alpha * cp * vtheta_bx * div_x  &
       &      - g13_bz * pi_z                   &
       &      - alpha * g13_bz * div_z          &
       &      - u_adv                           &
       &      + u_cori                          &
       &      + u_trb                           &
       &    )

  !---$BG[Ns$N2rJ|(B
  deallocate(vtheta_bx, pi_x, pi_z, div_x, div_z)


!  u(i,k) = u(i,k)                                           &
!       & + dts*(                                            &
!       &        - cp*(vptemp_bs(i+1,k) + vptemp_bs(i,k))    &
!       &          /2.0D0                                    &
!       &          *(                                        &
!       &            (pi(i,k)- pi(i-1,k))/dx                 &
!       &            - alp*div_x_u(i,k)                      &
!       &            + g13z(i,k)*(                           &
!       &                         (                          &
!       &                          pi(i,k+1) + pi(i+1,k+1)   &
!       &                          - pi(i,k-1)- pi(i-1,k-1)  &
!       &                         )/(2.0D0*dz)               &
!       &                         - alp*div_z_u(i,k)         &
!       &                        )                           &
!       &           )                                        &
!       &        - u_adv(i,k) + u_cori(i,k) + u_trb(i,k) &
!       &       )

end subroutine vel_u


