!c Description: 
!c   $BB.EY(B u $B$N7W;;(B
!c
!c Current Code Owner: 
!c   sugiyama@gfd-dennou.org
!c
!c Histry: 
!c   Version    Date          Comment
!c   -------    ----------    --------
!c   1.0        2003-11-04    $B9b66$3$&;R(B $B:n@.(B
!c   1.1        2003-11-20    $B?y;39L0lO/(B $B=$@5(B
!c
!c Copyright (C) SUGIYAMA Ko-ichiro, 2003, All rights reserved

module if_vel_u
  interface

     subroutine vel_u(pi, div, u_adv, u_cori, u_trb, u)
       use gridset, only: bm
       real(8), intent(in)               :: pi(-bm:,-bm:)
       real(8), intent(in)               :: div(-bm:,-bm:)
       real(8), intent(in)               :: u_adv(-bm:,-bm:)
       real(8), intent(in)               :: u_cori(-bm:,-bm:)
       real(8), intent(in)               :: u_trb(-bm:,-bm:)
       real(8), intent(inout)            :: u(-bm:,-bm:)       
     end subroutine vel_u

  end interface
end module if_vel_u




subroutine vel_u(pi, div, u_adv, u_cori, u_trb, u)

  !--- $B%b%8%e!<%k$NFI$_9~$_(B
  use gridset, only: bm, im
  use jacobian, only: g13_bz 
  use integrt, only: dts
  use prm, only: cp, alpha
  use basicenv, only: vtheta_bs
  use if_heikin
  use if_bibun

  !--- $B0EL[$N7?@k8@6X;_(B
  implicit none

  !--- $BF~=PNOJQ?t(B
  real(8), intent(in)      :: pi(-bm:,-bm:)
  real(8), intent(in)      :: div(-bm:,-bm:)
  real(8), intent(in)      :: u_adv(-bm:,-bm:)
  real(8), intent(in)      :: u_cori(-bm:,-bm:)
  real(8), intent(in)      :: u_trb(-bm:,-bm:)
  real(8), intent(inout)   :: u(-bm:,-bm:)

  !--- $BFbItJQ?t(B
  real(8), allocatable     :: vtheta_bx(:,:)
  real(8), allocatable     :: pi_x(:,:)
  real(8), allocatable     :: pi_z(:,:)
  real(8), allocatable     :: div_x(:,:)
  real(8), allocatable     :: div_z(:,:)

  !--- $BJ?6Q2=A`:n(B
  call heikin(21, vtheta_bs, vtheta_bx)
  
  !--- $BHyJ,1i;;(B
  call bibun(211, pi, pi_x)
  call bibun(212, pi, pi_z)
  call bibun(211, div, div_x)
  call bibun(212, div, div_z)

  !--- $BB.EY(B u
  u(0:im-1,:) =  &
       & u(0:im-1,:)                                                &
       &   + dts * (                                                &
       &      - cp * vtheta_bx(0:im-1,:) * pi_x(0:im-1,:)           &
       &      - alpha * cp * vtheta_bx(0:im-1,:) * div_x(0:im-1,:)  &
       &      - g13_bz(0:im-1,:) * pi_z(0:im-1,:)                   &
       &      - alpha * g13_bz(0:im-1,:) * div_z(0:im-1,:)          &
       &      - u_adv(0:im-1,:)                                     &
       &      + u_cori(0:im-1,:)                                    &
       &      + u_trb(0:im-1,:)                                     &
       &    )


  !---$BG[Ns$N2rJ|(B
  deallocate(vtheta_bx, pi_x, pi_z, div_x, div_z)


end subroutine vel_u
