!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2004, 2005, 2006. All rights reserved.
!---------------------------------------------------------------------
!= Subroutine BasicEnv
!
!   * Developer: SUGIYAMA Ko-ichiro, ODAKA Masatsugu
!   * Version: $Id: basicenv.f90,v 1.17 2006/09/20 13:42:18 sugiyama Exp $
!   * Tag Name: $Name: arare4-20060922 $
!   * Change History: 
!
!== Overview 
!
!ǥեȤδܾꤹ뤿ѿȷ⥸塼
!   * BasicEnvFile_init: ܾͤ netCDF ե뤫
!   * BasicEnvCalc_Init: ܾξ Namelist ͤ׻
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

subroutine BasicEnv()
  !
  !ǥեȤδܾꤹ뤿Υ֥롼. 
  !ܾ׻, BasicSet ⥸塼ͤ. 
  !
  !ѥν꤫, ܾ(hogeBasicZ ѿ)
  !׻ʬBasicSet ⥸塼뤫ڤΥƤ. 
  !ECCM Ϥ, BasicSet Τ˰¸뤬 hogeBasicZ  use ʤ
  !֥롼Ѥ뤿Ǥ. 
  !

  !⥸塼ɤ߹
  use gridset,  only: DimXMin,       &! X β
    &                 DimXMax,       &! X ξ
    &                 DimZMin,       &! Z β
    &                 RegZMin,       &! Z β
    &                 DimZMax,       &! Z ξ
    &                 SpcNum,        &!Žʬο
    &                 s_Z,           &!顼ʻǤι
    &                 DelZ            !Z γʻֳ
  use basicset, only: BasicSetArray_Init, &!
    &                 PressBasis,    &!̤δవ
    &                 GasRDry,       &!ʬ갵Ǯ
    &                 CpDry,         &!ʬ갵Ǯ
    &                 CvDry,         &!ʬǮ
    &                 MolWtDry,      &!ʬʬ
    &                 Grav,          &!ϲ®
    &                 SpcWetMolFr,   &!Žʬν
    &                 MolWtWet,      &!Žʬʬ
    &                 EnvType,       &!ܾ
    &                 Tropopause,    &!ή̹
    &                 GasRUniv,      &!
    &                 Humidity,      &!ܾм
    &                 TempStrat,     &!طβ [k]
    &                 Dhight          !ŤߴؿΥѥ᡼ [m]
  use Boundary, only: xz_BoundaryXCyc_xz,  &!
    &                 xz_BoundaryZSym_xz,  &!  
    &                 xza_BoundaryXCyc_xza,&!
    &                 xza_BoundaryZSym_xza  !  
  use ECCM,     only: ECCM_Temp_Press, &!
    &                 ECCM_MolFr
  
  !ۤηػ
  implicit none

  !ѿ
  real(8) :: xz_DensBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_PressBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_ExnerBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_TempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_PotTempBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xz_VelSoundBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: xza_MixRtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
  real(8) :: xz_EffMolWtBasicZ(DimXMin:DimXMax, DimZMin:DimZMax)
  real(8) :: z_TempBasicZ(DimZMin:DimZMax)
  real(8) :: z_PressBasicZ(DimZMin:DimZMax)
  real(8) :: MolFrIni(SpcNum)
  real(8) :: xza_MolFr(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
  real(8) :: za_MolFr(DimZMin:DimZMax, SpcNum)
  real(8) :: xza_MixRtDivMolWt(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
  real(8) :: z_DTempDZ(DimZMin:DimZMax)
  real(8) :: DTempDZ
  real(8) :: Weight
  integer :: i, k, s

  real(8),allocatable :: z_TempBasicZ_Dry (:)
  real(8),allocatable :: z_PressBasicZ_Dry(:)
  real(8),allocatable :: z_TempBasicZ_Moist (:)
  real(8),allocatable :: z_PressBasicZ_Moist(:)

  !---------------------------------------------------------------
  ! ν
  !---------------------------------------------------------------

  allocate( z_TempBasicZ_Dry   (DimZMin:DimZMax) )
  allocate( z_PressBasicZ_Dry  (DimZMin:DimZMax) )
  allocate( z_TempBasicZ_Moist (DimZMin:DimZMax) )
  allocate( z_PressBasicZ_Moist(DimZMin:DimZMax) )


  xz_DensBasicZ     = 0.0d0
  xz_PressBasicZ    = 0.0d0
  xz_ExnerBasicZ    = 0.0d0
  xz_TempBasicZ     = 0.0d0
  xz_PotTempBasicZ  = 0.0d0
  xz_VelSoundBasicZ = 0.0d0
  xza_MixRtBasicZ   = 0.0d0
  xz_EffMolWtBasicZ = 0.0d0
  z_TempBasicZ      = 0.0d0
  z_PressBasicZ     = 0.0d0
  za_MolFr          = 0.0d0


  !---------------------------------------------------------------
  ! EnvType 򸵤, , , 
  !---------------------------------------------------------------

!  if (trim(EnvType) == 'Dry') then 
!    MolFrIni = 0.0d0
!  elseif (trim(EnvType) == 'Moist') then 
!    MolFrIni = SpcWetMolFr(1:SpcNum) 
!  end if

  ! ή̤ޤǤǮʿվ֤ȤͿ
!  call ECCM_Temp_Press( MolFrIni, z_TempBasicZ, z_PressBasicZ )
 

  ! Ǯ
  MolFrIni = 0.0d0
  call ECCM_Temp_Press( MolFrIni, z_TempBasicZ_Dry, z_PressBasicZ_Dry )

  ! Ǯ
  MolFrIni = SpcWetMolFr(1:SpcNum) 
  call ECCM_Temp_Press( MolFrIni, z_TempBasicZ_Moist, z_PressBasicZ_Moist)

  ! EnvType ˤʬ
  ! 
  ! * Dry  : Ǯ
  ! * Moist: Ǯ
  ! * CI   : դ԰
  !
  if (trim(EnvType) == 'Dry') then 

    z_TempBasicZ  = z_TempBasicZ_Dry
    z_PressBasicZ = z_PressBasicZ_Dry

  elseif (trim(EnvType) == 'Moist') then 

    z_TempBasicZ  = z_TempBasicZ_Moist
    z_PressBasicZ = z_PressBasicZ_Moist

  elseif (trim(EnvType) == 'CI') then 

    z_TempBasicZ  = (z_TempBasicZ_Dry    + z_TempBasicZ_Moist )/2.0d0
    z_PressBasicZ = (z_PressBasicZ_Moist + z_PressBasicZ_Moist)/2.0d0

  end if

  do k = RegZMin+1, DimZMax-1
    z_DTempDZ(k) = (z_TempBasicZ(k) - z_TempBasicZ(k-1)) / DelZ
  end do

  ! ή̤ΰ
  !   ̤絤Ȥ. 絤絤ؤܤ 
  !   tanh ѤƤʤ餫ˤĤʤ
  do k = RegZMin+1, DimZMax-1     
    
    !ŤߤĤδؿѰ. tanh Ѥ
    Weight = ( tanh( (s_Z(k) - tropopause ) / Dhight ) + 1.0d0 ) * 5.0d-1
    
    !ͤȤƲ٤׻. ̤Ǥ 220 K 絤˶Ť
    z_TempBasicZ(k) = z_TempBasicZ(k) * ( 1.0d0 - Weight ) + TempStrat * Weight
    
    !ٸΨǮٸΨ꾮ʤʤ褦
    DTempDZ = &
      & max( z_DTempDZ(k), (z_TempBasicZ(k) - z_TempBasicZ(k-1)) / DelZ )
    
    !ܾβ٤
    z_TempBasicZ(k) = z_TempBasicZ(k-1) + DTempDZ * DelZ 
    
    !Ϥſ尵ʿդ׻
    z_PressBasicZ(k) =                                                    &
      &  z_PressBasicZ(k-1) * ( ( z_TempBasicZ(k-1) / z_TempBasicZ(k) )   &
      &    ** (Grav * MolWtDry / ( DTempDZ * GasRUniv ) ) )

    write(*,*) "temp", k, s_Z(k), DTempDZ, z_TempBasicZ(k), z_PressBasicZ(k)
  end do

  ! 2 ˳Ǽ
  do i = DimXMin, DimXMax
    xz_TempBasicZ(i,:)  = z_TempBasicZ  
    xz_PressBasicZ(i,:) = z_PressBasicZ  
  end do

  !
  xz_TempBasicZ  = xz_BoundaryXCyc_xz( xz_TempBasicZ )
  xz_TempBasicZ  = xz_BoundaryZSym_xz( xz_TempBasicZ )
  xz_PressBasicZ = xz_BoundaryXCyc_xz( xz_PressBasicZ )
  xz_PressBasicZ = xz_BoundaryZSym_xz( xz_PressBasicZ )
  
  !---------------------------------------------------------------
  ! 
  !---------------------------------------------------------------
  !ľʪʬ()
  !  ǤϤʤΤŪ. 
  call ECCM_MolFr( SpcWetMolFr(1:SpcNum), Humidity, z_TempBasicZ, &
    &              z_PressBasicZ, za_MolFr )

  !ʿˤϰ
  do i = DimXMin, DimXMax      
    xza_MolFr(i,:,:) = za_MolFr
  end do    

  !Υ򺮹Ѵ
  do s = 1, SpcNum
    xza_MixRtBasicZ(:,:,s) = xza_MolFr(:,:,s) * MolWtWet(s) / MolWtDry
  end do

!  !ͤʤꤹʤ褦˺ͤͿ
!  where (xza_MixRtBasicZ <= 1.0d-20 )
!    xza_MixRtBasicZ = 1.0d-20
!  end where
  
  !
  xza_MixRtBasicZ = xza_BoundaryXCyc_xza( xza_MixRtBasicZ )
  xza_MixRtBasicZ = xza_BoundaryZSym_xza( xza_MixRtBasicZ )
  
      
  !---------------------------------------------------------------
  ! ʬ̤θ
  !---------------------------------------------------------------
  do s = 1, SpcNum
    xza_MixRtDivMolWt(:,:,s) = xza_MixRtBasicZ(:,:,s) / MolWtWet(s)
  end do
  
  xz_EffMolWtBasicZ = &
    & 1.0d0 -  sum(xza_MixRtDivMolWt,3) &
    &            / ((1.0d0 / MolWtDry) + sum(xza_MixRtDivMolWt,3))  &
    & * (1.0d0 + sum(xza_MixRtBasicZ,3) )

  !  
  xz_EffMolWtBasicZ = xz_BoundaryXCyc_xz( xz_EffMolWtBasicZ )
  xz_EffMolWtBasicZ = xz_BoundaryZSym_xz( xz_EffMolWtBasicZ )
  
  
  !---------------------------------------------------------------    
  ! 
  !---------------------------------------------------------------
  xz_PotTempBasicZ = &
    & xz_TempBasicZ * (PressBasis / xz_PressBasicZ) ** (GasRDry / CpDry) 

  !  
  xz_PotTempBasicZ = xz_BoundaryXCyc_xz( xz_PotTempBasicZ )
  xz_PotTempBasicZ = xz_BoundaryZSym_xz( xz_PotTempBasicZ )

  !---------------------------------------------------------------    
  ! ʡؿ
  !---------------------------------------------------------------
  xz_ExnerBasicZ = xz_TempBasicZ / xz_PotTempBasicZ    

  !
  xz_ExnerBasicZ = xz_BoundaryXCyc_xz( xz_ExnerBasicZ )
  xz_ExnerBasicZ = xz_BoundaryZSym_xz( xz_ExnerBasicZ )

  
  !---------------------------------------------------------------    
  ! ̩
  !---------------------------------------------------------------
  xz_DensBasicZ = &
    & PressBasis * (xz_ExnerBasicZ ** (CvDry / GasRDry)) &
    &  / (GasRDry * xz_PotTempBasicZ / xz_EffMolWtBasicZ)

  !
  xz_DensBasicZ = xz_BoundaryXCyc_xz( xz_DensBasicZ )
  xz_DensBasicZ = xz_BoundaryZSym_xz( xz_DensBasicZ )
  

  !---------------------------------------------------------------    
  ! ®
  !---------------------------------------------------------------
  xz_VelSoundBasicZ = &
    & sqrt ( &
    &   CpDry * GasRDry * xz_ExnerBasicZ * xz_PotTempBasicZ &
    &   / (CvDry * xz_EffMolWtBasicZ) &
    & )

  !
  xz_VelSoundBasicZ = xz_BoundaryXCyc_xz( xz_VelSoundBasicZ )
  xz_VelSoundBasicZ = xz_BoundaryZSym_xz( xz_VelSoundBasicZ )

 
  !----------------------------------------------------------
  ! BasicSet ⥸塼ͤ
  !----------------------------------------------------------
  call BasicSetArray_Init(                                  &
    & xz_PressBasicZ,    xz_ExnerBasicZ, xz_TempBasicZ,     &
    & xz_PotTempBasicZ,  xz_DensBasicZ,  xz_VelSoundBasicZ, &
    & xza_MixRtBasicZ, xz_EffMolWtBasicZ )

end subroutine BasicEnv
