!= Module TimeSet
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: timeset.f90,v 1.2 2006/09/21 02:41:52 odakker Exp $ 
! Tag Name::  $Name: arare4-20060922 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!

module timeset
  !
  !Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
  !ݴɤ뤿ѿ⥸塼
  !
  
  !ۤηػ
  implicit none

  !save °
  save

  ! Public Interface
  real(8)           :: DelTimeLong    !Ĺॹƥå
  real(8)           :: DelTimeShort   !ûॹƥå
  real(8)           :: TimeInt        !ʬ
  real(8)           :: TimeDisp       !եϤֳִ
  real(8)           :: DayTime        ! 1 Ĺ [s]
  integer           :: NstepLong      !ĹॹƥåפΥƥå׿
  integer           :: NstepShort     !ûॹƥåפΥƥå׿

contains

  subroutine timeset_init(cfgfile)
    !
    !NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
    !

    !⥸塼ɤ߹
    use dc_message,    only: MessageNotify

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile
    
    !NAMELIST 
    NAMELIST /timeset/ &
         & DelTimeLong, DelTimeShort, TimeInt, TimeDisp, DayTime
    
    open (10, FILE=cfgfile)
    read(10, NML=timeset)
    close(10)

    !---------------------------------------------------------------
    ! 롼ײ
    !---------------------------------------------------------------
    NstepLong = nint( TimeInt / DelTimeLong )
    NstepShort = 2 * nint( DelTimeLong / DelTimeShort )
    
    !ʬ֤Ĺ֥ƥåפǳڤʤˤϷٹФ
    if(mod(TimeInt, DelTimeLong) /= 0) then 
      call MessageNotify("Message", "timeset_init", &
        &                "mod(TimeInt, DelTimeLong) is not zero")
    end if
    
    !Ĺ֥ƥåפû֥ƥåפǳڤʤˤϷٹФ
    if(mod(DelTimeLong, DelTimeShort) /= 0) then 
      call MessageNotify("Message", "timeset_init", &
        &                "mod(DelTimeLong, DelTimeShort) is not zero")
    end if
    
    !ʬ֤ϻֳִ֤ǳڤʤˤϷٹФ
    if(mod(TimeDisp, DelTimeLong) /= 0) then 
      call MessageNotify("Message", "timeset_init", &
        &                "mod(TimeDisp, DelTimeLong) is not zero")
    end if
        
    !---------------------------------------------------------------
    ! ǧ
    !---------------------------------------------------------------
    write(*,*) "timeset_init, DelTimeLong ", DelTimeLong
    write(*,*) "timeset_init, DelTimeShort", DelTimeShort
    write(*,*) "timeset_init, NstepLong   ", NstepLong
    write(*,*) "timeset_init, NstepShort  ", NstepShort
    write(*,*) "timeset_init, TimeInt     ", TimeInt
    write(*,*) "timeset_init, TimeDisp    ", TimeDisp
    write(*,*) "dataset_init, DayTime     ", DayTime
   
  end subroutine timeset_init
  
end module timeset
