!= Module Damping
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: damping.f90,v 1.4 2006/09/21 02:35:16 odakker Exp $
! Tag Name::  $Name: arare4-20060922 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ΨȤη׻ԤΥѥå⥸塼
!  * ȸη
!  * ݥؤ(նȤȿͤޤۼ뤿)
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!  * δؿ, ܾ줬ѿ(®, ʡؿξ)
!    ŬѤ뤳ȤꤷƤ. 
!  * ƳʻФؿɬפ
!
!== Future Plans
!
!

module Damping
  !
  !ΨȤη׻ԤΥѥå⥸塼
  !  * ȸη
  !  * ݥؤ(նȤȿͤޤۼ뤿)
  ! 

  !⥸塼ɤ߹
  use gridset, only: DimXMin,       &! x β
    &                DimXMax,       &! x ξ
    &                DimZMin,       &! z β
    &                DimZMax,       &! z ξ
    &                DelX,          &! x γʻֳ
    &                DelZ,          &! z γʻֳ
    &                s_X,           &!X ɸ(顼ʻ)
    &                s_Z,           &!Z ɸ(顼ʻ)
    &                f_X,           &!X ɸ(եåʻ)
    &                f_Z,           &!Z ɸ(եåʻ)
    &                XMax,          &!X ɸκ
    &                ZMax            !Z ɸκ
  use timeset,   only: DelTimeShort  !û֥ƥå
  
  !ۤηػ
  implicit none

  !private °
  private 
  
  !ؿˤ public °
  public Damping_Init
  public DampSound_Init
  public DampSponge_Init
  public xz_DampSponge_xz
  public xr_DampSponge_xr
  public pz_DampSponge_pz
  public xz_DampSponge
  public xr_DampSponge
  public pz_DampSponge
  public DampSound

  !ѿ
  real(8)  :: DampSound  = 0.0d0   !ȸθ그

  real(8)  :: EFTime     = 100.0d0 !ݥؤ e-folding time
  real(8)  :: DampDepthH = 0.0d0   !ݥؤθ(ʿ)
  real(8)  :: DampDepthV = 0.0d0   !ݥؤθ(ľ)
  real(8), allocatable    :: xz_DampRateH(:,:) !ss ʻ그(ʿ)
  real(8), allocatable    :: xz_DampRateV(:,:) !ss ʻ그(ľ)
  real(8), allocatable    :: pz_DampRateH(:,:) !fs ʻ그(ʿ)
  real(8), allocatable    :: pz_DampRateV(:,:) !fs ʻ그(ľ)
  real(8), allocatable    :: xr_DampRateH(:,:) !sf ʻ그(ʿ)
  real(8), allocatable    :: xr_DampRateV(:,:) !sf ʻ그(ľ)
  
  !ͤ save 
  save DampSound, EFTime, DampDepthH, DampDepthV
  save xz_DampRateH, xz_DampRateV
  save xr_DampRateH, xr_DampRateV
  save pz_DampRateH, pz_DampRateV
  
contains 
  
!!!------------------------------------------------------------------------!!!
  subroutine Damping_Init( cfgfile ) 
    !
    ! ȸȥݥؤθ그ν
    ! 

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile
    real(8)                  :: Alpha    !ȸη
    real(8)                  :: Time     !
    real(8)                  :: DepthH   !ݥؤθ(ʿ)
    real(8)                  :: DepthV   !ݥؤθ(ľ)

    !NAMELIST 
    NAMELIST /damping/ Alpha, Time, DepthH, DepthV
    open (10, FILE=cfgfile)
    read(10, NML=damping)
    close(10)

    !
    call DampSound_Init( Alpha ) 
    call DampSponge_Init( Time, DepthH, DepthV )


  end subroutine Damping_Init


!!!------------------------------------------------------------------------!!!
  subroutine DampSound_Init( damp ) 
    !
    ! ȸθ그ν
    ! 

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)  :: damp

    !-------------------------------------------------------------------
    ! ȸθΨ   Min(DelX, DelZ) ** 2.0 ˰¸?
    !-------------------------------------------------------------------
    DampSound = Damp * ( Min(DelX, DelZ) ** 2.0d0 ) / DelTimeShort
    
    !-----------------------------------------------------------------    
    ! ͤγǧ
    !-----------------------------------------------------------------
    write(*,*) "DampSound_init, DampSound : ", DampSound

  end subroutine DampSound_Init


!!!------------------------------------------------------------------------!!!
  subroutine DampSponge_Init( Time, DepthH, DepthV )
    !
    ! ݥؤθ그
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: Time     !ݥؤ e-folding time
    real(8), intent(in)   :: DepthH   !ݥؤθ(ʿ)
    real(8), intent(in)   :: DepthV   !ݥؤθ(ľ)
    real(8), parameter    :: Pi =3.1415926535897932385d0   !߼Ψ
    integer               :: i, k

    !
    allocate( &
      & xz_DampRateH(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xz_DampRateV(DimXMin:DimXMax, DimZMin:DimZMax), &
      & pz_DampRateH(DimXMin:DimXMax, DimZMin:DimZMax), &
      & pz_DampRateV(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xr_DampRateH(DimXMin:DimXMax, DimZMin:DimZMax), &
      & xr_DampRateV(DimXMin:DimXMax, DimZMin:DimZMax)    )
    xz_DampRateH = 0.0d0
    xz_DampRateV = 0.0d0
    pz_DampRateH = 0.0d0
    pz_DampRateV = 0.0d0
    xr_DampRateH = 0.0d0
    xr_DampRateV = 0.0d0

    !ͤ
    EFTime     = Time
    DampDepthH = DepthH
    DampDepthV = DepthV
    
    !-----------------------------------------------------------------    
    ! ݥؤθΨ
    !-----------------------------------------------------------------
    !ʿ¦¦
    if ( DampDepthH < DelX ) then 
!      write(*,*) "DampDepthH is too thin. DelX is ", DelX   !ٹΤ߽

    else
      do i = DimXMin, DimXMax
        !顼ʻ¦
        if ( s_X(i) < DampDepthH) then 
          xz_DampRateH(i,:) = ((1.0d0 - s_X(i) / DampDepthH) ** 3.0d0) / EFTime
        end if
        
        !եåʻ¦
        if ( f_X(i) < DampDepthH) then 
          pz_DampRateH(i,:) = ((1.0d0 - f_X(i) / DampDepthH) ** 3.0d0) / EFTime
         end if
        
        !顼ʻ¦    
        if ( s_X(i) > ( XMax - DampDepthH ) ) then 
          xz_DampRateH(i,:) = &
            & ((1.0d0 - (XMax - s_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
        
        !եåʻ¦    
        if ( f_X(i) > ( XMax - DampDepthH ) ) then 
          pz_DampRateH(i,:) = &
            & ((1.0d0 - (XMax - f_X(i)) / DampDepthH) ** 3.0d0) / EFTime 
        end if
      end do
    end if
    !sf  ss  X ˴ؤƤƱ
    xr_DampRateH  = xz_DampRateH
    
    !ľξ    
    if ( DampDepthV < DelZ ) then 
!      write(*,*) "DampDepthV is too thin. DelZ is ", DelZ   !ٹΤɽ
      
    else
      do k = DimZMin, DimZMax
        !顼ʻ
        if ( s_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xz_DampRateV(:,k) =  &
            & (1.0d0 - dcos(Pi * (s_Z(k) - ZMax + DampDepthV) / DampDepthV)) &
            &  / EFTime 
        end if
        
        !եåʻ
        if ( f_Z(k) >= ( ZMax - DampDepthV ) ) then 
          xr_DampRateV(:,k) =  &
            & (1.0d0 - dcos(Pi * (f_Z(k) - ZMax + DampDepthV)/ DampDepthV)) &
            &  / EFTime 
        end if
      end do
    end if
    !fs  ss  Z ˴ؤƤƱ
    pz_DampRateV  = xz_DampRateV
    
    !-----------------------------------------------------------------    
    ! ͤγǧ
    !-----------------------------------------------------------------
    write(*,*) "DampSponge_Init, EFTime :    ", EFTime 
    write(*,*) "DampSponge_Init, DampDepthH: ", DampDepthH 
    write(*,*) "DampSponge_Init, DampDepthV: ", DampDepthV    

  end subroutine DampSponge_Init
  

!!!------------------------------------------------------------------------!!!
  function xz_DampSponge_xz(xz_Var)
    !
    ! ss ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xz_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)               :: xz_DampSponge_xz(DimXMin:DimXMax, DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻
    xz_DampSponge_xz =  ( xz_DampRateH + xz_DampRateV ) * xz_Var
    
  end function xz_DampSponge_xz


!!!------------------------------------------------------------------------!!!
  function xz_DampSponge(xz_VarA, xz_VarB, DelTime)
    !
    ! ss ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xz_VarA(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: xz_VarB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: DelTime
    real(8)               :: xz_DampSponge(DimXMin:DimXMax, DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻
    xz_DampSponge =  xz_VarA - ( xz_DampRateH + xz_DampRateV ) * xz_VarB * DelTime
    
  end function xz_DampSponge


!!!------------------------------------------------------------------------!!!
  function xr_DampSponge_xr(xr_Var)
    !
    ! sf ʻФ륹ݥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xr_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)               :: xr_DampSponge_xr(DimXMin:DimXMax, DimZMin:DimZMax)

    !ݥؤˤԥ󥰤׻  
    xr_DampSponge_xr =  ( xr_DampRateH + xr_DampRateV )* xr_Var
    
  end function xr_DampSponge_xr


!!!------------------------------------------------------------------------!!!
  function xr_DampSponge(xr_VarA, xr_VarB, DelTime)
    !
    ! sf ʻФ륹ݥ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: xr_VarA(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: xr_VarB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: DelTime
    real(8)               :: xr_DampSponge(DimXMin:DimXMax, DimZMin:DimZMax)

    !ݥؤˤԥ󥰤׻  
    xr_DampSponge =  xr_VarA - ( xr_DampRateH + xr_DampRateV )* xr_VarB * DelTime
    
  end function xr_DampSponge


!!!------------------------------------------------------------------------!!!
  function pz_DampSponge_pz(pz_Var)
    !
    ! fs ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: pz_Var(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8)               :: pz_DampSponge_pz(DimXMin:DimXMax, DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻  
    pz_DampSponge_pz = ( pz_DampRateH + pz_DampRateV ) * pz_Var
    
  end function pz_DampSponge_pz
  

!!!------------------------------------------------------------------------!!!
  function pz_DampSponge(pz_VarA, pz_VarB, DelTime)
    !
    ! fs ʻФ륹ݥ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8), intent(in)   :: pz_VarA(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: pz_VarB(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)   :: DelTime
    real(8)               :: pz_DampSponge(DimXMin:DimXMax, DimZMin:DimZMax)
    
    !ݥؤˤԥ󥰤׻  
    pz_DampSponge = pz_VarA - ( pz_DampRateH + pz_DampRateV ) * pz_VarB * DelTime
    
  end function pz_DampSponge
  
end module Damping
