!= Subroutine TimeFilter
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: timefilter.f90,v 1.3 2006/09/21 02:35:16 odakker Exp $
! Tag Name::  $Name: arare4-20060922 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!åλ֥ե륿. leap-frog θŬ. 
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module TimeFilter

  !⥸塼ɤ߹
  use GridSet,  only: DimXMin,     & !x β
    &                 DimXMax,     & !x ξ
    &                 DimZMin,     & !z β
    &                 DimZMax,     & !z ξ
    &                 SpcNum         !ؼο

  !ۤηػ
  implicit none

  !°
  private

  !ؿ public °
  public AsselinFilter
  public xza_AsselinFilter_xza_xza_xza

  !ѿ
  real(8) :: tfil = 1.0d-1  !åλ֥ե륿η

  !ͤ save 
  save tfil
  
contains
  
  function AsselinFilter(VarA, VarN, VarB)
    !
    ! ֥ե륿; Asselin Υե륿
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)     :: VarA(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(in)     :: VarN(DimXMin:DimXMax, DimZMin:DimZMax)
    real(8), intent(inout)  :: VarB(DimXMin:DimXMax, DimZMin:DimZMax)  
    real(8)                 :: AsselinFilter(DimXMin:DimXMax, DimZMin:DimZMax)

    !֥ե륿
    AsselinFilter = VarN + tfil * ( VarB  - 2.0d0 * VarN + VarA ) 
    
  end function AsselinFilter
  

  function xza_AsselinFilter_xza_xza_xza( xza_VarA, xza_VarN, xza_VarB )
    !
    ! ֥ե륿; Asselin Υե륿
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)     :: xza_VarA(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8), intent(in)     :: xza_VarN(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8), intent(inout)  :: xza_VarB(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)
    real(8)                 :: xza_AsselinFilter_xza_xza_xza(DimXMin:DimXMax, DimZMin:DimZMax, SpcNum)

    !֥ե륿
    xza_AsselinFilter_xza_xza_xza &
      & = xza_VarN + tfil * ( xza_VarB  - 2.0d0 * xza_VarN + xza_VarA ) 
    
  end function xza_AsselinFilter_xza_xza_xza
  
end module TimeFilter
