!= Module HeatFlux
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: heatflux.f90,v 1.16 2006/11/27 02:18:46 sugiyama Exp $
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
! Υեåˤ벹٤ȶŷʬѲΨХ륯ˡ
! ŤƷ׻⥸塼.  
!
! Ǯեå Fh ȶŷʪΥեå Fq Ȥ, ٤ȶŷʪ
! ѲΨ H, Q 
!
!   H = Fh/z_1  
!   Q = Fq/z_1  
!
! ɽ.  z_1 ϺǲؤγʻҴֳ֤Ǥ.  
!
! Ǯեå Fh ȶŷʪΥեå Fq ϰʲμˤä
! ׻.
!
!   Fh = - Cd|V| * _1_1 
!   Fh = - Cd|V| * Q_1 
!
!  _1, Q_1, _1 Ϻǲؤβ٤ȶŷʪκ椪̵
! ϴؿ, T_sfc ϲβ, Q*(T_sfc)  T_sfc Ƿޤ˰º
! Ǥ. 
!
! Ǥϥǥǲؤβ٤᤹褦˥եåͿ. 
!
! ® v ȥХ륯 Cd ϰȤ. ̵ϴؿ _1 ϴܾ
! ͤѤ.
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module HeatFlux
  !
  !ǤΥեåη׻⥸塼
  !
  
  !⥸塼ɤ߹
  use gridset,  only: DimXMin,         & !x β
    &                 DimXMax,         & !x ξ
    &                 DimZMin,         & !z β
    &                 DimZMax,         & !z ξ
    &                 RegZMin,         & !z ʪΰβ
    &                 SpcNum,          & !
    &                 DelZ               !z γʻֳ
  use basicset, only: xz_ExnerBasicZ,  & !ʡؿδܾ
    &                 xz_PotTempBasicZ, &!
    &                 TempSfc
  use StoreSet,  only: StoreFlux
  use StoreSet2, only: Store2Flux

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public 
  public xz_HeatFluxBulk
  public xz_MixRtFluxBulk
  public xz_HeatFluxDiff
  public xz_MixRtFluxDiff
  public xza_MixRtFluxDiff

  !ѿ
  real(8)  :: Bulk = 1.5d-3        !Ǯư̥եåΥХ륯
  real(8)  :: Kappa = 800.0d0

  !ͤ¸
  save Bulk
  save Kappa

contains


!!!------------------------------------------------------------------------!!!
  function xz_HeatFluxBulk( xz_PotTemp )
    !
    ! Υեåˤ벹٤ѲΨХ륯ˡ
    ! ŤƷ׻.  
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)   :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !̤ξʬ    
    real(8)               :: xz_HeatFluxBulk(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !ɽǮեå
    real(8)  :: VelX = 100.0d0             !ؤǤοʿ®٤ᤦ

    !
    !  * Ƥͤ򥼥˸
    xz_HeatFluxBulk = 0.0d0
    
    !ɽǮեå׻
    !  * ñ̤ K/s
    !  * ʻ xz Ǥ, ʪΰκǲüź RegZMin+1
    !
    xz_HeatFluxBulk(:,RegZMin+1) =                        &
      & max(                                              &
      &         0.0d0,                                    &
      &       - Bulk * VelX * xz_ExnerBasicZ(:,RegZMin+1) &
      &          * xz_PotTemp(:,RegZMin+1) / DelZ         &
      &    )
    
  end function xz_HeatFluxBulk
  
!!!------------------------------------------------------------------------!!!
  function xz_MixRtFluxBulk( xz_MixRt )
    !
    ! ΥեåˤŷʬѲΨХ륯ˡ
    ! ŤƷ׻.  
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)   :: xz_MixRt(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !̤ξʬ    
    real(8)               :: xz_MixRtFluxBulk(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !ɽǮեå
    real(8)  :: VelX = 100.0d0             !ؤǤοʿ®٤ᤦ

    !
    !  * Ƥͤ򥼥˸
    xz_MixRtFluxBulk = 0.0d0

    
    xz_MixRtFluxBulk(:,RegZMin+1) =                        &
      & max(                                               &         
      &         0.0d0,                                     &
      &       - Bulk * VelX * xz_MixRt(:,RegZMin+1) / DelZ &
      &    )
    
  end function xz_MixRtFluxBulk


!!!------------------------------------------------------------------------!!!
  function xz_HeatFluxDiff( xz_PotTemp )

    implicit none

    real(8), intent(in)   :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8)               :: xz_HeatFluxDiff(DimXMin:DimXMax,DimZMin:DimZMax)

    xz_HeatFluxDiff = 0.0d0

    xz_HeatFluxDiff(:,RegZMin+1) =                                        &
      &  - Kappa * xz_PotTemp(:,RegZMin+1) * xz_ExnerBasicZ(:, RegZMin+1) &
      &    / ( ( DelZ * 5.0d-1 ) ** 2.0d0 )

    call StoreFlux( xz_HeatFluxDiff )

  end function xz_HeatFluxDiff


!!!------------------------------------------------------------------------!!!
  function xz_MixRtFluxDiff( xz_MixRt )

    implicit none

    real(8), intent(in)   :: xz_MixRt(DimXMin:DimXMax,DimZMin:DimZMax)
    real(8)               :: xz_MixRtFluxDiff(DimXMin:DimXMax,DimZMin:DimZMax)


    xz_MixRtFluxDiff = 0.0d0

    xz_MixRtFluxDiff(:,RegZMin+1) =                 &
      & max(                                        &
      &       0.0d0,                                &
      &     - Kappa * xz_MixRt(:,RegZMin+1)         &
      &        / ( ( DelZ * 5.0d-1 ) ** 2.0d0 )     &
      &    )

!    xz_MixRtFluxDiff(:,RegZMin+1) =               &
!      &  - Kappa * xz_MixRt(:,RegZMin+1)          &
!      &    / ( ( DelZ * 5.0d-1 ) ** 2.0d0 )       

  end function xz_MixRtFluxDiff


!!!------------------------------------------------------------------------!!!
  function xza_MixRtFluxDiff( xza_MixRt )

    implicit none

    real(8), intent(in)   :: xza_MixRt(DimXMin:DimXMax,DimZMin:DimZMax,SpcNum)
    real(8)               :: xza_MixRtFluxDiff(DimXMin:DimXMax,DimZMin:DimZMax,SpcNum)

    xza_MixRtFluxDiff = 0.0d0

    xza_MixRtFluxDiff(:,RegZMin+1,:) =         &
      &  - Kappa * xza_MixRt(:,RegZMin+1,:)    &
      &    / ( ( DelZ * 5.0d-1 ) ** 2.0d0 )       

!    xza_MixRtFluxDiff(:,RegZMin+1,:) =                 &
!      & max(                                           &
!      &      0.0d0,                                    &
!      &    - Kappa * xza_MixRt(:,RegZMin+1,:)          &
!      &      / ( ( DelZ * 5.0d-1 ) ** 2.0d0 )          &
!      &  )

    call Store2Flux( xza_MixRtFluxDiff )

  end function xza_MixRtFluxDiff


end module HeatFlux



!= Module HeatFlux_N1994
!
! Authors::   ODAKA Masatsugu 
! Version::   $Id: heatflux.f90,v 1.16 2006/11/27 02:18:46 sugiyama Exp $
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
! Υեåˤ벹٤ȶŷʬѲΨХ륯ˡ
! ŤƷ׻⥸塼.  (1994) Ѥ줿ˡǤ.
!
! Ǯեå Fh ȶŷʪΥեå Fq Ȥ, ٤ȶŷʪ
! ѲΨ H, Q 
!
!   H = Fh/z_1  
!   Q = Fq/z_1  
!
! ɽ.  z_1 ϺǲؤγʻҴֳ֤Ǥ.  
!
! Ǯեå Fh ȶŷʪΥեå Fq ϰʲμˤä
! ׻.
!
!   Fh = - Cd|V| * (_1_1 - T_sfc)
!   Fh = - Cd|V| * (Q_1 - Q*(T_sfc))
!
!  _1, Q_1, _1 Ϻǲؤβ٤ȶŷʪκ椪̵
! ϴؿ, T_sfc ϲβ, Q*(T_sfc)  T_sfc Ƿޤ˰º
! Ǥ. 
!
! Х륯 Cd ϰȤ. ̵ϴؿ _1 ϴܾͤѤ.
! ® |V| 
!
!   V = ( V^2 + V_0^2 )^(1/2)
!
! ȷ׻. 
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module HeatFlux_N1994
  !
  !ǤΥեåη׻⥸塼
  !
  
  !⥸塼ɤ߹
  use gridset,  only: DimXMin,         & !x β
    &                 DimXMax,         & !x ξ
    &                 DimZMin,         & !z β
    &                 DimZMax,         & !z ξ
    &                 RegZMin,         & !z ʪΰβ
    &                 DelZ               !z γʻֳ
  use basicset, only: xz_ExnerBasicZ  ,& !ʡؿδܾ
    &                 xz_PotTempBasicZ,& !̤δܾ
    &                 xza_MixRtBasicZ ,& !̤δܾ 
    &                 TempSfc         ,& !ɽ̲
    &                 PressSfc        ,& !ɽ̰ [Pa]
    &                 CpDry           ,& !ʬ갵Ǯ [J/K kg]
    &                 GasRDry            !ʬε [J/K kg]

  use average, only:  xz_avr_pz          
  use chemcalc, only: SvapPress, xz_SvapPress

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public 
  public xz_HeatFluxBulk
  public xz_MixRtFluxBulk

  !ѿ
  real(8)  :: Bulk = 1.5d-3        !Ǯư̥եåΥХ륯

  !ͤ¸
  save Bulk

contains


!!!------------------------------------------------------------------------!!!
  function xz_HeatFluxBulk( xz_PotTemp, pz_VelX )
    ! 
    ! Υեåˤ벹٤ѲΨ,
    ! Х륯ˡ˴ŤƷ׻.
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)   :: xz_PotTemp(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !̤ξʬ    
    real(8), intent(in)   :: pz_VelX(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !ʿ®
    real(8)               :: xz_HeatFluxBulk(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !ɽǮեå
    real(8)               :: VelX = 3.0d0  !ؤǤοʿ®ٿ夲
    integer               :: kz            !ź

    real(8), allocatable  :: xz_VelX(:,:)  !ʿ® (xz ʻ)


    !γդ
    allocate(xz_VelX(DimXMin:DimXMax,DimZMin:DimZMax))


    !
    !  * Ƥͤ򥼥˸
    xz_HeatFluxBulk = 0.0d0
    
    !ɽǮեåˤǮΨ׻
    !  * ñ̤ K/s
    !  * ʡؿϴܾͤɽ.     
    !  * ʻ xz Ǥ, ʪΰκǲüź RegZMin+1

    kz = RegZMin+1
    xz_VelX = xz_avr_pz(pz_VelX)

    xz_HeatFluxBulk(:,kz) =                                       &
      & MAX(                                                      &
      &       0.0d0,                                              & 
      &     - Bulk                                                &
      &       * SQRT(xz_VelX(:,kz)**2.0 + VelX**2.0)              &
      &       * (xz_ExnerBasicZ(:,kz)                             &
      &            * (xz_PotTemp(:,kz)  + xz_PotTempBasicZ(:,kz)) &
      &          - TempSfc                                        &
      &         )/DelZ                                            &
      &    )

    !β
    deallocate(xz_VelX)
    
  end function xz_HeatFluxBulk
  
!!!------------------------------------------------------------------------!!!
  function xz_MixRtFluxBulk( xz_MixRt, pz_VelX, xz_Exner, ID )
    !
    ! ΥեåˤŷʬѲΨ,
    ! Х륯ˡ˴ŤƷ׻.
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8), intent(in)   :: xz_MixRt(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !̤ξʬ    
    real(8), intent(in)   :: pz_VelX(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !ʿ®
    real(8), intent(in)   :: xz_Exner(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !Ϥξʬ    
    integer, intent(in)   :: ID            !ŷʬ ID ֹ
    real(8)               :: xz_MixRtFluxBulk(DimXMin:DimXMax,DimZMin:DimZMax)
                                           !ɽ̺եå
    real(8)               :: VelX = 3.0d0  !ؤǤοʿ®ٿ夲
    integer               :: kz            !ź

    real(8), allocatable  :: xz_VelX(:,:)  !ʿ® (xz ʻ)


    !γդ
    allocate(xz_VelX(DimXMin:DimXMax,DimZMin:DimZMax))


    !
    !  * Ƥͤ򥼥˸
    xz_MixRtFluxBulk = 0.0d0

    kz = RegZMin+1
    xz_VelX = xz_avr_pz(pz_VelX)
    
    xz_MixRtFluxBulk(:,kz) =                                     &
      & max(                                                     &         
      &       0.0d0,                                             &
      &     - Bulk                                               &
      &       * SQRT(xz_VelX(:,kz)**2.0 + VelX**2.0)             &
      &       * (xz_MixRt(:,kz)                                  & 
      &            - SvapPress( ID, TempSfc ) / (                &
      &              ( xz_Exner(:,kz) + xz_ExnerBasicZ(:,kz) )   &
      &              **( CpDry / GasRDry )*PressSfc )            &
      &         )/DelZ                                           &
      &    )

    !β
    deallocate(xz_VelX)

    
  end function xz_MixRtFluxBulk
  
end module HeatFlux_N1994
