!= Module TimeSet
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: timeset.f90,v 1.3 2006/09/30 05:53:59 odakker Exp $ 
! Tag Name::  $Name: arare4-20061224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!

module timeset
  !
  !Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
  !ݴɤ뤿ѿ⥸塼
  !

  !⥸塼ɤ߹
  use dc_message, only: MessageNotify
  
  !ۤηػ
  implicit none

  !save °
  save

  ! Public Interface
  real(8)           :: DelTimeLong    !Ĺॹƥå
  real(8)           :: DelTimeShort   !ûॹƥå
  real(8)           :: TimeInt        !ʬ
  real(8)           :: TimeDisp       !եϤֳִ
  real(8)           :: DayTime        ! 1 Ĺ [s]
  integer           :: NstepLong      !ĹॹƥåפΥƥå׿
  integer           :: NstepShort     !ûॹƥåפΥƥå׿

contains

  subroutine timeset_init(cfgfile)
    !
    !NAMELIST ɬפʾɤ߼, ִϢѿԤ. 
    !

    !ۤηػ
    implicit none

    !ѿ
    character(*), intent(in) :: cfgfile
    
    !NAMELIST 
    NAMELIST /timeset/ &
         & DelTimeLong, DelTimeShort, TimeInt, TimeDisp, DayTime
    
    open (10, FILE=cfgfile)
    read(10, NML=timeset)
    close(10)

    !---------------------------------------------------------------
    ! 롼ײ
    !---------------------------------------------------------------
    NstepLong = nint( TimeInt / DelTimeLong )
    NstepShort = 2 * nint( DelTimeLong / DelTimeShort )
    
    !ʬ֤Ĺ֥ƥåפǳڤʤˤϷٹФ
    if(mod(TimeInt, DelTimeLong) /= 0) then 
      call MessageNotify( "W", &
        & "timeset_init", "mod(TimeInt, DelTimeLong) is not zero")
    end if
    
    !Ĺ֥ƥåפû֥ƥåפǳڤʤˤϷٹФ
    if(mod(DelTimeLong, DelTimeShort) /= 0) then 
      call MessageNotify( "W", &
        & "timeset_init", "mod(DelTimeLong, DelTimeShort) is not zero")
    end if
    
    !ʬ֤ϻֳִ֤ǳڤʤˤϷٹФ
    if(mod(TimeDisp, DelTimeLong) /= 0) then 
      call MessageNotify( "W", &
        & "timeset_init", "mod(TimeDisp, DelTimeLong) is not zero")
    end if
        
    !---------------------------------------------------------------
    ! ǧ
    !---------------------------------------------------------------
    call MessageNotify( "M", &
      & "timeset_init", "DelTimeLong = %f", d=(/DelTimeLong/) )
    call MessageNotify( "M", &
      & "timeset_init", "DelTimeShort = %f", d=(/DelTimeShort/) )
    call MessageNotify( "M", &
      & "timeset_init", "NstepLong = %d", i=(/NstepLong/) )
    call MessageNotify( "M", &
      & "timeset_init", "NstepShort = %d", i=(/NstepShort/) )
    call MessageNotify( "M", &
      & "timeset_init", "TimeInt = %f",  d=(/TimeInt/)  )
    call MessageNotify( "M", &
      & "timeset_init", "TimeDisp= %f", d=(/TimeDisp/) )
    call MessageNotify( "M", &
      & "timeset_init", "DayTime= %f",  d=(/DayTime/)  )
   
  end subroutine timeset_init
  
end module timeset
