!---------------------------------------------------------------------
!     Copyright (C) GFD Dennou Club, 2006. All rights reserved.
!---------------------------------------------------------------------
!
!= 3  (xyz ) ֳָ߳ʻ ʻ⥸塼
!
!* 
!  * 2010/08/02 () : ɲ
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2006/12/26 () : ʿѴؿ̾򸵤᤹
!  * 2006/06/05 () : 
!
module axesset
  != 3  (xyz ) ֳָ߳ʻ ʻ⥸塼
  !
  !== 
  !
  ! axesset , 3  (xyz ) ֳָ߳ʻҤѤͭºʬˡ˴Ť
  ! ͥǥΤ, Ū Fortran90 ץपӴؿ󶡤. 
  ! Ū˹ԤäƤ뤳Ȥϰʲ̤.
  !
  ! * ʻɸȳʻֳ
  ! * ʻִؿ
  ! * ʻʬʿѴؿ
  ! 
  !== 
  !
  ! * 㳰ʤ
  ! * ξΥåɽʤ
  ! * ͤϥޥ󥤥ץͤȤƤ٤
  !

  !⥸塼ɤ߹
  use dc_types,    only: DP, STRING
  use dc_iounit,   only: FileOpen
  use dc_message,  only: MessageNotify
  use mpi_wrapper, only: myrank, nprocs
  use gridset,     only: &
    &                  nx, ny, nz,    & ! ʻ
    &                  imin, imax, jmin, jmax, kmin, kmax ! ξͤȲ
  use namelist_util, only: namelist_filename

  !ۤηػ
  implicit none

  !ǥեȤ
  private

  !
  ! ³
  public :: axesset_init
!!
  ! ʻִؿ 
  public :: xyz_avr_pyz, xyr_avr_pyr, xqz_avr_pqz
  public :: pyz_avr_xyz, pyr_avr_xyr, pqz_avr_xqz
  public :: xyz_avr_xqz, pyz_avr_pqz, xyr_avr_xqr
  public :: xqz_avr_xyz, pqz_avr_pyz, xqr_avr_xyr
  public :: xyz_avr_xyr, pyz_avr_pyr, xqz_avr_xqr
  public :: xyr_avr_xyz, pyr_avr_pyz, xqr_avr_xqz
  public :: pqz_avr_xyz, pyr_avr_xyz, xqr_avr_xyz
  public :: xyz_avr_pqz, xyz_avr_pyr, xyz_avr_xqr
!!
  ! ʻʬʿѴؿ
  public :: yz_IntX_xyz, yz_IntX_pyz, qz_IntX_xqz, yr_IntX_xyr
  public :: xz_IntY_xyz, xz_IntY_xqz, pz_IntY_pyz, xr_IntY_xyr 
  public :: xy_IntZ_xyz, xy_IntZ_xyr, py_IntZ_pyz, xq_IntZ_xqz 
  public :: z_IntXY_xyz, z_IntXY_pyz, z_IntXY_xqz, r_IntXY_xyr
  public :: IntXYZ_xyz , IntXYZ_pyz , IntXYZ_xqz , IntXYZ_xyr
  public :: yz_AvrX_xyz, yz_AvrX_pyz, qz_AvrX_xqz, yr_AvrX_xyr
  public :: xz_AvrY_xyz, xz_AvrY_xqz, pz_AvrY_pyz, xr_AvrY_xyr 
  public :: xy_AvrZ_xyz, xy_AvrZ_xyr, py_AvrZ_pyz, xq_AvrZ_xqz 
  public :: z_AvrXY_xyz, z_AvrXY_pyz, z_AvrXY_xqz, r_AvrXY_xyr
  public :: AvrXYZ_xyz , AvrXYZ_pyz , AvrXYZ_xqz , AvrXYZ_xyr

  ! ѿ
  real(DP), public, save :: Xmin = 0.0d0   ! x ɸλ
  real(DP), public, save :: Xmax = 1.0d4   ! x ɸλ
  real(DP), public, save :: Ymin = 0.0d0   ! x ɸλ
  real(DP), public, save :: Ymax = 1.0d4   ! x ɸλ
  real(DP), public, save :: Zmin = 0.0d0   ! z ɸλ
  real(DP), public, save :: Zmax = 1.0d4   ! z ɸλ
  real(DP), allocatable, public, save :: x_X(:)         ! Ⱦʻɸ
  real(DP), allocatable, public, save :: p_X(:)         ! ʻɸ
  real(DP), allocatable, public, save :: x_dx(:)        ! Ⱦʻֳ
  real(DP), allocatable, public, save :: p_dx(:)        ! ʻֳ
  real(DP), allocatable, public, save :: y_Y(:)         ! Ⱦʻɸ
  real(DP), allocatable, public, save :: q_Y(:)         ! ʻɸ
  real(DP), allocatable, public, save :: y_dy(:)        ! Ⱦʻֳ
  real(DP), allocatable, public, save :: q_dy(:)        ! ʻֳ
  real(DP), allocatable, public, save :: z_Z(:)         ! Ⱦʻɸ
  real(DP), allocatable, public, save :: r_Z(:)         ! ʻɸ
  real(DP), allocatable, public, save :: z_dz(:)        ! Ⱦʻֳ
  real(DP), allocatable, public, save :: r_dz(:)        ! ʻֳ
  real(DP), allocatable, public, save :: xyz_X(:,:,:)   ! x ɸ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_Y(:,:,:)   ! y ɸ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_Z(:,:,:)   ! z ɸ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_dX(:,:,:)  ! x ʻҴֳ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_dY(:,:,:)  ! y ʻҴֳ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_dZ(:,:,:)  ! z ʻҴֳ(Ⱦʻ)


  interface y_IntX_xy
    module procedure a_IntX_xa
  end interface 

  interface q_IntX_xq
    module procedure a_IntX_xa
  end interface 

  interface xyz_avr_pyz
    module procedure xaa_avr_paa
  end interface
  
  interface xyr_avr_pyr
    module procedure xaa_avr_paa
  end interface 

  interface xqz_avr_pqz
    module procedure xaa_avr_paa
  end interface
  
  interface pyz_avr_xyz
    module procedure paa_avr_xaa
  end interface 

  interface pqz_avr_xqz
    module procedure paa_avr_xaa
  end interface 

  interface pyr_avr_xyr
    module procedure paa_avr_xaa
  end interface 

  interface xyz_avr_xqz
    module procedure aya_avr_aqa
  end interface 

  interface pyz_avr_pqz
    module procedure aya_avr_aqa
  end interface 

  interface xyr_avr_xqr
    module procedure aya_avr_aqa
  end interface
  
  interface xqz_avr_xyz
    module procedure aqa_avr_aya
  end interface

  interface pqz_avr_pyz
    module procedure aqa_avr_aya
  end interface 

  interface xqr_avr_xyr
    module procedure aqa_avr_aya
  end interface 

  interface xyz_avr_xyr
    module procedure aaz_avr_aar
  end interface 

  interface pyz_avr_pyr
    module procedure aaz_avr_aar
  end interface 

  interface xqz_avr_xqr
    module procedure aaz_avr_aar
  end interface 

  interface xyr_avr_xyz
    module procedure aar_avr_aaz
  end interface 

  interface pyr_avr_pyz
    module procedure aar_avr_aaz
  end interface 

  interface xqr_avr_xqz
    module procedure aar_avr_aaz
  end interface 

  interface yz_IntX_xyz
    module procedure aa_IntX_xaa
  end interface

  interface qz_IntX_xqz
    module procedure aa_IntX_xaa
  end interface

  interface yr_IntX_xyr
    module procedure aa_IntX_xaa
  end interface

  interface xz_IntY_xyz
    module procedure aa_IntY_aya
  end interface

  interface pz_IntY_pyz
    module procedure aa_IntY_aya
  end interface

  interface xr_IntY_xyr
    module procedure aa_IntY_aya
  end interface

  interface xy_IntZ_xyz
    module procedure aa_IntZ_aaz
  end interface

  interface py_IntZ_pyz
    module procedure aa_IntZ_aaz
  end interface

  interface xq_IntZ_xqz
    module procedure aa_IntZ_aaz
  end interface

  interface z_IntXY_xyz
    module procedure a_IntXY_xya
  end interface

  interface r_IntXY_xyr
    module procedure a_IntXY_xya
  end interface

  interface yz_AvrX_xyz
    module procedure aa_AvrX_xaa
  end interface

  interface qz_AvrX_xqz
    module procedure aa_AvrX_xaa
  end interface

  interface yr_AvrX_xyr
    module procedure aa_AvrX_xaa
  end interface

  interface xz_AvrY_xyz
    module procedure aa_AvrY_aya
  end interface

  interface pz_AvrY_pyz
    module procedure aa_AvrY_aya
  end interface

  interface xr_AvrY_xyr
    module procedure aa_AvrY_aya
  end interface

  interface xy_AvrZ_xyz
    module procedure aa_AvrZ_aaz
  end interface

  interface py_AvrZ_pyz
    module procedure aa_AvrZ_aaz
  end interface

  interface xq_AvrZ_xqz
    module procedure aa_AvrZ_aaz
  end interface

  interface z_AvrXY_xyz
    module procedure a_AvrXY_xya
  end interface

  interface r_AvrXY_xyr
    module procedure a_AvrXY_xya
  end interface

contains
  !--------------------------------------------------------------------
  subroutine axesset_init
    ! ʻɸȳʻֳν    

    ! ۤηػ
    implicit none

    ! ѿ
    real(DP),allocatable :: xy_X(:,:)! x ɸ(Ⱦʻ, )
    real(DP),allocatable :: xy_Y(:,:)! y ɸ(Ⱦʻ, )
    real(DP),allocatable :: yz_Z(:,:)! z ɸ(Ⱦʻ, )
    integer              :: unit     ! եֹ
    

    !ե뤫ɤ߹ϥե
    NAMELIST /axesset_nml/ xmin, xmax, ymin, ymax, zmin, zmax

    !ե뤫ϥե˵ܤɤ߹
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=axesset_nml)
    close(unit)
    
    ! ξ岼¤, ɸͤȳʻֳ֤
    ! * 1 ѤΥ֥롼Ѥ
    !
    call x_axis_init
    call y_axis_init
    call z_axis_init
    
    ! MPI б
    ! * x Τ
    !
    XMin = XMin           ! XMin = 0 
    XMax = XMax * nprocs  ! CPU οΰĥ

    ! 3 ʻɸ
    ! * Ȥ߹ߴؿ spread Ѥ. 
    ! * Ȥ 2 ʻɸ,  3 ˳ĥ.
    ! 
    allocate(xy_X(imin:imax,jmin:jmax))
    allocate(xy_Y(imin:imax,jmin:jmax))
    allocate(yz_Z(jmin:jmax,kmin:kmax))
    
    allocate(xyz_X(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_Y(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_Z(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_dX(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_dY(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_dZ(imin:imax,jmin:jmax,kmin:kmax))
    
    xy_X  = spread(x_X, 2,size(y_Y))
    xyz_X = spread(xy_X,3,size(z_Z))
    
    xy_X   = spread(x_dX, 2,size(y_dY))
    xyz_dX = spread(xy_X,3,size(z_dZ))
    
    xy_Y  = spread(y_Y, 1,size(x_X))
    xyz_Y = spread(xy_Y,3,size(z_Z))
    
    xy_Y   = spread(y_dY, 1,size(x_dX))
    xyz_dY = spread(xy_Y,3,size(z_dZ))
    
    yz_Z  = spread(z_Z, 1,size(y_Y))
    xyz_Z = spread(yz_Z,1,size(x_X))
    
    yz_Z   = spread(z_dZ, 1,size(y_dY))
    xyz_dZ = spread(yz_Z,1,size(x_dX))
    
    deallocate(xy_X)
    deallocate(xy_Y)
    deallocate(yz_Z)

    !"myrank == 0" ˳׻Ρɤ, ɤ߹
    if (myrank == 0) then 
      call MessageNotify( "M", "axesset_init", "XMin = %f", d=(/XMin/)    )
      call MessageNotify( "M", "axesset_init", "XMax = %f", d=(/XMax/)    )
      call MessageNotify( "M", "axesset_init", "YMin = %f", d=(/YMin/)    )
      call MessageNotify( "M", "axesset_init", "YMax = %f", d=(/YMax/)    )
      call MessageNotify( "M", "axesset_init", "ZMin = %f", d=(/ZMin/)    )
      call MessageNotify( "M", "axesset_init", "ZMax = %f", d=(/ZMax/)    )
    end if
  
  end subroutine axesset_init
  
  !--------------------------------------------------------------------
  subroutine x_axis_init()
    ! ξ岼¤ͤȳʻɸ, ʻֳ֤ꤹ
    
    integer                 :: ix   ! do 롼ź
    real(DP)                :: dx   ! ʻҴֳ

    allocate(x_X(imin:imax))
    allocate(p_X(imin:imax))
    allocate(x_dx(imin:imax))
    allocate(p_dx(imin:imax))

    ! ֳֳʻ
    dx = (xmax - xmin) / nx
    
    do ix = imin, imax
      p_X(ix) = dx * ix  + myrank * xmax
      x_X(ix) = dx * (ix - 0.5) + myrank * xmax
!      p_X(ix) = dx * ix  
!      x_X(ix) = dx * (ix - 0.5)
      x_dx(ix) = dx
      p_dx(ix) = dx
    end do
    
  end subroutine x_axis_init
  !--------------------------------------------------------------------
  subroutine y_axis_init()
    ! y κɸͤȳʻֳ֤ꤹ
    
    integer                 :: jy   ! 롼ź
    real(DP)                :: dy
    
    allocate(y_Y(jmin:jmax))
    allocate(q_Y(jmin:jmax))
    allocate(y_dy(jmin:jmax))
    allocate(q_dy(jmin:jmax))
    
    ! ֳֳʻ
    dy = (ymax - ymin) / ny
    
    do jy = jmin, jmax
      q_Y(jy) = dy * jy
      y_Y(jy) = dy * (jy - 0.5)
      y_dy(jy) = dy
      q_dy(jy) = dy
    end do
    
  end subroutine y_axis_init
  !--------------------------------------------------------------------
  subroutine z_axis_init()
    ! z κɸͤȳʻֳ֤ꤹ
    
    integer                 :: kz   ! 롼ź
    real(DP)            :: dz
    
    allocate(z_Z(kmin:kmax))
    allocate(r_Z(kmin:kmax))
    allocate(z_dz(kmin:kmax))
    allocate(r_dz(kmin:kmax))
    
    ! ֳֳʻ
    dz = (zmax - zmin) / nz
    
    do kz = kmin, kmax
      r_Z(kz) = dz * kz
      z_Z(kz) = dz * (kz - 0.5)
      r_dz(kz) = dz
      z_dz(kz) = dz
    end do
    
  end subroutine z_axis_init
  
  !--------------------------------------------------------------------
  function xaa_avr_paa(paa_Var)
    ! ʿԤ x ʻͤȾ֤
    
    real(DP),intent(in) :: paa_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)            :: xaa_avr_paa(imin:imax,jmin:jmax,kmin:kmax)
    integer             :: ix

    ! 2 ׻(x ǿ 1)ξ, ͤ򤽤Τޤ֤
    if (imin == imax) then 
      xaa_avr_paa = paa_Var
      return
    end if

    ! ʿ: p ɸ x ɸ֤. imin ͤۤ.
    !
    !    p     imin    0     1         imax-1  imax
    !     |--*--|--*--||--*--|--*--|--*--||--*--|
    !    x  imin   0      1         imax-1  imax
    !
    do ix = imin+1, imax
      xaa_avr_paa(ix,:,:) = (paa_Var(ix,:,:) + paa_Var(ix-1,:,:))*0.5d0 
    end do
    
    ! imin ʻҾ
    xaa_avr_paa(imin,:,:) = 1.0d10 
    
  end function xaa_avr_paa
  !--------------------------------------------------------------------
  function paa_avr_xaa(xaa_Var)
    ! Ⱦʻ֤ͤ
    
    real(DP),intent(in) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)            :: paa_avr_xaa(imin:imax,jmin:jmax,kmin:kmax)
    integer             :: ix

    ! 2 ׻(x ǿ 1)ξ, ͤ򤽤Τޤ֤
    if (imin == imax) then 
      paa_avr_xaa = xaa_Var
      return
    end if

    ! ʿ: x ɸ p ɸ֤. imax ͤۤ.
    !     
    !    p     imin    0     1         imax-1  imax
    !     |--*--|--*--||--*--|--*--|--*--||--*--|
    !    x  imin   0      1         imax-1  imax
    !
    do ix = imin, imax-1
!      paa_avr_xaa(ix,:,:) = &
!        &  (x_dx(ix)*xaa_Var(ix+1,:,:) + x_dx(ix+1)*xaa_Var(ix,:,:)) &
!        &  *0.5d0/p_dx(ix)
      paa_avr_xaa(ix,:,:) = (xaa_Var(ix+1,:,:) + xaa_Var(ix,:,:)) * 0.5d0
    end do
    
    ! imax ʻҾ
    paa_avr_xaa(imax,:,:) = 1.0d10
    
  end function paa_avr_xaa
  !--------------------------------------------------------------------
  function aya_avr_aqa(aqa_Var)
    ! ʿԤ y Ⱦʻͤʻ֤
    
    real(DP),intent(in) :: aqa_Var(imin:imax,jmin:jmax,kmin:kmax)   
    real(DP)            :: aya_avr_aqa(imin:imax,jmin:jmax,kmin:kmax)
    integer                 :: jy
    
    ! 2 ׻(y ǿ 1)ξ, ͤ򤽤Τޤ֤
    if (jmin == jmax) then 
      aya_avr_aqa = aqa_Var
      return
    end if
    
    ! ʿ
    !
    do jy = jmin+1, jmax
      aya_avr_aqa(:,jy,:) = (aqa_Var(:,jy,:) + aqa_Var(:,jy-1,:))*0.5d0 
    end do
    
    ! jmin ʻҾ
    aya_avr_aqa(:,jmin,:) = 1.0d10
    
  end function aya_avr_aqa
  !--------------------------------------------------------------------
  function aqa_avr_aya(aya_Var)
    ! ʿԤ y Ⱦʻͤʻ֤
    
    real(DP),intent(in) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)            :: aqa_avr_aya(imin:imax,jmin:jmax,kmin:kmax) 
    integer                 :: jy
    
    ! 2 ׻(y ǿ 1)ξ, ͤ򤽤Τޤ֤
    if (jmin == jmax) then 
      aqa_avr_aya = aya_Var
      return
    end if
    
    ! ʿ
    !
    do jy = jmin, jmax-1
!      aqa_avr_aya(:,jy,:) = &
!        &  (y_dy(jy)*aya_Var(:,jy+1,:) + y_dy(jy+1)*aya_Var(:,jy,:)) &
!        &  * 0.5d0/q_dy(jy)
      aqa_avr_aya(:,jy,:) = (aya_Var(:,jy+1,:) + aya_Var(:,jy,:)) * 0.5d0
    end do
    
    ! jmax ʻҾ
    aqa_avr_aya(:,jmax,:) = 1.0d10
    
  end function aqa_avr_aya
  !--------------------------------------------------------------------
  function aaz_avr_aar(aar_Var)
    ! ʿԤ z ʻͤȾʻ֤
    
    real(DP),intent(in) :: aar_Var(imin:imax,jmin:jmax,kmin:kmax)   
    real(DP)            :: aaz_avr_aar(imin:imax,jmin:jmax,kmin:kmax)
    integer                 :: kz
    
    ! ʿ
    !
    do kz = kmin+1, kmax
      aaz_avr_aar(:,:,kz) = (aar_Var(:,:,kz) + aar_Var(:,:,kz-1))*0.5d0 
    end do
    
    ! kmin ʻҾ
    aaz_avr_aar(:,:,kmin) = 1.0d10
    
  end function aaz_avr_aar
  !--------------------------------------------------------------------
  function aar_avr_aaz(aaz_Var)
    ! ʿԤ z Ⱦʻͤʻ֤
    
    real(DP),intent(in) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)            :: aar_avr_aaz(imin:imax,jmin:jmax,kmin:kmax)
    integer                 :: kz
    
    ! ʿ
    !
    do kz = kmin, kmax-1
!      aar_avr_aaz(:,:,kz) = &
!        &  (z_dz(kz)*aaz_Var(:,:,kz+1) + z_dz(kz+1)*aaz_Var(:,:,kz)) &
!        &  *0.5d0/r_dz(kz)
      aar_avr_aaz(:,:,kz) = (aaz_Var(:,:,kz+1) + aaz_Var(:,:,kz)) * 0.5d0
    end do
    
    ! kmax ʻҾ
    aar_avr_aaz(:,:,kmax) = 1.0d10
    
  end function aar_avr_aaz
  !--------------------------------------------------------------------
  function pqz_avr_xyz(xyz_Var)
    real(DP), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)      ! 
    real(DP)             :: pqz_avr_xyz(imin:imax,jmin:jmax,kmin:kmax)  ! 
    integer              :: ix, jy                                      ! 롼ź

    ! 2 ׻(y ǿ 1)ξ, pz_avr_xz Ʊ׻Ԥ.
    if (jmin == jmax) then 
      do ix = imin, imax-1
        pqz_avr_xyz(ix,:,:) = &
          &  ( xyz_Var(ix,:,:) + xyz_Var(ix+1,:,:) ) * 0.5d0 
      end do

      ! imax ʻҾ
      pqz_avr_xyz(imax,:,:) = 1.0d10

    ! 3 ׻ξ
    else
      do jy = jmin, jmax-1
        do ix = imin, imax-1
          pqz_avr_xyz(ix,jy,:) = &
            &  ( xyz_Var(ix,jy,:)   + xyz_Var(ix+1,jy,:) +  &
            &    xyz_Var(ix,jy+1,:) + xyz_Var(ix+1,jy+1,:) ) * 0.25d0 
        end do
      end do

      ! imax ʻҾ
      pqz_avr_xyz(imax,:,:) = 1.0d10
      ! jmax ʻҾ
      pqz_avr_xyz(:,jmax,:) = 1.0d10
    end if
        
  end function pqz_avr_xyz
  !--------------------------------------------------------------------
  function pyr_avr_xyz(xyz_Var)
    real(DP), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)     ! 
    real(DP)             :: pyr_avr_xyz(imin:imax,jmin:jmax,kmin:kmax) ! 
    integer              :: ix, kz                                     ! 롼ź
    
    do kz = kmin, kmax-1
      do ix = imin, imax-1
        pyr_avr_xyz(ix,:,kz) = &
          &  ( xyz_Var(ix,:,kz)   + xyz_Var(ix+1,:,kz) +  &
          &    xyz_Var(ix,:,kz+1) + xyz_Var(ix+1,:,kz+1) ) * 0.25d0 
      end do
    end do

    ! imax ʻҾ
    pyr_avr_xyz(imax,:,:) = 1.0d10
    ! kmax ʻҾ
    pyr_avr_xyz(:,:,kmax) = 1.0d10

    
  end function pyr_avr_xyz
  !--------------------------------------------------------------------
  function xqr_avr_xyz(xyz_Var)
    real(DP), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)       ! 
    real(DP)             :: xqr_avr_xyz(imin:imax,jmin:jmax,kmin:kmax)   ! 
    integer              :: jy, kz                                       ! 롼ź
    
    if (jmin == jmax) then 
      ! xr_avr_xz Ʊˤʤ
      do kz = kmin, kmax-1
        xqr_avr_xyz(:,:,kz) = &
          &  ( xyz_Var(:,:,kz) + xyz_Var(:,:,kz+1) ) * 0.5d0 
      end do

      ! kmax ʻҾ
      xqr_avr_xyz(:,:,kmax) = 1.0d10
      
    else
      do kz = kmin, kmax-1
        do jy = jmin, jmax-1
          xqr_avr_xyz(:,jy,kz) = &
            &  ( xyz_Var(:,jy,kz)   + xyz_Var(:,jy+1,kz) +  &
            &    xyz_Var(:,jy,kz+1) + xyz_Var(:,jy+1,kz+1) ) * 0.25d0 
        end do
      end do

      ! jmax ʻҾ
      xqr_avr_xyz(:,jmax,:) = 1.0d10
      ! kmax ʻҾ
      xqr_avr_xyz(:,:,kmax) = 1.0d10

    end if
    
  end function xqr_avr_xyz
  !--------------------------------------------------------------------
  function xyz_avr_pqz(pqz_Var)
    real(DP), intent(in) :: pqz_Var(imin:imax,jmin:jmax,kmin:kmax)     ! 
    real(DP)             :: xyz_avr_pqz(imin:imax,jmin:jmax,kmin:kmax) ! 
    integer              :: ix, jy                                     ! 롼ź
    
    if (jmin == jmax) then 
      ! xz_avr_pz Ʊˤʤ
      do ix = imin+1, imax
        xyz_avr_pqz(ix,:,:) = &
          &  ( pqz_Var(ix-1,:,:) + pqz_Var(ix,:,:) ) * 0.5d0 
      end do

      ! imin ʻҾ
      xyz_avr_pqz(imin,:,:) = 1.0d10

    else
      do jy = jmin+1, jmax
        do ix = imin+1, imax
          xyz_avr_pqz(ix,jy,:) = &
            &  ( pqz_Var(ix-1,jy-1,:) + pqz_Var(ix,jy-1,:)  &
            &    + pqz_Var(ix-1,jy,:)   + pqz_Var(ix,jy,:) ) * 0.25d0 
        end do
      end do

      ! imin ʻҾ
      xyz_avr_pqz(imin,:,:) = 1.0d10
      ! jmin ʻҾ
      xyz_avr_pqz(:,jmin,:) = 1.0d10
    end if
    
  end function xyz_avr_pqz
  !--------------------------------------------------------------------
  function xyz_avr_pyr(pyr_Var)
    real(DP), intent(in) :: pyr_Var(imin:imax,jmin:jmax,kmin:kmax)     ! 
    real(DP)             :: xyz_avr_pyr(imin:imax,jmin:jmax,kmin:kmax) ! 
    integer              :: ix, kz                                     ! 롼ź
        
    do kz = kmin+1, kmax
      do ix = imin+1, imax
        xyz_avr_pyr(ix,:,kz) = &
          &  ( pyr_Var(ix-1,:,kz-1) + pyr_Var(ix,:,kz-1) +  &
          &    pyr_Var(ix-1,:,kz)   + pyr_Var(ix,:,kz)     ) * 0.25d0 
      end do
    end do

    ! imin ʻҾ
    xyz_avr_pyr(imin,:,:) = 1.0d10
    ! kmin ʻҾ
    xyz_avr_pyr(:,:,kmin) = 1.0d10

  end function xyz_avr_pyr
  !--------------------------------------------------------------------
  function xyz_avr_xqr(xqr_Var)
    real(DP), intent(in) :: xqr_Var(imin:imax,jmin:jmax,kmin:kmax)     ! 
    real(DP)             :: xyz_avr_xqr(imin:imax,jmin:jmax,kmin:kmax) ! 
    integer              :: jy, kz                                     ! 롼ź
        
    if (jmin == jmax) then  
      !xz_avr_xr Ʊ
      do kz = kmin+1, kmax
        xyz_avr_xqr(:,:,kz) = &
          &  ( xqr_Var(:,:,kz-1) + xqr_Var(:,:,kz) ) * 0.5d0 
      end do

      ! kmin ʻҾ
      xyz_avr_xqr(:,:,kmin) = 1.0d10

    else
      do kz = kmin+1, kmax
        do jy = jmin+1, jmax
          xyz_avr_xqr(:,jy,kz) = &
            &  ( xqr_Var(:,jy-1,kz-1) + xqr_Var(:,jy,kz-1) +  &
            &    xqr_Var(:,jy-1,kz)   + xqr_Var(:,jy,kz)     ) * 0.25d0 
        end do
      end do

      ! jmin ʻҾ
      xyz_avr_xqr(:,jmin,:) = 1.0d10
      ! kmin ʻҾ
      xyz_avr_xqr(:,:,kmin) = 1.0d10
    end if
    
  end function xyz_avr_xqr
  !--------------------------------------------------------------------
  function aa_IntX_xaa(xaa_Var)
    ! xaa ʻҾФ x ʬԤ
    
    real(DP), intent(in) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: aa_IntX_xaa(jmin:jmax,kmin:kmax)       ! 
    integer                  :: jy, kz                           ! 롼ź
    
    ! 
    aa_IntX_xaa = 0.0d0
    
    ! ʬ
    do kz = kmin, kmax
      do jy = jmin, jmax
        aa_IntX_xaa(jy,kz) = IntX_x(xaa_Var(:,jy,kz))
      end do
    end do
    
  end function aa_IntX_xaa
  !--------------------------------------------------------------------
  function yz_IntX_pyz(pyz_Var)
    ! pyz ʻҾФ x ʬԤ
    
    real(DP), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: yz_IntX_pyz(jmin:jmax,kmin:kmax)       ! 
    integer                  :: jy, kz                           ! 롼ź
    
    ! 
    yz_IntX_pyz = 0.0d0
    
    ! ʬ
    do kz = kmin, kmax
      do jy = jmin, jmax
        yz_IntX_pyz(jy,kz) = IntX_p(pyz_Var(:,jy,kz))
      end do
    end do
    
  end function yz_IntX_pyz
  !--------------------------------------------------------------------
  function aa_IntY_aya(aya_Var)
    ! aya ʻҾФ y ʬԤ
    
    real(DP), intent(in) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: aa_IntY_aya(imin:imax,kmin:kmax)       ! 
    integer                  :: ix, kz                           ! 롼ź
    
    ! 
    aa_IntY_aya = 0.0d0
    
    ! ʬ
    do kz = kmin, kmax
      do ix = imin, imax
        aa_IntY_aya(ix,kz) = IntY_y(aya_Var(ix,:,kz))
      end do
    end do
    
  end function aa_IntY_aya
  !--------------------------------------------------------------------
  function xz_IntY_xqz(xqz_Var)
    ! xqz ʻҾФ y ʬԤ
    
    real(DP), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: xz_IntY_xqz(imin:imax,kmin:kmax)       ! 
    integer                  :: ix, kz                           ! 롼ź
    
    ! 
    xz_IntY_xqz = 0.0d0
    
    ! ʬ
    do kz = kmin, kmax
      do ix = imin, imax
        xz_IntY_xqz(ix,kz) = IntY_q(xqz_Var(ix,:,kz))
      end do
    end do
    
  end function xz_IntY_xqz
  !--------------------------------------------------------------------
  function aa_IntZ_aaz(aaz_Var)
    ! aaz ʻҾФ z ʬԤ
    
    real(DP), intent(in) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: aa_IntZ_aaz(imin:imax,jmin:jmax)       ! 
    integer                  :: ix, jy                           ! 롼ź
    
    ! 
    aa_IntZ_aaz = 0.0d0

    ! ʬ
    do jy = jmin, jmax
      do ix = imin, imax
        aa_IntZ_aaz(ix,jy) = IntZ_z(aaz_Var(ix,jy,:))
      end do
    end do
    
  end function aa_IntZ_aaz
  !--------------------------------------------------------------------
  function xy_IntZ_xyr(xyr_Var)
    ! xyr ʻҾФ z ʬԤ
    
    real(DP), intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: xy_IntZ_xyr(imin:imax,jmin:jmax)       ! 
    integer                  :: ix, jy                           ! 롼ź
    
    ! 
    xy_IntZ_xyr = 0.0d0
    
    ! ʬ
    do jy = jmin, jmax
      do ix = imin, imax
        xy_IntZ_xyr(ix,jy) = IntZ_r(xyr_Var(ix,jy,:))
      end do
    end do
    
  end function xy_IntZ_xyr
  !--------------------------------------------------------------------
  function a_IntXY_xya(xya_Var)
    ! xya ʻҾФ xy ʬԤ
    
    real(DP), intent(in) :: xya_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: a_IntXY_xya(kmin:kmax)       ! 
    integer                  :: kz                           ! 롼ź
    
    ! 
    a_IntXY_xya = 0.0d0
    
    ! ʬ
    do kz = kmin, kmax
      a_IntXY_xya(kz) = IntY_y(y_IntX_xy(xya_Var(:,:,kz)))
    end do
    
  end function a_IntXY_xya
  !--------------------------------------------------------------------
  function z_IntXY_pyz(pyz_Var)
    ! pyz ʻҾФ xy ʬԤ
    
    real(DP), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: z_IntXY_pyz(kmin:kmax)       ! 
    integer                  :: kz                           ! 롼ź
    
    ! 
    z_IntXY_pyz = 0.0d0
    
    ! ʬ
    do kz = kmin, kmax
      z_IntXY_pyz(kz) = IntY_y(y_IntX_py(pyz_Var(:,:,kz)))
    end do
    
  end function z_IntXY_pyz
  !--------------------------------------------------------------------
  function z_IntXY_xqz(xqz_Var)
    ! xqz ʻҾФ xy ʬԤ
    
    real(DP), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: z_IntXY_xqz(kmin:kmax)       ! 
    integer                  :: kz                           ! 롼ź
    
    ! 
    z_IntXY_xqz = 0.0d0
    
    ! ʬ
    do kz = kmin, kmax
      z_IntXY_xqz(kz) = IntY_q(q_IntX_xq(xqz_Var(:,:,kz)))
    end do
    
  end function z_IntXY_xqz
  !--------------------------------------------------------------------
  function IntXYZ_xyz(xyz_Var)
    ! xyz ʻҾФΰʬԤ
    
    real(DP), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: IntXYZ_xyz                             ! 
    
    ! 
    IntXYZ_xyz = 0.0d0
    
    IntXYZ_xyz = IntZ_z(a_IntXY_xya(xyz_Var))
    
  end function IntXYZ_xyz
  !--------------------------------------------------------------------
  function IntXYZ_pyz(pyz_Var)
    ! pyz ʻҾФΰʬԤ
    
    real(DP), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: IntXYZ_pyz                             ! 
    
    ! 
    IntXYZ_pyz = 0.0d0

    IntXYZ_pyz = IntZ_z(z_IntXY_pyz(pyz_Var))
    
  end function IntXYZ_pyz
  !--------------------------------------------------------------------
  function IntXYZ_xqz(xqz_Var)
    ! xqz ʻҾФΰʬԤ
    
    real(DP), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: IntXYZ_xqz                             ! 
    
    ! 
    IntXYZ_xqz = 0.0d0
    
    IntXYZ_xqz = IntZ_z(z_IntXY_xqz(xqz_Var))
    
  end function IntXYZ_xqz
  !--------------------------------------------------------------------
  function IntXYZ_xyr(xyr_Var)
    ! xyr ʻҾФΰʬԤ
    
    real(DP), intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: IntXYZ_xyr                             ! 
    
    ! 
    IntXYZ_xyr = 0.0d0
    
    IntXYZ_xyr = IntZ_r(a_IntXY_xya(xyr_Var))

  end function IntXYZ_xyr
  !--------------------------------------------------------------------
  function aa_AvrX_xaa(xaa_Var)
    ! xaa ʻҾФ x ʿѤԤ

    real(DP), intent(in) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: aa_AvrX_xaa(jmin:jmax,kmin:kmax)       ! 
    
    ! 
    aa_AvrX_xaa = 0.0d0
    
    ! ʿ
    aa_AvrX_xaa = aa_IntX_xaa(xaa_Var)/sum(x_dx(1:nx))
    
  end function aa_AvrX_xaa
  !--------------------------------------------------------------------
  function yz_AvrX_pyz(pyz_Var)
    ! pyz ʻҾФ x ʿѤԤ
    
    real(DP), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: yz_AvrX_pyz(jmin:jmax,kmin:kmax)       ! 
    
    ! 
    yz_AvrX_pyz = 0.0d0
    
    ! ʿ
    yz_AvrX_pyz = yz_IntX_pyz(pyz_Var)/sum(x_dx(1:nx))
    
  end function yz_AvrX_pyz
  !--------------------------------------------------------------------
  function aa_AvrY_aya(aya_Var)
    ! aya ʻҾФ y ʿѤԤ
    
    real(DP), intent(in) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: aa_AvrY_aya(imin:imax,kmin:kmax)       ! 
    
    ! 
    aa_AvrY_aya = 0.0d0
    
    ! ʿ
    aa_AvrY_aya = aa_IntY_aya(aya_Var)/sum(y_dy(1:ny))
    
  end function aa_AvrY_aya
  !--------------------------------------------------------------------
  function xz_AvrY_xqz(xqz_Var)
    ! xqz ʻҾФ y ʿѤԤ
    
    real(DP), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: xz_AvrY_xqz(imin:imax,kmin:kmax)       ! 
    
    ! 
    xz_AvrY_xqz = 0.0d0
    
    ! ʿ
    xz_AvrY_xqz = xz_IntY_xqz(xqz_Var)/sum(y_dy(1:ny))
    
  end function xz_AvrY_xqz
  !--------------------------------------------------------------------
  function aa_AvrZ_aaz(aaz_Var)
    ! aaz ʻҾФ z ʿѤԤ
    
    real(DP), intent(in) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: aa_AvrZ_aaz(imin:imax,jmin:jmax)       ! 
    
    ! 
    aa_AvrZ_aaz = 0.0d0
    
    ! ʿ
    aa_AvrZ_aaz = aa_IntZ_aaz(aaz_Var)/sum(z_dz(1:nz))
    
  end function aa_AvrZ_aaz
  !--------------------------------------------------------------------
  function xy_AvrZ_xyr(xyr_Var)
    ! xyr ʻҾФ z ʿѤԤ
    
    real(DP), intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: xy_AvrZ_xyr(imin:imax,jmin:jmax)       ! 
      
    ! 
    xy_AvrZ_xyr = 0.0d0
    
    ! ʿ
    xy_AvrZ_xyr = xy_IntZ_xyr(xyr_Var)/sum(z_dz(1:nz))
    
  end function xy_AvrZ_xyr
!--------------------------------------------------------------------
  function AvrXYZ_xyz(xyz_Var)
    ! xyz ʻҾФΰʬԤ
    
    real(DP), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: AvrXYZ_xyz                             ! 
    
    ! 
    AvrXYZ_xyz = 0.0d0
    
    AvrXYZ_xyz = IntXYZ_xyz(xyz_Var)/ &
      &             (sum(x_dx(1:nx))*sum(y_dy(1:ny))*sum(z_dz(1:nz)))
    
  end function AvrXYZ_xyz
  !--------------------------------------------------------------------
  function AvrXYZ_pyz(pyz_Var)
    ! pyz ʻҾФΰʬԤ
    
    real(DP), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: AvrXYZ_pyz                             ! 
    
    ! 
    AvrXYZ_pyz = 0.0d0
    
    AvrXYZ_pyz = IntXYZ_pyz(pyz_Var)/ &
      &             (sum(x_dx(1:nx))*sum(y_dy(1:ny))*sum(z_dz(1:nz)))
    
  end function AvrXYZ_pyz
!--------------------------------------------------------------------
  function AvrXYZ_xqz(xqz_Var)
    ! xqz ʻҾФΰʬԤ
    
    real(DP), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: AvrXYZ_xqz                             ! 
    
    ! 
    AvrXYZ_xqz = 0.0d0
    
    AvrXYZ_xqz = IntXYZ_xqz(xqz_Var)/ &
      &             (sum(x_dx(1:nx))*sum(y_dy(1:ny))*sum(z_dz(1:nz)))
    
  end function AvrXYZ_xqz
  !--------------------------------------------------------------------
  function AvrXYZ_xyr(xyr_Var)
    ! xyr ʻҾФΰʬԤ
    
    real(DP), intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: AvrXYZ_xyr                             ! 
    
    ! 
    AvrXYZ_xyr = 0.0d0

    AvrXYZ_xyr = IntXYZ_xyr(xyr_Var)/ &
      &             (sum(x_dx(1:nx))*sum(y_dy(1:ny))*sum(z_dz(1:nz)))
    
  end function AvrXYZ_xyr
  !--------------------------------------------------------------------
  function a_AvrXY_xya(xya_Var)
    ! xya ʻҾФ xy ʿѤԤ
    
    real(DP), intent(in) :: xya_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: a_AvrXY_xya(kmin:kmax)       ! 

    ! 
    a_AvrXY_xya = 0.0d0
    
    ! ʿ
    a_AvrXY_xya = a_IntXY_xya(xya_Var)/(sum(x_dx(1:nx))*sum(y_dy(1:ny)))
    
  end function a_AvrXY_xya
  !--------------------------------------------------------------------
  function z_AvrXY_pyz(pyz_Var)
    ! pyz ʻҾФ xy ʿѤԤ
    
    real(DP), intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: z_AvrXY_pyz(kmin:kmax)       ! 
    
    ! 
    z_AvrXY_pyz = 0.0d0
    
    ! ʿ
    z_AvrXY_pyz = z_IntXY_pyz(pyz_Var)/(sum(x_dx(1:nx))*sum(y_dy(1:ny)))
    
  end function z_AvrXY_pyz
  !--------------------------------------------------------------------
  function z_AvrXY_xqz(xqz_Var)
    ! xqz ʻҾФ xy ʬԤ
    
    real(DP), intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: z_AvrXY_xqz(kmin:kmax)       ! 
    
    ! 
    z_AvrXY_xqz = 0.0d0
    
    ! ʿ
    z_AvrXY_xqz = z_IntXY_xqz(xqz_Var)/(sum(x_dx(1:nx))*sum(y_dy(1:ny)))
    
  end function z_AvrXY_xqz
  !--------------------------------------------------------------------
  function IntX_p(p_Var)
    ! ʻҾФ x ˽ŤդʬԤ
    
    real(DP), intent(in) :: p_Var(imin:imax)  ! 
    real(DP)             :: IntX_p            ! 
    
    ! 
    IntX_p = 0.0d0
    
    ! ʬ
    IntX_p = sum(p_Var(1:nx)*p_dx(1:nx))
    
  end function IntX_p
  !--------------------------------------------------------------------
  function IntX_x(x_Var)
    ! ȾʻҾФ x ˽ŤդʬԤ
    
    real(DP), intent(in) :: x_Var(imin:imax)  ! 
    real(DP)             :: IntX_x            ! 
    real(DP), allocatable:: work(:)
    
    ! 
    IntX_x = 0.0d0
    allocate(work(imin:imax))
    
    ! ʬ
    work = x_Var*x_dx
    
    IntX_x = sum(work(1:nx))
    
    deallocate(work)
    
  end function IntX_x
!--------------------------------------------------------------------
  function IntY_q(q_Var)
    ! ʻҾФ y ˽ŤդʬԤ
    
    real(DP), intent(in) :: q_Var(jmin:jmax)  ! 
    real(DP)             :: IntY_q            ! 
    
    ! 
    IntY_q = 0.0d0
    
    ! ʬ
    IntY_q = sum(q_Var(1:ny)*q_dy(1:ny))
    
  end function IntY_q
!--------------------------------------------------------------------
  function IntY_y(y_Var)
    ! ȾʻҾФ y ˽ŤդʬԤ
    
    real(DP), intent(in) :: y_Var(jmin:jmax)  ! 
    real(DP)             :: IntY_y            ! 
    
    ! 
    IntY_y = 0.0d0
    
    ! ʬ
    IntY_y = sum(y_Var(1:ny)*y_dy(1:ny))
    
  end function IntY_y
  !--------------------------------------------------------------------
  function IntZ_r(r_Var)
    ! ʻҾФ z ˽ŤդʬԤ

    real(DP), intent(in) :: r_Var(kmin:kmax)  ! 
    real(DP)             :: IntZ_r            ! 
    
    ! 
    IntZ_r = 0.0d0
    
    ! ʬ
    IntZ_r = sum(r_Var(1:nz)*r_dz(1:nz))
    
  end function IntZ_r
!--------------------------------------------------------------------
  function IntZ_z(z_Var)
    ! ȾʻҾФ z ˽ŤդʬԤ
    
    real(DP), intent(in) :: z_Var(kmin:kmax)  ! 
    real(DP)             :: IntZ_z            ! 

    ! 
    IntZ_z = 0.0d0
    
    ! ʬ
    IntZ_z = sum(z_Var(1:nz)*z_dz(1:nz))
    
  end function IntZ_z
!--------------------------------------------------------------------
  function a_IntX_xa(xa_Var)
    ! xa ʻҾФ x ˽ŤդʬԤ
    
    real(DP), intent(in) :: xa_Var(imin:imax,jmin:jmax) ! 
    real(DP)             :: a_IntX_xa(jmin:jmax)        ! 
    integer                  :: jy                          ! 롼ź

    ! 
    a_IntX_xa = 0.0d0
    
    ! ʬ
    do jy = jmin, jmax
      a_IntX_xa(jy) = IntX_x(xa_Var(:,jy))
    end do
    
  end function a_IntX_xa
!--------------------------------------------------------------------
  function y_IntX_py(py_Var)
    ! py ʻҾФ x ˽ŤդʬԤ
    
    real(DP), intent(in) :: py_Var(imin:imax,jmin:jmax) ! 
    real(DP)             :: y_IntX_py(jmin:jmax)        ! 
    integer                  :: jy                          ! 롼ź
    
    ! 
    y_IntX_py = 0.0d0

    ! ʬ
    do jy = jmin, jmax
      y_IntX_py(jy) = IntX_p(py_Var(:,jy))
    end do
    
  end function y_IntX_py
  !--------------------------------------------------------------------
  function a_IntY_ay(ay_Var)
    ! ay ʻҾФ y ˽ŤդʬԤ
    
    real(DP), intent(in) :: ay_Var(imin:imax,jmin:jmax) ! 
    real(DP)             :: a_IntY_ay(imin:imax)        ! 
    integer                  :: ix                          ! 롼ź
    
    ! 
    a_IntY_ay = 0.0d0
    
    ! ʬ
    do ix = imin, imax
      a_IntY_ay(ix) = IntY_y(ay_Var(ix,:))
    end do
    
  end function a_IntY_ay
  !--------------------------------------------------------------------
  function x_IntY_xq(xq_Var)
    ! ay ʻҾФ y ˽ŤդʬԤ
    
    real(DP), intent(in) :: xq_Var(imin:imax,jmin:jmax) ! 
    real(DP)             :: x_IntY_xq(imin:imax)        ! 
    integer                  :: ix                          ! 롼ź
    
    ! 
    x_IntY_xq = 0.0d0
    
    ! ʬ
    do ix = imin, imax
      x_IntY_xq(ix) = IntY_q(xq_Var(ix,:))
    end do
    
  end function x_IntY_xq

end module axesset

