!= ñͥ⥸塼: ȤΰѡǮ
!
! Authors::   YAMASHITA Tatsuya, SUGIYAMA Ko-ichiro
! Version::   $Id: radiation_heatbalance.f90,v 1.13 2014/07/08 01:04:18 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]


module Radiation_HeatBalance
  !
  ! ñͥ⥸塼: ȤΰѡǮ
  !

  !⥸塼ɤ߹
  use dc_types, only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

  use mpi_wrapper,only: myrank
  use namelist_util, only: namelist_filename
  use timeset, only:  TimeN
  use gridSet,  only: imin,     & !x β
    &                 imax,     & !x ξ
    &                 jmin,     & !y β
    &                 jmax,     & !y ξ
    &                 kmin,     & !z β
    &                 kmax,     & !z ξ
    &                 nx, ny, nz
  use axesset, only:  z_Z, z_dz   !Z ɸ(顼ʻ)
  use constants,only: DayTime,    & ! 1 Ĺ [s]
    &                 PressBasis, & !̤δవ
    &                 CpDry,      & !갵Ǯ
    &                 CvDry,      & !Ǯ
    &                 GasRDry       !
  use basicset, only: xyz_ExnerBZ, & !ʡؿδܾ
    &                 xyz_VPTempBZ,    &! 
    &                 xyz_PTempBZ    !̤δܾ
  use DExnerDt, only: xyz_DExnerDt_xyz
  
  !ۤηػ
  implicit none

  !private °
  private

  !ؿ public ˤ. 
  public Radiation_heatbalance_init
  public Radiation_heatbalance_forcing

  !ѿ
  real(DP),save   :: RadCoolRate = 0.0d0    !ͲǮΨ [K/day]
  integer, save   :: IdxHeatUp   = 0        !Ǯ¤αľɸб
  integer, save   :: IdxHeatDown = 0        !Ѱ¤αľɸб
  integer, save   :: IdxCoolUp   = 0        !Ǯ¤αľɸб
  integer, save   :: IdxCoolDown = 0        !Ѱ¤αľɸб
  real(DP),save, allocatable :: xyz_RadHeightHeat(:,:,:)  !ͲǮ¸ߤΰ
  real(DP),save, allocatable :: xyz_RadHeightCool(:,:,:)  !ͲǮ¸ߤΰ

  logical, save :: FlagDExnerDtRad = .true.

contains

!!!------------------------------------------------------------------------!!!
  subroutine Radiation_heatbalance_init
    !
    !NAMELIST Ψ, Ѥΰ, Ǯΰ, ꤹ. 
    !ǮΨ襹ƥå׷׻Τ, 롼ǤϷʤ. 
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8) :: HeightHeatUp   = 0.0d0  !Ǯΰξüι
    real(8) :: HeightHeatDown = 0.0d0  !Ǯΰβüι
    real(8) :: HeightCoolUp   = 0.0d0  !ΰξüι
    real(8) :: HeightCoolDown = 0.0d0  !ΰβüι
    integer :: k                       !롼ѿ
    integer :: unit

    character(*), parameter:: module_name = 'Radiation_Heatbalance_Init'


    ! NAMELIST 
    NAMELIST /radiation_heatbalance_nml/ &
      & RadCoolRate, HeightHeatUp, HeightHeatDown, HeightCoolUp, HeightCoolDown, &
      & FlagDExnerDtRad

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=radiation_heatbalance_nml)
    close(unit)

    do k = kmin, kmax-1
      if ( z_Z(k) <= HeightHeatUp .AND. HeightHeatUp < z_Z(k+1) ) then 
        IdxHeatUp = k
      elseif ( z_Z(k) <= HeightHeatDown .AND. HeightHeatDown < z_Z(k+1) ) then 
        IdxHeatDown = k
      elseif ( z_Z(k) <= HeightCoolUp .AND. HeightCoolUp < z_Z(k+1) ) then 
        IdxCoolUp = k
      elseif ( z_Z(k) <= HeightCoolDown .AND. HeightCoolDown < z_Z(k+1) ) then 
        IdxCoolDown = k
      end if
    end do

    allocate( xyz_RadHeightHeat(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_RadHeightCool(imin:imax, jmin:jmax, kmin:kmax) )

    xyz_RadHeightHeat = 1.0d0
    xyz_RadHeightHeat(:,:,IdxHeatDown:IdxHeatUp) = 1.0d0
    xyz_RadHeightCool = 0.0d0
    xyz_RadHeightCool(:,:,IdxCoolDown:IdxCoolUp) = 1.0d0

    ! Output
    !
    if (myrank == 0) then 
      call MessageNotify( "M", &
        & module_name, "RadCoolRate = %f", d=(/RadCoolRate/))
      call MessageNotify( "M", &
        & module_name, "HeightHeatUp = %f", d=(/HeightHeatUp/))
      call MessageNotify( "M", &
        & module_name, "HeightHeatDown= %f", d=(/HeightHeatDown/))
      call MessageNotify( "M", &
        & module_name, "HeightCoolUp = %f", d=(/HeightCoolUp/))
      call MessageNotify( "M", &
        & module_name, "HeightCoolDown= %f", d=(/HeightCoolDown/))
      call MessageNotify( "M", &
        & module_name, "FlagDExnerDtRad= %b", l=(/ FlagDExnerDtRad /))
    end if

    ! ҥȥǡ
    ! 
    call HistoryAutoAddVariable(  &
      & varname='PTempRad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Radiation term of potential temperature', &
      & units='K.s-1"',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerRad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Radiation term of exner function', &
      & units='s-1"',    &
      & xtype='float')

  end subroutine Radiation_heatbalance_init

!!!------------------------------------------------------------------------!!!
  subroutine radiation_heatbalance_forcing(xyz_Exner, xyz_PTemp, xyz_DPTempDt, xyz_DExnerDt)
    !
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǶŪ˰ͤʲǮ, 
    ! RadHeight  RadHeight2 ޤǤδ֤ǶŪʰͤѤͿ. 
    ! ͶΤȤƲǮѤХ󥹤褦˻ͲǮΨ
    ! ӰΨѲ. 
    ! ѤοͿ, ǮοĴ᤹. 

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)  :: xyz_Exner(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(in)  :: xyz_PTemp(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(inout) :: xyz_DPTempDt(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(inout) :: xyz_DExnerDt(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_DPTempDt0(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_DExnerDt0(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_Rad(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_RadPI(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_DensSum(imin:imax, jmin:jmax, kmin:kmax) 
                                        !̩(ܾʬȾʬ)
    real(DP)              :: HeatSum    !Ǥñ̻βǮ
    real(DP)              :: CoolSum    !Ǥñ̻
    real(DP)              :: RadHeatRate
    integer               :: i, j, k

    ! 
    !
    HeatSum = 0.0d0
    CoolSum = 0.0d0
    xyz_DPTempDt0 = xyz_DPTempDt
    xyz_DExnerDt0 = xyz_DExnerDt

    ! ̩٤λ
    xyz_DensSum = PressBasis                            &
      & * (xyz_ExnerBZ + xyz_Exner)**( CvDry /GasRDry ) &
      & / (GasRDry * (xyz_PTempBZ + xyz_PTemp ) )

    ! Ǥ (Ǯ/ǮΨ) ׻
    do k = IdxHeatDown, IdxHeatUp
      do j = 1, ny
        do i = 1, nx
          HeatSum = HeatSum + z_dz(k) * CpDry * xyz_DensSum(i,j,k)
        end do
      end do
    end do
    
    ! Ǥ (/Ψ) ׻
    do k = IdxCoolDown, IdxCoolUp
      do j = 1, ny
        do i = 1, nx
          CoolSum = CoolSum + z_dz(k) * CpDry * xyz_DensSum(i,j,k)
        end do
      end do
    end do

    ! ǮΨλ
    ! RadCoolRate ͤǤ뤳Ȥ. 
    RadHeatRate = - RadCoolRate * CoolSum / HeatSum
    
    xyz_Rad = &
      &   xyz_RadHeightHeat * RadHeatRate / ( xyz_ExnerBZ  * DayTime ) &
      & + xyz_RadHeightCool * RadCoolRate / ( xyz_ExnerBZ  * DayTime )

    xyz_DPTempDt = xyz_DPTempDt0 + xyz_Rad

    ! Ѳ
    !
    if ( FlagDExnerDtRad ) then
      xyz_RadPI = xyz_DExnerDt_xyz( xyz_Rad )
    else
      xyz_RadPI = 0.0d0
    end if

    ! output
    !
    call HistoryAutoPut(TimeN, 'PTempRad', xyz_Rad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'ExnerRad', xyz_RadPI(1:nx,1:ny,1:nz))
    

    ! Set Margin
    !
!    call SetMargin_xyz(xyz_DPTempDt)
!    call SetMargin_xyz(xyz_DExnerDt)

  end subroutine radiation_heatbalance_forcing
  
end module Radiation_HeatBalance
