!= 3  (xyz ) ֳָ߳ʻ ʻ⥸塼
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: axesset.f90,v 1.16 2014/07/08 01:05:32 sugiyama Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module axesset
  != 3  (xyz ) ֳָ߳ʻ ʻ⥸塼
  !
  !== 
  !
  ! axesset , 3  (xyz ) ֳָ߳ʻҤѤͭºʬˡ˴Ť
  ! ͥǥΤ, Ū Fortran90 ץपӴؿ󶡤. 
  ! Ū˹ԤäƤ뤳Ȥϰʲ̤.
  !
  ! * ʻɸȳʻֳ
  ! * ʻʿѴؿ
  ! 

  !⥸塼ɤ߹
  !
  use dc_types,      only: DP
  use dc_iounit,     only: FileOpen
  use dc_message,    only: MessageNotify
  use mpi_wrapper,   only: myrank,               &
    &                      MPIWrapperCartCreate, &
    &                      MPIWrapperCartShift,  &
    &                      MPIWrapperCommFree
  use gridset,       only: FlagCalc3D,    &
    &                      xsub, ysub,    & ! 
    &                      nx, ny, nz,    & ! ʻ
    &                      imin, imax, jmin, jmax, kmin, kmax ! ξͤȲ
  use namelist_util, only: namelist_filename

  !ۤηػ
  !
  implicit none

  !ǥեȤ
  !
  private

  !
  ! ³
  !
  public :: axesset_init

  ! ʻִؿ 
  !
  public :: xyz_avr_pyz, xyr_avr_pyr, xqz_avr_pqz
  public :: pyz_avr_xyz, pyr_avr_xyr, pqz_avr_xqz
  public :: xyz_avr_xqz, pyz_avr_pqz, xyr_avr_xqr
  public :: xqz_avr_xyz, pqz_avr_pyz, xqr_avr_xyr
  public :: xyz_avr_xyr, pyz_avr_pyr, xqz_avr_xqr
  public :: xyr_avr_xyz, pyr_avr_pyz, xqr_avr_xqz
  public :: pqz_avr_xyz, pyr_avr_xyz, xqr_avr_xyz
  public :: xyz_avr_pqz, xyz_avr_pyr, xyz_avr_xqr

  public :: xyz_pyz, xyr_pyr, xqz_pqz
  public :: pyz_xyz, pyr_xyr, pqz_xqz
  public :: xyz_xqz, pyz_pqz, xyr_xqr
  public :: xqz_xyz, pqz_pyz, xqr_xyr
  public :: xyz_xyr, pyz_pyr, xqz_xqr
  public :: xyr_xyz, pyr_pyz, xqr_xqz
  public :: pqz_xyz, pyr_xyz, xqr_xyz
  public :: xyz_pqz, xyz_pyr, xyz_xqr

  ! ѿ
  real(DP), public, save :: Xmin = 0.0d0                ! x ɸλ
  real(DP), public, save :: Xmax = 1.0d4                ! x ɸλ
  real(DP), public, save :: Ymin = 0.0d0                ! x ɸλ
  real(DP), public, save :: Ymax = 1.0d4                ! x ɸλ
  real(DP), public, save :: Zmin = 0.0d0                ! z ɸλ
  real(DP), public, save :: Zmax = 1.0d4                ! z ɸλ
  real(DP), public, save :: DX  
  real(DP), public, save :: DY           
  real(DP), public, save :: DZ           
  real(DP), allocatable, public, save :: x_X(:)         ! Ⱦʻɸ
  real(DP), allocatable, public, save :: p_X(:)         ! ʻɸ
  real(DP), allocatable, public, save :: x_dx(:)        ! Ⱦʻֳ
  real(DP), allocatable, public, save :: p_dx(:)        ! ʻֳ
  real(DP), allocatable, public, save :: y_Y(:)         ! Ⱦʻɸ
  real(DP), allocatable, public, save :: q_Y(:)         ! ʻɸ
  real(DP), allocatable, public, save :: y_dy(:)        ! Ⱦʻֳ
  real(DP), allocatable, public, save :: q_dy(:)        ! ʻֳ
  real(DP), allocatable, public, save :: z_Z(:)         ! Ⱦʻɸ
  real(DP), allocatable, public, save :: r_Z(:)         ! ʻɸ
  real(DP), allocatable, public, save :: z_dz(:)        ! Ⱦʻֳ
  real(DP), allocatable, public, save :: r_dz(:)        ! ʻֳ
  real(DP), allocatable, public, save :: xyz_X(:,:,:)   ! x ɸ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_Y(:,:,:)   ! y ɸ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_Z(:,:,:)   ! z ɸ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_dX(:,:,:)  ! x ʻҴֳ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_dY(:,:,:)  ! y ʻҴֳ(Ⱦʻ)
  real(DP), allocatable, public, save :: xyz_dZ(:,:,:)  ! z ʻҴֳ(Ⱦʻ)

!------------------------------------
  interface pqz_avr_xyz
    module procedure pqz_xyz
  end interface

  interface pyr_avr_xyz
    module procedure pyr_xyz
  end interface

  interface xqr_avr_xyz
    module procedure xqr_xyz
  end interface

  interface xyz_avr_pqz
    module procedure xyz_pqz
  end interface
  
  interface xyz_avr_pyr
    module procedure xyz_pyr
  end interface

  interface xyz_avr_xqr
    module procedure xyz_xqr
  end interface

!------------------------------------

  interface xyz_avr_pyz
    module procedure xaa_paa
  end interface
  
  interface xyr_avr_pyr
    module procedure xaa_paa
  end interface 

  interface xqz_avr_pqz
    module procedure xaa_paa
  end interface
  
  interface pyz_avr_xyz
    module procedure paa_xaa
  end interface 

  interface pqz_avr_xqz
    module procedure paa_xaa
  end interface 

  interface pyr_avr_xyr
    module procedure paa_xaa
  end interface 

  interface xyz_avr_xqz
    module procedure aya_aqa
  end interface 

  interface pyz_avr_pqz
    module procedure aya_aqa
  end interface 

  interface xyr_avr_xqr
    module procedure aya_aqa
  end interface
  
  interface xqz_avr_xyz
    module procedure aqa_aya
  end interface

  interface pqz_avr_pyz
    module procedure aqa_aya
  end interface 

  interface xqr_avr_xyr
    module procedure aqa_aya
  end interface 

  interface xyz_avr_xyr
    module procedure aaz_aar
  end interface 

  interface pyz_avr_pyr
    module procedure aaz_aar
  end interface 

  interface xqz_avr_xqr
    module procedure aaz_aar
  end interface 

  interface xyr_avr_xyz
    module procedure aar_aaz
  end interface 

  interface pyr_avr_pyz
    module procedure aar_aaz
  end interface 

  interface xqr_avr_xqz
    module procedure aar_aaz
  end interface 

!------------------------------------

  interface xyz_pyz
    module procedure xaa_paa
  end interface
  
  interface xyr_pyr
    module procedure xaa_paa
  end interface 

  interface xqz_pqz
    module procedure xaa_paa
  end interface
  
  interface pyz_xyz
    module procedure paa_xaa
  end interface 

  interface pqz_xqz
    module procedure paa_xaa
  end interface 

  interface pyr_xyr
    module procedure paa_xaa
  end interface 

  interface xyz_xqz
    module procedure aya_aqa
  end interface 

  interface pyz_pqz
    module procedure aya_aqa
  end interface 

  interface xyr_xqr
    module procedure aya_aqa
  end interface
  
  interface xqz_xyz
    module procedure aqa_aya
  end interface

  interface pqz_pyz
    module procedure aqa_aya
  end interface 

  interface xqr_xyr
    module procedure aqa_aya
  end interface 

  interface xyz_xyr
    module procedure aaz_aar
  end interface 

  interface pyz_pyr
    module procedure aaz_aar
  end interface 

  interface xqz_xqr
    module procedure aaz_aar
  end interface 

  interface xyr_xyz
    module procedure aar_aaz
  end interface 

  interface pyr_pyz
    module procedure aar_aaz
  end interface 

  interface xqr_xqz
    module procedure aar_aaz
  end interface 

contains
  !--------------------------------------------------------------------
  subroutine axesset_init
    ! ʻɸȳʻֳν    

    ! ۤηػ
    implicit none

    ! ѿ
    real(DP),allocatable :: xy_X(:,:)! x ɸ(Ⱦʻ, )
    real(DP),allocatable :: xy_Y(:,:)! y ɸ(Ⱦʻ, )
    real(DP),allocatable :: yz_Z(:,:)! z ɸ(Ⱦʻ, )
    integer              :: unit     ! եֹ
    integer              :: comm_cart
    logical, parameter   :: periodic = .false.

    !ե뤫ɤ߹ϥե
    NAMELIST /axesset_nml/ xmin, xmax, ymin, ymax, zmin, zmax

    !ե뤫ϥե˵ܤɤ߹
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=axesset_nml)
    close(unit)
    
    ! ξ岼¤, ɸͤȳʻֳ֤
    ! * 1 ѤΥ֥롼Ѥ
    !
    call MPIWrapperCartCreate(xsub, ysub, periodic, comm_cart)
    call x_axis_init(comm_cart)
    call y_axis_init(comm_cart)
    call z_axis_init
    call MPIWrapperCommFree(comm_cart)
    
    ! 3 ʻɸ
    ! * Ȥ߹ߴؿ spread Ѥ. 
    ! * Ȥ 2 ʻɸ,  3 ˳ĥ.
    ! 
    allocate(xy_X(imin:imax,jmin:jmax))
    allocate(xy_Y(imin:imax,jmin:jmax))
    allocate(yz_Z(jmin:jmax,kmin:kmax))
    
    allocate(xyz_X(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_Y(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_Z(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_dX(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_dY(imin:imax,jmin:jmax,kmin:kmax))
    allocate(xyz_dZ(imin:imax,jmin:jmax,kmin:kmax))
    
    xy_X  = spread(x_X, 2,size(y_Y))
    xyz_X = spread(xy_X,3,size(z_Z))
    
    xy_X   = spread(x_dX, 2,size(y_dY))
    xyz_dX = spread(xy_X,3,size(z_dZ))
    
    xy_Y  = spread(y_Y, 1,size(x_X))
    xyz_Y = spread(xy_Y,3,size(z_Z))
    
    xy_Y   = spread(y_dY, 1,size(x_dX))
    xyz_dY = spread(xy_Y,3,size(z_dZ))
    
    yz_Z  = spread(z_Z, 1,size(y_Y))
    xyz_Z = spread(yz_Z,1,size(x_X))
    
    yz_Z   = spread(z_dZ, 1,size(y_dY))
    xyz_dZ = spread(yz_Z,1,size(x_dX))
    
    deallocate(xy_X)
    deallocate(xy_Y)
    deallocate(yz_Z)

    !"myrank == 0" ˳׻Ρɤ, ɤ߹
    if (myrank == 0) then 
      call MessageNotify( "M", "axesset_init", "XMin = %f", d=(/XMin/)    )
      call MessageNotify( "M", "axesset_init", "XMax = %f", d=(/XMax/)    )
      call MessageNotify( "M", "axesset_init", "YMin = %f", d=(/YMin/)    )
      call MessageNotify( "M", "axesset_init", "YMax = %f", d=(/YMax/)    )
      call MessageNotify( "M", "axesset_init", "ZMin = %f", d=(/ZMin/)    )
      call MessageNotify( "M", "axesset_init", "ZMax = %f", d=(/ZMax/)    )
      call MessageNotify( "M", "axesset_init", "dx = %f", d=(/dx/)    )
      call MessageNotify( "M", "axesset_init", "dy = %f", d=(/dy/)    )
      call MessageNotify( "M", "axesset_init", "dz = %f", d=(/dz/)    )
    end if
  
  end subroutine axesset_init
  
  !--------------------------------------------------------------------
  subroutine x_axis_init(comm_cart)
    !
    != ʻɸȳʻֳν    
    !
    
    ! ۤηػ
    implicit none

    integer, intent(in) :: comm_cart

    ! ѿ
    integer             :: ix   ! do 롼ź
    integer             :: rank, tmp
    integer             :: lp
    integer, parameter  :: direction = 1

    allocate(x_X(imin:imax))
    allocate(p_X(imin:imax))
    allocate(x_dx(imin:imax))
    allocate(p_dx(imin:imax))

    ! 
    lp = -999

    ! ֳֳʻ
    dx = (xmax - xmin) / ( nx * xsub )
    
    ! ٤礦 CPU θĿ
    sx: do ix = 1, xsub
      call MPIWrapperCartShift( comm_cart, direction, ix, rank, tmp )
      if ( rank < 0 ) then 
        lp = ix - 1
        exit sx
      end if
    end do sx

    !ǧ
    if ( lp == -999 ) then 
      call MessageNotify( "E", "axesset_init", "lp (x) is undifined" )
    end if

    ! κ
    do ix = imin, imax
      p_X(ix) = XMin + dx * nx * lp + dx * ix 
      x_X(ix) = XMin + dx * nx * lp + dx * ix - dx * 0.5d0
      x_dx(ix) = dx
      p_dx(ix) = dx
    end do
    
  end subroutine x_axis_init

  !--------------------------------------------------------------------
  subroutine y_axis_init(comm_cart)
    !
    != y κɸͤȳʻֳ֤ꤹ
    !
    
    ! ۤηػ
    implicit none

    integer, intent(in) :: comm_cart

    ! ѿ
    integer             :: jy   ! 롼ź
    integer             :: lp
    integer             :: rank, tmp
    integer, parameter  :: direction = 0
    
    allocate(y_Y(jmin:jmax))
    allocate(q_Y(jmin:jmax))
    allocate(y_dy(jmin:jmax))
    allocate(q_dy(jmin:jmax))

    ! 
    lp = -999

    ! 2 ξ ymax = dx Ȥ. 
    if (.NOT. FlagCalc3D ) then 
      ymax = dx
    end if
    
    ! ֳֳʻ
    dy = (ymax - ymin) / ( ny * ysub )
    
    ! ٤礦 CPU θĿ
    sy: do jy = 1, ysub
      call MPIWrapperCartShift( comm_cart, direction, jy, tmp, rank )
      if ( rank < 0 ) then 
        lp = jy - 1
        exit sy
      end if
    end do sy

    !ǧ
    if ( lp == -999 ) then 
      call MessageNotify( "E", "axesset_init", "lp (y) is undifined" )
    end if
    
    ! κ
    do jy = jmin, jmax
      q_Y(jy) = YMin + dy * ny * lp  + dy * jy
      y_Y(jy) = YMin + dy * ny * lp  + dy * jy - dy * 0.5d0
      y_dy(jy) = dy
      q_dy(jy) = dy
    end do
    
  end subroutine y_axis_init
  !--------------------------------------------------------------------
  subroutine z_axis_init()
    !
    != z κɸͤȳʻֳ֤ꤹ
    !
    
    ! ۤηػ
    implicit none

    ! ѿ
    integer                 :: kz   ! 롼ź
    
    allocate(z_Z(kmin:kmax))
    allocate(r_Z(kmin:kmax))
    allocate(z_dz(kmin:kmax))
    allocate(r_dz(kmin:kmax))
    
    ! ֳֳʻ
    dz = (zmax - zmin) / nz

    ! κ
    do kz = kmin, kmax
      r_Z(kz) = ZMin + dz * kz
      z_Z(kz) = ZMin + dz * (kz - 0.5)
      r_dz(kz) = dz
      z_dz(kz) = dz
    end do
    
  end subroutine z_axis_init
  
  !--------------------------------------------------------------------
  function xaa_paa(paa_Var)
    !
    != ʿԤ x ʻͤȾ֤ 
    ! 
    ! ʿ: p ɸ x ɸ֤. imin ͤۤ.
    !
    !    p     imin    0     1         imax-1  imax
    !     |--*--|--*--||--*--|--*--|--*--||--*--|
    !    x  imin   0      1         imax-1  imax
    !

    ! ۤηػ
    implicit none
        
    real(DP),intent(in) :: paa_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)            :: xaa_paa(imin:imax,jmin:jmax,kmin:kmax)
    integer             :: i, j, k

    do k = kmin, kmax
      do j = jmin, jmax    
        do i = imin+1, imax
          xaa_paa(i,j,k) = ( paa_Var(i,j,k) + paa_Var(i-1,j,k) ) * 0.5d0 
        end do
      end do
    end do

    ! imin ʻҾ
    xaa_paa(imin,:,:) = 1.0d10 
    
  end function xaa_paa
  !--------------------------------------------------------------------
  function paa_xaa(xaa_Var)
    !
    != Ⱦʻ֤ͤ
    !
    ! ʿ: x ɸ p ɸ֤. imax ͤۤ.
    !     
    !    p     imin    0     1         imax-1  imax
    !     |--*--|--*--||--*--|--*--|--*--||--*--|
    !    x  imin   0      1         imax-1  imax
    !
    
    ! ۤηػ
    implicit none

    real(DP),intent(in) :: xaa_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)            :: paa_xaa(imin:imax,jmin:jmax,kmin:kmax)
    integer             :: i, j, k

    do k = kmin, kmax
      do j = jmin, jmax    
        do i = imin, imax-1
          paa_xaa(i,j,k) = ( xaa_Var(i+1,j,k) + xaa_Var(i,j,k) ) * 0.5d0
        end do
      end do
    end do
    
    ! imax ʻҾ
    paa_xaa(imax,:,:) = 1.0d10
    
  end function paa_xaa
  !--------------------------------------------------------------------
  function aya_aqa(aqa_Var)
    !
    != ʿԤ y Ⱦʻͤʻ֤
    !
    ! ʿ: q ɸ y ɸ֤. jmin ͤۤ.
    !
    !    q     jmin    0     1         jmax-1  jmax
    !     |--*--|--*--||--*--|--*--|--*--||--*--|
    !    y  jmin   0      1         jmax-1  jmax
    !
    
    ! ۤηػ
    implicit none

    real(DP),intent(in) :: aqa_Var(imin:imax,jmin:jmax,kmin:kmax)   
    real(DP)            :: aya_aqa(imin:imax,jmin:jmax,kmin:kmax)
    integer             :: i, j, k 
 
    if ( FlagCalc3D ) then 
      do k = kmin, kmax
        do j = jmin+1, jmax    
          do i = imin,   imax
            aya_aqa(i,j,k) = ( aqa_Var(i,j,k) + aqa_Var(i,j-1,k) ) * 0.5d0 
          end do
        end do
      end do
      
      ! jmin ʻҾ
      aya_aqa(:,jmin,:) = 1.0d10

    else      
      ! 2 ׻(y ǿ 1)ξ, ͤ򤽤Τޤ֤
      aya_aqa = aqa_Var
      return
      
    end if   
    
  end function aya_aqa
  !--------------------------------------------------------------------
  function aqa_aya(aya_Var)
    !
    != ʿԤ y ʻͤȾʻ֤
    !
    ! ʿ: y ɸ q ɸ֤. jmax ͤۤ.
    !
    !    q     jmin    0     1         jmax-1  jmax
    !     |--*--|--*--||--*--|--*--|--*--||--*--|
    !    y  jmin   0      1         jmax-1  jmax
    !
    
    ! ۤηػ
    implicit none

    real(DP),intent(in) :: aya_Var(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)            :: aqa_aya(imin:imax,jmin:jmax,kmin:kmax) 
    integer             :: i, j, k

    if ( FlagCalc3D ) then 
      do k = kmin, kmax
        do j = jmin, jmax-1  
          do i = imin, imax
            aqa_aya(i,j,k) = ( aya_Var(i,j+1,k) + aya_Var(i,j,k) ) * 0.5d0
          end do
        end do
      end do
      
      ! jmax ʻҾ
      aqa_aya(:,jmax,:) = 1.0d10

    else
    
      ! 2 ׻(y ǿ 1)ξ, ͤ򤽤Τޤ֤
      aqa_aya = aya_Var
      return

    end if
    
    
  end function aqa_aya
  !--------------------------------------------------------------------
  function aaz_aar(aar_Var)
    !
    != ʿԤ z ʻͤȾʻ֤
    !
    ! ʿ: r ɸ z ɸ֤. zmin ͤۤ.
    !
    !    r     kmin    0     1         kmax-1  kmax
    !     |--*--|--*--||--*--|--*--|--*--||--*--|
    !    z  kmin   0      1         kmax-1  kmax
    !
    
    ! ۤηػ
    implicit none

    real(DP),intent(in) :: aar_Var(imin:imax,jmin:jmax,kmin:kmax)   
    real(DP)            :: aaz_aar(imin:imax,jmin:jmax,kmin:kmax)
    integer             :: i, j, k
    
    do k = kmin+1, kmax
      do j = jmin, jmax    
        do i = imin, imax
          aaz_aar(i,j,k) = ( aar_Var(i,j,k) + aar_Var(i,j,k-1) ) * 0.5d0 
        end do
      end do
    end do
    
    ! kmin ʻҾ
    aaz_aar(:,:,kmin) = 1.0d10
    
  end function aaz_aar
  !--------------------------------------------------------------------
  function aar_aaz(aaz_Var)
    !
    != ʿԤ z Ⱦʻͤʻ֤
    !
    ! ʿ: z ɸ r ɸ֤. zmax ͤۤ.
    !
    !    r     kmin    0     1         kmax-1  kmax
    !     |--*--|--*--||--*--|--*--|--*--||--*--|
    !    z  kmin   0      1         kmax-1  kmax
    !
    
    ! ۤηػ
    implicit none
    
    real(DP),intent(in) :: aaz_Var(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP)            :: aar_aaz(imin:imax,jmin:jmax,kmin:kmax)
    integer             :: i, j, k
    
    do k = kmin, kmax-1
      do j = jmin, jmax    
        do i = imin, imax
          aar_aaz(i,j,k) = ( aaz_Var(i,j,k+1) + aaz_Var(i,j,k) ) * 0.5d0
        end do
      end do
    end do
    
    ! kmax ʻҾ
    aar_aaz(:,:,kmax) = 1.0d10
    
  end function aar_aaz
  !--------------------------------------------------------------------
  function pqz_xyz(xyz_Var)
    !
    != XY ʿ̤ˤ, Ⱦʻ (xy) ʻ (pq) Ѵ
    !

    ! ۤηػ
    implicit none

    real(DP), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)  ! 
    real(DP)             :: pqz_xyz(imin:imax,jmin:jmax,kmin:kmax)  ! 
    integer              :: i, j, k                                 ! 롼ź

    if ( FlagCalc3D ) then 
      ! 3 η׻
      !
      do k = kmin, kmax
        do j = jmin, jmax-1
          do i = imin, imax-1
            pqz_xyz(i,j,k) =             &
              &  (                       &
              &     xyz_Var(i,   j,   k) &
              &   + xyz_Var(i+1, j,   k) &
              &   + xyz_Var(i,   j+1, k) &
              &   + xyz_Var(i+1, j+1, k) &
              &  ) * 0.25d0 
          end do
        end do
      end do
      
      ! imax ʻҾ
      pqz_xyz(imax,:,:) = 1.0d10
      ! jmax ʻҾ
      pqz_xyz(:,jmax,:) = 1.0d10
      
    else
      ! 2 ׻ (y ǿ 1) ξ
      !
      do k = kmin, kmax
        do j = jmin, jmax    
          do i = imin, imax-1
            pqz_xyz(i,j,k) =           &
              &  (                     &
              &     xyz_Var(i,   j, k) &
              &   + xyz_Var(i+1, j, k) &
              &  ) * 0.5d0 
          end do
        end do
      end do

      ! imax ʻҾ
      pqz_xyz(imax,:,:) = 1.0d10
      
    end if
        
  end function pqz_xyz
  !--------------------------------------------------------------------
  function pyr_xyz(xyz_Var)
    !
    != XZ ʿ̤ˤȾʻ (xz) ʻ (pr) ؤѴԤ
    !

    ! ۤηػ
    implicit none

    real(DP), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: pyr_xyz(imin:imax,jmin:jmax,kmin:kmax) ! 
    integer              :: i, j, k                                ! 롼ź
    
    do k = kmin, kmax-1
      do j = jmin, jmax
        do i = imin, imax-1
          pyr_xyz(i,j,k) =                &
            &  (                          &
            &    + xyz_Var(i,   j, k  )   &
            &    + xyz_Var(i+1, j, k  )   &
            &    + xyz_Var(i,   j, k+1)   &
            &    + xyz_Var(i+1, j, k+1)   &
            &  ) * 0.25d0 
        end do
      end do
    end do

    ! imax ʻҾ
    pyr_xyz(imax,:,:) = 1.0d10
    ! kmax ʻҾ
    pyr_xyz(:,:,kmax) = 1.0d10

    
  end function pyr_xyz
  !--------------------------------------------------------------------
  function xqr_xyz(xyz_Var)
    !
    != YZ ʿ̤ˤ, ʻ (qr) Ⱦʻ (yz) ؤѴԤ
    !

    ! ۤηػ
    implicit none

    real(DP), intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax)   ! 
    real(DP)             :: xqr_xyz(imin:imax,jmin:jmax,kmin:kmax)   ! 
    integer              :: i, j, k                                  ! 롼ź
    
    if ( FlagCalc3D ) then 
      
      do k = kmin, kmax-1
        do j = jmin, jmax-1
          do i = imin, imax
            xqr_xyz(i,j,k) =              &
              &  (                        &
              &   + xyz_Var(i, j,   k  )  &
              &   + xyz_Var(i, j+1, k  )  &
              &   + xyz_Var(i, j,   k+1)  &
              &   + xyz_Var(i, j+1, k+1)  &
              &  ) * 0.25d0 
          end do
        end do
      end do

      ! jmax ʻҾ
      xqr_xyz(:,jmax,:) = 1.0d10
      ! kmax ʻҾ
      xqr_xyz(:,:,kmax) = 1.0d10

    else
      
      do k = kmin, kmax-1
        do j = jmin, jmax
          do i = imin, imax
            xqr_xyz(i,j,k) =            &
              &  (                      &
              &    + xyz_Var(i, j, k)   &
              &    + xyz_Var(i, j, k+1) &
              &  ) * 0.5d0 
          end do
        end do
      end do

      ! kmax ʻҾ
      xqr_xyz(:,:,kmax) = 1.0d10

    end if
    
  end function xqr_xyz
  !--------------------------------------------------------------------
  function xyz_pqz(pqz_Var)
    !
    != XY ʿ̤ˤ, ʻ (pq) Ⱦʻ (xz) Ѵ
    !

    ! ۤηػ
    implicit none

    real(DP), intent(in) :: pqz_Var(imin:imax,jmin:jmax,kmin:kmax) ! 
    real(DP)             :: xyz_pqz(imin:imax,jmin:jmax,kmin:kmax) ! 
    integer              :: i, j, k                                ! 롼ź
    
    if ( FlagCalc3D ) then 
      ! 3 η׻
      !
      do k = kmin, kmax
        do j = jmin+1, jmax
          do i = imin+1, imax
            xyz_pqz(i,j,k) =               &
              &  (                         &
              &    + pqz_Var(i-1, j-1, k)  &
              &    + pqz_Var(i,   j-1, k)  &
              &    + pqz_Var(i-1, j,   k)  &
              &    + pqz_Var(i,   j,   k)  &
              &  ) * 0.25d0 
          end do
        end do
      end do

      ! imin ʻҾ
      xyz_pqz(imin,:,:) = 1.0d10
      ! jmin ʻҾ
      xyz_pqz(:,jmin,:) = 1.0d10
      
    else
      ! 2 ׻ (y ǿ 1) ξ
      !
      do k = kmin, kmax
        do j = jmin, jmax
          do i = imin+1, imax
            xyz_pqz(i,j,k) =            &
              &  (                      &
              &    + pqz_Var(i-1, j, k) &
              &    + pqz_Var(i,   j, k) &
              &  ) * 0.5d0 
          end do
        end do
      end do
      
      ! imin ʻҾ
      xyz_pqz(imin,:,:) = 1.0d10

    end if
    
  end function xyz_pqz
  !--------------------------------------------------------------------
  function xyz_pyr(pyr_Var)
    !
    != XZ ʿ̤ˤʻ (pr) Ⱦʻ (xz) ؤѴԤ
    !

    ! ۤηػ
    implicit none

    real(DP), intent(in) :: pyr_Var(imin:imax,jmin:jmax,kmin:kmax)     ! 
    real(DP)             :: xyz_pyr(imin:imax,jmin:jmax,kmin:kmax) ! 
    integer              :: i, j, k                                    ! 롼ź
        
    do k = kmin+1, kmax
      do j = jmin,   jmax
        do i = imin+1, imax
          xyz_pyr(i,j,k) =               &
            &  (                         &
            &    + pyr_Var(i-1, j, k-1)  &
            &    + pyr_Var(i,   j, k-1)  &
            &    + pyr_Var(i-1, j, k  )  &
            &    + pyr_Var(i,   j, k  )  &
            &  ) * 0.25d0 
        end do
      end do
    end do
    
    ! imin ʻҾ
    xyz_pyr(imin,:,:) = 1.0d10
    ! kmin ʻҾ
    xyz_pyr(:,:,kmin) = 1.0d10
    
  end function xyz_pyr
  !--------------------------------------------------------------------
  function xyz_xqr(xqr_Var)
    !
    != YZ ʿ̤ˤ, Ⱦʻ (yz) ʻ (qr) ؤѴԤ
    !

    ! ۤηػ
    implicit none

    real(DP), intent(in) :: xqr_Var(imin:imax,jmin:jmax,kmin:kmax)     ! 
    real(DP)             :: xyz_xqr(imin:imax,jmin:jmax,kmin:kmax) ! 
    integer              :: i, j, k                                    ! 롼ź

    if ( FlagCalc3D ) then 

      do k = kmin+1, kmax
        do j = jmin+1, jmax
          do i = imin, imax
            xyz_xqr(i,j,k) =               &
              &  (                         &
              &    + xqr_Var(i, j-1, k-1)  &
              &    + xqr_Var(i, j,   k-1)  &
              &    + xqr_Var(i, j-1, k  )  &
              &    + xqr_Var(i, j,   k  )  &
              &  ) * 0.25d0 
          end do
        end do
      end do

      ! jmin ʻҾ
      xyz_xqr(:,jmin,:) = 1.0d10
      ! kmin ʻҾ
      xyz_xqr(:,:,kmin) = 1.0d10
      
    else

      do k = kmin+1, kmax
        do j = jmin, jmax
          do i = imin, imax
            xyz_xqr(i,j,k) =              &
              &  (                        &
              &    + xqr_Var(i, j, k-1)   &
              &    + xqr_Var(i, j, k  )   &
              &  ) * 0.5d0 
          end do
        end do
      end do
      
      ! kmin ʻҾ
      xyz_xqr(:,:,kmin) = 1.0d10
      
    end if
    
  end function xyz_xqr

end module axesset

