!= شϢν̤׻뤿Υ⥸塼
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: chemcalc.f90,v 1.13 2015/02/19 02:17:25 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006-2014. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module ChemCalc
  !
  != شϢν̤׻뤿Υ⥸塼. 
  !
  ! AMP  Antoine ˰¾Ѥưʲ. 
  ! ǥեȤǤ AMP Ȥ褦ˤƤ. 
  !  * ˰¾
  !  * ˰¾βʬ
  !  * Ǯ
  !

  ! ⥸塼ƤӽФ
  !
  use dc_types,   only: DP                               !ٻ
  use dc_message, only: MessageNotify                    !åɽ
  use mpi_wrapper,only: myrank                           !rank
  use ChemData,   only: ChemData_init,                 & !
    &                   ChemData_SpcNum,               & !ǡ١βؼ
    &                   ChemData_SvapPress_AntoineA,   & !Antoine  A 
    &                   ChemData_SvapPress_AntoineB,   & !Antoine  B 
    &                   ChemData_SvapPress_AntoineC,   & !Antoine  C 
    &                   ChemData_SvapPress_AntoineUnit,& !ñѴѷ
    &                   ChemData_SvapPress_AMPA,       & !AMP  A 
    &                   ChemData_SvapPress_AMPB,       & !AMP  B 
    &                   ChemData_SvapPress_AMPC,       & !AMP  C 
    &                   ChemData_SvapPress_AMPD,       & !AMP  D 
    &                   ChemData_SvapPress_AMPE,       & !AMP  E 
    &                   GasRUniv,                      & !
    &                   ChemData_OneSpcID,             & !ؼ ID      
    &                   ChemData_CpRef,                & !ɸ֤Ǥñ̼Ǯ
    &                   ChemData_CpPerMolRef,          & !ɸ֤Ǥñ̥Ǯ
    &                   ChemData_CvRef,                & !ɸ֤Ǥñ̼Ǯ
    &                   ChemData_MolWt,                & !ʬ
    &                   ChemData_GasR                    ! [J/K kg]
  use gridset,    only: nx, ny, nz,                    & ! ʪΰ礭
    &                   imin, imax,                    & !  X ξ¡
    &                   jmin, jmax,                    & !  Y ξ¡
    &                   kmin, kmax                       !  Z ξ¡
  use constants,  only: PressBasis,                    & !̤ɸవ         [Pa]
    &                   PressSfc,                      & !Ǥΰ       [Pa]
    &                   CpDry,                         & !ʬʿ갵Ǯ [J/K kg]
    &                   MolWtDry,                      & !ʬʿʬ   [kg/mol]
    &                   GasRDry                          !ʬε     [J/K kg]
  use basicset,   only: xyz_TempBZ                       !٤δܾ
  use axesset,    only: z_Z                              !z 

  ! ۤηػ
  !
  implicit none

  ! ΤФ private °դ. 
  !
  private
  
  real(DP), save, public :: ReactHeatNH4SH       !NH4SH ȿǮ [J/K kg]
  real(DP), save, public :: ReactHeatNH4SHPerMol !NH4SH ȿǮ [J/K mol]

  integer,  save :: a_kmin(ChemData_SpcNum)   !ʪ˷᤿β
  integer,  save :: a_kmax(ChemData_SpcNum)   !ʪ˷᤿β
  real(DP), save :: a_SwAmp(ChemData_SpcNum)  !å. AMP Ȥ 1.0, Ǥʤ 0.0  
  real(DP), save :: a_SwAnt(ChemData_SpcNum)  !å. Antoine Ȥ 1.0, Ǥʤ 0.0
  real(DP), save :: a_antA(ChemData_SpcNum)   !Antoine ξ A 
  real(DP), save :: a_antB(ChemData_SpcNum)   !Antoine ξ B 
  real(DP), save :: a_antC(ChemData_SpcNum)   !Antoine ξ C 
  real(DP), save :: a_antU(ChemData_SpcNum)   !Antoine ξñ̴Τη
  real(DP), save :: a_ampA(ChemData_SpcNum)   !AMP ξ A 
  real(DP), save :: a_ampB(ChemData_SpcNum)   !AMP ξ B 
  real(DP), save :: a_ampC(ChemData_SpcNum)   !AMP ξ C 
  real(DP), save :: a_ampD(ChemData_SpcNum)   !AMP ξ D 
  real(DP), save :: a_ampE(ChemData_SpcNum)   !AMP ξ E 
  real(DP), save :: a_MolWt(ChemData_SpcNum)  !ʬ
  
  ! 륵֥롼 public °դ
  !
  public ChemCalc_Init                            !롼
  public ChemCalc_Init2                           !롼
  public MolWt                                    !ʬ
  public GasR                                     !
  public CpRef, CpPerMolRef, CvRef                !갵Ǯ, Ǯ
  public SvapPress, xyz_SvapPress                 !˰¾ [Pa]
  public xyz_LatentHeat                           !Ǯ [J/K kg]
  public LatentHeatPerMol                         !Ǯ [J/K mol]
  public xyz_DQMixSatDPTemp
  public xyz_DelQMixNH4SH
  public DelMolFrNH4SH
  
contains
  
!!!
!!! 롼
!!!
  subroutine ChemCalc_Init
    !
    !롼
    !

    !ۤηػ
    implicit none

    !ѿ
    character(20)      :: Name
    integer            :: id
    
    !-----------------------------------------------------------
    ! 
    !
    
    ! ǡ١ν
    call chemdata_init

    !Antoine ˰¾η
    a_antA = ChemData_SvapPress_AntoineA
    a_antB = ChemData_SvapPress_AntoineB
    a_antC = ChemData_SvapPress_AntoineC
    a_antU = ChemData_SvapPress_AntoineUnit

    !AMP ˰¾η
    a_ampA = ChemData_SvapPress_AMPA
    a_ampB = ChemData_SvapPress_AMPB
    a_ampC = ChemData_SvapPress_AMPC
    a_ampD = ChemData_SvapPress_AMPD
    a_ampE = ChemData_SvapPress_AMPE

    !ʬ
    a_MolWt = ChemData_MolWt
    
    !NH4SH ȿǮν
    !  NH4SH 1kg ФȿǮˤ.
    Name = 'NH4SH-s'
    id   = ChemData_OneSpcID( Name )  
    
    ReactHeatNH4SHPerMol  = GasRUniv * 10834.0d0
    ReactHeatNH4SH = GasRUniv * 10834.0d0 / MolWt( id )

    !--------------------------------------------------------
    ! ʪˤä, AMP Ȥ Antoine Ȥ. 
    ! AMP ηʤ Antoine ȤȤˤ. 
    !     

    do ID = 1, ChemData_SpcNum
      if ( a_ampA(ID) /= 0.0d0 ) then 

        ! AMP ηͿƤ
        !
        a_SwAmp(ID) = 1.0d0
        a_SwAnt(ID) = 0.0d0

      elseif ( a_antA(ID) /= 0.0d0 ) then 

        ! Antoine ηͿƤ
        !
        a_SwAmp(ID) = 0.0d0
        a_SwAnt(ID) = 1.0d0

      else

        ! Τξ
        !
        a_SwAmp(ID) = 0.0d0
        a_SwAnt(ID) = 0.0d0

      end if
    end do

    !  (ʪΰξ¤Ϳ) 
    a_kmax = nz

    !  (ʪΰβ¤Ϳ) 
    a_kmin = 1

!    if (myrank == 0) then 
!      
!      call MessageNotify( "M", &
!        & "ChemCalc_Init", "ReactHeatNH4SH = %f", d=(/ReactHeatNH4SH/) )
!      id   = ChemData_OneSpcID( Name )  
!      call MessageNotify( "M", &
!        & "ChemCalc_Init", "NH4SH MolWt = %f", d=(/MolWt(id)/) )
!      
!      write(*,*) "*** MESSAGE [ChemCalc_Init] ***  a_kmin = ", a_kmin
!      write(*,*) "*** MESSAGE [ChemCalc_Init] ***  a_kmax = ", a_kmax
!      write(*,*) "*** MESSAGE [ChemCalc_Init] ***  a_SwAMP = ", a_SwAMP
!      write(*,*) "*** MESSAGE [ChemCalc_Init] ***  a_SWAnt = ", a_SwAnt
!
!    end if

  end subroutine ChemCalc_Init

!!!
!!! 롼
!!!
!!!==========================================================================
  subroutine ChemCalc_Init2
    !
    ! 롼  2
    !
    ! Ŭͤ˰¾礭/ˤ˰¾η׻
    ! ԤʤȤˤ.  TempBZ ޤʤȷ׻ʤΤ,
    ! ѻǤϤ뤬, 롼 2 ĤʬƤ. 
    !

    use namelist_util, only: namelist_filename
    use dc_iounit,     only: FileOpen

    !ۤηػ
    implicit none

    !ѿ
    integer            :: id
    integer            :: k
    integer            :: unit, ierr
    real(DP)           :: Temp
    real(DP),parameter :: Temp0C = 273.15d0
    real(DP)           :: logsvap
    real(DP)           :: HeightUp = 0.0d0
    real(DP)           :: HeightDown = 0.0d0
    logical            :: FlagNoNML = .false.
    
    !NAMELIST 
    NAMELIST /chemcalc_nml/ HeightUp, HeightDown
 
    !ե륪ץ. . 
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=chemcalc_nml, iostat=ierr, err=99)
    close(unit)
99  FlagNoNML = .true.

    !--------------------------------------------------------
    ! ׻Ŭ˥ܤ뤿ν (1) 
    !
    ! ˰¾ʬ, ׻ɬפϤʤȤɤΤ?
    ! ׻ξ, ήǤϿξϤۤȤɥ, ή
    ! ˤäƱնޤǻ夬, ʤȯ.
    ! ŷŪ˹٤ꤹΤ񤷤ʤΤ,  (HeightUp) ꤵ줿
    ! ˤ, η׻ϹԤʤȤȤ. 
    
    ! HeightUp ꤵƤ˽Ԥ. 
    ! ʪ˰㤦ȤϹͤƤʤΤ, ʪФ롼פϲ󤵤ʤ. 
    !
    if ( HeightUp > 0.0d0 ) then 

      do k = kmin, kmax
        if ( z_Z(k) > HeightUp ) then 
          a_kmax = k
          exit
        end if
      end do
      
    end if

    !--------------------------------------------------------
    ! ׻Ŭ˥ܤ뤿ν (2) 
    ! 
    ! ˰¾׻뤿źβ¤. 
    ! HeightDown ꤵƤˤϤͥ褷, 
    ! HeightDown ξˤϰʲμ³ǲꤹ. 
    !
    ! * ˰¾ǤΰϤϤʤȤȤ˷.
    !   * ɤʪФƤ Antoine ηͿƤ뤳Ȥ. 
    ! 
    ! Fujitsu Fortran Ǥ, exp(logsvap) [logsvap > 700] ǥ顼Ф. 
    ! HeightUp ǤäƤ, logsvap > 700 Ȥʤ٤򲼸¤Ȥ. 

    do ID = 1, ChemData_SpcNum
      ! ŷʪξ˷׻Ԥ (Τξ a_antA = 0.0)
      !
      if ( a_antA(ID) /= 0.0d0 ) then 

        ! ľϾ롼פ.        
        do k = nz, 1, -1

          ! ܾβ٤Ф˰¾ log ׻
          !
          Temp = xyz_TempBZ(1,1,k)
          logsvap =                                    &
            &       (                                  &
            &           a_antA(ID)                     &
            &         - a_antB(ID)                     &
            &           / (a_antC(ID) + Temp - Temp0C) &
            &        ) * dlog(10.0d0)                  &
            &        + a_antU(ID)

          ! logsvap > 700 Ȥʤźݴ
          ! 
          if ( logsvap > 700 ) then
            a_kmin(ID) = k
            exit
            
          ! ¤ꤵ줿
          !
          elseif ( z_Z(k) <= HeightDown ) then 
            a_kmin(ID) = k
            exit

          ! ˰¾
          !
          elseif( HeightDown < 0.0d0 .AND. logsvap >= dlog( PressSfc ) ) then 
            a_kmin(ID) = k
            exit

          end if
        end do
        
      end if
    end do

    !--------------------------------------------------------
    ! ͤγǧ
    !
    if (myrank == 0) then
      
      if (FlagNoNML) then
        call MessageNotify( "M", "ChemCalc_Init2", "No information of chemcalc_nml in config file; use default values")

      else
        write(*,*) "*** MESSAGE [ChemCalc_Init2] ***  a_kmin = ", a_kmin
        write(*,*) "*** MESSAGE [ChemCalc_Init2] ***  a_kmax = ", a_kmax

      end if
      
    end if


  end subroutine ChemCalc_Init2

!!!
!!! ˰¾, Ǯ, etc. δܴؿ. 
!!! ؼ ID Ȳ٤Ф֤ͤ
!!!  

!!!==========================================================================
  function CpRef(ID)
    !
    !Ϳ줿ؼФ, ɸ֤Ǥñ̼갵Ǯ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: CpRef        !ɸ֤Ǥñ̼Ǯ
    integer, intent(in) :: ID           !ؼ ID

    
    !ǡ١
    CpRef = ChemData_CpRef(ID)

  end function CpRef


!!!==========================================================================
  function CpPerMolRef(ID)
    !
    !Ϳ줿ؼФ, ɸ֤Ǥñ̥갵Ǯ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: CpPerMolRef  !ɸ֤Ǥñ̥Ǯ
    integer, intent(in) :: ID           !ؼ ID

    
    !ǡ١
    CpPerMolRef = ChemData_CpPerMolRef(ID)

  end function CpPerMolRef


!!!==========================================================================
  function CvRef(ID)
    !
    !Ϳ줿ؼФ, ɸ֤Ǥñ̼갵Ǯ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: CvRef       !ɸ֤Ǥñ̼Ǯ
    integer, intent(in) :: ID           !ؼ ID

    
    !ǡ١
    CvRef = ChemData_CvRef(ID)

  end function CvRef


!!!==========================================================================
  function MolWt(ID)
    !
    !Ϳ줿ؼФ, ʬ̤׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: MolWt         !ʬ
    integer, intent(in) :: ID      !ؼ ID

    
    !ǡ١
    MolWt = ChemData_MolWt(ID)

  end function MolWt


!!!==========================================================================
  function GasR(ID)
    !
    !Ϳ줿ؼФ, ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: GasR          !ʬ
    integer, intent(in) :: ID      !ؼ ID
    
    
    !ǡ١
    GasR = ChemData_GasR(ID)

  end function GasR


!!!
!!!  3 δؿ
!!!

!!!==========================================================================
  function xyz_SvapPress( ID, xyz_Temp )
    !
    != Ϳ줿ؼȲ٤Ф, ˰¾׻. 
    !

    !ۤηػ
    implicit none
    
    ! ѿ  
    real(DP)            :: xyz_SvapPress(imin:imax,jmin:jmax,kmin:kmax) 
                                                          !˰¾
    real(DP),intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax)  
                                                          !
    integer, intent(in) :: ID                             !ؼ ID
  
    !ѿ
    real(DP)            :: LogSvapPress
    real(DP),parameter  :: Temp0C = 273.15d0
    integer             :: i, j, k

    ! 
    ! * ˰¾Ͻʬ礭ͤˤƤ.
    !
    xyz_SvapPress = PressSfc * 100.0d0

    ! ˰¾η׻
    ! a_SwAmp, a_SwAnt Ѥ뤳Ȥ, 򤵤줿׻ˡѤ.
    !
    do k = a_kmin(ID), a_kmax(ID)
      do j = 1, ny
        do i = 1, nx
          
          ! ˰¾ log ׻
          !
          LogSvapPress =                                           &
            &      (                                               &
            &         a_ampA(ID) / xyz_Temp(i,j,k)                 &
            &       + a_ampB(ID)                                   &
            &       + a_ampC(ID) * dlog( xyz_Temp(i,j,k) )         &
            &       + a_ampD(ID) * xyz_Temp(i,j,k)                 &
            &       + a_ampE(ID) * ( xyz_temp(i,j,k) ** 2 )        &
            &       + dlog(1.0d-1)                                 &
            &      ) * a_SwAmp(ID)                                 &
            &    + (                                               &
            &       + (                                            &
            &          + a_antA(ID)                                &
            &          - a_antB(ID)                                &
            &            / (a_antC(ID) + xyz_Temp(i,j,k) - Temp0C) &
            &         ) * dlog(10.0d0)                             &
            &       + a_antU(ID)                                   &
            &      ) * a_SwAnt(ID)
          
          !˰¾׻
          !
          xyz_SvapPress(i,j,k) =  dexp( LogSvapPress )

        end do
      end do
    end do

  end function xyz_SvapPress  

!!!==========================================================================
  function xyz_LatentHeat(ID, xyz_Temp)
    !
    != ˰¾Ǯ׻. 
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP)            :: xyz_LatentHeat(imin:imax,jmin:jmax,kmin:kmax)
                                                            !Ǯ[J/K kg]
    real(DP),intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax)
                                                    ![K]
    integer, intent(in) :: ID                       !ؼ ID

    !ؿ
    real(DP)            :: DLogSvapPressDTemp
    real(DP),parameter  :: GasRUniv = 8.314d0
    real(DP),parameter  :: Temp0C = 273.15d0
    integer             :: i, j, k

    ! 
    !
    xyz_LatentHeat = 0.0d0

    do k = a_kmin(ID), a_kmax(ID)
      do j = 1, ny
        do i = 1, nx

          ! ˰¾βʬ
          ! a_SwAmp, a_SwAnt Ѥ뤳Ȥ, 򤵤줿׻ˡѤ.
          !
          DLogSvapPressDTemp =                                             &
            &    (                                                         &
            &     - a_ampA(ID) / (xyz_Temp(i,j,k) ** 2.0d0)                &
            &     + a_ampC(ID) / xyz_Temp(i,j,k)                           &
            &     + a_ampD(ID)                                             &
            &     + a_ampE(ID) * 2.0d0 * xyz_Temp(i,j,k)                   &
            &    ) * a_SwAmp(ID)                                           &
            &  + (                                                         &
            &     + a_antB(ID) * dlog(10.0d0)                              &
            &       / ( (a_antC(ID) + xyz_Temp(i,j,k) - Temp0C) ** 2.0d0 ) &
            &    ) * a_SwAnt(ID)
          
          xyz_LatentHeat(i,j,k) =                                          &
            & DLogSvapPressDTemp * GasRUniv * (xyz_Temp(i,j,k) ** 2.0d0)   &
            &  / a_MolWt(ID)

        end do
      end do
    end do
    
  end function xyz_LatentHeat


!!!==========================================================================
  function SvapPress(ID, Temp)
    !
    != Ϳ줿ؼȲ٤Ф, ˰¾׻. 
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: SvapPress   !˰¾
    real(DP),intent(in) :: Temp        ! [K]
    integer, intent(in) :: ID          !ؼ ID

    !ѿ
    real(DP)            :: LogSvapPress
    real(DP), parameter :: Temp0C = 273.15d0

    ! ˰¾ log ׻
    ! п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    !
    LogSvapPress =                               &
      & min(                                     &
      &      (                                   &
      &         a_ampA(ID) / Temp                &
      &       + a_ampB(ID)                       &
      &       + a_ampC(ID) * dlog( Temp )        &
      &       + a_ampD(ID) * Temp                &
      &       + a_ampE(ID) * ( Temp ** 2 )       &
      &       + dlog(1.0d-1)                     &
      &      ) * a_SwAmp(ID)                     &
      &    + (                                   &
      &        (                                 &
      &         + a_antA(ID)                     &
      &         - a_antB(ID)                     &
      &           / (a_antC(ID) + Temp - Temp0C) &
      &        ) * dlog(10.0d0)                  &
      &       + a_antU(ID)                       &
      &      ) * a_SwAnt(ID),                    &
      &   700.0d0                                &
      & )
          
    !˰¾׻
    !
    SvapPress =  dexp( LogSvapPress )

  end function SvapPress


!!!==========================================================================
  function LatentHeatPerMol(ID, Temp)
    !
    != Ϳ줿ؼȲ٤Ф, Ǯ [J/K/mol] ׻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP)            :: LatentHeatPerMol   !Ǯ
    real(DP),intent(in) :: Temp               !
    integer, intent(in) :: ID                 !ؼ̾
    
    !ѿ
    real(DP)            :: DLogSvapPressDTemp
    real(DP),parameter  :: GasRUniv = 8.314d0  !׵
    real(DP),parameter  :: Temp0C = 273.15d0

    ! ˰¾βʬ
    ! a_SwAmp, a_SwAnt Ѥ뤳Ȥ, 򤵤줿׻ˡѤ.
    !
    DLogSvapPressDTemp =                                  &
      &    (                                              &
      &     - a_ampA(ID) / (Temp ** 2.0d0)                &
      &     + a_ampC(ID) / Temp                           &
      &     + a_ampD(ID)                                  &
      &     + a_ampE(ID) * 2.0d0 * Temp                   &
      &    ) * a_SwAmp(ID)                                &
      &  + (                                              &
      &     + a_antB(ID) * dlog(10.0d0)                   &
      &       / ( (a_antC(ID) + Temp - Temp0C) ** 2.0d0 ) &
      &    ) * a_SwAnt(ID)
          
    ! Ǯη׻
    !
    LatentHeatPerMol =                                    &
      & DLogSvapPressDTemp * GasRUniv * (Temp ** 2.0d0)   

  end function LatentHeatPerMol

!!!-----------------------------------------------------------------------!!!
  function xyz_DQMixSatDPTemp(ID, MolWt, xyz_Temp, xyz_Exner)
    !
    !˰¾  ʬԤ
    !ºݤˤ, dq/dp * dp/dT * dT/d ¹. (â p ˰¾)
    !
    ! * dq/dp =  Mv / (Md * p_all) 
    !   (q = p * Mv / (Md * p_all) )
    ! * dT/d= \pi  (T = \pi \theta)
    !
    
    !ۤηػ
    implicit none 
    
    !ѿ
    integer, intent(in) :: ID
    real(DP),intent(in) :: MolWt
    real(DP),intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax)
                                            !( + ܾ)
    real(DP),intent(in) :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax)
                                            !ʡؿ( + ܾ)
    real(DP)            :: xyz_DQMixSatDPTemp(imin:imax,jmin:jmax,kmin:kmax)
                           
    !ѿ
    real(DP)            :: xyz_Press(imin:imax,jmin:jmax,kmin:kmax)
                                            !( + ܾ)
    real(DP)            :: DSvapPressDTemp
                                            !˰¾βʬ [Pa/K]
    real(DP)            :: LogSvapPress
    real(DP)            :: DLogSvapPressDTemp
    real(DP),parameter  :: Temp0C = 273.15d0
    integer             :: i, j, k

    ! 
    !
    xyz_DQMixSatDPTemp = 0.0d0
    xyz_Press = PressBasis * (xyz_Exner ** (CpDry / GasRDry))

    ! ˰¾βʬ
    !
    do k = a_kmin(ID), a_kmax(ID)
      do j = 1, ny
        do i = 1, nx
          ! ˰¾ log ׻
          !
          LogSvapPress =                                           &
            &      (                                               &
            &         a_ampA(ID) / xyz_Temp(i,j,k)                 &
            &       + a_ampB(ID)                                   &
            &       + a_ampC(ID) * dlog( xyz_Temp(i,j,k) )         &
            &       + a_ampD(ID) * xyz_Temp(i,j,k)                 &
            &       + a_ampE(ID) * ( xyz_temp(i,j,k) ** 2 )        &
            &       + dlog(1.0d-1)                                 &
            &      ) * a_SwAmp(ID)                                 &
            &    + (                                               &
            &       + (                                            &
            &          + a_antA(ID)                                &
            &          - a_antB(ID)                                &
            &            / (a_antC(ID) + xyz_Temp(i,j,k) - Temp0C) &
            &         ) * dlog(10.0d0)                             &
            &       + a_antU(ID)                                   &
            &      ) * a_SwAnt(ID)

          ! ˰¾βʬ
          !
          DLogSvapPressDTemp =                                             &
            &    (                                                         &
            &     - a_ampA(ID) / (xyz_Temp(i,j,k) ** 2.0d0)                &
            &     + a_ampC(ID) / xyz_Temp(i,j,k)                           &
            &     + a_ampD(ID)                                             &
            &     + a_ampE(ID) * 2.0d0 * xyz_Temp(i,j,k)                   &
            &    ) * a_SwAmp(ID)                                           &
            &  + (                                                         &
            &     + a_antB(ID) * dlog(10.0d0)                              &
            &       / ( (a_antC(ID) + xyz_Temp(i,j,k) - Temp0C) ** 2.0d0 ) &
            &    ) * a_SwAnt(ID)
      
          DSvapPressDTemp = DLogSvapPressDTemp * dexp( LogSvapPress ) 

          xyz_DQMixSatDPTemp(i,j,k) =                               &
            &   MolWt / ( MolWtDry * xyz_Press(i,j,k) )             &
            &   * DSvapPressDTemp * xyz_Exner(i,j,k)   
          
        end do
      end do
    end do
    
  end function xyz_DQMixSatDPTemp


!!!-----------------------------------------------------------------------!!!
  function xyz_DelQMixNH4SH(xyz_TempAll, xyz_PressAll, xyz_PressDry, &
    &                       xyz_QMixNH3, xyz_QMixH2S, &
    &                       MolWtNH3, MolWtH2S)
    !
    ! NH4SH ȿȼ, NH4SH ()
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP),intent(in) :: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax)
                                         !
    real(DP),intent(in) :: xyz_PressAll(imin:imax,jmin:jmax,kmin:kmax)
                                         !
    real(DP),intent(in) :: xyz_PressDry(imin:imax,jmin:jmax,kmin:kmax)
                                         !
    real(DP),intent(in) :: xyz_QMixNH3(imin:imax,jmin:jmax,kmin:kmax)
                                         !NH3 κ
    real(DP),intent(in) :: xyz_QMixH2S(imin:imax,jmin:jmax,kmin:kmax)
                                         !H2S κ
    real(DP),intent(in) :: MolWtNH3      !NH3 ʬ
    real(DP),intent(in) :: MolWtH2S      !H2S ʬ

    real(DP) :: xyz_DelQMixNH4SH(imin:imax,jmin:jmax,kmin:kmax)
                                         !NH4SH κ
    real(DP) :: xyz_EquivConst(imin:imax,jmin:jmax,kmin:kmax)
                                         !ʿ
    real(DP) :: xyzf_PartialPress(imin:imax,jmin:jmax,kmin:kmax,2)
                                         !(ʬ)
    real(DP) :: xyz_Solution(imin:imax,jmin:jmax,kmin:kmax)
                                         !(β)

    !
!    xyz_DelQMixNH4SH = 0.0d0
    
    !˥βǤʬ. 
    xyzf_PartialPress(:,:,:,1) = xyz_QMixNH3 * xyz_PressAll * MolWtDry / MolWtNH3 
    xyzf_PartialPress(:,:,:,2) = xyz_QMixH2S * xyz_PressAll * MolWtDry / MolWtH2S 

    !ʿ
    xyz_EquivConst = 61.781d0 - 10834.0d0 / xyz_TempAll - dlog(1.0d2)

    !Ѳ. 
    !  (P_NH3 - X) * (P_H2S - X) = exp(Kp)
    !  DelX^2 - (P_NH3 + P_H2S) * DelX + P_NH3 * P_H2S * exp( Kp ) = 0
    !  Ȥɬפ뤬, P_NH3 > P_H2S  X < P_H2S 
    !  θ, θΤ򤵤.
    xyz_Solution  =                                                   &
      & (                                                            &
      &     sum(xyzf_PartialPress, 4)                                        &
      &   - dsqrt( (xyzf_PartialPress(:,:,:,1) - xyzf_PartialPress(:,:,:,2)) ** 2.0d0 &
      &            + 4.0d0 * dexp( min( 700.0d0, xyz_EquivConst ) ) ) &
      &  ) * 5.0d-1

    !̤
    xyz_DelQMixNH4SH = xyz_Solution * ( MolWtNH3 + MolWtH2S ) &
      &                   / ( xyz_PressDry * MolWtDry )

  end function xyz_DelQMixNH4SH
  

!!!-----------------------------------------------------------------------!!!
  function DelMolFrNH4SH(TempAll, PressAll, MolFrNH3, MolFrH2S, Humidity)
    !
    ! NH4SH ȿȼ H2S  NH3 Υθʬ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP),intent(in) :: TempAll       !
    real(DP),intent(in) :: PressAll      !
    real(DP),intent(in) :: MolFrNH3      !NH3 Υ
    real(DP),intent(in) :: MolFrH2S      !H2S Υ
    real(DP),intent(in) :: Humidity      !˰
    real(DP)            :: DelMolFrNH4SH !NH4SH ȼѲ
    real(DP)            :: EquivConst    !ʿ
    real(DP)            :: PPress(2)     !(ʬ)
    real(DP)            :: Solution      !(β)

    !------------------------------------------------------------
    !NH4SH ʿվ
    !------------------------------------------------------------
    !˥βǤʬ
    PPress(1) = MolFrNH3 * PressAll
    PPress(2) = MolFrH2S * PressAll

    !ʿ
    EquivConst = 61.781d0 - 10834.0d0 / TempAll - dlog(1.0d2) - 2.0d0 * dlog( Humidity )
    
    !ѲβȤƵ. 
    Solution = 5.0d-1 * (sum(PPress) &
      &        - dsqrt( (PPress(1) - PPress(2))**2.0d0 &
      &                    + 4.0d0 * dexp( min( 700.0d0, EquivConst ))) )
    
    !NH4SH . 
    DelMolFrNH4SH = Solution / PressAll

  end function DelMolFrNH4SH

    
end module ChemCalc

