!= ⥸塼
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: constants.f90,v 1.12 2014-01-21 05:00:57 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module constants
  !
  != ⥸塼
  !

  !⥸塼ɤ߹
  !
  use dc_types,      only: DP
  use dc_iounit,     only: FileOpen
  use dc_message,    only: MessageNotify          !å
  use ChemData,      only: GasRUniv,             &!׵
    &                      ChemData_OneSpcID,    &!ؼ ID
    &                      ChemData_CpPerMolRef, &!ɸ֤ǤǮ
    &                      ChemData_MolWt         !ʬ
  use mpi_wrapper,   only: myrank
  use namelist_util, only: namelist_filename

  !ۤηػ
  !
  implicit none

  ! private °
  !
  private

  !Public Interface
  !
  real(DP), save, public :: Grav = 9.8d0          ! [m/s^2]
  real(DP), save, public :: PressBasis = 965.0d0  !̤δవ [Pa]
  real(DP), save, public :: TempSfc = 0.0d0       !ɽ̲ [K]
  real(DP), save, public :: PressSfc = 0.0d0      !ɽ̰ [Pa]
  real(DP), save, public :: TempTop = 0.0d0       !β [K]
  real(DP), save, public :: PressTop = 0.0d0      !Ǥΰ [Pa]
  real(DP), save, public :: CpDry  = 0.0d0        !ʬ갵Ǯ [J/K kg]
  real(DP), save, public :: CpDryMol = 0.0d0      !ʬ갵Ǯ [J/K kg]
  real(DP), save, public :: CvDry = 0.0d0         !ʬǮ [J/K kg]
  real(DP), save, public :: MolWtDry = 0.0d0      !ʬʬ   [kg/mol]
  real(DP), save, public :: GasRDry  = 0.0d0      !ʬε [J/K kg]
  real(DP), save, public :: DayTime = 86400.0d0   ! 1 Ĺ [s]

  ! ֥롼θ
  !
  public constants_init

contains

!!!-----------------------------------------------------------------!!!
  subroutine constants_Init
    !
    != 롼
    !
    ! namelist ˴Ťʪ. ϰʲ̤. 
    !
    ! * namelist 갵Ǯ (CpDry) ʿʬ (MolWtDry) Ϳ줿, 
    !   򸵤˵(GasRDry), Ǯ (CvDry), 갵Ǯ (CpDryMol) . 
    ! * namelist 갵Ǯ (CpDry) ȵ (GasRDry) Ϳ줿, 
    !   򸵤ʿʬ(MolWtDry), Ǯ (CvDry), 갵Ǯ (CpDryMol) . 
    ! * namelist 鴥ʬΥ (SpcDryMolFr) Ϳ줿ˤ, 
    !   Ǯϳإơ֥, 갵Ǯ (CpDry),  (GasRDry), 
    !   ʿʬ(MolWtDry), Ǯ (CvDry), 갵Ǯ (CpDryMol) . 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    integer                  :: SpcDryNum       !ʬβؼο
    character(20)            :: SpcDrySymbol(5) !ʬβؼ̾
    real(DP)                 :: SpcDryMolFr(5)  !ʬβؼ¸
    integer, allocatable     :: SpcDryID(:)     !ʬβؼID
    real(DP), allocatable    :: PropertyDry(:)  !
    integer                  :: s               !ѿ
    integer                  :: unit            !ֹ
    logical                  :: flag = .false.
     
    !NAMELIST 
    NAMELIST /constants_nml/ &
      & Grav, PressBasis, TempSfc, PressSfc, TempTop, PressTop, & 
      & SpcDrySymbol, SpcDryMolFr, DayTime, CpDry, MolWtDry, GasRDry
 
    SpcDrySymbol = '' 
    SpcDryMolFr  = 0.0d0
    
    !ե륪ץ. . 
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=constants_nml)
    close(unit)

    if (CpDry /= 0.0d0 .AND. MolWtDry /= 0.0d0) then 
    ! namelist  CpDry ͤϤ줿

      !갵Ǯ
      CpDryMol = CpDry *  MolWtDry 
      
      !
      GasRDry = GasRUniv / MolWtDry
      
      !Ǯ
      CvDry    = CpDry - GasRDry

    elseif (CpDry /= 0.0d0 .AND. GasRDry /= 0.0d0) then 
    ! namelist  CpDry  GasRDry ͤϤ줿

      !ʬʬ
      MolWtDry = GasRUniv / GasRDry 

      !갵Ǯ
      CpDryMol = CpDry *  MolWtDry 
      
      !Ǯ
      CvDry    = CpDry - GasRDry

    elseif (SpcDryMolFr(1) /= 0.0d0) then 
    ! namelist  椬Ϥ줿

      flag = .true.

      !----------------------------------------------------------
      ! ʬʪͤν
      !
      !ʬθĿ
      SpcDryNum = count(SpcDrySymbol /= "")
      
      !ؼ ID     
      allocate(SpcDryID(SpcDryNum))    
      do s = 1, SpcDryNum
        SpcDryID(s) = ChemData_OneSpcID( SpcDrySymbol(s) )
      end do
      
      !ν
      allocate(PropertyDry(SpcDryNum))
      
      !ʬ
      do s = 1, SpcDryNum
        PropertyDry(s) = ChemData_MolWt(SpcDryID(s))
      end do
      MolWtDry = dot_product(PropertyDry, SpcDryMolFr(1:SpcDryNum)) 
      
      !갵Ǯ()
      do s = 1, SpcDryNum    
        PropertyDry(s) = ChemData_CpPerMolRef(SpcDryID(s))
      end do
      CpDryMol = dot_product(PropertyDry, SpcDryMolFr(1:SpcDryNum)) 
      
      !갵Ǯ
      CpDry    = CpDryMol / MolWtDry
      
      !
      GasRDry = GasRUniv / MolWtDry
      
      !Ǯ
      CvDry    = CpDry - GasRDry

    else
      call MessageNotify( "E", "constants_init", "Enough Variables are not set" )
    end if
    
    !----------------------------------------------------------
    ! ǧ
    !----------------------------------------------------------
    if (myrank == 0) then 
      call MessageNotify( "M", &
        & "constants_init", "Grav = %f",     d=(/Grav/) )
      call MessageNotify( "M", &
        & "constants_init", "PressBasis = %f", d=(/PressBasis/))
      if (TempSfc /= 0) then 
        ! ɽ̲٤Ϳ줿 
        !
        call MessageNotify( "M", &
          & "constants_init", "TempSfc = %f",  d=(/TempSfc/) )
        call MessageNotify( "M", &
          & "constants_init", "PressSfc = %f", d=(/PressSfc/) )
      end if
      if (TempTop /= 0) then 
        ! β٤Ϳ줿 
        !
        call MessageNotify( "M", &
          & "constants_init", "TempTop = %f",  d=(/TempTop/) )
        call MessageNotify( "M", &
          & "constants_init", "PressTop = %f", d=(/PressTop/) )
      end if
      if (flag) then 
        ! 椬Ϳ줿ˤϥץåȤ. 
        !
        do s = 1, SpcDryNum
          call MessageNotify( "M", &
            &  "constants_init", "SpcDryID = %d",      i=(/SpcDryID(s)/))
          call MessageNotify( "M", &
            &  "constants_init", "SpcDrySymbol = %c", c1=trim(SpcDrySymbol(s)))
          call MessageNotify( "M", &
            &  "constants_init", "SpcDryMolFr = %f",   d=(/SpcDryMolFr(s)/))
        end do
      end if
      
      call MessageNotify( "M", "constants_init", "CpDry    = %f",    d=(/CpDry/) )
      call MessageNotify( "M", "constants_init", "CpDryMol = %f", d=(/CpDryMol/) )
      call MessageNotify( "M", "constants_init", "CvDry    = %f",    d=(/CvDry/) )
      call MessageNotify( "M", "constants_init", "GasRDry  = %f",  d=(/GasRDry/) )
      call MessageNotify( "M", "constants_init", "MolWtDry = %f", d=(/MolWtDry/) )
      call MessageNotify( "M", "constants_init", "DayTime  = %f",  d=(/DayTime/)  )
    end if

  end subroutine Constants_Init

end module Constants
