module gms_draw_graph

!	use dcl
	use gms_size
	use gms_position
	use gtool_history
	implicit none

contains

	subroutine gt4init1_x(var1, fname, ndump, vname1, lname1, vunit1, dt)

		type(var_x), intent(in) :: var1
		character(*), intent(in) :: fname, vname1, lname1, vunit1
		real        , intent(in) :: ndump
		real(8)		, intent(in) :: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'x', 't'/), (/size_x(var1),0/), &
			(/"x-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('x', pos_x(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'x','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

	end subroutine gt4init1_x

	
	subroutine gt4init1_y(var1, fname, ndump, vname1, lname1, vunit1, dt)

		type(var_y), intent(in) :: var1
		character(*), intent(in) :: fname, vname1, lname1, vunit1
		real        , intent(in) :: ndump
		real(8)		, intent(in) :: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'y', 't'/), (/size_y(var1),0/), &
			(/"y-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('y', pos_y(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'y','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

	end subroutine gt4init1_y


	subroutine gt4init1_z(var1, fname, ndump, vname1, lname1, vunit1, dt)

		type(var_z), intent(in) :: var1
		character(*), intent(in) :: fname, vname1, lname1, vunit1
		real        , intent(in) :: ndump
		real(8)		, intent(in) :: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'z', 't'/), (/size_z(var1),0/), &
			(/"z-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('z', pos_z(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'z','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

	end subroutine gt4init1_z

	
	subroutine gt4init1_xy(var1, fname, ndump, vname1, lname1, vunit1, dt)

		type(var_xy), intent(in) :: var1
    	character(*), intent(in):: fname, vname1, lname1, vunit1
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','t'/), (/size_x(var1),size_y(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","time        "/), (/"cm ","rad","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

 	end subroutine gt4init1_xy


	subroutine gt4init1_yz(var1, fname, ndump, vname1, lname1, vunit1, dt)

		type(var_yz), intent(in) :: var1
    	character(*), intent(in):: fname, vname1, lname1, vunit1
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'y','z','t'/), (/size_y(var1),size_z(var1),0/), 		 	&
			&(/"y-coordinate","z-coordinate","time        "/), (/"rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('y', pos_y(var1))
    	call HistoryPut('z', pos_z(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

 	end subroutine gt4init1_yz


	subroutine gt4init1_xz(var1, fname, ndump, vname1, lname1, vunit1, dt)

		type(var_xz), intent(in) :: var1
    	character(*), intent(in):: fname, vname1, lname1, vunit1
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','z','t'/), (/size_x(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","z-coordinate","time        "/), (/"cm","cm","s "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))	
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

 	end subroutine gt4init1_xz


	subroutine gt4init1_xyz(var1, fname, ndump, vname1, lname1, vunit1, dt)

		type(var_xyz), intent(in) :: var1
    	character(*), intent(in):: fname, vname1, lname1, vunit1
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','z','t'/), (/size_x(var1),size_y(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","z-coordinate","time        "/), (/"cm ","rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

 	end subroutine gt4init1_xyz


	subroutine gt4init2_x(var1, var2, fname, ndump, vname1, vname2, lname1, lname2, vunit1, vunit2, dt)

		type(var_x), intent(in) :: var1, var2
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2
		character(*), intent(in):: lname1, lname2
		character(*), intent(in):: vunit1, vunit2
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'x', 't'/), (/size_x(var1),0/), &
			(/"x-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('x', pos_x(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'x','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'x','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

	end subroutine gt4init2_x


	subroutine gt4init2_y(var1, var2, fname, ndump, vname1, vname2, lname1, lname2, vunit1, vunit2, dt)

		type(var_y), intent(in) :: var1, var2
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2
		character(*), intent(in):: lname1, lname2
		character(*), intent(in):: vunit1, vunit2
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'y', 't'/), (/size_y(var1),0/), &
			(/"y-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('y', pos_y(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'y','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'y','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

	end subroutine gt4init2_y


	subroutine gt4init2_z(var1, var2, fname, ndump, vname1, vname2, lname1, lname2, vunit1, vunit2, dt)

		type(var_z), intent(in) :: var1, var2
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2
		character(*), intent(in):: lname1, lname2
		character(*), intent(in):: vunit1, vunit2
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'z', 't'/), (/size_z(var1),0/), &
			(/"z-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('z', pos_z(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'z','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'z','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

	end subroutine gt4init2_z


	subroutine gt4init2_xy(var1, var2, fname, ndump, vname1, vname2, lname1, lname2, vunit1, vunit2, dt)

		type(var_xy), intent(in) :: var1, var2
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2
		character(*), intent(in):: lname1, lname2
		character(*), intent(in):: vunit1, vunit2
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt

		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','t'/), (/size_x(var1),size_y(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","time        "/), (/"cm ","rad","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','y','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

 	end subroutine gt4init2_xy


	subroutine gt4init2_yz(var1, var2, fname, ndump, vname1, vname2, lname1, lname2, vunit1, vunit2, dt)

		type(var_yz), intent(in) :: var1, var2
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2
		character(*), intent(in):: lname1, lname2
		character(*), intent(in):: vunit1, vunit2
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'y','z','t'/), (/size_y(var1),size_z(var1),0/), 		 	&
			&(/"y-coordinate","z-coordinate","time        "/), (/"rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('y', pos_y(var1))
    	call HistoryPut('z', pos_z(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'y','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

 	end subroutine gt4init2_yz


	subroutine gt4init2_xz(var1, var2, fname, ndump, vname1, vname2, lname1, lname2, vunit1, vunit2, dt)

		type(var_xz), intent(in) :: var1, var2
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2
		character(*), intent(in):: lname1, lname2
		character(*), intent(in):: vunit1, vunit2
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','z','t'/), (/size_x(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","z-coordinate","time        "/), (/"cm","cm","s "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))	
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

 	end subroutine gt4init2_xz


	subroutine gt4init2_xyz(var1, var2, fname, ndump, vname1, vname2, lname1, lname2, vunit1, vunit2, dt)


		type(var_xyz), intent(in) :: var1, var2
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2
		character(*), intent(in):: lname1, lname2
		character(*), intent(in):: vunit1, vunit2
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','z','t'/), (/size_x(var1),size_y(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","z-coordinate","time        "/), (/"cm ","rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','y','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

 	end subroutine gt4init2_xyz


	subroutine gt4init3_x(var1, var2, var3, fname, ndump, vname1, vname2, vname3, lname1, lname2, lname3, vunit1, &
								& vunit2, vunit3, dt)

		type(var_x), intent(in) :: var1, var2, var3
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3
		character(*), intent(in):: lname1, lname2, lname3
		character(*), intent(in):: vunit1, vunit2, vunit3
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'x', 't'/), (/size_x(var1),0/), &
			(/"x-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('x', pos_x(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'x','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'x','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname3, dims=(/'x','t'/), & 
				longname=lname3, units=vunit3, xtype='double')

	end subroutine gt4init3_x


	subroutine gt4init3_y(var1, var2, var3, fname, ndump, vname1, vname2, vname3, lname1, lname2, lname3, vunit1, &
								& vunit2, vunit3, dt)

		type(var_y), intent(in) :: var1, var2, var3
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3
		character(*), intent(in):: lname1, lname2, lname3
		character(*), intent(in):: vunit1, vunit2, vunit3
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'y', 't'/), (/size_y(var1),0/), &
			(/"y-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('y', pos_y(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'y','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'y','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname3, dims=(/'y','t'/), & 
				longname=lname3, units=vunit3, xtype='double')

	end subroutine gt4init3_y


	subroutine gt4init3_z(var1, var2, var3, fname, ndump, vname1, vname2, vname3, lname1, lname2, lname3, vunit1, &
								& vunit2, vunit3, dt)

		type(var_z), intent(in) :: var1, var2, var3
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3
		character(*), intent(in):: lname1, lname2, lname3
		character(*), intent(in):: vunit1, vunit2, vunit3
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'z', 't'/), (/size_z(var1),0/), &
			(/"z-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('z', pos_z(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'z','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'z','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname3, dims=(/'z','t'/), & 
				longname=lname3, units=vunit3, xtype='double')

	end subroutine gt4init3_z


	subroutine gt4init3_xy(var1, var2, var3, fname, ndump, vname1, vname2, vname3, lname1, lname2, lname3, vunit1, &
								& vunit2, vunit3, dt)

		type(var_xy), intent(in) :: var1, var2, var3
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3
		character(*), intent(in):: lname1, lname2, lname3
		character(*), intent(in):: vunit1, vunit2, vunit3
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt

		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','t'/), (/size_x(var1),size_y(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","time        "/), (/"cm ","rad","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','y','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'x','y','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

 	end subroutine gt4init3_xy


	subroutine gt4init3_yz(var1, var2, var3, fname, ndump, vname1, vname2, vname3, lname1, lname2, lname3, vunit1, &
								& vunit2, vunit3, dt)

		type(var_yz), intent(in) :: var1, var2, var3
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3
		character(*), intent(in):: lname1, lname2, lname3
		character(*), intent(in):: vunit1, vunit2, vunit3
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'y','z','t'/), (/size_y(var1),size_z(var1),0/), 		 	&
			&(/"y-coordinate","z-coordinate","time        "/), (/"rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('y', pos_y(var1))
    	call HistoryPut('z', pos_z(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'y','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'y','z','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

 	end subroutine gt4init3_yz


	subroutine gt4init3_xz(var1, var2, var3, fname, ndump, vname1, vname2, vname3, lname1, lname2, lname3, vunit1, &
								& vunit2, vunit3, dt)

		type(var_xz), intent(in) :: var1, var2, var3
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3
		character(*), intent(in):: lname1, lname2, lname3
		character(*), intent(in):: vunit1, vunit2, vunit3
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','z','t'/), (/size_x(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","z-coordinate","time        "/), (/"cm","cm","s "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))	
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'x','z','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

 	end subroutine gt4init3_xz	


	subroutine gt4init3_xyz(var1, var2, var3, fname, ndump, vname1, vname2, vname3, lname1, lname2, lname3, vunit1, &
								& vunit2, vunit3, dt)

		type(var_xyz), intent(in) :: var1, var2, var3
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3
		character(*), intent(in):: lname1, lname2, lname3
		character(*), intent(in):: vunit1, vunit2, vunit3
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','z','t'/), (/size_x(var1),size_y(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","z-coordinate","time        "/), (/"cm ","rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','y','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

 	end subroutine gt4init3_xyz


	subroutine gt4init4_x(var1, var2, var3, var4, fname, ndump, vname1, vname2, vname3, vname4, lname1, lname2, &
								& lname3, lname4, vunit1, vunit2, vunit3, vunit4, dt)

		type(var_x), intent(in) :: var1, var2, var3, var4
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4
		character(*), intent(in):: lname1, lname2, lname3, lname4
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'x', 't'/), (/size_x(var1),0/), &
			(/"x-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('x', pos_x(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'x','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'x','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname3, dims=(/'x','t'/), & 
				longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname4, dims=(/'x','t'/), & 
				longname=lname4, units=vunit4, xtype='double')

	end subroutine gt4init4_x


	subroutine gt4init4_y(var1, var2, var3, var4, fname, ndump, vname1, vname2, vname3, vname4, lname1, lname2, &
								& lname3, lname4, vunit1, vunit2, vunit3, vunit4, dt)

		type(var_y), intent(in) :: var1, var2, var3, var4
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4
		character(*), intent(in):: lname1, lname2, lname3, lname4
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'y', 't'/), (/size_y(var1),0/), &
			(/"y-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('y', pos_y(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'y','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'y','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname3, dims=(/'y','t'/), & 
				longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname4, dims=(/'y','t'/), & 
				longname=lname4, units=vunit4, xtype='double')

	end subroutine gt4init4_y


	subroutine gt4init4_z(var1, var2, var3, var4, fname, ndump, vname1, vname2, vname3, vname4, lname1, lname2, &
								& lname3, lname4, vunit1, vunit2, vunit3, vunit4, dt)

		type(var_z), intent(in) :: var1, var2, var3, var4
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4
		character(*), intent(in):: lname1, lname2, lname3, lname4
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'z', 't'/), (/size_z(var1),0/), &
			(/"x-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('z', pos_z(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'z','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'z','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname3, dims=(/'z','t'/), & 
				longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname4, dims=(/'z','t'/), & 
				longname=lname4, units=vunit4, xtype='double')

	end subroutine gt4init4_z


	subroutine gt4init4_xy(var1, var2, var3, var4, fname, ndump, vname1, vname2, vname3, vname4, lname1, lname2, &
								& lname3, lname4, vunit1, vunit2, vunit3, vunit4, dt)

		type(var_xy), intent(in) :: var1, var2, var3, var4
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4
		character(*), intent(in):: lname1, lname2, lname3, lname4
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt

		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','t'/), (/size_x(var1),size_y(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","time        "/), (/"cm ","rad","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','y','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'x','y','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname4, dims=(/'x','y','t'/), & 
     	      longname=lname4, units=vunit4, xtype='double')

 	end subroutine gt4init4_xy


	subroutine gt4init4_yz(var1, var2, var3, var4, fname, ndump, vname1, vname2, vname3, vname4, lname1, lname2, &
								& lname3, lname4, vunit1, vunit2, vunit3, vunit4, dt)

		type(var_yz), intent(in) :: var1, var2, var3, var4
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4
		character(*), intent(in):: lname1, lname2, lname3, lname4
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'y','z','t'/), (/size_y(var1),size_z(var1),0/), 		 	&
			&(/"y-coordinate","z-coordinate","time        "/), (/"rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('y', pos_y(var1))
    	call HistoryPut('z', pos_z(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'y','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'y','z','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname4, dims=(/'y','z','t'/), & 
     	      longname=lname4, units=vunit4, xtype='double')

 	end subroutine gt4init4_yz


	subroutine gt4init4_xz(var1, var2, var3, var4, fname, ndump, vname1, vname2, vname3, vname4, lname1, lname2, &
								& lname3, lname4, vunit1, vunit2, vunit3, vunit4, dt)

		type(var_xz), intent(in) :: var1, var2, var3, var4
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4
		character(*), intent(in):: lname1, lname2, lname3, lname4
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','z','t'/), (/size_x(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","z-coordinate","time        "/), (/"cm","cm","s "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))	
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'x','z','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname4, dims=(/'x','z','t'/), & 
     	      longname=lname4, units=vunit4, xtype='double')

 	end subroutine gt4init4_xz


	subroutine gt4init4_xyz(var1, var2, var3, var4, fname, ndump, vname1, vname2, vname3, vname4, lname1, lname2, &
								& lname3, lname4, vunit1, vunit2, vunit3, vunit4, dt)

		type(var_xyz), intent(in) :: var1, var2, var3, var4
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4
		character(*), intent(in):: lname1, lname2, lname3, lname4
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','z','t'/), (/size_x(var1),size_y(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","z-coordinate","time        "/), (/"cm ","rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','y','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'x','y','z','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname4, dims=(/'x','y','z','t'/), & 
     	      longname=lname4, units=vunit4, xtype='double')

 	end subroutine gt4init4_xyz


	subroutine gt4init5_x(var1, var2, var3, var4, var5, fname, ndump, vname1, vname2, vname3, vname4, vname5, lname1, &
								& lname2, lname3, lname4, lname5, vunit1, vunit2, vunit3, vunit4, vunit5, dt)

		type(var_x), intent(in) :: var1, var2, var3, var4, var5
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4, vname5
		character(*), intent(in):: lname1, lname2, lname3, lname4, lname5
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4, vunit5
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'x', 't'/), (/size_x(var1),0/), &
			(/"x-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('x', pos_x(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'x','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'x','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname3, dims=(/'x','t'/), & 
				longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname4, dims=(/'x','t'/), & 
				longname=lname4, units=vunit4, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname5, dims=(/'x','t'/), & 
				longname=lname5, units=vunit5, xtype='double')

	end subroutine gt4init5_x


	subroutine gt4init5_y(var1, var2, var3, var4, var5, fname, ndump, vname1, vname2, vname3, vname4, vname5, lname1, &
								& lname2, lname3, lname4, lname5, vunit1, vunit2, vunit3, vunit4, vunit5, dt)

		type(var_y), intent(in) :: var1, var2, var3, var4, var5
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4, vname5
		character(*), intent(in):: lname1, lname2, lname3, lname4, lname5
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4, vunit5
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'y', 't'/), (/size_y(var1),0/), &
			(/"y-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('y', pos_y(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'y','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'y','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname3, dims=(/'y','t'/), & 
				longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname4, dims=(/'y','t'/), & 
				longname=lname4, units=vunit4, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname5, dims=(/'y','t'/), & 
				longname=lname5, units=vunit5, xtype='double')

	end subroutine gt4init5_y


	subroutine gt4init5_z(var1, var2, var3, var4, var5, fname, ndump, vname1, vname2, vname3, vname4, vname5, lname1, &
								& lname2, lname3, lname4, lname5, vunit1, vunit2, vunit3, vunit4, vunit5, dt)

		type(var_z), intent(in) :: var1, var2, var3, var4, var5
		character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4, vname5
		character(*), intent(in):: lname1, lname2, lname3, lname4, lname5
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4, vunit5
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt
    
		call HistoryCreate(fname, "gms_test", "gms_shallow1d", "hoge", &
			& (/'z', 't'/), (/size_z(var1),0/), &
			(/"z-coordinate","time        "/), (/"cm","s "/), 0.0, interval=real(ndump*dt))

		call HistoryPut('z', pos_z(var1))

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname1, dims=(/'z','t'/), & 
				longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname2, dims=(/'z','t'/), & 
				longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname3, dims=(/'z','t'/), & 
				longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname4, dims=(/'z','t'/), & 
				longname=lname4, units=vunit4, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
				varname=vname5, dims=(/'z','t'/), & 
				longname=lname5, units=vunit5, xtype='double')

	end subroutine gt4init5_z


	subroutine gt4init5_xy(var1, var2, var3, var4, var5, fname, ndump, vname1, vname2, vname3, vname4, vname5, lname1, &
								& lname2, lname3, lname4, lname5, vunit1, vunit2, vunit3, vunit4, vunit5, dt)

		type(var_xy), intent(in) :: var1, var2, var3, var4, var5
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4, vname5
		character(*), intent(in):: lname1, lname2, lname3, lname4, lname5
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4, vunit5
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt

		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','t'/), (/size_x(var1),size_y(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","time        "/), (/"cm ","rad","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','y','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'x','y','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname4, dims=(/'x','y','t'/), & 
     	      longname=lname4, units=vunit4, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname5, dims=(/'x','y','t'/), & 
     	      longname=lname5, units=vunit5, xtype='double')

 	end subroutine gt4init5_xy


	subroutine gt4init5_yz(var1, var2, var3, var4, var5, fname, ndump, vname1, vname2, vname3, vname4, vname5, lname1, &
								& lname2, lname3, lname4, lname5, vunit1, vunit2, vunit3, vunit4, vunit5, dt)

		type(var_yz), intent(in) :: var1, var2, var3, var4, var5
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4, vname5
		character(*), intent(in):: lname1, lname2, lname3, lname4, lname5
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4, vunit5
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'y','z','t'/), (/size_y(var1),size_z(var1),0/), 		 	&
			&(/"y-coordinate","z-coordinate","time        "/), (/"rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('y', pos_y(var1))
    	call HistoryPut('z', pos_z(var1))		

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'y','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'y','z','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname4, dims=(/'y','z','t'/), & 
     	      longname=lname4, units=vunit4, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname5, dims=(/'y','z','t'/), & 
     	      longname=lname5, units=vunit5, xtype='double')

 	end subroutine gt4init5_yz
	

	subroutine gt4init5_xz(var1, var2, var3, var4, var5, fname, ndump, vname1, vname2, vname3, vname4, vname5, lname1, &
								& lname2, lname3, lname4, lname5, vunit1, vunit2, vunit3, vunit4, vunit5, dt)

		type(var_xz), intent(in) :: var1, var2, var3, var4, var5
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4, vname5
		character(*), intent(in):: lname1, lname2, lname3, lname4, lname5
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4, vunit5
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','z','t'/), (/size_x(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","z-coordinate","time        "/), (/"cm","cm","s "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))	
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'x','z','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname4, dims=(/'x','z','t'/), & 
     	      longname=lname4, units=vunit4, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname5, dims=(/'x','z','t'/), & 
     	      longname=lname5, units=vunit5, xtype='double')

 	end subroutine gt4init5_xz


	subroutine gt4init5_xyz(var1, var2, var3, var4, var5, fname, ndump, vname1, vname2, vname3, vname4, vname5, lname1, &
								& lname2, lname3, lname4, lname5, vunit1, vunit2, vunit3, vunit4, vunit5, dt)


		type(var_xyz), intent(in) :: var1, var2, var3, var4, var5
    	character(*), intent(in):: fname
		character(*), intent(in):: vname1, vname2, vname3, vname4, vname5
		character(*), intent(in):: lname1, lname2, lname3, lname4, lname5
		character(*), intent(in):: vunit1, vunit2, vunit3, vunit4, vunit5
    	real        , intent(in):: ndump
		real(8)		, intent(in):: dt


		call HistoryCreate(fname, "gms_test", "suiheinetsutairyu", "hoge",   		&
			& (/'x','y','z','t'/), (/size_x(var1),size_y(var1),size_z(var1),0/), 		 	&
			&(/"x-coordinate","y-coordinate","z-coordinate","time        "/), (/"cm ","rad","cm ","s  "/), 	&
			& 0.0, interval=real(ndump*dt))


    	call HistoryPut('x', pos_x(var1))
    	call HistoryPut('y', pos_y(var1))		
    	call HistoryPut('z', pos_z(var1))

    	call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname1, dims=(/'x','y','z','t'/), & 
     	      longname=lname1, units=vunit1, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname2, dims=(/'x','y','z','t'/), & 
     	      longname=lname2, units=vunit2, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname3, dims=(/'x','y','z','t'/), & 
     	      longname=lname3, units=vunit3, xtype='double')

		call HistoryAddVariable( &                                ! 変数定義
     	      varname=vname4, dims=(/'x','y','z','t'/), & 
     	      longname=lname4, units=vunit4, xtype='double')

		call HistoryAddVariable( & 
                               ! 変数定義
     	      varname=vname5, dims=(/'x','y','z','t'/), & 
     	      longname=lname5, units=vunit5, xtype='double')

 	end subroutine gt4init5_xyz


!!!!!!

	subroutine gt4_varout1_x(vname1, var1)
  		character(*), intent(in) :: vname1
   	type(var_x), intent(in)  ::var1

			call HistoryPut(vname1, get(var1) )
		
	end subroutine gt4_varout1_x


	subroutine gt4_varout1_y(vname1, var1)
  		character(*), intent(in) :: vname1
   	type(var_y), intent(in)  ::var1

			call HistoryPut(vname1, get(var1) )
		
	end subroutine gt4_varout1_y


	subroutine gt4_varout1_z(vname1, var1)
  		character(*), intent(in) :: vname1
   	type(var_z), intent(in)  ::var1

			call HistoryPut(vname1, get(var1) )
		
	end subroutine gt4_varout1_z


	subroutine gt4_varout1_xy(vname1, var1)
  		character(*), intent(in) :: vname1
   	type(var_xy), intent(in)  ::var1

			call HistoryPut(vname1, get(var1) )
		
	end subroutine gt4_varout1_xy


	subroutine gt4_varout1_yz(vname1, var1)
  		character(*), intent(in) :: vname1
   	type(var_yz), intent(in)  ::var1

			call HistoryPut(vname1, get(var1) )
		
	end subroutine gt4_varout1_yz


	subroutine gt4_varout1_xz(vname1, var1)
  		character(*), intent(in) :: vname1
   	type(var_xz), intent(in)  ::var1

			call HistoryPut(vname1, get(var1) )
		
	end subroutine gt4_varout1_xz


	subroutine gt4_varout1_xyz(vname1, var1)
  		character(*), intent(in) :: vname1
   	type(var_xyz), intent(in)  ::var1

			call HistoryPut(vname1, get(var1) )
		
	end subroutine gt4_varout1_xyz


	subroutine gt4_varout2_x(vname1, var1, vname2, var2)
  		character(*), intent(in) :: vname1, vname2
   	type(var_x), intent(in) :: var1, var2

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
		
	end subroutine gt4_varout2_x


	subroutine gt4_varout2_y(vname1, var1, vname2, var2)
  		character(*), intent(in) :: vname1, vname2
   	type(var_y), intent(in) :: var1, var2

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
		
	end subroutine gt4_varout2_y


	subroutine gt4_varout2_z(vname1, var1, vname2, var2)
  		character(*), intent(in) :: vname1, vname2
   	type(var_z), intent(in) :: var1, var2

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
		
	end subroutine gt4_varout2_z


	subroutine gt4_varout2_xy(vname1, var1, vname2, var2)
  		character(*), intent(in) :: vname1, vname2
   	type(var_xy), intent(in) :: var1, var2

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
		
	end subroutine gt4_varout2_xy


	subroutine gt4_varout2_yz(vname1, var1, vname2, var2)
  		character(*), intent(in) :: vname1, vname2
   	type(var_yz), intent(in) :: var1, var2

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
		
	end subroutine gt4_varout2_yz


	subroutine gt4_varout2_xz(vname1, var1, vname2, var2)
  		character(*), intent(in) :: vname1, vname2
   	type(var_xz), intent(in) :: var1, var2

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
		
	end subroutine gt4_varout2_xz


	subroutine gt4_varout2_xyz(vname1, var1, vname2, var2)
  		character(*), intent(in) :: vname1, vname2
   	type(var_xyz), intent(in)  ::var1, var2

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
		
	end subroutine gt4_varout2_xyz


	subroutine gt4_varout3_x(vname1, var1, vname2, var2, vname3, var3)
  		character(*), intent(in) :: vname1, vname2, vname3
   	type(var_x), intent(in) :: var1, var2, var3

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
		
	end subroutine gt4_varout3_x


	subroutine gt4_varout3_y(vname1, var1, vname2, var2, vname3, var3)
  		character(*), intent(in) :: vname1, vname2, vname3
   	type(var_y), intent(in) :: var1, var2, var3

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
		
	end subroutine gt4_varout3_y


	subroutine gt4_varout3_z(vname1, var1, vname2, var2, vname3, var3)
  		character(*), intent(in) :: vname1, vname2, vname3
   	type(var_z), intent(in) :: var1, var2, var3

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
		
	end subroutine gt4_varout3_z


	subroutine gt4_varout3_xy(vname1, var1, vname2, var2, vname3, var3)
  		character(*), intent(in) :: vname1, vname2, vname3
   	type(var_xy), intent(in) :: var1, var2, var3

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
		
	end subroutine gt4_varout3_xy


	subroutine gt4_varout3_yz(vname1, var1, vname2, var2, vname3, var3)
  		character(*), intent(in) :: vname1, vname2, vname3
   	type(var_yz), intent(in) :: var1, var2, var3

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
		
	end subroutine gt4_varout3_yz


	subroutine gt4_varout3_xz(vname1, var1, vname2, var2, vname3, var3)
  		character(*), intent(in) :: vname1, vname2, vname3
   	type(var_xz), intent(in) :: var1, var2, var3

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
		
	end subroutine gt4_varout3_xz


	subroutine gt4_varout3_xyz(vname1, var1, vname2, var2, vname3, var3)
  		character(*), intent(in) :: vname1, vname2, vname3
   	type(var_xyz), intent(in)  ::var1, var2, var3

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
		
	end subroutine gt4_varout3_xyz


	subroutine gt4_varout4_x(vname1, var1, vname2, var2, vname3, var3, vname4, var4)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4
   	type(var_x), intent(in)  ::var1, var2, var3, var4

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
		
	end subroutine gt4_varout4_x


	subroutine gt4_varout4_y(vname1, var1, vname2, var2, vname3, var3, vname4, var4)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4
   	type(var_y), intent(in)  ::var1, var2, var3, var4

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
		
	end subroutine gt4_varout4_y


	subroutine gt4_varout4_z(vname1, var1, vname2, var2, vname3, var3, vname4, var4)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4
   	type(var_z), intent(in)  ::var1, var2, var3, var4

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
		
	end subroutine gt4_varout4_z


	subroutine gt4_varout4_xy(vname1, var1, vname2, var2, vname3, var3, vname4, var4)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4
   	type(var_xy), intent(in)  ::var1, var2, var3, var4

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
		
	end subroutine gt4_varout4_xy


	subroutine gt4_varout4_yz(vname1, var1, vname2, var2, vname3, var3, vname4, var4)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4
   	type(var_yz), intent(in)  ::var1, var2, var3, var4

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
		
	end subroutine gt4_varout4_yz


	subroutine gt4_varout4_xz(vname1, var1, vname2, var2, vname3, var3, vname4, var4)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4
   	type(var_xz), intent(in)  ::var1, var2, var3, var4

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
		
	end subroutine gt4_varout4_xz


	subroutine gt4_varout4_xyz(vname1, var1, vname2, var2, vname3, var3, vname4, var4)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4
   	type(var_xyz), intent(in)  ::var1, var2, var3, var4

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
		
	end subroutine gt4_varout4_xyz


	subroutine gt4_varout5_x(vname1, var1, vname2, var2, vname3, var3, vname4, var4, vname5, var5)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4, vname5
   	type(var_x), intent(in) :: var1, var2, var3, var4, var5

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
			call HistoryPut(vname5, get(var5) )
		
	end subroutine gt4_varout5_x


	subroutine gt4_varout5_y(vname1, var1, vname2, var2, vname3, var3, vname4, var4, vname5, var5)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4, vname5
   	type(var_y), intent(in) :: var1, var2, var3, var4, var5

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
			call HistoryPut(vname5, get(var5) )
		
	end subroutine gt4_varout5_y


	subroutine gt4_varout5_z(vname1, var1, vname2, var2, vname3, var3, vname4, var4, vname5, var5)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4, vname5
   	type(var_z), intent(in) :: var1, var2, var3, var4, var5

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
			call HistoryPut(vname5, get(var5) )
		
	end subroutine gt4_varout5_z


	subroutine gt4_varout5_xy(vname1, var1, vname2, var2, vname3, var3, vname4, var4, vname5, var5)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4, vname5
   	type(var_xy), intent(in) :: var1, var2, var3, var4, var5

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
			call HistoryPut(vname5, get(var5) )
		
	end subroutine gt4_varout5_xy


	subroutine gt4_varout5_yz(vname1, var1, vname2, var2, vname3, var3, vname4, var4, vname5, var5)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4, vname5
   	type(var_yz), intent(in) :: var1, var2, var3, var4, var5

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
			call HistoryPut(vname5, get(var5) )
		
	end subroutine gt4_varout5_yz


	subroutine gt4_varout5_xz(vname1, var1, vname2, var2, vname3, var3, vname4, var4, vname5, var5)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4, vname5
   	type(var_xz), intent(in) :: var1, var2, var3, var4, var5

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
			call HistoryPut(vname5, get(var5) )
		
	end subroutine gt4_varout5_xz


	subroutine gt4_varout5_xyz(vname1, var1, vname2, var2, vname3, var3, vname4, var4, vname5, var5)
  		character(*), intent(in) :: vname1, vname2, vname3, vname4, vname5
   	type(var_xyz), intent(in)  ::var1, var2, var3, var4, var5

			call HistoryPut(vname1, get(var1) )
			call HistoryPut(vname2, get(var2) )
			call HistoryPut(vname3, get(var3) )
			call HistoryPut(vname4, get(var4) )
			call HistoryPut(vname5, get(var5) )
		
	end subroutine gt4_varout5_xyz

	subroutine gt4_timeout(vname, time)
		character(*), intent(in) :: vname
		real, intent(in)  ::time
	
		call HistoryPut(vname, time )

	end subroutine gt4_timeout

  subroutine gt4end
    call HistoryClose
  end subroutine gt4end


end module gms_draw_graph
