! testarray.f90 - ŔzoĂ݂eXg
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4:

program testarray
    use gtool_data
    use gtool_attribute
    implicit none
    integer, parameter:: LATSIZE = 24, LONSIZE = 36
    integer, parameter:: LATDIV = 4, LONDIV = 3
    real, parameter:: PI = 3.141592653589793238462
    ! ܓxƌox̒lƂoϐ  
    real:: lat(LATSIZE), lon(LONSIZE)
    type(GT_VARIABLE):: latvar, lonvar
    ! ܓxox2̊iql u Ƃoϐ  
    real:: u(LONSIZE, LATSIZE)
    type(GT_VARIABLE):: uvar
    ! [vϐp
    integer:: i, j
    ! 
    type(GT_ATTRIBUTE):: a
    ! G[E
    logical:: fail
continue

    call check1

    ! W̒l̗p
    lon(:) = (/((real(i) * PI / LONSIZE), i = 1, LONSIZE)/)
    lat(:) = (/((real(j) * PI / LATSIZE), j = 1, LATSIZE)/)

    ! ϐ쐬
    call Create(lonvar, 'gtool.nc#lon', length=size(lon))
    call Put(lonvar, lon)
    call Close(lonvar)

    call Create(latvar, 'gtool.nc#lat', length=size(lat))
    call Put(latvar, lat)
    call Close(latvar)

    call Create(uvar, 'gtool.nc#u', dims=(/lonvar, latvar/))
    ! u ɒlpӂďo
    do, i = 1, LONSIZE
	do, j = 1, LATSIZE
	    u(i, j) = sin(lon(i) * LONDIV) * sin(lat(j) * LATDIV)
	enddo
    enddo
    call Put(uvar, u)

    call PutAttribute(uvar, 'title', 'test data')
    call PutAttribute(uvar, 'source', 'program testarray')
    call PutAttribute(uvar, 'institute', 'GFD-Dennou Club')

    ! n
    call Close(uvar)

contains

    subroutine check1
	logical:: exist
	inquire(file='gtool.nc', exist=exist)
	if (exist) stop 'gtool.nc already exists.'
    end subroutine
    
end program
