! dcunitsscan.f90 - lexical scanner

subroutine DCUnitsSetLine(line)
    use dcunits_com, only: scan_line, scan_idx
    implicit none
    character(*), intent(in):: line
    scan_line = line
    scan_idx = 1
end subroutine

subroutine DCUnitsGetToken(tokentype, ivalue, dvalue, cvalue)
    use dcunits_com, only: scan_line, scan_idx, &
        S_EOF, S_SHIFT, S_TEXT
    use regex, only: match
    implicit none
    integer, intent(out):: tokentype
    integer, intent(out):: ivalue(6)
    double precision, intent(out):: dvalue
    character(*), intent(out):: cvalue
    integer:: i, iend, istr, ilen
    ivalue = 0
    dvalue = 0.0d0
    cvalue = ""
    i = 1
    iend = len_trim(scan_line)
    do
        if (i > iend) exit
        call match("^##", scan_line(i:), istr, ilen)
        if (istr > 0) then
            scan_idx = iend + 1
            tokentype = S_EOF
            return
        endif
        call match("^#s*@", scan_line(i:), istr, ilen)
        if (istr > 0) then
            scan_idx = i + istr - 1 + ilen
            tokentype = S_SHIFT
            return
        endif
        call match("^#a#w*", scan_line(i:), istr, ilen)
        if (istr > 0) then
            scan_idx = i + istr - 1 + ilen
            tokentype = S_TEXT
            cvalue = scan_line(i+istr-1: i+istr-1+ilen)
            return
        endif
        i = i + 1
    enddo
    scan_idx = iend + 1
    tokentype = S_EOF
end subroutine

