! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

! Create(var, url, copyfrom, [copyvalue], [overwrite], [err])
! ͕ϐ copyfrom ƓAϐ쐬B
! KvȂΎϐB
! copyvalue ^Ɏw肷ƒlB
!
! ȂAϐ̕ copyfrom  url قȂt@C
! ڂĂꍇɍsȂB netCDF/an z肵̂
! ق̃t@C`ǉꂽƂɂ͕ύXv邩ȂB

subroutine GTVarCreateCopy(var, url, copyfrom, copyvalue, &
    & overwrite, err)
    use gtdata_types, only: GT_VARIABLE
    use dc_string, only: VSTRING, vchar, len, STRING_MAX, assignment(=), &
        & operator(==), operator(//)
    use gtdata_generic, only: Open, Inquire, Close, Create
    use dc_url, only: UrlSplit, GT_ATMARK
    use dc_error
    implicit none
    intrinsic trim
    type(GT_VARIABLE), intent(out):: var
    type(VSTRING), intent(in):: url
    type(GT_VARIABLE), intent(inout):: copyfrom
    logical, intent(in), optional:: copyvalue
    logical, intent(in), optional:: overwrite
    logical, intent(out), optional:: err
    type(GT_VARIABLE), allocatable:: vDimSource(:)
    type(GT_VARIABLE), allocatable:: vDimDest(:)
    integer:: i, nd, stat
    logical:: myerr
    type(VSTRING):: vpart, upart
    character(STRING_MAX):: desturl
    stat = 0
    myerr = .FALSE.
    call Inquire(copyfrom, alldims=nd)
    allocate(vDimSource(nd), vDimDest(nd), stat=stat)
    if (stat /= 0) goto 999
    do, i = 1, nd
        call Open(vDimSource(i), copyfrom, dimord=i, &
            & count_compact=.TRUE., err=myerr)
        call GTVarCopyDim(to=vDimDest(i), from=vDimSource(i), &
            & target=url)
    end do
    desturl = url
    call UrlSplit(url, var=vpart)
    if (vpart == "") then
        call Inquire(copyfrom, url=upart)
        call UrlSplit(upart, var=vpart)
        desturl = trim(desturl) // GT_ATMARK // vpart
    end if
    call Create(var, trim(desturl), dims=vDimDest, err=myerr)
    if (myerr) goto 990
    if (present(copyvalue)) then
        call GTVarCopyValue(to=var, from=copyfrom)
    endif
    do, i = 1, nd
        call Close(vDimSource(i))
        call Close(vDimDest(i))
    end do
990 continue
    deallocate(vDimSource, vDimDest, stat=stat)
999 continue
    if (stat /= 0) then
        call StoreError(GT_ENOMEM, "GTVarCreateCopy", err)
    else if (present(err)) then
        err = myerr
    else if (myerr) then
        call DumpError
    end if
contains

    ! from Ɠe̕ϐ URL target Ŏϐ̍쐬
    ! ƂĎg悤 to ɕʁB
    ! ȂׂăI[vōς܂ƂB
    subroutine GTVarCopyDim(to, from, target)
        use gtdata_types
        use dc_string
        use dc_url, only: UrlSplit, operator(.onthesamefile.)
        use gtdata_generic, only: Open, Inquire, Create
        type(GT_VARIABLE), intent(out):: to
        type(GT_VARIABLE), intent(inout):: from
        type(VSTRING), intent(in):: target
        type(VSTRING):: xtype, url, file
        integer:: length
        call Inquire(var=from, url=url)
        if (url .onthesamefile. target) then
            call Open(to, from, dimord=0)
            return
        endif
        call UrlSplit(target, file=file)
        if (LookupEquivalent(to, from, file)) then
            return
        else
            call Inquire(var=from, xtype=xtype, allcount=length)
            if (length < 0) length = 0
            ! t@C^VK쐬͕ϐ
            call Create(to, vchar(file, len(file)), &
                & length, vchar(xtype, len(xtype)))
            call GTVarCopyValue(to, from)
            return
        endif
    end subroutine

    logical function LookupEquivalent(to, from, file) result(result)
        use dc_string
        use gtdata_generic, only: Inquire, GTVarSearch
        type(GT_VARIABLE), intent(out):: to
        type(GT_VARIABLE), intent(in):: from
        type(VSTRING), intent(in):: file
        type(VSTRING):: url
        logical:: end
        integer:: len1, len2
        result = .FALSE.
        call Inquire(from, allcount=len1)
        call GTVarSearch(file)
        do
            call GTVarSearch(url, end)
            if (end) exit
            call Open(to, url, writable=.TRUE., err=end)
            if (end) exit
            call Inquire(to, allcount=len2)
            if (len1 /= len2) then
                call Close(to)
                cycle
            endif
            result = .TRUE.
            return
        enddo
    end function

    ! łɑ݂ϐɂāAlƑRs[B
    !
    subroutine GTVarCopyValue(to, from)
        use gtdata_types, only: GT_VARIABLE
        use gtdata_generic, only: GTVarGetReal, GTVarPutReal, &
            Attr_Rewind, Attr_Next, Copy_Attr, Inquire, Slice, Slice_Next
        use dc_error, only: DumpError
        use dc_string
        type(GT_VARIABLE), intent(inout):: to
        type(GT_VARIABLE), intent(inout):: from
        type(VSTRING):: aname
        real, allocatable:: rbuffer(:)
        logical:: err, end
        integer:: siz, stat
        ! ̃Rs[
        call Attr_Rewind(from)
        do
            call Attr_Next(from, aname, end)
            if (end) exit
            call Copy_Attr(to=to, attrname=vchar(aname, len(aname)), &
                & from=from, err=err)
            if (err) call DumpError()
        enddo
        ! l̃Rs[
        call Slice(from)
        call Slice(to, compatible=from)
        call Inquire(from, size=siz)
        allocate (rbuffer(siz))
        do
            call GTVarGetReal(from, rbuffer, siz, err)
            if (err) call DumpError()
            call GtVarPutReal(to, rbuffer, siz, err)
            if (err) call DumpError()
            call Slice_Next(from, stat=stat)
            if (stat /= 0) exit
            call Slice_Next(to, stat=stat)
        enddo
        deallocate (rbuffer)
    end subroutine

end subroutine
