! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GTVarPutAttrChar(var, name, value, xtype, err)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: put_attr
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    character(len = *), intent(in):: value
    character(len = *), intent(in), optional:: xtype
    logical, intent(out), optional:: err
    if (associated(var%an)) then
        call put_attr(var%an, name, value, xtype, err)
    endif
end subroutine

    ! VSTRING ^L put_attr ĂяoBʑŵƂ͊֒mȂ
subroutine GTVarPutAttrString(var, name, value, err)
    use gtdata_types, only: GT_VARIABLE
    use dc_string, only: VSTRING, vchar, operator(==), len
    use gtdata_generic, only: put_attr
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    type(VSTRING), intent(in):: value
    logical, intent(out), optional:: err
    call put_attr(var, name, vchar(value, len(value)), err=err)
end subroutine

subroutine GTVarPutAttrReal(var, name, value, err)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: put_attr
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    real, intent(in):: value(:)
    logical, intent(out), optional:: err
    if (associated(var%an)) then
        call put_attr(var%an, name, value, err)
    endif
end subroutine

subroutine GTVarPutAttrDouble(var, name, value, err)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: put_attr
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    double precision, intent(in):: value(:)
    logical, intent(out), optional:: err
    if (associated(var%an)) then
        call put_attr(var%an, name, value, err)
    endif
end subroutine

subroutine GTVarPutAttrInt(var, name, value, err)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: put_attr
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    integer, intent(in):: value(:)
    logical, intent(out), optional:: err
    if (associated(var%an)) then
        call put_attr(var%an, name, value, err)
    endif
end subroutine

subroutine GTVarPutAttrLogical(var, name, value, err)
    use gtdata_types, only: GT_VARIABLE
    use an_generic, only: put_attr
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    logical, intent(in):: value
    logical, intent(out), optional:: err
    if (associated(var%an)) then
        if (value) then
            call put_attr(var%an, name, "true", err=err)
        else
            call put_attr(var%an, name, "false", err=err)
        endif
    endif
end subroutine
