! GTAxisSave - WϐƂĕۑ
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GTAxisSave(axis, name, name_result)
    use gtgraph_generic, only: Save, GTGraphSaveName
    use gtgraph_types, only: GT_Axis
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Create, Close, Put_Attr, add_member, Inquire
    use dc_string
    implicit none
    type(GT_AXIS), intent(inout):: axis
    type(VSTRING), intent(in), optional:: name
    type(VSTRING), intent(out), optional:: name_result
    type(VSTRING):: vname, title, url
    type(GT_VARIABLE):: var
continue
    if (present(name)) then
        vname = name
    else
        vname = GTGraphSaveName()
    endif
    if (axis%vertical) then
        title = "vertical axis of " // axis%title
    else
        title = "horizontal axis of " // axis%title
    endif
    call Create(var, vchar(vname, len(vname)), &
        & xtype="int", overwrite=.TRUE., &
        & long_name=vchar(title, len(title)))
    call Put_Attr(var, "gt_structure_class", "axis")
    call Put_Attr(var, "gt_axis_vertical", axis%vertical)

    ! }̃oɂȂĂ̂̏o
    call Inquire(axis%var, url=url)
    call add_member(var, url, link_name="data")
    
    call Close(var)
    print *, vchar(title, len(title)), " stored at ", vchar(vname, len(vname))
    axis%saved = vname
    if (present(name_result)) name_result = vname
end subroutine
