! gtgraph_generic.f90 - 
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module gtgraph_generic

    implicit none
    interface Inquire
        subroutine GtObjInquire(obj, type)
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(in):: obj
            character(len = *), intent(out), optional:: type
        end subroutine
    end interface

    interface Open

        ! --- ftHgRXgN^ ---

        subroutine GTObjOpen(obj)
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(out):: obj
        end subroutine

        subroutine GTDevOpen(dev, ws_id, err)
            use gtgraph_types, only: GT_DEVICE
            type(GT_DEVICE), intent(out):: dev
            integer, intent(in), optional:: ws_id
            logical, intent(out), optional:: err
        end subroutine

        subroutine GTFrameOpen(frame)
            use gtgraph_types, only: GT_FRAME
            type(GT_FRAME), intent(out):: frame
        end subroutine

        subroutine GTFigOpen(fig)
            use gtgraph_types, only: GT_FIGURE
            type(GT_FIGURE), intent(out):: fig
        end subroutine

        ! --- GTOOL_VARIABLE Ɏ Open ---

        subroutine GTContOpen(cont, var)
            use gtgraph_types, only: GT_CONTOURS
            use gtdata_types, only: GT_VARIABLE
            type(GT_CONTOURS), intent(out):: cont
            type(GT_VARIABLE), intent(in):: var
        end subroutine

        subroutine GTLineOpen(Line, var)
            use gtgraph_types, only: GT_Line
            use gtdata_types, only: GT_VARIABLE
            type(GT_Line), intent(out):: Line
            type(GT_VARIABLE), intent(in):: var
        end subroutine

        subroutine GTAxisOpen(axis, var, dimno, vertical)
            use gtgraph_types, only: GT_AXIS
            use gtdata_types, only: GT_VARIABLE
            type(GT_AXIS), intent(out):: axis
            type(GT_VARIABLE), intent(in):: var
            integer, intent(in):: dimno
            logical, intent(in), optional:: vertical
        end subroutine

    end interface

    interface Close

        subroutine GTDevClose(dev)
            use gtgraph_types, only: GT_DEVICE
            type(GT_DEVICE), intent(inout):: dev
        end subroutine

        recursive subroutine GTObjClose(obj)
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(inout):: obj
        end subroutine

        subroutine GTFrameClose(frame)
            use gtgraph_types, only: GT_FRAME
            type(GT_FRAME), intent(inout):: frame
        end subroutine

        subroutine GTFigClose(fig)
            use gtgraph_types, only: GT_FIGURE
            type(GT_FIGURE), intent(inout):: fig
        end subroutine

        subroutine GTContClose(cont)
            use gtgraph_types, only: GT_CONTOURS
            type(GT_CONTOURS), intent(inout):: cont
        end subroutine

        subroutine GTLineClose(Line)
            use gtgraph_types, only: GT_LINE
            type(GT_LINE), intent(inout):: Line
        end subroutine

        subroutine GTAxisClose(axis)
            use gtgraph_types, only: GT_AXIS
            type(GT_AXIS), intent(inout):: axis
        end subroutine

    end interface

        ! IɎgp
    interface Clear
        subroutine GTObjClear(obj)
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(inout):: obj
        end subroutine
    end interface

    interface Option

        subroutine GtObjOption(obj, option, value, err)
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(in):: obj
            character(len = *), intent(in):: option
            character(len = *), intent(in):: value
            logical, intent(out):: err
        end subroutine

        subroutine GtFigOption(fig, optname, value, err)
            use gtgraph_types, only: GT_FIGURE
            type(GT_FIGURE), intent(inout):: fig
            character(len = *), intent(in):: optname
            character(len = *), intent(in):: value
            logical, intent(out):: err
        end subroutine

        subroutine GtContOption(cont, optname, value, err)
            use gtgraph_types, only: GT_CONTOURS
            type(GT_CONTOURS), intent(inout):: cont
            character(len = *), intent(in):: optname
            character(len = *), intent(in):: value
            logical, intent(out):: err
        end subroutine

        subroutine GtLineOption(line, optname, value, err)
            use gtgraph_types, only: GT_LINE
            type(GT_LINE), intent(inout):: line
            character(len = *), intent(in):: optname
            character(len = *), intent(in):: value
            logical, intent(out):: err
        end subroutine

    end interface

    interface Bind

        subroutine GTObjBindObj(parent, child)
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(inout):: parent
            type(GT_OBJECT), intent(in):: child
        end subroutine

        subroutine GTFigBindObject(fig, obj)
            use gtgraph_types, only: GT_OBJECT, GT_FIGURE
            type(GT_FIGURE), intent(inout):: fig
            type(GT_OBJECT), intent(in):: obj
        end subroutine

        subroutine GTFigBindAxis(fig, axis, vertical)
            use gtgraph_types, only: GT_FIGURE, GT_AXIS
            type(GT_FIGURE), intent(inout):: fig
            type(GT_AXIS), pointer:: axis
            logical, intent(in), optional:: vertical
        end subroutine

        subroutine GTFigBindCont(fig, cont)
            use gtgraph_types, only: GT_FIGURE, GT_CONTOURS
            type(GT_FIGURE), intent(inout):: fig
            type(GT_CONTOURS), intent(in):: cont
        end subroutine

        subroutine GTFigBindLine(fig, line)
            use gtgraph_types, only: GT_FIGURE, GT_LINE
            type(GT_FIGURE), intent(inout):: fig
            type(GT_LINE), intent(in):: line
        end subroutine

        subroutine GTFrameBindFig(frame, fig)
            use gtgraph_types, only: GT_FRAME, GT_FIGURE
            type(GT_FRAME), intent(out):: frame
            type(GT_FIGURE), intent(in):: fig
        end subroutine

    end interface

    !
    ! ʂ̃[U Display() ĂяoB
    ! I Draw Tu[`QĂяoĂB
    ! 
    interface Display
 
        subroutine GTFrameDisplay(dev, frame)
            use gtgraph_types, only: GT_DEVICE, GT_FRAME
            type(GT_DEVICE), intent(inout):: dev
            type(GT_FRAME), intent(inout):: frame
        end subroutine

        subroutine GTFigDisplay(dev, fig)
            use gtgraph_types, only: GT_DEVICE, GT_FIGURE
            type(GT_DEVICE), intent(inout):: dev
            type(GT_FIGURE), intent(inout):: fig
        end subroutine

    end interface

    !
    ! Draw(..., paent) ͓I Display(dev, ...) 
    ! p邽߂ɂBparent ͒ʏ햳p[U
    ! ~X^CvŌĂяoȂ߂ Put Ƌtʒu
    ! tĂB
    !
    interface Draw

        subroutine GTAxesDraw(h_axis, v_axis, parent, set_space)
            use gtgraph_types, only: GT_AXIS, GT_FIGURE
            type(GT_AXIS), intent(inout):: h_axis, v_axis
            type(GT_FIGURE), intent(in):: parent
            logical, intent(in), optional:: set_space
        end subroutine

        subroutine GTContDraw(cont, parent)
            use gtgraph_types, only: GT_CONTOURS, GT_FIGURE
            type(GT_CONTOURS), intent(inout):: cont
            type(GT_FIGURE), intent(in):: parent
        end subroutine

        subroutine GTLineDraw(line, parent)
            use gtgraph_types, only: GT_LINE, GT_FIGURE
            type(GT_LINE), intent(inout):: line
            type(GT_FIGURE), intent(in):: parent
        end subroutine

        subroutine GTFigDraw(fig, parent)
            use gtgraph_types, only: GT_FRAME, GT_FIGURE
            type(GT_FIGURE), intent(inout):: fig
            type(GT_FRAME), intent(in):: parent
        end subroutine

    end interface

    !
    ! o
    !

    interface Load

        recursive subroutine GTObjLoad(obj, varname)
            use dc_string, only: VSTRING
            use gtgraph_types, only: GT_OBJECT
            type(GT_OBJECT), intent(out):: obj
            type(VSTRING), intent(in):: varname
        end subroutine

        recursive subroutine GTObjLoadVar(obj, var)
            use gtgraph_types, only: GT_OBJECT
            use gtdata_types, only: GT_VARIABLE
            type(GT_OBJECT), intent(out):: obj
            type(GT_VARIABLE), intent(in):: var
        end subroutine

        subroutine GTFrameLoad(frame, var)
            use gtgraph_types, only: GT_FRAME
            use gtdata_types, only: GT_VARIABLE
            type(GT_FRAME), intent(out):: frame
            type(GT_VARIABLE), intent(in):: var
        end subroutine

        subroutine GTFigLoad(Fig, var)
            use gtgraph_types, only: GT_FIGURE
            use gtdata_types, only: GT_VARIABLE
            type(GT_FIGURE), intent(out):: Fig
            type(GT_VARIABLE), intent(in):: var
        end subroutine

        subroutine GTContLoad(Cont, var)
            use gtgraph_types, only: GT_CONTOURS
            use gtdata_types, only: GT_VARIABLE
            type(GT_CONTOURS), intent(out):: Cont
            type(GT_VARIABLE), intent(in):: var
        end subroutine

        subroutine GTLineLoad(Line, var)
            use gtgraph_types, only: GT_Line
            use gtdata_types, only: GT_VARIABLE
            type(GT_Line), intent(out):: Line
            type(GT_VARIABLE), intent(in):: var
        end subroutine

        subroutine GTAxisLoadByName(Axis, varname)
            use gtgraph_types, only: GT_AXIS
            use dc_string, only: VSTRING
            type(GT_AXIS), intent(out):: axis
            type(VSTRING), intent(in):: varname
        end subroutine

        subroutine GTAxisLoad(Axis, var)
            use gtgraph_types, only: GT_Axis
            use gtdata_types, only: GT_VARIABLE
            type(GT_Axis), intent(out):: Axis
            type(GT_VARIABLE), intent(in):: var
        end subroutine

    end interface

    ! --- Save ---
    !
    ! Save ͐}`ϐi[Bvarname ȗ
    ! ϐ͎B

    interface Save

        subroutine GTFrameSave(frame, varname, resultname)
            use gtgraph_types, only: GT_FRAME
            use dc_string, only: VSTRING
            type(GT_FRAME), intent(in):: frame
            type(VSTRING), intent(in), optional:: varname
            type(VSTRING), intent(out), optional:: resultname
        end subroutine

        subroutine GTFigSave(fig, varname, resultname)
            use gtgraph_types, only: GT_FIGURE
            use dc_string, only: VSTRING
            type(GT_FIGURE), intent(in):: fig
            type(VSTRING), intent(in), optional:: varname
            type(VSTRING), intent(out), optional:: resultname
        end subroutine

        subroutine GTLineSave(line, varname, resultname)
            use gtgraph_types, only: GT_LINE
            use dc_string, only: VSTRING
            type(GT_LINE), intent(in):: line
            type(VSTRING), intent(in), optional:: varname
            type(VSTRING), intent(out), optional:: resultname
        end subroutine

        subroutine GTContSave(cont, varname, resultname)
            use gtgraph_types, only: GT_CONTOURS
            use dc_string, only: VSTRING
            type(GT_CONTOURS), intent(in):: cont
            type(VSTRING), intent(in), optional:: varname
            type(VSTRING), intent(out), optional:: resultname
        end subroutine

        subroutine GTAxisSave(axis, varname, resultname)
            use gtgraph_types, only: GT_AXIS
            use dc_string, only: VSTRING
            type(GT_AXIS), intent(in):: axis
            type(VSTRING), intent(in), optional:: varname
            type(VSTRING), intent(out), optional:: resultname
        end subroutine

    end interface

    interface operator(.equivalent.)

	logical function GTAxisEquivalent(axis1, axis2)
	    use gtgraph_types, only: gt_axis
	    type(gt_axis), intent(in):: axis1
	    type(gt_axis), intent(in):: axis2
	end function

    end interface

    ! Save gO

    interface
        type(VSTRING) function GTGraphSaveName()
            use dc_string, only: VSTRING
        end function
    end interface

end module
