! Copyright (C) GFD Dennou Club, 2000-2001.  All rights reserved.

subroutine GTVarInquire(var, xtype, name, url, rank, alldims, allcount, &
    & size, growable)
    use gtdata_types, only: gt_variable
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: inquire, an_variable
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(gt_variable), intent(in):: var
    ! O^̖O
    character(len=*), intent(out), optional:: xtype
    ! name ͕ϐ̍ŏ̒PʂԂB
    ! t@C܂܂Ȃ߃vOł̈Ӑ͕ۏ؂ȂB
    character(len=*), intent(out), optional:: name
    ! url ̓t@ĈϐԂBvO
    ! ӂłB
    character(len=*), intent(out), optional:: url
    ! RpNg(k)𐔂Ȃ, ̐
    integer, intent(out), optional:: rank
    ! kގ܂ޑSBdimord ɂ͊{Iɂg
    integer, intent(out), optional:: alldims
    ! ϐϐłꍇAԂBG[̓[B
    integer, intent(out), optional:: allcount
    ! ϐ̓o͗̈̑傫B
    integer, intent(out), optional:: size
    ! growable: ϐϐłꍇAg\ۂԂB
    ! ϐłȂꍇ͕sB
    logical, intent(out), optional:: growable
    integer:: class, cid
continue
    call beginsub('gtvarinquire', 'var.mapid=%d', i=(/var%mapid/))
    call var_class(var, class, cid)
    select case(class)
    case(vtb_class_netcdf)
        if (present(xtype) .or. present(name) .or. present(url)) then
            call inquire(an_variable(cid), xtype=xtype, name=name, url=url)
            if (present(xtype)) call message('xtype=%c', c1=trim(xtype))
            if (present(name)) call message('name=%c', c1=trim(name))
            if (present(url)) call message('url=%c', c1=trim(url))
        endif
        if (present(growable)) then
            call inquire(an_variable(cid), growable=growable)
            call message('growable=%y', L=(/growable/))
        endif
    case(vtb_class_memory)
        call message('vtb_class_memory not implemented: skipped')
    end select
    if (present(alldims)) alldims = internal_get_alldims(var)
    if (present(allcount)) allcount = internal_get_allcount(var)
    if (present(size)) size = internal_get_size(var)
    if (present(rank)) rank = internal_get_rank(var)
    call endsub('gtvarinquire')
    return
contains

    integer function internal_get_alldims(var) result(result)
        use gt_map, only: map_lookup
        implicit none
        type(gt_variable), intent(in):: var
        call map_lookup(var, ndims=result)
        call message('alldims=%d', i=(/result/))
    end function

    integer function internal_get_allcount(var) result(result)
        use gt_map, only: gt_dimmap, map_lookup
        implicit none
        type(gt_variable), intent(in):: var
        type(gt_dimmap), allocatable:: map(:)
        integer:: nd
        intrinsic size
        call map_lookup(var, ndims=nd)
        if (nd <= 0) then
            call message('internal_get_allcount: no map')
            result = 1
            return
        endif
        allocate(map(nd))
        call map_lookup(var, map=map)
        result = product(map(1:nd)%allcount)
        call message('internal_get_allcount: %d map.size=%d', &
            & i=(/result, nd/))
        deallocate(map)
    end function

    integer function internal_get_size(var) result(result)
        use gt_map, only: gt_dimmap, map_lookup
        implicit none
        type(gt_variable), intent(in):: var
        type(gt_dimmap), allocatable:: map(:)
        integer:: nd
        intrinsic size
        call map_lookup(var, ndims=nd)
        if (nd <= 0) then
            call message('internal_get_size: no map')
            result = 1
            return
        endif
        allocate(map(nd))
        call map_lookup(var, map=map)
        result = product(map(1:nd)%count)
        call message('internal_get_size: %d map.size=%d', &
            & i=(/result, nd/))
        deallocate(map)
    end function

    integer function internal_get_rank(var) result(result)
        use gt_map, only: gt_dimmap, map_lookup
        implicit none
        type(gt_variable), intent(in):: var
        type(gt_dimmap), allocatable:: map(:)
        integer:: nd

        call map_lookup(var, ndims=nd)
        if (nd <= 0) then
            call message('internal_get_rank: no map')
            result = 1
            return
        endif
        allocate(map(nd))
        call map_lookup(var, map=map)
        result = count(map(1:nd)%count > 1)
        call message('internal_get_rank: %d', i=(/result/))
        deallocate(map)
    end function

end subroutine

subroutine GTVarInquireD(var, dimord, url, allcount)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: open, close, inquire
    implicit none
    type(GT_VARIABLE), intent(in):: var
    integer, intent(in):: dimord
    character(len=*), intent(out), optional:: url
    integer, intent(out), optional:: allcount
    type(GT_VARIABLE):: dimvar
    call open(dimvar, source_var=var, dimord=dimord)
    if (present(url)) call inquire(dimvar, url=url)
    if (present(allcount)) call inquire(dimvar, allcount=allcount)
    call close(dimvar)
end subroutine

! ȂΓRςȂƂN邪ACɂȂB
subroutine GTVarInquireV(var, xtype, name, url)
    use gtdata_types, only: GT_VARIABLE
    use dc_types, only: string
    use dc_string, only: VSTRING, assignment(=)
    use gtdata_generic, only: inquire
    implicit none
    type(GT_VARIABLE), intent(in):: var
    type(vstring), intent(out), optional:: xtype, name, url
    character(string):: s_xtype, s_name, s_url
    if (present(xtype)) then
        call inquire(var, xtype=s_xtype)
        xtype = trim(s_xtype)
    endif
    if (present(name)) then
        call inquire(var, name=s_name)
        name = trim(s_name)
    endif
    if (present(url)) then
        call inquire(var, url=s_url)
        url = trim(s_url)
    endif
end subroutine

subroutine GTVarInquireAV(var, attrname, xtype)
    use gtdata_types, only: gt_variable
    use dc_types, only: string
    use dc_string, only: VSTRING, assignment(=)
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: inquire, an_variable
    type(gt_variable), intent(in):: var
    character(len=*), intent(in):: attrname
    type(vstring), intent(out), optional:: xtype
    character(string):: s_xtype
    integer:: class, cid
continue
    call var_class(var, class, cid)
    select case(class)
    case(vtb_class_netcdf)
        call inquire(an_variable(cid), attrname=attrname, xtype=s_xtype)
        if (present(xtype)) xtype = trim(s_xtype)
    end select
end subroutine

! ȂΓRςȂƂN邪ACɂȂB
subroutine GTVarInquireA(var, attrname, xtype)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: inquire
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: inquire, an_variable
    type(GT_VARIABLE), intent(in):: var
    character(len=*), intent(in):: attrname
    character(len=*), intent(out), optional:: xtype
    integer:: class, cid
continue
    call var_class(var, class, cid)
    select case(class)
    case(vtb_class_netcdf)
        call inquire(an_variable(cid), attrname=attrname, xtype=xtype)
    end select
end subroutine
