! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTVarGetReal1(var, value, err)
    use gtdata_types, only: gt_variable
    use gtdata_generic, only: get_slice, get, inquire
    use gt_map, only: map_set_rank
    use dc_error, only: storeerror, dc_noerr
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(gt_variable), intent(inout):: var
    real, pointer:: value(:)
    logical, intent(out), optional:: err
    integer:: stat, n
continue
    call beginsub('gtvargetreal1', 'var.mapid=%d', i=(/var%mapid/))
    call map_set_rank(var, 1, stat)
    if (stat /= dc_noerr) goto 999
    call get_slice(var, dimord=1, count=n, count_compact=.false.)
    allocate(value(n))
    call get(var, value, n, err)
    call message('max=%r min=%r', r=(/maxval(value), minval(value)/))
999 continue
    call endsub('gtvargetreal1', 'n=%d', i=(/n/))
    call storeerror(stat, 'gtvargetreal1')
end subroutine
